package Acme::MetaSyntactic::batman;
use strict;
use Acme::MetaSyntactic::MultiList;
our @ISA = qw( Acme::MetaSyntactic::MultiList );
our $VERSION = '1.001';
__PACKAGE__->init();
1;

=head1 NAME

Acme::MetaSyntactic::batman - The batman theme

=head1 DESCRIPTION

The fight sound effects from the 60s serial.

All the bat sounds come from this page:
L<http://www.usfamily.net/web/wpattinson/otr/batman/batfight.htm>

You can find photos of the serie's onomatopoeias here:
L<http://www.batmania.com.ar/paginas/serie_onomatopeyas.htm>.

The cast, characters, and cameo lists comes from
L<https://en.wikipedia.org/wiki/List_of_Batman_television_series_characters>.

=head1 CONTRIBUTOR

Philippe Bruhat (BooK).

=head1 CHANGES

=over 4

=item *

2017-06-12 - v1.001

Updated with the cast and characters from the Batman television series
in Acme-MetaSyntactic-Themes version 1.050.

This update is a tribute to Adam West, who passed away on June 9, 2017.

=item *

2012-05-07 - v1.000

Received its own version number in Acme-MetaSyntactic-Themes version 1.000.

=item *

2005-01-14

Introduced in Acme-MetaSyntactic version 0.01.

=back

=head1 SEE ALSO

L<Acme::MetaSyntactic>, L<Acme::MetaSyntactic::List>.

=cut

__DATA__
# default
onomatopoeia
# names onomatopoeia
aieee       aiieee    awk         awkkkkkk
bam         bang      bang_eth    bap
biff        bloop     blurp       boff
bonk        clange    clank       clank_est
clash       clunk     clunk_eth   crash
crr_aaack   crraack   cr_r_a_a_ck crunch
crunch_eth  eee_yow   flrbbbbb    glipp
glurpp      kapow     kayo        ker_plop
ker_sploosh klonk     krunch      ooooff
ouch        ouch_eth  owww        pam
plop        pow       powie       qunckkk
rakkk       rip       slosh       sock
spla_a_t    splatt    sploosh     swa_a_p
swish       swoosh    thunk       thwack
thwacke     thwape    thwapp      touche
uggh        urkk      urkkk       vronk
whack       whack_eth wham_eth    whamm
whap        zam       zamm        zap
zapeth      zgruppp   zlonk       zlopp
zlott       zok       zowie       zwapp
z_zwap      zzzzzwap
# names cast
Adam_West
Burt_Ward
Yvonne_Craig
Alan_Napier
Neil_Hamilton
Stafford_Repp
Madge_Blake
Byron_Keith
David_Lewis
Van_Williams
Bruce_Lee
Julie_Newmar Lee_Meriwether Eartha_Kitt
Vincent_Price
Cesar_Romero
Victor_Buono
David_Wayne
George_Sanders Otto_Preminger Eli_Wallach
Burgess_Meredith
Frank_Gorshin John_Astin
Cliff_Robertson
Art_Carney
Tallulah_Bankhead
Roddy_McDowall
Liberace
Barbara_Rush
Walter_Slezak
Malachi_Throne
Rudy_Vallee
Jacques_Bergerac
Roger_C_Carmel
Ethel_Merman
Milton_Berle
Shelley_Winters
Carolyn_Jones
Zsa_Zsa_Gabor
Van_Johnson
Maurice_Evans
Michael_Rennie
Joan_Collins
Ida_Lupino
Anne_Baxter
#_names_characters
Bruce_Wayne Batman
Dick_Grayson Robin
Barbara_Gordon Batgirl
Alfred_Pennyworth
Commissioner_James_Gordon
Chief_Miles_Clancy_O_Hara
Aunt_Harriet_Cooper
Mayor_Linseed
Warden_Crichton
Britt_Reid Green_Hornet
Kato
The_Catwoman
Egghead
The_Joker
King_Tut Professor_William_McElroy
Mad_Hatter Jervis_Tetch
Mr_Freeze Art_Schivel
The_Penguin
The_Riddler
Shame
Archer
Black_Widow
Bookworm
Chandell Harry
Nora_Clavicle
Clock_King
False_Face
Lord_Marmaduke_Ffogg
Freddy_the_Fence Freddy_Touche
Colonel_Gumm
Lola_Lasagne Lulu_Schultz
Louie_the_Lilac
Ma_Parker
Marsha_Queen_of_Diamonds
Minerva
Minstrel
Puzzler
Sandman Dr_Somnambular
Siren Lorelei_Circe
Dr_Cassandra_Spellcraft
Zelda_the_Great
#_names_cameo
Jerry_Lewis
George_Cisar
Dick_Clark
Van_Williams
Bruce_Lee
Sammy_Davis_Jr
Bill_Dana Josw_Jimwnez
Howard_Duff Sam_Stone
Werner_Klemperer Colonel_Klink
Ted_Cassidy Lurch
Don_Ho
Andy_Devine Santa_Claus
Art_Linkletter
Edward_G_Robinson
Suzy_Knickerbocker Aileen_Mehle
Cyril_Lord Carpet_King
