#ifndef UU_TYPE_H
#define UU_TYPE_H

#ifndef HAVE_TYPE_U64
#  if defined(HAS_QUAD)
     typedef Uquad_t U64;
#    define HAVE_TYPE_U64 1
#  elif defined(HAVE_STDINT_H)
     typedef uint64_t U64;
#    define HAVE_TYPE_U64 1
#  endif
#endif

/* v1 and v4 use this */
struct uu {
  U32 time_low;
  U16 time_mid;
  U16 time_high_and_version;
  U16 clock_seq_and_variant;
  U8  node[6];
};

struct uu6 {
  U32 time_high;
  U16 time_mid;
  U16 time_low_and_version;
  U16 clock_seq_and_variant;
  U8  node[6];
};

/* this should be aligned at least 4 bytes, better yet 16 */
typedef U8 uu_t[16];

typedef unsigned char UCHAR;

#endif
/* ex:set ts=2 sw=2 itab=spaces */
