package App::InteractivePerlTutorial::Chapter::Control::UnlessUntil;

use 5.014000;
use strict;
use warnings;
our $VERSION = '0.000_001';

use constant TEXT => 'Unless & Until';
use constant EXERCISES => [
	{ statement => 'Write a program that reads a number from STDIN and prints "Yes" if the number is greater than or equal to 100', hint => 'Use <>, unless and print', solution => <<'SOL', input => '150', check => sub { $_[0] =~ /^\s*yes\s*$/i } }
my $x = <>;
unless($x < 100){
	print 'Yes'
}
SOL
];

1;
__DATA__

=encoding utf-8

=head1 Unless and Until

E<bull> If you want to execute a block of code only when the conditional is false, change C<if> to C>unless>:

  unless ($x<0){
    print "The value is positive.";
  } else  {
     print "The value is negative";
  }

Using the C<unless> control structure is equivalent to using the C<if> structure with the condition negated:

  if(!($x<0)){
    print  "The value is positive";
  } else {
    print "The value is negative";
  }

E<bull> Sometimes you want to reverse the condition of a while loop. To do that, just use until:

  until ($j > 100) {
    $j = $j*2;
  }


=cut
