#!/usr/bin/perl

package eBay::API::XML::Call::GetStore::GetStoreRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetStoreRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetStore::GetStoreRequestType

=head1 DESCRIPTION

Retrieves configuration information for the eBay store of the store owner 
specified with UserID. If no UserID is specified, the store configuration 
information is returned for the caller. 
The return value from GetStoreResponse is a StoreType, which contains
the store configuration, including the store name, URL, subscription level, and
other data. You can set CategoryStructureOnly to true to retrieve only
information about the category hierarchy of the store.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetStore::GetStoreRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'CategoryStructureOnly', 'xs:boolean', '', '', '' ]
	, [ 'LevelLimit', 'xs:int', '', '', '' ]
	, [ 'RootCategoryID', 'xs:long', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryStructureOnly()

If this is set to True, only the category structure of the store is
returned. If this is not specified or set to False, the complete store
configuration is returned.

  RequiredInput: Conditionally
#    Argument: 'xs:boolean'

=cut

sub setCategoryStructureOnly {
  my $self = shift;
  $self->{'CategoryStructureOnly'} = shift
}

=head2 isCategoryStructureOnly()

#    Returns: 'xs:boolean'

=cut

sub isCategoryStructureOnly {
  my $self = shift;
  return $self->{'CategoryStructureOnly'};
}


=head2 setLevelLimit()

Specifies the limit for the number of levels of the category hierarchy
to return, where the given root category is level 1 and its children are
level 2. Only categories at or above the level specified are returned.
This tag is optional. If LevelLimit is not set, the complete category
hierarchy is returned. Stores support category hierarchies up to 3
levels only.

  RequiredInput: Conditionally
#    Argument: 'xs:int'

=cut

sub setLevelLimit {
  my $self = shift;
  $self->{'LevelLimit'} = shift
}

=head2 getLevelLimit()

#    Returns: 'xs:int'

=cut

sub getLevelLimit {
  my $self = shift;
  return $self->{'LevelLimit'};
}


=head2 setRootCategoryID()

Specifies the category ID for the topmost category to return (along with
the subcategories under it, the value of the LevelLimit property
determining how deep). This tag is optional. If RootCategoryID is not
specified, then the category tree starting at that root Category is
returned.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut

sub setRootCategoryID {
  my $self = shift;
  $self->{'RootCategoryID'} = shift
}

=head2 getRootCategoryID()

#    Returns: 'xs:long'

=cut

sub getRootCategoryID {
  my $self = shift;
  return $self->{'RootCategoryID'};
}


=head2 setUserID()

Specifies the user whose store data is to be returned. If not specified,
then the store returned is that for the requesting user.

  RequiredInput: No
#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
