#!/usr/bin/perl

package eBay::API::XML::DataType::SiteWideCharacteristicsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SiteWideCharacteristicsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::SiteWideCharacteristicsType

=head1 DESCRIPTION

A list of one or more characteristics sets mapped to the category, if any. Use this information when working with Item Specifics (Attributes) and Pre-filled Item Information (Catalogs) functionality.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::SiteWideCharacteristicsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::CharacteristicsSetType;


my @gaProperties = ( [ 'CharacteristicsSet', 'ns:CharacteristicsSetType', ''
	     ,'eBay::API::XML::DataType::CharacteristicsSetType', '1' ]
	, [ 'ExcludeCategoryID', 'xs:string', '1', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCharacteristicsSet()

Container for site-wide characteristics set information.

#    Argument: 'ns:CharacteristicsSetType'

=cut

sub setCharacteristicsSet {
  my $self = shift;
  $self->{'CharacteristicsSet'} = shift
}

=head2 getCharacteristicsSet()

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: 'ns:CharacteristicsSetType'

=cut

sub getCharacteristicsSet {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CharacteristicsSet'
		,'eBay::API::XML::DataType::CharacteristicsSetType');
}


=head2 setExcludeCategoryID()

A category that does not support the specified site-wide characteristics set.

#    Argument: reference to an array  
                      of 'xs:string'

=cut

sub setExcludeCategoryID {
  my $self = shift;
  $self->{'ExcludeCategoryID'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getExcludeCategoryID()

  Calls: GetCategory2CS
  Returned: Conditionally
  Details: DetailLevel: ReturnAll

#    Returns: reference to an array  
                      of 'xs:string'

=cut

sub getExcludeCategoryID {
  my $self = shift;
  return $self->_getDataTypeArray('ExcludeCategoryID');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
