;; Tests for datatypes containing weak references
;; Bruno Haible 2004-05-05

;; Type tests

(mapcar #'(lambda (x)
            (list (weak-pointer-p x)
                  (weak-list-p x)
                  (weak-and-relation-p x)
                  (weak-or-relation-p x)
                  (weak-mapping-p x)
                  (weak-and-mapping-p x)
                  (weak-or-mapping-p x)
                  (weak-alist-p x)))
        (list '(a b c)
              #(a b c)
              (make-weak-pointer (list 'x))
              (make-weak-list (list 'x 'y 'z))
              (make-weak-and-relation (list (list 'x)))
              (make-weak-or-relation (list (list 'x)))
              (make-weak-mapping '#:G15 '#:G16)
              (make-weak-and-mapping (list '#:G15 '#:G16) '#:G17)
              (make-weak-or-mapping (list '#:G15 '#:G16) '#:G17)
              (make-weak-alist)))
((nil nil nil nil nil nil nil nil)
 (nil nil nil nil nil nil nil nil)
 ( t  nil nil nil nil nil nil nil)
 (nil  t  nil nil nil nil nil nil)
 (nil nil  t  nil nil nil nil nil)
 (nil nil nil  t  nil nil nil nil)
 (nil nil nil nil  t  nil nil nil)
 (nil nil nil nil nil  t  nil nil)
 (nil nil nil nil nil nil  t  nil)
 (nil nil nil nil nil nil nil  t ))
 

;; WEAK-POINTER

(let ((a (list 'x)))
  (let ((w (make-weak-pointer a)))
    (gc)
    (multiple-value-list (weak-pointer-value w))))
((x) t)

(let ((a (list 'x)))
  (let ((w (make-weak-pointer a)))
    (setq a (list 'y))
    (gc)
    (multiple-value-list (weak-pointer-value w))))
(nil nil)


;; WEAK-LIST

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (gc)
    (weak-list-list w)))
((x) (y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (setq a nil)
    (gc)
    (weak-list-list w)))
((y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (setq b nil)
    (gc)
    (weak-list-list w)))
((x) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (setq c nil)
    (gc)
    (weak-list-list w)))
((x) (y))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (setq a 1 b 2 c 3)
    (gc)
    (weak-list-list w)))
NIL

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (setq a nil)
    (gc)
    (setf (weak-list-list w) (list c b))
    (gc)
    (weak-list-list w)))
((z) (y))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-list (list a b c))))
    (setq a nil c nil)
    (gc)
    (setq c (list 'zz))
    (setf (weak-list-list w) (list c c b c))
    (gc)
    (weak-list-list w)))
((zz) (zz) (y) (zz))

(let ((li '()))
  (loop :for i :from 0 :to 1000
        :for string = (format nil "~r" i)
        :do (push string li))
  (setq li (nreverse li))
  (let ((w (make-weak-list li)))
    (list (progn (gc) (length (weak-list-list w)))
          (progn (setq li nil) (gc) (length (weak-list-list w))))))
(1001 0)


;; WEAK-AND-RELATION

(let ((a (list 'x)))
  (let ((w (make-weak-and-relation (list a))))
    (gc)
    (weak-and-relation-list w)))
((x))

(let ((a (list 'x)))
  (let ((w (make-weak-and-relation (list a))))
    (setq a (list 'y))
    (gc)
    (weak-and-relation-list w)))
NIL

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-relation (list a b c))))
    (gc)
    (weak-and-relation-list w)))
((x) (y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-relation (list a b c))))
    (setq a nil)
    (gc)
    (weak-and-relation-list w)))
nil

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-relation (list a b c))))
    (setq b nil)
    (gc)
    (weak-and-relation-list w)))
nil

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-relation (list a b c))))
    (setq c nil)
    (gc)
    (weak-and-relation-list w)))
nil

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-and-relation (list a (make-weak-and-relation (list a b))))))
    (gc)
    (weak-and-relation-list w)))
nil


;; WEAK-OR-RELATION

(let ((a (list 'x)))
  (let ((w (make-weak-or-relation (list a))))
    (gc)
    (weak-or-relation-list w)))
((x))

(let ((a (list 'x)))
  (let ((w (make-weak-or-relation (list a))))
    (setq a (list 'y))
    (gc)
    (weak-or-relation-list w)))
NIL

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-relation (list a b c))))
    (gc)
    (weak-or-relation-list w)))
((x) (y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-relation (list a b c))))
    (setq a nil b nil)
    (gc)
    (weak-or-relation-list w)))
((x) (y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-relation (list a b c))))
    (setq b nil c nil)
    (gc)
    (weak-or-relation-list w)))
((x) (y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-relation (list a b c))))
    (setq a nil c nil)
    (gc)
    (weak-or-relation-list w)))
((x) (y) (z))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-relation (list a b c))))
    (setq a nil b nil c nil)
    (gc)
    (weak-or-relation-list w)))
nil

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-relation (list a (make-weak-or-relation (list a b))))))
    (gc)
    (mapcar #'type-of (weak-or-relation-list w))))
(CONS WEAK-OR-RELATION)

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-relation (list a (make-weak-or-relation (list a b))))))
    (setq b nil)
    (gc)
    (weak-or-relation-list (second (weak-or-relation-list w)))))
((x) (y))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-relation (list (make-weak-or-relation (list a b)) b))))
    (setq a nil)
    (gc)
    (weak-or-relation-list (first (weak-or-relation-list w)))))
((x) (y))


;; WEAK-MAPPING

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-mapping a b)))
    (gc)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
(((x) (y) t) ((y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-mapping a b)))
    (setq b nil)
    (gc)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
(((x) (y) t) ((y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-mapping a b)))
    (setq a nil)
    (gc)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-mapping a b)))
    (setq a nil b nil)
    (gc)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
((nil nil nil) (nil))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-mapping a3 a4))
        (w2 (make-weak-mapping a1 a2))
        (w3 (make-weak-mapping a4 a5))
        (w4 (make-weak-mapping a2 a3)))
    (setq a2 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-mapping-value w2)
          (weak-mapping-value w4)
          (weak-mapping-value w1)
          (weak-mapping-value w3))))
((x2) (x3) (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-mapping a3 a4))
        (w2 (make-weak-mapping a1 a2))
        (w3 (make-weak-mapping a4 a5))
        (w4 (make-weak-mapping a2 a3)))
    (setq a1 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-mapping-value w2)
          (weak-mapping-value w4)
          (weak-mapping-value w1)
          (weak-mapping-value w3))))
(nil (x3) (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-mapping a3 a4))
        (w2 (make-weak-mapping a1 a2))
        (w3 (make-weak-mapping a4 a5))
        (w4 (make-weak-mapping a2 a3)))
    (setq a1 nil a2 nil a4 nil a5 nil)
    (gc)
    (list (weak-mapping-value w2)
          (weak-mapping-value w4)
          (weak-mapping-value w1)
          (weak-mapping-value w3))))
(nil nil (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-mapping a3 a4))
        (w2 (make-weak-mapping a1 a2))
        (w3 (make-weak-mapping a4 a5))
        (w4 (make-weak-mapping a2 a3)))
    (setq a1 nil a2 nil a3 nil a5 nil)
    (gc)
    (list (weak-mapping-value w2)
          (weak-mapping-value w4)
          (weak-mapping-value w1)
          (weak-mapping-value w3))))
(nil nil nil (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-mapping a3 a4))
        (w2 (make-weak-mapping a1 a2))
        (w3 (make-weak-mapping a4 a5))
        (w4 (make-weak-mapping a2 a3)))
    (setq a1 nil a2 nil a3 nil a4 nil)
    (gc)
    (list (weak-mapping-value w2)
          (weak-mapping-value w4)
          (weak-mapping-value w1)
          (weak-mapping-value w3))))
(nil nil nil nil)

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-mapping a b)))
    (setf (weak-mapping-value w) c)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
(((x) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-mapping a b)))
    (setf (weak-mapping-value w) c)
    (gc)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
(((x) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-mapping a b)))
    (gc)
    (setf (weak-mapping-value w) c)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
(((x) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-mapping a b)))
    (setq a nil)
    (setf (weak-mapping-value w) c)
    (gc)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-mapping a b)))
    (setq a nil)
    (gc)
    (setf (weak-mapping-value w) c)
    (list (multiple-value-list (weak-mapping-pair w))
          (multiple-value-list (weak-mapping-value w)))))
((nil nil nil) (nil))


;; WEAK-AND-MAPPING

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((((x)) (y) t) ((y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setq b nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((((x)) (y) t) ((y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setq a nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setq a nil b nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-and-mapping (list a b c) d)))
    (setq d nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((((x) (y) (z)) (r) t) ((r)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-and-mapping (list a b c) d)))
    (setq a nil d nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-and-mapping (list a b c) d)))
    (setq b nil d nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-and-mapping (list a b c) d)))
    (setq c nil d nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (d (list 'r)))
  (let ((w (make-weak-and-mapping (list a (make-weak-and-mapping (list a b) d)) d)))
    (setq d nil)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-and-mapping (list a3) a4))
        (w2 (make-weak-and-mapping (list a1) a2))
        (w3 (make-weak-and-mapping (list a4) a5))
        (w4 (make-weak-and-mapping (list a2) a3)))
    (setq a2 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-and-mapping-value w2)
          (weak-and-mapping-value w4)
          (weak-and-mapping-value w1)
          (weak-and-mapping-value w3))))
((x2) (x3) (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-and-mapping (list a3) a4))
        (w2 (make-weak-and-mapping (list a1) a2))
        (w3 (make-weak-and-mapping (list a4) a5))
        (w4 (make-weak-and-mapping (list a2) a3)))
    (setq a1 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-and-mapping-value w2)
          (weak-and-mapping-value w4)
          (weak-and-mapping-value w1)
          (weak-and-mapping-value w3))))
(nil (x3) (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-and-mapping (list a3) a4))
        (w2 (make-weak-and-mapping (list a1) a2))
        (w3 (make-weak-and-mapping (list a4) a5))
        (w4 (make-weak-and-mapping (list a2) a3)))
    (setq a1 nil a2 nil a4 nil a5 nil)
    (gc)
    (list (weak-and-mapping-value w2)
          (weak-and-mapping-value w4)
          (weak-and-mapping-value w1)
          (weak-and-mapping-value w3))))
(nil nil (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-and-mapping (list a3) a4))
        (w2 (make-weak-and-mapping (list a1) a2))
        (w3 (make-weak-and-mapping (list a4) a5))
        (w4 (make-weak-and-mapping (list a2) a3)))
    (setq a1 nil a2 nil a3 nil a5 nil)
    (gc)
    (list (weak-and-mapping-value w2)
          (weak-and-mapping-value w4)
          (weak-and-mapping-value w1)
          (weak-and-mapping-value w3))))
(nil nil nil (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-and-mapping (list a3) a4))
        (w2 (make-weak-and-mapping (list a1) a2))
        (w3 (make-weak-and-mapping (list a4) a5))
        (w4 (make-weak-and-mapping (list a2) a3)))
    (setq a1 nil a2 nil a3 nil a4 nil)
    (gc)
    (list (weak-and-mapping-value w2)
          (weak-and-mapping-value w4)
          (weak-and-mapping-value w1)
          (weak-and-mapping-value w3))))
(nil nil nil nil)

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setf (weak-and-mapping-value w) c)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((((x)) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setf (weak-and-mapping-value w) c)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((((x)) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (gc)
    (setf (weak-and-mapping-value w) c)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((((x)) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setq a nil)
    (setf (weak-and-mapping-value w) c)
    (gc)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-and-mapping (list a) b)))
    (setq a nil)
    (gc)
    (setf (weak-and-mapping-value w) c)
    (list (multiple-value-list (weak-and-mapping-pair w))
          (multiple-value-list (weak-and-mapping-value w)))))
((nil nil nil) (nil))


;; WEAK-OR-MAPPING

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x)) (y) t) ((y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setq b nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x)) (y) t) ((y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setq a nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setq a nil b nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a b c) d)))
    (setq d nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x) (y) (z)) (r) t) ((r)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a b c) d)))
    (setq a nil b nil d nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x) (y) (z)) (r) t) ((r)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a b c) d)))
    (setq b nil c nil d nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x) (y) (z)) (r) t) ((r)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a b c) d)))
    (setq a nil c nil d nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x) (y) (z)) (r) t) ((r)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a b c) d)))
    (setq a nil b nil c nil d nil)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a (make-weak-or-mapping (list a b) d)) d)))
    (setq d nil)
    (gc)
    (mapcar #'type-of (weak-or-mapping-pair w))))
(CONS WEAK-OR-MAPPING)

(let ((a (list 'x))
      (b (list 'y))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list a (make-weak-or-mapping (list a b) d)) d)))
    (setq b nil d nil)
    (gc)
    (weak-or-mapping-pair (second (weak-or-mapping-pair w)))))
((x) (y))

(let ((a (list 'x))
      (b (list 'y))
      (d (list 'r)))
  (let ((w (make-weak-or-mapping (list (make-weak-or-mapping (list a b) d) b) d)))
    (setq a nil d nil)
    (gc)
    (weak-or-mapping-pair (first (weak-or-mapping-pair w)))))
((x) (y))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-or-mapping (list a3) a4))
        (w2 (make-weak-or-mapping (list a1) a2))
        (w3 (make-weak-or-mapping (list a4) a5))
        (w4 (make-weak-or-mapping (list a2) a3)))
    (setq a2 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-or-mapping-value w2)
          (weak-or-mapping-value w4)
          (weak-or-mapping-value w1)
          (weak-or-mapping-value w3))))
((x2) (x3) (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-or-mapping (list a3) a4))
        (w2 (make-weak-or-mapping (list a1) a2))
        (w3 (make-weak-or-mapping (list a4) a5))
        (w4 (make-weak-or-mapping (list a2) a3)))
    (setq a1 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-or-mapping-value w2)
          (weak-or-mapping-value w4)
          (weak-or-mapping-value w1)
          (weak-or-mapping-value w3))))
(nil (x3) (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-or-mapping (list a3) a4))
        (w2 (make-weak-or-mapping (list a1) a2))
        (w3 (make-weak-or-mapping (list a4) a5))
        (w4 (make-weak-or-mapping (list a2) a3)))
    (setq a1 nil a2 nil a4 nil a5 nil)
    (gc)
    (list (weak-or-mapping-value w2)
          (weak-or-mapping-value w4)
          (weak-or-mapping-value w1)
          (weak-or-mapping-value w3))))
(nil nil (x4) (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-or-mapping (list a3) a4))
        (w2 (make-weak-or-mapping (list a1) a2))
        (w3 (make-weak-or-mapping (list a4) a5))
        (w4 (make-weak-or-mapping (list a2) a3)))
    (setq a1 nil a2 nil a3 nil a5 nil)
    (gc)
    (list (weak-or-mapping-value w2)
          (weak-or-mapping-value w4)
          (weak-or-mapping-value w1)
          (weak-or-mapping-value w3))))
(nil nil nil (x5))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-or-mapping (list a3) a4))
        (w2 (make-weak-or-mapping (list a1) a2))
        (w3 (make-weak-or-mapping (list a4) a5))
        (w4 (make-weak-or-mapping (list a2) a3)))
    (setq a1 nil a2 nil a3 nil a4 nil)
    (gc)
    (list (weak-or-mapping-value w2)
          (weak-or-mapping-value w4)
          (weak-or-mapping-value w1)
          (weak-or-mapping-value w3))))
(nil nil nil nil)

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setf (weak-or-mapping-value w) c)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x)) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setf (weak-or-mapping-value w) c)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x)) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (gc)
    (setf (weak-or-mapping-value w) c)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((((x)) (z) t) ((z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setq a nil)
    (setf (weak-or-mapping-value w) c)
    (gc)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((nil nil nil) (nil))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-or-mapping (list a) b)))
    (setq a nil)
    (gc)
    (setf (weak-or-mapping-value w) c)
    (list (multiple-value-list (weak-or-mapping-pair w))
          (multiple-value-list (weak-or-mapping-value w)))))
((nil nil nil) (nil))


;; WEAK-ALIST

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (gc)
    (weak-alist-type w)))
:key

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :value
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (gc)
    (weak-alist-type w)))
:value

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key-and-value
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (gc)
    (weak-alist-type w)))
:key-and-value

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc))
                            :type :key-or-value)))
    (gc)
    (weak-alist-type w)))
:key-or-value

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (gc)
    (weak-alist-type w)))
:key

(let ((w (make-weak-alist)))
  (gc)
  (weak-alist-contents w))
NIL

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (gc)
    (weak-alist-contents w)))
(((kx) . (vx)) ((ky) . (vy)) ((kz) . (vz)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (setq ka nil)
    (gc)
    (weak-alist-contents w)))
(((ky) . (vy)) ((kz) . (vz)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (setq kb nil)
    (gc)
    (weak-alist-contents w)))
(((kx) . (vx)) ((kz) . (vz)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (setq kc nil)
    (gc)
    (weak-alist-contents w)))
(((kx) . (vx)) ((ky) . (vy)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (setq ka 1 kb 2 kc 3)
    (gc)
    (weak-alist-contents w)))
NIL

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (setq ka nil)
    (gc)
    (setf (weak-alist-contents w) (list (cons kc vc) (cons kb vb)))
    (gc)
    (weak-alist-contents w)))
(((kz) . (vz)) ((ky) . (vy)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :key
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons kc vc)))))
    (setq ka nil kc nil)
    (gc)
    (setq kc (list 'zz))
    (setf (weak-alist-contents w) (list (cons kc vc) (cons kc vc) (cons kb vb) (cons kc vc)))
    (gc)
    (weak-alist-contents w)))
(((zz) . (vz)) ((zz) . (vz)) ((ky) . (vy)) ((zz) . (vz)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (gc)
    (weak-alist-contents w)))
(((x) . (y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setq b nil)
    (gc)
    (weak-alist-contents w)))
(((x) . (y)))

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setq a nil)
    (gc)
    (weak-alist-contents w)))
NIL

(let ((a (list 'x))
      (b (list 'y)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setq a nil b nil)
    (gc)
    (weak-alist-contents w)))
NIL

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-alist :initial-contents (list (cons a3 a4))))
        (w2 (make-weak-alist :initial-contents (list (cons a1 a2))))
        (w3 (make-weak-alist :initial-contents (list (cons a4 a5))))
        (w4 (make-weak-alist :initial-contents (list (cons a2 a3)))))
    (setq a2 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-alist-contents w2)
          (weak-alist-contents w4)
          (weak-alist-contents w1)
          (weak-alist-contents w3))))
((((x1) . (x2))) (((x2) . (x3))) (((x3) . (x4))) (((x4) . (x5))))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-alist :initial-contents (list (cons a3 a4))))
        (w2 (make-weak-alist :initial-contents (list (cons a1 a2))))
        (w3 (make-weak-alist :initial-contents (list (cons a4 a5))))
        (w4 (make-weak-alist :initial-contents (list (cons a2 a3)))))
    (setq a1 nil a3 nil a4 nil a5 nil)
    (gc)
    (list (weak-alist-contents w2)
          (weak-alist-contents w4)
          (weak-alist-contents w1)
          (weak-alist-contents w3))))
(nil (((x2) . (x3))) (((x3) . (x4))) (((x4) . (x5))))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-alist :initial-contents (list (cons a3 a4))))
        (w2 (make-weak-alist :initial-contents (list (cons a1 a2))))
        (w3 (make-weak-alist :initial-contents (list (cons a4 a5))))
        (w4 (make-weak-alist :initial-contents (list (cons a2 a3)))))
    (setq a1 nil a2 nil a4 nil a5 nil)
    (gc)
    (list (weak-alist-contents w2)
          (weak-alist-contents w4)
          (weak-alist-contents w1)
          (weak-alist-contents w3))))
(nil nil (((x3) . (x4))) (((x4) . (x5))))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-alist :initial-contents (list (cons a3 a4))))
        (w2 (make-weak-alist :initial-contents (list (cons a1 a2))))
        (w3 (make-weak-alist :initial-contents (list (cons a4 a5))))
        (w4 (make-weak-alist :initial-contents (list (cons a2 a3)))))
    (setq a1 nil a2 nil a3 nil a5 nil)
    (gc)
    (list (weak-alist-contents w2)
          (weak-alist-contents w4)
          (weak-alist-contents w1)
          (weak-alist-contents w3))))
(nil nil nil (((x4) . (x5))))

(let ((a1 (list 'x1))
      (a2 (list 'x2))
      (a3 (list 'x3))
      (a4 (list 'x4))
      (a5 (list 'x5)))
  (let ((w1 (make-weak-alist :initial-contents (list (cons a3 a4))))
        (w2 (make-weak-alist :initial-contents (list (cons a1 a2))))
        (w3 (make-weak-alist :initial-contents (list (cons a4 a5))))
        (w4 (make-weak-alist :initial-contents (list (cons a2 a3)))))
    (setq a1 nil a2 nil a3 nil a4 nil)
    (gc)
    (list (weak-alist-contents w2)
          (weak-alist-contents w4)
          (weak-alist-contents w1)
          (weak-alist-contents w3))))
(nil nil nil nil)

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setf (weak-alist-value a w) c)
    (weak-alist-contents w)))
(((x) . (z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setf (weak-alist-value a w) c)
    (gc)
    (weak-alist-contents w)))
(((x) . (z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (gc)
    (setf (weak-alist-value a w) c)
    (weak-alist-contents w)))
(((x) . (z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setq a (list 'x2))
    (setf (weak-alist-value a w) c)
    (gc)
    (weak-alist-contents w)))
(((x2) . (z)))

(let ((a (list 'x))
      (b (list 'y))
      (c (list 'z)))
  (let ((w (make-weak-alist :initial-contents (list (cons a b)))))
    (setq a (list 'x2))
    (gc)
    (setf (weak-alist-value a w) c)
    (weak-alist-contents w)))
(((x2) . (z)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (list (weak-alist-assoc ka w)
          (weak-alist-assoc kb w)
          (weak-alist-assoc kc w)
          (weak-alist-assoc va w)
          (weak-alist-assoc vb w)
          (weak-alist-assoc vc w))))
(((kx) . (vx)) ((ky) . (vy)) ((kz) . (vz)) nil nil nil)

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (list (weak-alist-rassoc ka w)
          (weak-alist-rassoc kb w)
          (weak-alist-rassoc kc w)
          (weak-alist-rassoc va w)
          (weak-alist-rassoc vb w)
          (weak-alist-rassoc vc w))))
(nil nil nil ((kx) . (vx)) ((ky) . (vy)) ((kx) . (vz)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (list (weak-alist-value ka w)
          (weak-alist-value kb w)
          (weak-alist-value kc w)
          (weak-alist-value va w)
          (weak-alist-value vb w)
          (weak-alist-value vc w))))
((vx) (vy) (vz) nil nil nil)

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :value
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (setq va nil)
    (gc)
    (list (weak-alist-assoc ka w)
          (weak-alist-assoc kb w)
          (weak-alist-assoc kc w)
          (weak-alist-assoc vb w)
          (weak-alist-assoc vc w))))
(((kx) . (vz)) ((ky) . (vy)) ((kz) . (vz)) nil nil)

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :value
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (setq va nil)
    (gc)
    (list (weak-alist-rassoc ka w)
          (weak-alist-rassoc kb w)
          (weak-alist-rassoc kc w)
          (weak-alist-rassoc vb w)
          (weak-alist-rassoc vc w))))
(nil nil nil ((ky) . (vy)) ((kx) . (vz)))

(let ((ka (list 'kx)) (va (list 'vx))
      (kb (list 'ky)) (vb (list 'vy))
      (kc (list 'kz)) (vc (list 'vz)))
  (let ((w (make-weak-alist :type :value
                            :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (setq va nil)
    (gc)
    (list (weak-alist-value ka w)
          (weak-alist-value kb w)
          (weak-alist-value kc w)
          (weak-alist-value vb w)
          (weak-alist-value vc w))))
((vz) (vy) (vz) nil nil)

(let ((ka (list 'x)) (va (list '\x))
      (kb (list 'y)) (vb (list '\y))
      (kc (list 'z)) (vc (list '\z)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (list (weak-alist-assoc (car ka) w :test #'string-equal :key #'car)
          (weak-alist-assoc (car kb) w :test #'string-equal :key #'car)
          (weak-alist-assoc (car kc) w :test #'string-equal :key #'car)
          (weak-alist-assoc (car va) w :test #'string-equal :key #'car)
          (weak-alist-assoc (car vb) w :test #'string-equal :key #'car)
          (weak-alist-assoc (car vc) w :test #'string-equal :key #'car))))
(((x) . (\x)) ((y) . (\y)) ((z) . (\z)) ((x) . (\x)) ((y) . (\y)) ((z) . (\z)))

(let ((ka (list 'x)) (va (list '\x))
      (kb (list 'y)) (vb (list '\y))
      (kc (list 'z)) (vc (list '\z)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (list (weak-alist-rassoc (car ka) w :test #'string-equal :key #'car)
          (weak-alist-rassoc (car kb) w :test #'string-equal :key #'car)
          (weak-alist-rassoc (car kc) w :test #'string-equal :key #'car)
          (weak-alist-rassoc (car va) w :test #'string-equal :key #'car)
          (weak-alist-rassoc (car vb) w :test #'string-equal :key #'car)
          (weak-alist-rassoc (car vc) w :test #'string-equal :key #'car))))
(((x) . (\x)) ((y) . (\y)) ((x) . (\z)) ((x) . (\x)) ((y) . (\y)) ((x) . (\z)))

(let ((ka (list 'x)) (va (list '\x))
      (kb (list 'y)) (vb (list '\y))
      (kc (list 'z)) (vc (list '\z)))
  (let ((w (make-weak-alist :initial-contents (list (cons ka va)
                                                    (cons kb vb)
                                                    (cons ka vc)
                                                    (cons kc vc)))))
    (list (weak-alist-value ka w :test #'(lambda (u v) (string-equal (car u) (car v))))
          (weak-alist-value kb w :test #'(lambda (u v) (string-equal (car u) (car v))))
          (weak-alist-value kc w :test #'(lambda (u v) (string-equal (car u) (car v))))
          (weak-alist-value va w :test #'(lambda (u v) (string-equal (car u) (car v))))
          (weak-alist-value vb w :test #'(lambda (u v) (string-equal (car u) (car v))))
          (weak-alist-value vc w :test #'(lambda (u v) (string-equal (car u) (car v)))))))
((\x) (\y) (\z) (\x) (\y) (\z))

(let* ((li '())
       (w (let ((ali '()))
            (loop :for i :from 0 :to 1000
                  :for string = (format nil "~r" i)
                  :do (push string li) (push (cons string i) ali))
            (setq li (nreverse li))
            (setq ali (nreverse ali))
            (make-weak-alist :initial-contents ali))))
  (list (progn (gc) (length (weak-alist-contents w)))
        (progn (setq li nil) (gc) (length (weak-alist-contents w)))))
(1001 0)
