/* 
 *   Copyright (C) 2005, 2006 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 *
 */ 

#include <stdlib.h>
#include <stdio.h>
#include <ming.h>
#include <ming_utils.h>

void
add_xtrace_function(SWFMovie mo, SWFBlock font, int depth, int x, int y, int width, int height)
{
	SWFTextField tf;
	SWFDisplayItem it;
	const char* asciichars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%^&*()-_=+[]{};:.>,</?'\"\\|`~";

	tf = newSWFTextField();

	SWFTextField_setFont(tf, font);

	/* setting flags seem unneeded */
	/*SWFTextField_setFlags(tf, SWFTEXTFIELD_USEFONT|SWFTEXTFIELD_NOEDIT);*/

	/* Add all ascii chars */
	SWFTextField_addChars(tf, asciichars);
	SWFTextField_addString(tf, " - xtrace enabled -\n");

	SWFTextField_setBounds(tf, width, height);

	/*SWFTextField_setHeight(tf, 240);*/
	/*SWFTextField_setColor(tf, 0x00, 0x00, 0x00, 0xff);*/
	/*SWFTextField_setAlignment(tf, SWFTEXTFIELD_ALIGN_LEFT);*/
	/*SWFTextField_setLeftMargin(tf, 0);*/
	/*SWFTextField_setRightMargin(tf, 0);*/
	/*SWFTextField_setIndentation(tf, 0);*/
	/*SWFTextField_setLineSpacing(tf, 40);*/
	/*SWFTextField_setLineSpacing(tf, 40);*/

	it = SWFMovie_add(mo, (SWFBlock)tf);
	SWFDisplayItem_moveTo(it, x, y);
	SWFDisplayItem_setDepth(it, depth);
	SWFDisplayItem_setName(it, "_xtrace_win");

	/* Where would we find the _xtrace_win ? */
	add_actions(mo,
		" _global.xtrace = function (msg) { "
		" trace (msg); "
		" _level0._xtrace_win.text += msg + '\n'; "
		"};");
}

SWFShape
make_square(int x, int y, int width, int height, byte r, byte g, byte b)
{
	SWFShape sh = newSWFShape();
	SWFShape_setLineStyle(sh, 1, r, g, b, 255);
	SWFShape_movePenTo(sh, x, y);
	SWFShape_drawLineTo(sh, x, y+height);
	SWFShape_drawLineTo(sh, x+width, y+height);
	SWFShape_drawLineTo(sh, x+width, y);
	SWFShape_drawLineTo(sh, x, y);

	return sh;
}

SWFShape
make_fill_square(int x, int y, int width, int height, byte or, byte og, byte ob, byte fr, byte fg, byte fb)
{
	SWFShape sh = newSWFShape();
	SWFFillStyle fs = SWFShape_addSolidFillStyle(sh, fr, fg, fb, 255);
	SWFShape_setLineStyle(sh, 1, or, og, ob, 255);
	SWFShape_setLeftFillStyle(sh, fs);
	SWFShape_movePenTo(sh, x, y);
	SWFShape_drawLineTo(sh, x, y+height);
	SWFShape_drawLineTo(sh, x+width, y+height);
	SWFShape_drawLineTo(sh, x+width, y);
	SWFShape_drawLineTo(sh, x, y);

	return sh;
}

void
add_dejagnu_functions(SWFMovie mo, SWFBlock font,
	int depth, int x, int y, int width, int height)
{
	SWFAction ac;

	add_xtrace_function(mo, font, depth, x, y, width, height);

	static const size_t BUFLEN = 2048;

	char buf[BUFLEN];
	snprintf(buf, BUFLEN,
		"function TestState() {\n"
		" this.passed = 0;\n"
		" this.failed = 0;\n"
		" this.untest = 0;\n"
		" this.unresolve = 0;\n"
		"};\n"
		"TestState.prototype.fail = function (why) {\n"
		" this.failed++;\n"
		" xtrace('FAILED: '+why);\n"
		"};\n"
		"TestState.prototype.xfail = function(why) {\n"
		" this.failed++;\n"
		" xtrace('XFAILED: '+why);\n"
		"};\n"
		"TestState.prototype.pass = function(why) {\n"
		" this.passed++;\n"
		" xtrace('PASSED: '+why);\n"
		"};\n"
		"TestState.prototype.xpass = function(why) {\n"
		" this.xpassed++;\n"
		" xtrace('XPASSED: '+why);\n"
		"};\n"
		"TestState.prototype.totals = function() {\n"
		" xtrace('#passed: '+ this.passed);\n"
		" xtrace('#failed: '+ this.failed);\n"
		" if ( this.xpassed ) {\n"
		"   xtrace('#unexpected successes: '+ this.xpassed);\n"
		" }\n"
		" if ( this.xfailed ) {\n"
		"   xtrace('#expected failures: '+ this.xfailed);\n"
		" }\n"
		"};\n"
		"_global.runtest = new TestState();\n"
		"function check_equals(obt, exp) {\n"
		" if ( obt == exp ) runtest.pass(obt+' == '+exp);\n"
		" else runtest.fail('expected: '+exp+' , obtained: '+obt);\n"
		"}\n"
		"function xcheck_equals(obt, exp) {\n"
		" if ( obt == exp ) runtest.xpass(obt+' == '+exp);\n"
		" else runtest.xfail('expected: '+exp+' , obtained: '+obt);\n"
		"}\n"
		"function check(a) {\n"
		" if ( a ) runtest.pass(a);\n"
		" else runtest.fail(a);\n"
		"}\n"
		"function xcheck(a) {\n"
		" if ( a ) runtest.xpass(a);\n"
		" else runtest.xfail(a);\n"
		"}\n"
	);

	/*printf("%s", buf);*/

	ac = compileSWFActionCode(buf);

	SWFMovie_add(mo, (SWFBlock)ac);
}

void
check(SWFMovie mo, const char* expr,
		int expected_failure)
{
	static const size_t BUFLEN = 512;

	char buf[BUFLEN];
	SWFAction ac;
	snprintf(buf, BUFLEN, "%scheck(%s);",
		expected_failure ? "x" : "",
		expr);
	buf[BUFLEN-1] = '\0';
	ac = compileSWFActionCode(buf);
	SWFMovie_add(mo, (SWFBlock)ac);
}

void
check_equals(SWFMovie mo, const char* obtained, const char* expected,
		int expected_failure)
{
	static const size_t BUFLEN = 512;

	char buf[BUFLEN];
	SWFAction ac;
	snprintf(buf, BUFLEN, "%scheck_equals(%s, %s);",
		(expected_failure ? "x" : ""),
		obtained, expected);
	buf[BUFLEN-1] = '\0';
	ac = compileSWFActionCode(buf);
	/*fprintf(stderr, "%s\n", buf);*/
	SWFMovie_add(mo, (SWFBlock)ac);
}

void
add_actions(SWFMovie mo, const char* code)
{
	static const size_t BUFLEN = 1024;

	char buf[BUFLEN];
	SWFAction ac;
	snprintf(buf, BUFLEN, "%s", code);
	buf[BUFLEN-1] = '\0';
	ac = compileSWFActionCode(buf);
	SWFMovie_add(mo, (SWFBlock)ac);
}

void
print_tests_summary(SWFMovie mo)
{
	add_actions(mo, "runtest.totals();");
}

SWFFont
get_default_font(const char* mediadir)
{
	FILE *font_file;
	char fdbfont[256];

	sprintf(fdbfont, "%s/Bitstream Vera Sans.fdb", mediadir);

	font_file = fopen(fdbfont, "r");
	if ( font_file == NULL )
	{
		perror(fdbfont);
		exit(1);
	}
	return loadSWFFontFromFile(font_file);
}


