/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

// node.js url module. Makes it easier to resole 
// urls in that datauri loaded dom
var urlHandler = require("url_handler/url_handler");

var pageWorkers = require("page-worker");

var data = require("self").data;

// license definitions, we are using canonical urls and license
// identifiers.
var licenses = require('js_checker/license_definitions').licenses;

// keep web labels in memory so that they can be checked even when they
// are embedded dynamically.
var jsWebLabelEntries = {};

var webLabelFinder = {

    dom: null,
    pageURL: null,
    jslicenseURL: null,
    pageContent: null,
    licenseList:null,
    callback: null,
    
    init: function (dom, pageURL, callback) {
	this.pageURL = pageURL;
	this.dom = dom;
	this.callback = callback;
	this.findJavaScriptLicenses();
	this.pageContent = '';
	this.jslicenseURL = '';
    },

    findJavaScriptLicenses: function () {
	
	this.searchForJsLink();

	if (this.jslicenseURL) {
	    // get content from license page.
	    this.pageContent = this.fetchLicensePage();
	}
	
    },

    searchForJsLink: function () {
	//console.log('triggered searchForJsLink');
	var linkTags = this.dom.getElementsByTagName('a'),
	    i = 0,
	    len = linkTags.length,
	    path;

	// loop through all a tags.
	for (; i < len; i++) {
	    if (linkTags[i].hasAttribute('rel') &&
	        linkTags[i].getAttribute('rel') === 'jslicense') {
		return this.formatURL(linkTags[i]);
	    }
	}
	// no js web labels were found. call back.
	this.callback();
    },

    formatURL: function (link) {
	this.jslicenseURL = urlHandler.resolve(this.pageURL, link.href);
	this.jslicenseURL = urlHandler.addFragment(this.jslicenseURL, 'librejs=true');
	//console.log('license URL found', this.jslicenseURL);
    },
    
    fetchLicensePage: function () {
	var pw,
	    that = this;

	// create invisible page and extract table.
	pw = pageWorkers.Page({

	    contentURL: this.jslicenseURL,

	    contentScriptFile: data.url("web_labels/find_js_labels.js"),

	    onMessage: function (message) {

		if (message.event === 'jsList') {

		    that.licenseList = message.value;

		    that.matchListWithDefs();

		    // add these entries to the global
		    // object for dynamically embedded scripts.
		    jsWebLabelEntries[that.pageURL] = that.licenseList;

		    // return array to requester object
		    that.callback(that.licenseList);

		}

		// delete pageWorker.
		pw.destroy();
	    }

	});
    },
    matchListWithDefs: function () {
	var i = 0, 
	    len = this.licenseList.length,
	    lic,
	    licDef,
            urlLength,
            iUrl, 
            licArray = null;
	    
	// nested loop.
	for (; i < len; i++) {

	    lic = this.licenseList[i];

	    for (license in licenses) {

		licDef = licenses[license];
                if (licDef.canonicalUrl != undefined) {
                    if (typeof licDef.canonicalUrl == 'string') {
                        // this is a string. make it an array.
                        licArray = [licDef.canonicalUrl];
                    }  else {
                        licArray = licDef.canonicalUrl;
                    }

                    urlLength = licArray.length;
                    for (iUrl = 0; iUrl < urlLength; iUrl++) {
                        if (urlHandler.removeFragment(licArray[iUrl]) === urlHandler.removeFragment(lic.licenseUrl) ||
		            lic.licenseName.indexOf(licDef.identifier) != -1) {
		            lic.free = true;
		            break;
		        }
                    }
                }


	    }

	}

    }
};

exports.webLabelFinder = webLabelFinder;

// store the web labels harvested across webpages (single session).
exports.jsWebLabelEntries = jsWebLabelEntries;
