/**
 * GNU LibreJS - A browser add-on to block nonfree nontrivial JavaScript.
 * *
 * Copyright (C) 2011, 2012 Loic J. Duros
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see  <http://www.gnu.org/licenses/>.
 *
 */

var mockLicenseList = [{
'fileName': 'jquery-1.7.min.js',
'fileUrl': 'http://lduros.net/assets/librejs/tests/test-labels-accepted/js/jquery-1.7.min.js',
'fileHash': null,
'licenseName': 'Expat',
'licenseUrl': 'http://www.jclark.com/xml/copying.txt',
'sourceName': 'jquery-1.7.tar.gz',
'sourceUrl': 'http://lduros.net/js/jquery-1.7.tar.gz',
'free': true
}];

var dom_handler = require('html_script_finder/dom_handler');

exports.testScriptHasJsWebLabel = function (test) {
  var dm = Object.create(dom_handler.testDomHandlerObject);
  dm.licenseList = mockLicenseList;
  dm.pageURL = 'http://lduros.net/';
  var script = {'src': 'https://lduros.net/assets/librejs/tests/test-labels-accepted/js/jquery-1.7.min.js'};
  test.assertEqual(dm.scriptHasJsWebLabel(script), true);
};
