/*
 * This file was automatically generated by EvoSuite
 * Wed Sep 19 20:42:01 GMT 2018
 */

package uk.ac.sanger.artemis.io;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.shaded.org.mockito.Mockito.*;
import static org.evosuite.runtime.EvoAssertions.*;

import java.io.ByteArrayInputStream;
import java.awt.datatransfer.Clipboard;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Hashtable;
import javax.swing.JPasswordField;
import javax.swing.plaf.synth.SynthMenuBarUI;
import org.apache.log4j.Category;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggerRepository;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.ViolatedAssumptionAnswer;
import org.evosuite.runtime.mock.java.io.MockFile;
import org.evosuite.runtime.mock.java.io.MockFileWriter;
import org.evosuite.runtime.mock.java.io.MockPrintWriter;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.EvoSuiteURL;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.evosuite.runtime.testdata.NetworkHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.Selection;
import uk.ac.sanger.artemis.io.ChadoCanonicalGene;
import uk.ac.sanger.artemis.io.DatabaseInferredFeature;
import uk.ac.sanger.artemis.io.DatabaseStreamFeature;
import uk.ac.sanger.artemis.io.EmblStreamFeature;
import uk.ac.sanger.artemis.io.EntryInformation;
import uk.ac.sanger.artemis.io.Feature;
import uk.ac.sanger.artemis.io.GFF3AttributeAggregator;
import uk.ac.sanger.artemis.io.GFF3AttributeBuilder;
import uk.ac.sanger.artemis.io.GFFStreamFeature;
import uk.ac.sanger.artemis.io.GenbankStreamFeature;
import uk.ac.sanger.artemis.io.Key;
import uk.ac.sanger.artemis.io.LineGroup;
import uk.ac.sanger.artemis.io.Location;
import uk.ac.sanger.artemis.io.MSPcrunchStreamFeature;
import uk.ac.sanger.artemis.io.Qualifier;
import uk.ac.sanger.artemis.io.QualifierVector;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RangeVector;
import uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature;
import uk.ac.sanger.artemis.util.DatabaseDocument;
import uk.ac.sanger.artemis.util.InputStreamProgressListener;
import uk.ac.sanger.artemis.util.LinePushBackReader;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = false, useJEE = true) 
public class GFFStreamFeature_ESTest extends GFFStreamFeature_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      
      GFFStreamFeature gFFStreamFeature2 = (GFFStreamFeature)gFFStreamFeature0.copy();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature2.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature2.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature2);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature2);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature2, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature2, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature2.isReadOnly());
      assertNull(gFFStreamFeature2.getGffSeqName());
      assertTrue(gFFStreamFeature2.isVisible());
      assertFalse(gFFStreamFeature2.isLazyLoaded());
      assertNull(gFFStreamFeature2.getGffSource());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)119;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)0, (byte)119, (byte) (-68), (byte)116, (byte)119}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Timestamp timestamp1 = gFFStreamFeature1.getLastModified();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(timestamp1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(timestamp1, timestamp0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals("1970-01-01 00:00:02.889", timestamp1.toString());
      assertEquals(889000000, timestamp1.getNanos());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      RangeVector rangeVector0 = new RangeVector(range1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertNotNull(rangeVector0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals("[2889]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      
      String string0 = gFFStreamFeature0.getSegmentID(rangeVector0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals("[2889]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      
      Hashtable<String, String> hashtable1 = gFFStreamFeature1.getNewIdMapToOldId();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      String[] stringArray0 = gFFStreamFeature1.getPrefix("Sw", '=');
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(stringArray0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(2, stringArray0.length);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Hashtable<String, Integer> hashtable2 = gFFStreamFeature0.getFeature_relationship_rank_store();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(hashtable2);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)0, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      
      GFFStreamFeature gFFStreamFeature2 = (GFFStreamFeature)gFFStreamFeature1.copy();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature2.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature2.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature2);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature2);
      assertNotSame(gFFStreamFeature2, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature2, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature2);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature2.getGffSource());
      assertTrue(gFFStreamFeature2.isVisible());
      assertFalse(gFFStreamFeature2.isReadOnly());
      assertNull(gFFStreamFeature2.getGffSeqName());
      assertFalse(gFFStreamFeature2.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      
      Hashtable<String, Integer> hashtable1 = gFFStreamFeature0.getFeature_relationship_rank_store();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature2));
      assertNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature2);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      String[] stringArray0 = gFFStreamFeature0.getPrefix("internal error - unexpected exception: ", 'p');
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature2));
      assertNotNull(stringArray0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature2);
      assertEquals(2, stringArray0.length);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)119;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)119}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      
      Timestamp timestamp1 = gFFStreamFeature1.getLastModified();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(timestamp1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(timestamp1, timestamp0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertEquals("1970-01-01 00:00:02.889", timestamp1.toString());
      assertEquals(889000000, timestamp1.getNanos());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      RangeVector rangeVector0 = new RangeVector();
      assertNotNull(rangeVector0);
      assertEquals(0, rangeVector0.size());
      assertTrue(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[]", rangeVector0.toString());
      
      String string1 = gFFStreamFeature0.getSegmentID(rangeVector0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(string1.equals((Object)string0));
      assertNotNull(string1);
      assertEquals("", string1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertEquals(0, rangeVector0.size());
      assertTrue(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[]", rangeVector0.toString());
      
      Hashtable<String, String> hashtable1 = gFFStreamFeature1.getNewIdMapToOldId();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      String[] stringArray0 = gFFStreamFeature1.getPrefix("Sw", '=');
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(stringArray0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(2, stringArray0.length);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      
      Hashtable<String, Integer> hashtable2 = gFFStreamFeature0.getFeature_relationship_rank_store();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(hashtable2);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte) (-18);
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)99;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte) (-18), (byte) (-68), (byte)99, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      gFFStreamFeature0.setGffSeqName("internal error - unexpected exception: ");
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[1] = (byte)0;
      byteArray0[1] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)11, (byte)0, (byte)119, (byte) (-68), (byte)0, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertNotNull(hashtable0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature0);
      assertFalse(boolean0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      gFFStreamFeature0.setGffSeqName("internal error - unexpected exception: ");
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.add("2M2<ZAt%pSuLVA(l", "internal error - unexpected exception: ");
      gFFStreamFeature0.prepareProcessors(gFF3AttributeBuilder0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature0.setLastModified(timestamp0);
      assertFalse(range0.equals((Object)range1));
      assertNotSame(range0, range1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      MockFileWriter mockFileWriter0 = new MockFileWriter("internal error - unexpected exception: ", false);
      assertNotNull(mockFileWriter0);
      
      gFFStreamFeature0.writeToStream(mockFileWriter0);
      assertFalse(range0.equals((Object)range1));
      assertNotSame(range0, range1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      
      GFFStreamFeature gFFStreamFeature1 = (GFFStreamFeature)gFFStreamFeature0.copy();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      
      Hashtable<String, Integer> hashtable1 = gFFStreamFeature0.getFeature_relationship_rank_store();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("internal error - unexpected exception: ", gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)119;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)119}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Timestamp timestamp1 = gFFStreamFeature1.getLastModified();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(timestamp1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(timestamp1, timestamp0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals(889000000, timestamp1.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp1.toString());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      RangeVector rangeVector0 = new RangeVector();
      assertNotNull(rangeVector0);
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[]", rangeVector0.toString());
      assertTrue(rangeVector0.isEmpty());
      assertEquals(0, rangeVector0.size());
      
      String string1 = gFFStreamFeature0.getSegmentID(rangeVector0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(string1.equals((Object)string0));
      assertNotNull(string1);
      assertEquals("", string1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[]", rangeVector0.toString());
      assertTrue(rangeVector0.isEmpty());
      assertEquals(0, rangeVector0.size());
      
      Hashtable<String, String> hashtable1 = gFFStreamFeature1.getNewIdMapToOldId();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      gFFStreamFeature1.setLastModified(timestamp1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(timestamp1, timestamp0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals(889000000, timestamp1.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp1.toString());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      Qualifier qualifier0 = new Qualifier("internal error - unexpected exception: ", "");
      assertNotNull(qualifier0);
      assertEquals("internal error - unexpected exception: ", qualifier0.getName());
      
      boolean boolean1 = qualifierVector0.add(qualifier0);
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(1, qualifierVector0.size());
      assertFalse(qualifierVector0.isEmpty());
      assertEquals("internal error - unexpected exception: ", qualifier0.getName());
      
      boolean boolean2 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean2 == boolean1);
      assertTrue(boolean2 == boolean0);
      assertFalse(boolean2);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(1, qualifierVector0.size());
      assertFalse(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(1, qualifierVector0.size());
      assertFalse(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(1, qualifierVector0.size());
      assertFalse(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2871, 2871);
      assertNotNull(range0);
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      Boolean boolean0 = new Boolean("internal error - unexpected exception: ");
      assertNotNull(boolean0);
      assertFalse(boolean0);
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range1, range0);
      assertNotSame(range0, range1);
      assertEquals(1, range1.getCount());
      assertEquals(2871, range1.getStart());
      assertEquals(2871, range1.getEnd());
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      
      Timestamp timestamp0 = new Timestamp(2871);
      assertNotNull(timestamp0);
      assertEquals(871000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.871", timestamp0.toString());
      
      Clipboard clipboard0 = new Clipboard(" n}n8U}ebcmeV3fv");
      assertNotNull(clipboard0);
      assertEquals(" n}n8U}ebcmeV3fv", clipboard0.getName());
      
      Selection selection0 = new Selection(clipboard0);
      assertNotNull(selection0);
      assertEquals(" n}n8U}ebcmeV3fv", clipboard0.getName());
      
      RangeVector rangeVector0 = selection0.getSelectionRanges();
      assertNotNull(rangeVector0);
      assertEquals(" n}n8U}ebcmeV3fv", clipboard0.getName());
      assertEquals(0, rangeVector0.size());
      assertTrue(rangeVector0.isEmpty());
      assertEquals("[]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertFalse(range0.equals((Object)range1));
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature(gFFStreamFeature0);
      assertFalse(range0.equals((Object)range1));
      assertNotNull(genbankStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(genbankStreamFeature0);
      assertFalse(range0.equals((Object)range1));
      assertNotNull(databaseStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSource());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertFalse(databaseStreamFeature0.isReadOnly());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(databaseStreamFeature0, false);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2871, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2871, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSource());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      
      MockFile mockFile0 = new MockFile("internal error - unexpected exception: ");
      assertNotNull(mockFile0);
      
      MockFileWriter mockFileWriter0 = new MockFileWriter(mockFile0, false);
      assertNotNull(mockFileWriter0);
      
      // Undeclared exception!
      try { 
        gFFStreamFeature0.writeToStream(mockFileWriter0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      org.gmod.schema.sequence.Feature feature0 = new org.gmod.schema.sequence.Feature();
      assertNotNull(feature0);
      assertNull(feature0.getMd5Checksum());
      assertFalse(feature0.isAnalysis());
      assertNull(feature0.getUniqueName());
      assertFalse(feature0.isObsolete());
      assertNull(feature0.getName());
      assertNull(feature0.getDisplayName());
      assertEquals((-1), feature0.getSeqLen());
      assertEquals(0, feature0.getFeatureId());
      
      gFFStreamFeature0.setChadoLazyFeature(feature0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(feature0.getMd5Checksum());
      assertFalse(feature0.isAnalysis());
      assertNull(feature0.getUniqueName());
      assertFalse(feature0.isObsolete());
      assertNull(feature0.getName());
      assertNull(feature0.getDisplayName());
      assertEquals((-1), feature0.getSeqLen());
      assertEquals(0, feature0.getFeatureId());
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      String string1 = gFFStreamFeature0.getGffSource();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(string1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      StringReader stringReader0 = new StringReader("");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      GFFStreamFeature gFFStreamFeature0 = GFFStreamFeature.readFromStream(linePushBackReader0);
      assertNull(gFFStreamFeature0);
      assertEquals(0, linePushBackReader0.getLineNumber());
  }

  @Test(timeout = 4000)
  public void test12()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(false);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      org.gmod.schema.sequence.Feature feature0 = gFFStreamFeature0.getChadoLazyFeature();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(feature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      boolean boolean1 = gFFStreamFeature0.isReadOnly();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test13()  throws Throwable  {
      Range range0 = new Range((-925));
      assertNotNull(range0);
      assertEquals((-925), range0.getStart());
      assertEquals((-925), range0.getEnd());
      assertEquals(1, range0.getCount());
      
      RangeVector rangeVector0 = new RangeVector(range0);
      assertNotNull(rangeVector0);
      assertEquals((-925), range0.getStart());
      assertEquals((-925), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals("[-925]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      
      Location location0 = new Location(rangeVector0, false);
      assertNotNull(location0);
      assertEquals((-925), range0.getStart());
      assertEquals((-925), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals("[-925]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      
      Location location1 = location0.reverseComplement((-925));
      assertFalse(location1.equals((Object)location0));
      assertNotNull(location1);
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertEquals((-925), range0.getStart());
      assertEquals((-925), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals("[-925]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertNotNull(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      
      Feature feature0 = chadoCanonicalGene0.getTranscriptFeatureFromName(".3zwu");
      assertNull(feature0);
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      
      GFFStreamFeature.removeAttribute("6n(^Z ZUrgk)-i");
      boolean boolean0 = NetworkHandling.createRemoteTextFile((EvoSuiteURL) null, "");
      assertFalse(boolean0);
      
      Key key0 = new Key("", true);
      assertNotNull(key0);
      assertEquals("", key0.getKeyString());
      assertEquals("", key0.toString());
      assertEquals(0, key0.length());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals("[]", qualifierVector0.toString());
      
      QualifierVector qualifierVector1 = qualifierVector0.copy();
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNotNull(qualifierVector1);
      assertNotSame(qualifierVector0, qualifierVector1);
      assertNotSame(qualifierVector1, qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector1.capacity());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location1, qualifierVector1);
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertTrue(qualifierVector0.equals((Object)qualifierVector1));
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNotNull(gFFStreamFeature0);
      assertEquals((-925), range0.getStart());
      assertEquals((-925), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals("[-925]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("", key0.getKeyString());
      assertEquals("", key0.toString());
      assertEquals(0, key0.length());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector1.capacity());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.size());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      gFFStreamFeature0.setGffSource("~My\"._M[5[Pgm6sx#");
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertTrue(qualifierVector0.equals((Object)qualifierVector1));
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertNotSame(qualifierVector0, qualifierVector1);
      assertNotSame(qualifierVector1, qualifierVector0);
      assertEquals((-925), range0.getStart());
      assertEquals((-925), range0.getEnd());
      assertEquals(1, range0.getCount());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals("[-925]", rangeVector0.toString());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("", key0.getKeyString());
      assertEquals("", key0.toString());
      assertEquals(0, key0.length());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector1.capacity());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.size());
      assertEquals("~My\"._M[5[Pgm6sx#", gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
  }

  @Test(timeout = 4000)
  public void test14()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      int int0 = byteArrayReader0.read(byteArray0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, int0);
      assertEquals(7, byteArray0.length);
      assertEquals(0, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(0, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      org.gmod.schema.sequence.Feature feature0 = gFFStreamFeature0.getChadoLazyFeature();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(feature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      boolean boolean1 = gFFStreamFeature0.isReadOnly();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      gFFStreamFeature1.setLazyLoaded(false);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
  }

  @Test(timeout = 4000)
  public void test15()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      
      PipedReader pipedReader0 = new PipedReader(2329);
      assertNotNull(pipedReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      try { 
        gFFStreamFeature0.setFromStream((EntryInformation) null, linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test16()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)119;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)119}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getStart());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Timestamp timestamp1 = gFFStreamFeature1.getLastModified();
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(timestamp1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(timestamp1, timestamp0);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("1970-01-01 00:00:02.889", timestamp1.toString());
      assertEquals(889000000, timestamp1.getNanos());
  }

  @Test(timeout = 4000)
  public void test17()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)0;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)0, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.setGlue("Query", "timelastmodified");
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      org.gmod.schema.sequence.Feature feature0 = gFFStreamFeature0.getChadoLazyFeature();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(feature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean1 = gFFStreamFeature0.isReadOnly();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFFStreamFeature gFFStreamFeature2 = (GFFStreamFeature)gFFStreamFeature1.copy();
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature2.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature2.equals((Object)gFFStreamFeature1));
      assertNotNull(gFFStreamFeature2);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature2);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature2);
      assertNotSame(gFFStreamFeature2, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature2, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature2.isReadOnly());
      assertNull(gFFStreamFeature2.getGffSeqName());
      assertNull(gFFStreamFeature2.getGffSource());
      assertFalse(gFFStreamFeature2.isLazyLoaded());
      assertTrue(gFFStreamFeature2.isVisible());
  }

  @Test(timeout = 4000)
  public void test18()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte) (-18);
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte) (-18), (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setSegmentRangeStore(hashtable0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Integer> hashtable1 = new Hashtable<String, Integer>();
      assertNotNull(hashtable1);
      assertTrue(hashtable1.isEmpty());
      assertEquals(0, hashtable1.size());
      
      gFFStreamFeature1.setFeature_relationship_rank_store(hashtable1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(hashtable1.isEmpty());
      assertEquals(0, hashtable1.size());
  }

  @Test(timeout = 4000)
  public void test19()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable1 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(hashtable1, hashtable0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(hashtable1.isEmpty());
      assertEquals(1, hashtable1.size());
  }

  @Test(timeout = 4000)
  public void test20()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      Instant instant0 = timestamp0.toInstant();
      assertNotNull(instant0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Integer> hashtable1 = gFFStreamFeature1.getFeature_relationship_rank_store();
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(hashtable1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test21()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      genbankStreamFeature0.setDirtyFlag();
      boolean boolean0 = NetworkHandling.createRemoteTextFile((EvoSuiteURL) null, "");
      assertFalse(boolean0);
      
      genbankStreamFeature0.setDirtyFlag();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(genbankStreamFeature0);
      assertNotNull(databaseStreamFeature0);
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter("#_V!MQo]j,6JKISD&5");
      assertNotNull(mockPrintWriter0);
      
      boolean boolean1 = FileSystemHandling.shouldAllThrowIOExceptions();
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      
      LineGroup.writeStartOfGFFEntry(mockPrintWriter0);
      String string0 = databaseStreamFeature0.getGffSeqName();
      assertNull(string0);
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      
      DatabaseStreamFeature databaseStreamFeature1 = (DatabaseStreamFeature)databaseStreamFeature0.copy();
      assertFalse(databaseStreamFeature1.equals((Object)databaseStreamFeature0));
      assertNotNull(databaseStreamFeature1);
      assertNotSame(databaseStreamFeature0, databaseStreamFeature1);
      assertNotSame(databaseStreamFeature1, databaseStreamFeature0);
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      assertNull(databaseStreamFeature1.getGffSeqName());
      assertNull(databaseStreamFeature1.getGffSource());
      assertFalse(databaseStreamFeature1.isReadOnly());
      assertFalse(databaseStreamFeature1.isLazyLoaded());
      assertTrue(databaseStreamFeature1.isVisible());
  }

  @Test(timeout = 4000)
  public void test22()  throws Throwable  {
      boolean boolean0 = NetworkHandling.createRemoteTextFile((EvoSuiteURL) null, "1dCuvZ_6");
      assertFalse(boolean0);
      
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertNotNull(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      
      Feature feature0 = chadoCanonicalGene0.getGene();
      assertNull(feature0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      
      boolean boolean1 = GFFStreamFeature.isGTF((Feature) null);
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      Key key0 = new Key("\"N+", false);
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("\"N+", key0.toString());
      assertEquals("\"N+", key0.getKeyString());
      
      Range range0 = new Range(4);
      assertNotNull(range0);
      assertEquals(4, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(4, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location0, qualifierVector0, chadoCanonicalGene0);
      assertNotNull(databaseInferredFeature0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(3, key0.length());
      assertEquals("\"N+", key0.toString());
      assertEquals("\"N+", key0.getKeyString());
      assertEquals(4, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(databaseInferredFeature0.getGffSeqName());
      assertFalse(databaseInferredFeature0.isLazyLoaded());
      assertTrue(databaseInferredFeature0.isVisible());
      assertFalse(databaseInferredFeature0.isReadOnly());
      assertNull(databaseInferredFeature0.getGffSource());
      
      ChadoCanonicalGene chadoCanonicalGene1 = databaseInferredFeature0.getChadoGene();
      assertNotNull(chadoCanonicalGene1);
      assertSame(chadoCanonicalGene0, chadoCanonicalGene1);
      assertSame(chadoCanonicalGene1, chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(3, key0.length());
      assertEquals("\"N+", key0.toString());
      assertEquals("\"N+", key0.getKeyString());
      assertEquals(4, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(databaseInferredFeature0.getGffSeqName());
      assertFalse(databaseInferredFeature0.isLazyLoaded());
      assertTrue(databaseInferredFeature0.isVisible());
      assertFalse(databaseInferredFeature0.isReadOnly());
      assertNull(databaseInferredFeature0.getGffSource());
      assertEquals(0, chadoCanonicalGene1.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene1.getSeqlen());
      
      String string0 = "sXI0L{!\\BU#9Y+_VK3R";
      char char0 = 'S';
      Key key1 = Key.CDS;
      assertFalse(key1.equals((Object)key0));
      assertNotNull(key1);
      assertNotSame(key1, key0);
      assertEquals(3, key1.length());
      assertEquals("CDS", key1.getKeyString());
      assertEquals("CDS", key1.toString());
      
      ReadOnlyEmblStreamFeature readOnlyEmblStreamFeature0 = new ReadOnlyEmblStreamFeature(key1, location0, qualifierVector0);
      assertFalse(key1.equals((Object)key0));
      assertNotNull(readOnlyEmblStreamFeature0);
      assertEquals(4, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(4, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertEquals(3, key1.length());
      assertEquals("CDS", key1.getKeyString());
      assertEquals("CDS", key1.toString());
      
      StringVector stringVector0 = StringVector.getStrings("\"N+", "hsql://");
      assertNotNull(stringVector0);
      assertEquals(1, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[\"N+]", stringVector0.toString());
      
      Qualifier qualifier0 = new Qualifier("SELECT synonym_id FROM synonym WHERE synonym.name='", stringVector0);
      assertNotNull(qualifier0);
      assertEquals(1, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[\"N+]", stringVector0.toString());
      assertEquals("SELECT synonym_id FROM synonym WHERE synonym.name='", qualifier0.getName());
      
      Qualifier qualifier1 = qualifierVector0.addQualifierValues(qualifier0);
      assertNull(qualifier1);
      assertFalse(qualifierVector0.isEmpty());
      assertEquals(1, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(1, stringVector0.size());
      assertFalse(stringVector0.isEmpty());
      assertEquals(10, stringVector0.capacity());
      assertEquals("[\"N+]", stringVector0.toString());
      assertEquals("SELECT synonym_id FROM synonym WHERE synonym.name='", qualifier0.getName());
      
      try { 
        readOnlyEmblStreamFeature0.addQualifierValues((Qualifier) null);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.ReadOnlyEmblStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test23()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(emblStreamFeature0);
      assertNotNull(gFFStreamFeature0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Range range0 = new Range(0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertNotNull(string0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertNotNull(hashtable0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      
      gFFStreamFeature0.setSegmentRangeStore(hashtable0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertNotNull(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      
      gFFStreamFeature0.setChadoGene(chadoCanonicalGene0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
  }

  @Test(timeout = 4000)
  public void test24()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      ChadoCanonicalGene chadoCanonicalGene0 = gFFStreamFeature0.getChadoGene();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(chadoCanonicalGene0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(qualifierVector0.isEmpty());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test25()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(emblStreamFeature0);
      assertNotNull(gFFStreamFeature0);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      String string0 = range0.toString();
      assertNotNull(string0);
      assertEquals("0", string0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      String string1 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(string1.equals((Object)string0));
      assertNotNull(string1);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      RangeVector rangeVector0 = new RangeVector();
      assertNotNull(rangeVector0);
      assertEquals(0, rangeVector0.size());
      assertTrue(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[]", rangeVector0.toString());
      
      String string2 = gFFStreamFeature0.getSegmentID(rangeVector0);
      assertFalse(string2.equals((Object)string1));
      assertFalse(string2.equals((Object)string0));
      assertNotNull(string2);
      assertEquals("", string2);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals(0, rangeVector0.size());
      assertTrue(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[]", rangeVector0.toString());
  }

  @Test(timeout = 4000)
  public void test26()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertTrue(gFFStreamFeature1.isVisible());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      org.gmod.schema.sequence.Feature feature0 = gFFStreamFeature0.getChadoLazyFeature();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(feature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      boolean boolean1 = gFFStreamFeature0.isReadOnly();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean1 == boolean0);
      assertTrue(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(0, qualifierVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
  }

  @Test(timeout = 4000)
  public void test27()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(emblStreamFeature0);
      assertNotNull(gFFStreamFeature0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertNotNull(string0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals(0, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getStart());
      
      Timestamp timestamp0 = gFFStreamFeature0.getLastModified();
      assertNull(timestamp0);
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      // Undeclared exception!
      try { 
        gFFStreamFeature0.setLastModified((Timestamp) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.util.Calendar", e);
      }
  }

  @Test(timeout = 4000)
  public void test28()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte) (-18);
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte) (-18), (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertFalse(hashtable0.isEmpty());
      assertEquals(1, hashtable0.size());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFF3AttributeBuilder0.unsetAggregator("internal error - unexpected exception: ", (GFF3AttributeAggregator) null);
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getEnd());
      
      boolean boolean1 = FileSystemHandling.createFolder((EvoSuiteFile) null);
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      long long0 = timestamp0.getTime();
      assertEquals(2889L, long0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setGffSeqName("");
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("", gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector0.size());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test29()  throws Throwable  {
      JPasswordField jPasswordField0 = new JPasswordField(2368);
      assertNotNull(jPasswordField0);
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      
      SynthMenuBarUI synthMenuBarUI0 = new SynthMenuBarUI();
      assertNotNull(synthMenuBarUI0);
      
      jPasswordField0.addPropertyChangeListener("Error configuring Result.  Could not set ResultClass.  Cause: ", (PropertyChangeListener) synthMenuBarUI0);
      assertFalse(jPasswordField0.getIgnoreRepaint());
      assertTrue(jPasswordField0.getFocusTraversalKeysEnabled());
      assertFalse(jPasswordField0.isFocusCycleRoot());
      assertFalse(jPasswordField0.isFocusTraversalPolicySet());
      assertFalse(jPasswordField0.isFocusTraversalPolicyProvider());
      
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(emblStreamFeature0, true);
      assertNotNull(gFFStreamFeature0);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      gFFStreamFeature0.setVisible(false);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      InputStreamProgressListener inputStreamProgressListener0 = mock(InputStreamProgressListener.class, new ViolatedAssumptionAnswer());
      DatabaseDocument databaseDocument0 = null;
      try {
        databaseDocument0 = new DatabaseDocument((String) null, jPasswordField0, (String) null, "]a)+n'<B*`Sz", false, inputStreamProgressListener0);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - created a null Document
         //
         verifyException("uk.ac.sanger.artemis.util.Document", e);
      }
  }

  @Test(timeout = 4000)
  public void test30()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getStart());
      assertEquals(2889, range1.getEnd());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNull(gFFStreamFeature1.getGffSource());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getEnd());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isVisible());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      MockFileWriter mockFileWriter0 = new MockFileWriter("internal error - unexpected exception: ", false);
      assertNotNull(mockFileWriter0);
      
      // Undeclared exception!
      try { 
        gFFStreamFeature1.writeToStream(mockFileWriter0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test31()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte) (-18), (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)116, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertEquals(889000000, timestamp0.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(boolean1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertTrue(gFFStreamFeature1.isVisible());
      assertNull(gFFStreamFeature1.getGffSource());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      String string0 = gFFStreamFeature0.getSegmentID(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      
      boolean boolean2 = gFFStreamFeature0.isVisible();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean2 == boolean1);
      assertFalse(boolean2 == boolean0);
      assertTrue(boolean2);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("[]", qualifierVector0.toString());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
  }

  @Test(timeout = 4000)
  public void test32()  throws Throwable  {
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      assertNotNull(emblStreamFeature0);
      
      MSPcrunchStreamFeature mSPcrunchStreamFeature0 = new MSPcrunchStreamFeature(emblStreamFeature0);
      assertNotNull(mSPcrunchStreamFeature0);
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(mSPcrunchStreamFeature0, true);
      assertNotNull(gFFStreamFeature0);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = gFFStreamFeature0.isLazyLoaded();
      assertFalse(boolean0);
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSource());
      assertNull(gFFStreamFeature0.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test33()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader(2447);
      assertNotNull(pipedReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      try { 
        GFFStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test34()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(3078);
      assertNotNull(range0);
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      
      RangeVector rangeVector0 = new RangeVector(range0);
      assertNotNull(rangeVector0);
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      
      Location location0 = new Location(rangeVector0, true);
      assertNotNull(location0);
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      
      String string0 = range0.toString();
      assertNotNull(string0);
      assertEquals("3078", string0);
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      
      Location location1 = location0.reverseComplement((-2321), 0);
      assertFalse(location1.equals((Object)location0));
      assertNotNull(location1);
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      
      QualifierVector qualifierVector1 = qualifierVector0.copy();
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNotNull(qualifierVector1);
      assertNotSame(qualifierVector0, qualifierVector1);
      assertNotSame(qualifierVector1, qualifierVector0);
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector1.size());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location1, qualifierVector1);
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertTrue(qualifierVector0.equals((Object)qualifierVector1));
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector1.size());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.capacity());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      
      Hashtable<String, String> hashtable0 = gFFStreamFeature0.getNewIdMapToOldId();
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertTrue(qualifierVector0.equals((Object)qualifierVector1));
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNull(hashtable0);
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertNotSame(qualifierVector0, qualifierVector1);
      assertNotSame(qualifierVector1, qualifierVector0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector1.size());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.capacity());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      
      gFFStreamFeature0.setNewIdMapToOldId((Hashtable<String, String>) null);
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertTrue(qualifierVector0.equals((Object)qualifierVector1));
      assertTrue(qualifierVector1.equals((Object)qualifierVector0));
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertNotSame(qualifierVector0, qualifierVector1);
      assertNotSame(qualifierVector1, qualifierVector0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.toString());
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals("[]", qualifierVector0.toString());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals(0, qualifierVector1.size());
      assertEquals("[]", qualifierVector1.toString());
      assertTrue(qualifierVector1.isEmpty());
      assertEquals(0, qualifierVector1.capacity());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      
      String string1 = location1.toStringShort();
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertFalse(string1.equals((Object)string0));
      assertNotNull(string1);
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertEquals(3078, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(3078, range0.getStart());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(10, rangeVector0.capacity());
      assertEquals("[3078]", rangeVector0.toString());
      assertEquals(1, rangeVector0.size());
      
      // Undeclared exception!
      try { 
        gFFStreamFeature0.getAutoNumber("", 'g');
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test35()  throws Throwable  {
      GenbankStreamFeature genbankStreamFeature0 = new GenbankStreamFeature();
      assertNotNull(genbankStreamFeature0);
      
      genbankStreamFeature0.setDirtyFlag();
      genbankStreamFeature0.setDirtyFlag();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(genbankStreamFeature0);
      assertNotNull(databaseStreamFeature0);
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
      
      MockPrintWriter mockPrintWriter0 = new MockPrintWriter("#_V!MQo]j,6JKISD&5");
      assertNotNull(mockPrintWriter0);
      
      LineGroup.writeStartOfGFFEntry(mockPrintWriter0);
      String string0 = databaseStreamFeature0.getGffSeqName();
      assertNull(string0);
      assertFalse(databaseStreamFeature0.isReadOnly());
      assertNull(databaseStreamFeature0.getGffSeqName());
      assertNull(databaseStreamFeature0.getGffSource());
      assertTrue(databaseStreamFeature0.isVisible());
      assertFalse(databaseStreamFeature0.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test36()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((String) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.util.StringVector", e);
      }
  }

  @Test(timeout = 4000)
  public void test37()  throws Throwable  {
      // Undeclared exception!
      try { 
        GFFStreamFeature.readFromStream((LinePushBackReader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test38()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test39()  throws Throwable  {
      StringReader stringReader0 = new StringReader("org.apache.log4j.helpers.DateLayout");
      assertNotNull(stringReader0);
      
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      assertNotNull(linePushBackReader0);
      assertEquals(0, linePushBackReader0.getLineNumber());
      
      try { 
        GFFStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: org.apache.log4j.helpers.DateLayout
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test40()  throws Throwable  {
      boolean boolean0 = GFFStreamFeature.isGTF((Feature) null);
      assertFalse(boolean0);
      
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature("Parent");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: Parent
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test41()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(0, 0);
      assertNotNull(range0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      
      RangeVector rangeVector0 = new RangeVector(range0);
      assertNotNull(rangeVector0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[0]", rangeVector0.toString());
      
      Location location0 = new Location(rangeVector0, true);
      assertNotNull(location0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[0]", rangeVector0.toString());
      
      Location location1 = location0.addRange(range0);
      assertFalse(location1.equals((Object)location0));
      assertNotNull(location1);
      assertNotSame(location0, location1);
      assertNotSame(location1, location0);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[0]", rangeVector0.toString());
      
      Location location2 = location1.reverseComplement(0);
      assertFalse(location0.equals((Object)location1));
      assertFalse(location1.equals((Object)location0));
      assertFalse(location2.equals((Object)location0));
      assertFalse(location2.equals((Object)location1));
      assertNotNull(location2);
      assertNotSame(location0, location1);
      assertNotSame(location0, location2);
      assertNotSame(location1, location0);
      assertNotSame(location1, location2);
      assertNotSame(location2, location0);
      assertNotSame(location2, location1);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[0]", rangeVector0.toString());
      
      Location location3 = location2.removeRange(range0);
      assertFalse(location0.equals((Object)location1));
      assertFalse(location0.equals((Object)location2));
      assertFalse(location1.equals((Object)location0));
      assertFalse(location1.equals((Object)location2));
      assertFalse(location2.equals((Object)location0));
      assertFalse(location2.equals((Object)location1));
      assertFalse(location3.equals((Object)location0));
      assertFalse(location3.equals((Object)location2));
      assertFalse(location3.equals((Object)location1));
      assertNotNull(location3);
      assertNotSame(location0, location1);
      assertNotSame(location0, location3);
      assertNotSame(location0, location2);
      assertNotSame(location1, location3);
      assertNotSame(location1, location0);
      assertNotSame(location1, location2);
      assertNotSame(location2, location0);
      assertNotSame(location2, location1);
      assertNotSame(location2, location3);
      assertNotSame(location3, location0);
      assertNotSame(location3, location2);
      assertNotSame(location3, location1);
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[0]", rangeVector0.toString());
      
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertNotNull(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      
      DatabaseInferredFeature databaseInferredFeature0 = new DatabaseInferredFeature(key0, location3, (QualifierVector) null, chadoCanonicalGene0);
      assertFalse(location0.equals((Object)location1));
      assertFalse(location0.equals((Object)location3));
      assertFalse(location0.equals((Object)location2));
      assertFalse(location1.equals((Object)location3));
      assertFalse(location1.equals((Object)location0));
      assertFalse(location1.equals((Object)location2));
      assertFalse(location2.equals((Object)location0));
      assertFalse(location2.equals((Object)location1));
      assertFalse(location2.equals((Object)location3));
      assertFalse(location3.equals((Object)location0));
      assertFalse(location3.equals((Object)location2));
      assertFalse(location3.equals((Object)location1));
      assertNotNull(databaseInferredFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(0, range0.getStart());
      assertEquals(1, range0.getCount());
      assertEquals(0, range0.getEnd());
      assertEquals(10, rangeVector0.capacity());
      assertEquals(1, rangeVector0.size());
      assertFalse(rangeVector0.isEmpty());
      assertEquals("[0]", rangeVector0.toString());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertTrue(databaseInferredFeature0.isVisible());
      assertFalse(databaseInferredFeature0.isLazyLoaded());
      assertNull(databaseInferredFeature0.getGffSource());
      assertFalse(databaseInferredFeature0.isReadOnly());
      assertNull(databaseInferredFeature0.getGffSeqName());
      
      // Undeclared exception!
      try { 
        databaseInferredFeature0.getAutoNumber((String) null, ';');
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test42()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((Key) null, (Location) null, (QualifierVector) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test43()  throws Throwable  {
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertNotNull(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      
      StringVector stringVector0 = StringVector.getStrings("*=9*'/T.");
      assertNotNull(stringVector0);
      assertFalse(stringVector0.isEmpty());
      assertEquals(1, stringVector0.size());
      assertEquals("[*=9*'/T.]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      
      Feature feature0 = chadoCanonicalGene0.containsTranscript(stringVector0);
      assertNull(feature0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      assertFalse(stringVector0.isEmpty());
      assertEquals(1, stringVector0.size());
      assertEquals("[*=9*'/T.]", stringVector0.toString());
      assertEquals(10, stringVector0.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature((Feature) null, false);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test44()  throws Throwable  {
      String string0 = "";
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature("");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // invalid GFF line: 8 fields needed (got 0 fields) from: 
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test45()  throws Throwable  {
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature("uk.ac.sanger.artemis.io.GFFStreamFeature$1");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: uk.ac.sanger.artemis.io.GFFStreamFeature$1
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test46()  throws Throwable  {
      GFFStreamFeature.removeAttribute("lowrite");
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      assertNotNull(chadoCanonicalGene0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      
      boolean boolean0 = FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      assertFalse(boolean0);
      
      Feature feature0 = chadoCanonicalGene0.getTranscriptFeatureFromName("lowrite");
      assertNull(feature0);
      assertEquals(0, chadoCanonicalGene0.getSrcfeature_id());
      assertEquals(0, chadoCanonicalGene0.getSeqlen());
      
      DatabaseStreamFeature databaseStreamFeature0 = null;
      try {
        databaseStreamFeature0 = new DatabaseStreamFeature((Feature) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test47()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)119;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)0, (byte)119, (byte) (-68), (byte)116, (byte)119}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      boolean boolean1 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertTrue(boolean1 == boolean0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(boolean1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Timestamp timestamp1 = gFFStreamFeature1.getLastModified();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(timestamp1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertSame(timestamp1, timestamp0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(889000000, timestamp1.getNanos());
      assertEquals("1970-01-01 00:00:02.889", timestamp1.toString());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      RangeVector rangeVector0 = new RangeVector(range1);
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertNotNull(rangeVector0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals("[2889]", rangeVector0.toString());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      assertEquals(10, rangeVector0.capacity());
      
      rangeVector0.trimToSize();
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals("[2889]", rangeVector0.toString());
      assertEquals(1, rangeVector0.capacity());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(1, rangeVector0.size());
      
      boolean boolean2 = rangeVector0.add(range0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertFalse(boolean2 == boolean1);
      assertFalse(boolean2 == boolean0);
      assertTrue(boolean2);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals(2, rangeVector0.capacity());
      assertEquals("[2889, 2889]", rangeVector0.toString());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(2, rangeVector0.size());
      
      String string0 = gFFStreamFeature0.getSegmentID(rangeVector0);
      assertFalse(range0.equals((Object)range1));
      assertFalse(range1.equals((Object)range0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(string0);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range1.getEnd());
      assertEquals(2889, range1.getStart());
      assertEquals(1, range1.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(2, rangeVector0.capacity());
      assertEquals("[2889, 2889]", rangeVector0.toString());
      assertFalse(rangeVector0.isEmpty());
      assertEquals(2, rangeVector0.size());
      
      Hashtable<String, String> hashtable1 = gFFStreamFeature1.getNewIdMapToOldId();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNull(hashtable1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      String[] stringArray0 = gFFStreamFeature1.getPrefix("Sw", '=');
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(stringArray0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(2, stringArray0.length);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
      
      Hashtable<String, Integer> hashtable2 = gFFStreamFeature0.getFeature_relationship_rank_store();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNull(hashtable2);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      String string1 = gFFStreamFeature1.getGffSeqName();
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNull(string1);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertEquals(3, key0.length());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range0.getStart());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertTrue(gFFStreamFeature0.isVisible());
      assertNull(gFFStreamFeature0.getGffSource());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertNull(gFFStreamFeature1.getGffSeqName());
  }

  @Test(timeout = 4000)
  public void test48()  throws Throwable  {
      Key key0 = Key.CDS;
      assertNotNull(key0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      
      Range range0 = new Range(2889, 2889);
      assertNotNull(range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      Location location0 = new Location(range0);
      assertNotNull(location0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      
      QualifierVector qualifierVector0 = new QualifierVector();
      assertNotNull(qualifierVector0);
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      assertNotNull(gFFStreamFeature0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      byte[] byteArray0 = new byte[7];
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      assertNotNull(hashtable0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      
      gFFStreamFeature0.setSegmentRangeStore(hashtable0);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals(1, hashtable0.size());
      assertFalse(hashtable0.isEmpty());
      
      byteArray0[4] = (byte) (-68);
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      assertEquals(7, byteArrayReader0.available());
      
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      assertNotNull(loggerRepository0);
      
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      assertArrayEquals(new byte[] {(byte)0, (byte)0, (byte)11, (byte)119, (byte) (-68), (byte)0, (byte)57}, byteArray0);
      assertEquals(7, byteArray0.length);
      assertEquals(7, byteArrayReader0.available());
      
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertNotNull(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Hashtable<String, Range> hashtable1 = gFFStreamFeature0.getSegmentRangeStore();
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotNull(hashtable1);
      assertSame(hashtable1, hashtable0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertFalse(hashtable1.isEmpty());
      assertEquals(1, hashtable1.size());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      boolean boolean0 = GFFStreamFeature.isGTF(gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertFalse(boolean0);
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      assertNotNull(gFF3AttributeBuilder0);
      
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Range range1 = range0.copy();
      assertFalse(range1.equals((Object)range0));
      assertNotNull(range1);
      assertNotSame(range0, range1);
      assertNotSame(range1, range0);
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals(2889, range1.getEnd());
      assertEquals(1, range1.getCount());
      assertEquals(2889, range1.getStart());
      
      gFFStreamFeature0.setReadOnlyFeature(true);
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      
      Timestamp timestamp0 = new Timestamp(2889);
      assertNotNull(timestamp0);
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      gFFStreamFeature1.setLastModified(timestamp0);
      assertFalse(gFFStreamFeature1.equals((Object)gFFStreamFeature0));
      assertFalse(range0.equals((Object)range1));
      assertFalse(gFFStreamFeature0.equals((Object)gFFStreamFeature1));
      assertNotSame(gFFStreamFeature1, gFFStreamFeature0);
      assertNotSame(range0, range1);
      assertNotSame(gFFStreamFeature0, gFFStreamFeature1);
      assertFalse(gFFStreamFeature1.isReadOnly());
      assertNull(gFFStreamFeature1.getGffSeqName());
      assertTrue(gFFStreamFeature1.isVisible());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
      assertNull(gFFStreamFeature1.getGffSource());
      assertEquals("CDS", key0.getKeyString());
      assertEquals("CDS", key0.toString());
      assertEquals(3, key0.length());
      assertEquals(2889, range0.getStart());
      assertEquals(2889, range0.getEnd());
      assertEquals(1, range0.getCount());
      assertEquals("[]", qualifierVector0.toString());
      assertTrue(qualifierVector0.isEmpty());
      assertEquals(0, qualifierVector0.size());
      assertEquals(7, qualifierVector0.capacity());
      assertNull(gFFStreamFeature0.getGffSource());
      assertTrue(gFFStreamFeature0.isVisible());
      assertFalse(gFFStreamFeature0.isLazyLoaded());
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertNull(gFFStreamFeature0.getGffSeqName());
      assertEquals("1970-01-01 00:00:02.889", timestamp0.toString());
      assertEquals(889000000, timestamp0.getNanos());
      
      MockFileWriter mockFileWriter0 = new MockFileWriter("internal error - unexpected exception: ", false);
      assertNotNull(mockFileWriter0);
      
      // Undeclared exception!
      try { 
        gFFStreamFeature1.writeToStream(mockFileWriter0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test49()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(2889, 2889);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      byte[] byteArray0 = new byte[7];
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      gFFStreamFeature0.getSegmentRangeStore();
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      range0.copy();
      gFFStreamFeature0.setReadOnlyFeature(true);
      Timestamp timestamp0 = new Timestamp(2889);
      gFFStreamFeature1.setLastModified(timestamp0);
      gFFStreamFeature1.copy();
      assertFalse(gFFStreamFeature1.isReadOnly());
      
      gFFStreamFeature0.getFeature_relationship_rank_store();
      gFFStreamFeature0.getPrefix("internal error - unexpected exception: ", 'p');
      assertTrue(gFFStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test50()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(2889, 2889);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      byte[] byteArray0 = new byte[7];
      byteArray0[1] = (byte)0;
      byteArray0[1] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      gFFStreamFeature0.getSegmentRangeStore();
      GFFStreamFeature.isGTF(gFFStreamFeature1);
      gFFStreamFeature1.setGffSeqName("internal error - unexpected exception: ");
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFF3AttributeBuilder0.add("2M2<ZAt%pSuLVA(l", "internal error - unexpected exception: ");
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      range0.copy();
      gFFStreamFeature0.setReadOnlyFeature(true);
      Timestamp timestamp0 = new Timestamp(2889);
      gFFStreamFeature1.setLastModified(timestamp0);
      MockFileWriter mockFileWriter0 = new MockFileWriter("internal error - unexpected exception: ", false);
      gFFStreamFeature1.writeToStream(mockFileWriter0);
      gFFStreamFeature1.copy();
      assertFalse(gFFStreamFeature1.isReadOnly());
      
      gFFStreamFeature0.getFeature_relationship_rank_store();
      assertTrue(gFFStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test51()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(2871, 2871);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      gFFStreamFeature0.getSegmentRangeStore();
      Boolean boolean0 = new Boolean("internal error - unexpected exception: ");
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      range0.copy();
      gFFStreamFeature0.setReadOnlyFeature(true);
      Timestamp timestamp0 = new Timestamp(2871);
      gFFStreamFeature1.setLastModified(timestamp0);
      gFFStreamFeature0.getChadoLazyFeature();
      gFFStreamFeature0.isReadOnly();
      Clipboard clipboard0 = new Clipboard(" n}n8U}ebcmeV3fv");
      Selection selection0 = new Selection(clipboard0);
      RangeVector rangeVector0 = selection0.getSelectionRanges();
      gFFStreamFeature1.getSegmentID(rangeVector0);
      assertTrue(gFFStreamFeature0.isReadOnly());
      assertFalse(gFFStreamFeature1.isLazyLoaded());
  }

  @Test(timeout = 4000)
  public void test52()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(2889, 2889);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(key0, location0, qualifierVector0);
      gFFStreamFeature0.setReadOnlyFeature(false);
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[2] = (byte)11;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-68);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      Category.getDefaultHierarchy();
      GFFStreamFeature gFFStreamFeature1 = new GFFStreamFeature(gFFStreamFeature0);
      Hashtable<String, Range> hashtable0 = gFFStreamFeature0.getSegmentRangeStore();
      GFFStreamFeature.isGTF(gFFStreamFeature1);
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFFStreamFeature1.prepareProcessors(gFF3AttributeBuilder0);
      range0.copy();
      GFFStreamFeature.contig_ranges = hashtable0;
      gFFStreamFeature0.setReadOnlyFeature(true);
      GFFStreamFeature.isGTF(gFFStreamFeature1);
      gFFStreamFeature0.getSegmentID(range0);
      assertTrue(gFFStreamFeature0.isReadOnly());
  }

  @Test(timeout = 4000)
  public void test53()  throws Throwable  {
      Key key0 = Key.CDS;
      Range range0 = new Range(2889, 2889);
      Location location0 = new Location(range0);
      QualifierVector qualifierVector0 = new QualifierVector();
      DatabaseStreamFeature databaseStreamFeature0 = new DatabaseStreamFeature(key0, location0, qualifierVector0);
      byte[] byteArray0 = new byte[7];
      byteArray0[0] = (byte) (-18);
      byteArray0[1] = (byte)0;
      byteArray0[3] = (byte)119;
      byteArray0[4] = (byte) (-23);
      byteArray0[5] = (byte)116;
      byteArray0[6] = (byte)57;
      ByteArrayInputStream byteArrayReader0 = new ByteArrayInputStream(byteArray0);
      LoggerRepository loggerRepository0 = Category.getDefaultHierarchy();
      OptionConverter.selectAndConfigure((InputStream) byteArrayReader0, "internal error - unexpected exception: ", loggerRepository0);
      GFFStreamFeature gFFStreamFeature0 = new GFFStreamFeature(databaseStreamFeature0);
      databaseStreamFeature0.getSegmentRangeStore();
      GFFStreamFeature.isGTF(gFFStreamFeature0);
      GFF3AttributeBuilder gFF3AttributeBuilder0 = new GFF3AttributeBuilder();
      gFFStreamFeature0.prepareProcessors(gFF3AttributeBuilder0);
      Loader.getResource("uk.ac.sanger.artemis.io.GFFStreamFeature$4");
      range0.copy();
      databaseStreamFeature0.setReadOnlyFeature(true);
      Timestamp timestamp0 = new Timestamp(2889);
      gFFStreamFeature0.setLastModified(timestamp0);
      GFFStreamFeature.isGTF(gFFStreamFeature0);
      databaseStreamFeature0.getSegmentID(range0);
      databaseStreamFeature0.getAutoNumber("", 'k');
  }

  @Test(timeout = 4000)
  public void test54()  throws Throwable  {
      Clipboard clipboard0 = new Clipboard((String) null);
      Selection selection0 = new Selection(clipboard0);
      selection0.getSelectionRange();
      uk.ac.sanger.artemis.FeatureVector featureVector0 = selection0.getAllFeatures();
      // Undeclared exception!
      try { 
        featureVector0.elementAt((-1414));
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test55()  throws Throwable  {
      Range range0 = new Range((-878));
      Range range1 = range0.change((-878), (-878));
      RangeVector rangeVector0 = new RangeVector(range0);
      range0.truncate(range1);
      Location location0 = new Location(rangeVector0, false);
      location0.changeRange(range0, range0);
      ChadoCanonicalGene chadoCanonicalGene0 = new ChadoCanonicalGene();
      EmblStreamFeature emblStreamFeature0 = new EmblStreamFeature();
      FileSystemHandling.shouldThrowIOException((EvoSuiteFile) null);
      GFFStreamFeature.removeAttribute("6n(^Z ZUrgk)-i");
      GFFStreamFeature gFFStreamFeature0 = null;
      try {
        gFFStreamFeature0 = new GFFStreamFeature(".3zwu");
        fail("Expecting exception: IOException");
      
      } catch(Throwable e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: .3zwu
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test56()  throws Throwable  {
      StringReader stringReader0 = new StringReader("k'rEYF/YD");
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(stringReader0);
      try { 
        GFFStreamFeature.readFromStream(linePushBackReader0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // invalid GFF line: 8 fields needed (got 1 fields) from: k'rEYF/YD
         //
         verifyException("uk.ac.sanger.artemis.io.GFFStreamFeature", e);
      }
  }

  @Test(timeout = 4000)
  public void test57()  throws Throwable  {
      GFFStreamFeature.includeAttribute("m");
      JPasswordField jPasswordField0 = new JPasswordField("m");
      DatabaseDocument databaseDocument0 = new DatabaseDocument("", jPasswordField0, " new=", (String) null);
      // Undeclared exception!
      try { 
        databaseDocument0.getLinePushBackReader();
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
        
      }
  }
}
