;; Testing i64 lowering.

(module
  (func $dummy)

  (func (export "eq_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.eq (local.get $0) (local.get $1)))

  (func (export "ne_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.ne (local.get $0) (local.get $1)))

  (func (export "ge_s_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.ge_s (local.get $0) (local.get $1)))

  (func (export "gt_s_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.gt_s (local.get $0) (local.get $1)))

  (func (export "le_s_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.le_s (local.get $0) (local.get $1)))

  (func (export "lt_s_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.lt_s (local.get $0) (local.get $1)))

  (func (export "ge_u_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.ge_u (local.get $0) (local.get $1)))

  (func (export "gt_u_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.gt_u (local.get $0) (local.get $1)))

  (func (export "le_u_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.le_u (local.get $0) (local.get $1)))

  (func (export "lt_u_i64") (param $0 i64) (param $1 i64) (result i32)
    (i64.lt_u (local.get $0) (local.get $1)))
)

;; TODO: change things so we can invoke with i64 args and automatically lower
;; the arguments, rather than doing it manually.
(assert_return (invoke "eq_i64" (i32.const 0) (i32.const 0)
                                (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "eq_i64" (i32.const 0) (i32.const 0)
                                (i32.const 0) (i32.const 1))
               (i32.const 0))
(assert_return (invoke "eq_i64" (i32.const 1) (i32.const 0)
                                (i32.const 0) (i32.const 1))
               (i32.const 0))

(assert_return (invoke "ne_i64" (i32.const 0) (i32.const 0)
                                (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "ne_i64" (i32.const 0) (i32.const 0)
                                (i32.const 0) (i32.const 1))
               (i32.const 1))
(assert_return (invoke "ne_i64" (i32.const 1) (i32.const 0)
                                (i32.const 0) (i32.const 1))
               (i32.const 1))

(assert_return (invoke "lt_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "lt_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "lt_u_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "lt_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 1))
(assert_return (invoke "lt_u_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "lt_u_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))

(assert_return (invoke "gt_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "gt_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "gt_u_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "gt_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 0))
(assert_return (invoke "gt_u_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "gt_u_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))

(assert_return (invoke "le_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "le_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "le_u_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "le_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 1))
(assert_return (invoke "le_u_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "le_u_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))

(assert_return (invoke "ge_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "ge_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "ge_u_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "ge_u_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 0))
(assert_return (invoke "ge_u_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "ge_u_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))

(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "lt_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 1))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "lt_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 0))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0xffffffff))
               (i32.const 1))
(assert_return (invoke "lt_s_i64" (i32.const 1) (i32.const 0xffffffff)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 0))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0x80000000))
               (i32.const 0))
(assert_return (invoke "lt_s_i64" (i32.const 0) (i32.const 0x80000000)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))

(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "gt_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 0))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "gt_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 1))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0xffffffff))
               (i32.const 0))
(assert_return (invoke "gt_s_i64" (i32.const 1) (i32.const 0xffffffff)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 1))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0x80000000))
               (i32.const 1))
(assert_return (invoke "gt_s_i64" (i32.const 0) (i32.const 0x80000000)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))

(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "le_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 1))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "le_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 0))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0xffffffff))
               (i32.const 1))
(assert_return (invoke "le_s_i64" (i32.const 1) (i32.const 0xffffffff)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 0))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0x80000000))
               (i32.const 0))
(assert_return (invoke "le_s_i64" (i32.const 0) (i32.const 0x80000000)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))

(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "ge_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 1))
               (i32.const 0))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 1)
                                  (i32.const 1) (i32.const 0))
               (i32.const 1))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0))
               (i32.const 0))
(assert_return (invoke "ge_s_i64" (i32.const 1) (i32.const 0)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 1))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0xffffffff)
                                  (i32.const 1) (i32.const 0xffffffff))
               (i32.const 0))
(assert_return (invoke "ge_s_i64" (i32.const 1) (i32.const 0xffffffff)
                                  (i32.const 0) (i32.const 0xffffffff))
               (i32.const 1))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0)
                                  (i32.const 0) (i32.const 0x80000000))
               (i32.const 1))
(assert_return (invoke "ge_s_i64" (i32.const 0) (i32.const 0x80000000)
                                  (i32.const 0) (i32.const 0))
               (i32.const 0))
