/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __osc
#define __osc

#include <lo/lo.h>
#include "command.h"
#include <string>

struct oserver : command {

  lo_server server;
  int lo_fd;
  fd_set rfds;
  struct timeval tv;
  bool enabled;
  bool msg;

  oserver (const std::string& ln, const std::string& sn) : command (ln, sn) {}
  bool operator() (tokenizer& tz);
  void handle_requests ();
  void toggle ();
  ~oserver ();

};

int command_handler (const char *path, const char *types, lo_arg **argv, int argc, void *data, void *user_data);

struct oconnect : command {

  lo_address& client;

  oconnect (lo_address& c, const std::string& ln, const std::string& sn) : command (ln, sn), client(c) {}
  bool operator() (tokenizer& tz);
  ~oconnect () {}

};

struct osend : command {

  lo_address& client;

  osend (lo_address& c, const std::string& ln, const std::string& sn) : command (ln, sn), client(c) {}
  bool operator() (tokenizer& tz);
  ~osend () {}

};

void osc ();

#endif
