/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.ColorMenu;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;
import org.emboss.jemboss.gui.filetree.FileSave;
import org.emboss.jemboss.gui.filetree.FileSaving;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;
import org.emboss.jemboss.server.JembossServer;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class ResultsMenuBar
extends JMenuBar {
    private JMenuItem saveToLocalFile;
    private JMenuItem saveToRemoteFile;
    private JToolBar toolBar = new JToolBar();
    private JMenuItem undo = new JMenuItem("Undo");
    private JMenuItem redo = new JMenuItem("Redo");
    private UndoManager undoManager = new UndoManager();

    public ResultsMenuBar(JFrame frame, JTabbedPane rtb, Hashtable hashOut, JembossParams mysettings) {
        this(frame, rtb, hashOut, null, null, mysettings);
    }

    public ResultsMenuBar(JFrame frame, JTabbedPane rtb, Hashtable hashOut, Hashtable hashIn) {
        this(frame, rtb, hashOut, hashIn, null, null);
    }

    public ResultsMenuBar(JFrame frame, final FileEditorDisplay fed, final JembossParams mysettings) {
        this.setResultsMenuBar(frame, false);
        this.saveToLocalFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FileSaving fsave = new FileSaving(fed, fed.getPNGContent(), mysettings);
                if (fsave.writeOK()) {
                    String fileSelected = fsave.getFileName();
                    String pathSelected = fsave.getPath();
                    try {
                        Jemboss.tree.addObject(fileSelected, pathSelected, null);
                    }
                    catch (NullPointerException npe) {
                        // empty catch block
                    }
                    DragTree ltree = LocalAndRemoteFileTreeFrame.getLocalDragTree();
                    if (ltree != null) {
                        ltree.addObject(fileSelected, pathSelected, null);
                    }
                }
            }
        });
        fed.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent e) {
                ResultsMenuBar.this.undoManager.addEdit(e.getEdit());
                ResultsMenuBar.this.updateMenu();
            }
        });
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ResultsMenuBar.this.undoManager.undo();
                }
                catch (CannotRedoException cre) {
                    cre.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ResultsMenuBar.this.undoManager.redo();
                }
                catch (CannotRedoException cre) {
                    cre.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        JMenu colourMenu = new JMenu("Colour");
        colourMenu.setMnemonic(76);
        ColorMenu cm = new ColorMenu("Text");
        cm.setColor(fed.getForeground());
        cm.setMnemonic('t');
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                fed.setForeground(m.getColor());
            }
        };
        cm.addActionListener(lst);
        colourMenu.add(cm);
        cm = new ColorMenu("Background");
        cm.setColor(fed.getBackground());
        cm.setMnemonic('b');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                fed.setBackground(m.getColor());
            }
        };
        cm.addActionListener(lst);
        colourMenu.add(cm);
        this.add(colourMenu);
        ButtonGroup group = new ButtonGroup();
        JMenu optionsMenu = new JMenu("Options");
        JRadioButtonMenuItem optionsMenuText = new JRadioButtonMenuItem("Text");
        optionsMenu.add(optionsMenuText);
        optionsMenuText.setSelected(true);
        group.add(optionsMenuText);
        JRadioButtonMenuItem optionsMenuSeq = new JRadioButtonMenuItem("Sequence");
        optionsMenu.add(optionsMenuSeq);
        group.add(optionsMenuSeq);
        this.add(optionsMenu);
        optionsMenuSeq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JRadioButtonMenuItem)e.getSource()).isSelected()) {
                    String text = fed.getText();
                    fed.setText("");
                    fed.setText(text, "sequence");
                    fed.setCaretPosition(0);
                }
            }
        });
        optionsMenuText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (((JRadioButtonMenuItem)e.getSource()).isSelected()) {
                    String text = fed.getText();
                    fed.setText("");
                    fed.setText(text, "regular");
                    fed.setCaretPosition(0);
                }
            }
        });
        this.add(optionsMenu);
        String[] sizes = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> fntSize = new JComboBox<String>(sizes);
        fntSize.setToolTipText("font size");
        Font fnt = fed.getFont();
        fntSize.setSelectedItem(Integer.toString(fnt.getSize()));
        fntSize.setPreferredSize(fntSize.getMinimumSize());
        fntSize.setMaximumSize(fntSize.getMinimumSize());
        fntSize.setEditable(true);
        this.toolBar.add(fntSize);
        fntSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Font fnt = fed.getFont();
                try {
                    String fsize = (String)fntSize.getSelectedItem();
                    if (fsize.indexOf(".") > -1) {
                        fsize = fsize.substring(0, fsize.indexOf("."));
                    }
                    fnt = new Font(fnt.getFontName(), fnt.getStyle(), Integer.parseInt(fsize));
                    fed.setFont(fnt);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        String[] styles = new String[]{"Plain", "Bold", "Italic"};
        final JComboBox<String> cbFonts = new JComboBox<String>(styles);
        cbFonts.setMaximumSize(cbFonts.getPreferredSize());
        cbFonts.setToolTipText("font style");
        cbFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = cbFonts.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                Font fnt = fed.getFont();
                fnt = index == 0 ? fnt.deriveFont(0) : (index == 1 ? fnt.deriveFont(1) : fnt.deriveFont(2));
                fed.setFont(fnt);
            }
        });
        this.toolBar.add(cbFonts);
    }

    public ResultsMenuBar(final JFrame frame, final JTabbedPane rtb, final Hashtable hashOut, final Hashtable hashIn, final String project, final JembossParams mysettings) {
        boolean addRemoteSaveMenu = false;
        if (project != null) {
            addRemoteSaveMenu = true;
        }
        this.setResultsMenuBar(frame, addRemoteSaveMenu);
        this.saveToLocalFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String fileSelected = "";
                String cwd = "";
                SecurityManager sm = System.getSecurityManager();
                System.setSecurityManager(null);
                JFileChooser fc = new JFileChooser(mysettings.getUserHome());
                System.setSecurityManager(sm);
                fc.addChoosableFileFilter(new SequenceFilter());
                int returnVal = fc.showSaveDialog(fc);
                if (returnVal == 0) {
                    File files = fc.getSelectedFile();
                    cwd = fc.getCurrentDirectory().getAbsolutePath();
                    fileSelected = files.getName();
                    frame.setCursor(new Cursor(3));
                    String tabTitle = rtb.getTitleAt(rtb.getSelectedIndex());
                    JTextComponent jtc = ResultsMenuBar.this.getJTextComponentAt(rtb, rtb.getSelectedIndex());
                    if (jtc != null) {
                        ResultsMenuBar.this.fileSave(cwd, fileSelected, jtc.getText());
                    } else if (hashOut.containsKey(tabTitle)) {
                        ResultsMenuBar.this.fileSave(cwd, fileSelected, tabTitle, hashOut);
                    } else if (hashIn != null && hashIn.containsKey(tabTitle)) {
                        ResultsMenuBar.this.fileSave(cwd, fileSelected, tabTitle, hashIn);
                    }
                    frame.setCursor(new Cursor(0));
                }
            }
        });
        for (int i = 0; i < rtb.getTabCount(); ++i) {
            JTextComponent jtc = this.getJTextComponentAt(rtb, i);
            if (jtc == null) continue;
            jtc.getDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent e) {
                    ResultsMenuBar.this.undoManager.addEdit(e.getEdit());
                    ResultsMenuBar.this.updateMenu();
                }
            });
        }
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ResultsMenuBar.this.undoManager.undo();
                }
                catch (CannotRedoException cre) {
                    cre.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    ResultsMenuBar.this.undoManager.redo();
                }
                catch (CannotRedoException cre) {
                    cre.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        JMenu colourMenu = new JMenu("Colour");
        colourMenu.setMnemonic(76);
        ColorMenu cm = new ColorMenu("Text");
        cm.setMnemonic('t');
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                JTextPane jtp = ResultsMenuBar.this.getSelectedJTextPane(rtb);
                if (jtp != null) {
                    jtp.setForeground(m.getColor());
                }
            }
        };
        cm.addActionListener(lst);
        colourMenu.add(cm);
        cm = new ColorMenu("Background");
        cm.setMnemonic('b');
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ColorMenu m = (ColorMenu)e.getSource();
                JTextPane jtp = ResultsMenuBar.this.getSelectedJTextPane(rtb);
                if (jtp != null) {
                    jtp.setBackground(m.getColor());
                }
            }
        };
        cm.addActionListener(lst);
        colourMenu.add(cm);
        this.add(colourMenu);
        if (addRemoteSaveMenu) {
            this.saveToRemoteFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JTextComponent jtc = ResultsMenuBar.this.getJTextComponentAt(rtb, rtb.getSelectedIndex());
                    String tabTitle = rtb.getTitleAt(rtb.getSelectedIndex());
                    if (Jemboss.withSoap) {
                        Vector<String> params = new Vector<String>();
                        params.addElement(project);
                        params.addElement(tabTitle);
                        params.addElement(jtc.getText().replace('\r', ' '));
                        try {
                            new PrivateRequest(mysettings, "save_project_file", params);
                        }
                        catch (JembossSoapException jse) {}
                    } else {
                        JembossServer js = new JembossServer(mysettings.getResultsHome());
                        js.save_project_file(project, tabTitle, jtc.getText().replace('\r', ' '));
                    }
                }
            });
        }
        String[] sizes = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> fntSize = new JComboBox<String>(sizes);
        fntSize.setToolTipText("font size");
        fntSize.setSelectedItem("12");
        fntSize.setPreferredSize(fntSize.getMinimumSize());
        fntSize.setMaximumSize(fntSize.getMinimumSize());
        fntSize.setEditable(true);
        this.toolBar.add(fntSize);
        fntSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JTextPane jtp = ResultsMenuBar.this.getSelectedJTextPane(rtb);
                if (jtp != null) {
                    Font fnt = jtp.getFont();
                    try {
                        String fsize = (String)fntSize.getSelectedItem();
                        if (fsize.indexOf(".") > -1) {
                            fsize = fsize.substring(0, fsize.indexOf("."));
                        }
                        fnt = new Font("monospaced", fnt.getStyle(), Integer.parseInt(fsize));
                        jtp.setFont(fnt);
                    }
                    catch (NumberFormatException nfe) {
                        // empty catch block
                    }
                }
            }
        });
        this.toolBar.addSeparator();
        String[] styles = new String[]{"Plain", "Bold", "Italic"};
        final JComboBox<String> cbFonts = new JComboBox<String>(styles);
        cbFonts.setMaximumSize(cbFonts.getPreferredSize());
        cbFonts.setToolTipText("font style");
        cbFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int index = cbFonts.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                JTextPane jtp = ResultsMenuBar.this.getSelectedJTextPane(rtb);
                if (jtp == null) {
                    return;
                }
                Font fnt = jtp.getFont();
                fnt = index == 0 ? fnt.deriveFont(0) : (index == 1 ? fnt.deriveFont(1) : fnt.deriveFont(2));
                jtp.setFont(fnt);
            }
        });
        this.toolBar.add(cbFonts);
    }

    public void setResultsMenuBar(final JFrame frame, boolean addRemoteSaveMenu) {
        this.add(Box.createRigidArea(new Dimension(5, 24)));
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        if (addRemoteSaveMenu) {
            this.saveToRemoteFile = Jemboss.withSoap ? new JMenuItem("Save to Server File") : new JMenuItem("Save Back to Project Directory");
            fileMenu.add(this.saveToRemoteFile);
        }
        this.saveToLocalFile = new JMenuItem("Save to Local File...");
        fileMenu.add(this.saveToLocalFile);
        fileMenu.addSeparator();
        fileMenu.add(this.undo);
        this.undo.setEnabled(false);
        this.undo.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        fileMenu.add(this.redo);
        this.redo.setEnabled(false);
        this.redo.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        fileMenu.addSeparator();
        JMenuItem resFileMenuExit = new JMenuItem("Close");
        resFileMenuExit.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        resFileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        fileMenu.add(resFileMenuExit);
        this.add(fileMenu);
    }

    private void updateMenu() {
        this.undo.setText(this.undoManager.getUndoPresentationName());
        this.redo.setText(this.undoManager.getRedoPresentationName());
        this.undo.setEnabled(this.undoManager.canUndo());
        this.redo.setEnabled(this.undoManager.canRedo());
    }

    protected JToolBar getToolBar() {
        return this.toolBar;
    }

    private void fileSave(String cwd, String fileSelected, String tabTitle, Hashtable h) {
        this.fileSave(cwd, fileSelected, h.get(tabTitle));
    }

    private void fileSave(String cwd, String fileSelected, Object fileContents) {
        String fs = new String(System.getProperty("file.separator"));
        FileSave fsave = new FileSave(new File(cwd + fs + fileSelected));
        if (fsave.doWrite()) {
            fsave.fileSaving(fileContents);
        }
        if (!fsave.fileExists()) {
            Jemboss.tree.addObject(fileSelected, cwd, null);
            DragTree ltree = SetUpMenuBar.getLocalDragTree();
            if (ltree != null) {
                ltree.addObject(fileSelected, cwd, null);
            }
        }
    }

    private JTextPane getSelectedJTextPane(JTabbedPane rtb) {
        try {
            JScrollPane jsp = (JScrollPane)rtb.getSelectedComponent();
            return (JTextPane)jsp.getViewport().getView();
        }
        catch (ClassCastException cce) {
            try {
                JPanel panel = (JPanel)rtb.getSelectedComponent();
                JScrollPane jsp = (JScrollPane)panel.getComponent(0);
                ScrollPanel panel2 = (ScrollPanel)jsp.getViewport().getView();
                return (JTextPane)panel2.getComponent(0);
            }
            catch (ClassCastException classCastException) {
                return null;
            }
        }
    }

    private JTextComponent getJTextComponentAt(JTabbedPane rtb, int index) {
        try {
            JScrollPane jsp = (JScrollPane)rtb.getComponentAt(index);
            return (JTextComponent)jsp.getViewport().getView();
        }
        catch (ClassCastException cce) {
            try {
                JPanel panel = (JPanel)rtb.getComponentAt(index);
                JScrollPane jsp = (JScrollPane)panel.getComponent(0);
                ScrollPanel panel2 = (ScrollPanel)jsp.getViewport().getView();
                return (JTextPane)panel2.getComponent(0);
            }
            catch (ClassCastException cce2) {
                return null;
            }
        }
    }
}

