# frozen_string_literal: true

describe Facts::Aix::Processors::Isa do
  describe '#call_the_resolver' do
    subject(:fact) { Facts::Aix::Processors::Isa.new }

    let(:processors_arch) { 'powerpc' }

    before do
      allow(Facter::Resolvers::Uname).to \
        receive(:resolve).with(:processor).and_return(processors_arch)
    end

    it 'returns processors isa fact' do
      expect(fact.call_the_resolver).to be_an_instance_of(Array).and \
        contain_exactly(an_object_having_attributes(name: 'processors.isa', value: processors_arch),
                        an_object_having_attributes(name: 'hardwareisa', value: processors_arch, type: :legacy))
    end
  end
end
