// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file XtypesTestsTypeBig.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__XTYPESTESTSTYPEBIG_HPP
#define FAST_DDS_GENERATED__XTYPESTESTSTYPEBIG_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>
#include "XtypesTestsType1.hpp"
#include "XtypesTestsType2.hpp"
#include "XtypesTestsType3.hpp"

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(XTYPESTESTSTYPEBIG_SOURCE)
#define XTYPESTESTSTYPEBIG_DllAPI __declspec( dllexport )
#else
#define XTYPESTESTSTYPEBIG_DllAPI __declspec( dllimport )
#endif // XTYPESTESTSTYPEBIG_SOURCE
#else
#define XTYPESTESTSTYPEBIG_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define XTYPESTESTSTYPEBIG_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure Type4 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type4
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type4()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type4()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type4 that will be copied.
     */
    eProsima_user_DllExport Type4(
            const Type4& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type4 that will be copied.
     */
    eProsima_user_DllExport Type4(
            Type4&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type4 that will be copied.
     */
    eProsima_user_DllExport Type4& operator =(
            const Type4& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type4 that will be copied.
     */
    eProsima_user_DllExport Type4& operator =(
            Type4&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type4 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type4& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type4 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type4& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type5 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type5
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type5()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type5()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type5 that will be copied.
     */
    eProsima_user_DllExport Type5(
            const Type5& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type5 that will be copied.
     */
    eProsima_user_DllExport Type5(
            Type5&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type5 that will be copied.
     */
    eProsima_user_DllExport Type5& operator =(
            const Type5& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type5 that will be copied.
     */
    eProsima_user_DllExport Type5& operator =(
            Type5&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type5 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type5& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type5 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type5& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type6 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type6
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type6()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type6()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type6 that will be copied.
     */
    eProsima_user_DllExport Type6(
            const Type6& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type6 that will be copied.
     */
    eProsima_user_DllExport Type6(
            Type6&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type6 that will be copied.
     */
    eProsima_user_DllExport Type6& operator =(
            const Type6& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type6 that will be copied.
     */
    eProsima_user_DllExport Type6& operator =(
            Type6&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type6 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type6& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type6 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type6& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type7 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type7
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type7()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type7()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type7 that will be copied.
     */
    eProsima_user_DllExport Type7(
            const Type7& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type7 that will be copied.
     */
    eProsima_user_DllExport Type7(
            Type7&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type7 that will be copied.
     */
    eProsima_user_DllExport Type7& operator =(
            const Type7& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type7 that will be copied.
     */
    eProsima_user_DllExport Type7& operator =(
            Type7&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type7 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type7& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type7 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type7& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type8 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type8
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type8()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type8()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type8 that will be copied.
     */
    eProsima_user_DllExport Type8(
            const Type8& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type8 that will be copied.
     */
    eProsima_user_DllExport Type8(
            Type8&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type8 that will be copied.
     */
    eProsima_user_DllExport Type8& operator =(
            const Type8& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type8 that will be copied.
     */
    eProsima_user_DllExport Type8& operator =(
            Type8&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type8 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type8& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type8 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type8& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type9 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type9
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type9()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type9()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type9 that will be copied.
     */
    eProsima_user_DllExport Type9(
            const Type9& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type9 that will be copied.
     */
    eProsima_user_DllExport Type9(
            Type9&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type9 that will be copied.
     */
    eProsima_user_DllExport Type9& operator =(
            const Type9& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type9 that will be copied.
     */
    eProsima_user_DllExport Type9& operator =(
            Type9&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type9 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type9& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type9 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type9& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type10 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type10
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type10()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type10()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type10 that will be copied.
     */
    eProsima_user_DllExport Type10(
            const Type10& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type10 that will be copied.
     */
    eProsima_user_DllExport Type10(
            Type10&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type10 that will be copied.
     */
    eProsima_user_DllExport Type10& operator =(
            const Type10& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type10 that will be copied.
     */
    eProsima_user_DllExport Type10& operator =(
            Type10&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type10 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type10& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type10 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type10& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type11 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type11
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type11()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type11()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type11 that will be copied.
     */
    eProsima_user_DllExport Type11(
            const Type11& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type11 that will be copied.
     */
    eProsima_user_DllExport Type11(
            Type11&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type11 that will be copied.
     */
    eProsima_user_DllExport Type11& operator =(
            const Type11& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type11 that will be copied.
     */
    eProsima_user_DllExport Type11& operator =(
            Type11&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type11 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type11& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type11 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type11& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type12 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type12
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type12()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type12()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type12 that will be copied.
     */
    eProsima_user_DllExport Type12(
            const Type12& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type12 that will be copied.
     */
    eProsima_user_DllExport Type12(
            Type12&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type12 that will be copied.
     */
    eProsima_user_DllExport Type12& operator =(
            const Type12& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type12 that will be copied.
     */
    eProsima_user_DllExport Type12& operator =(
            Type12&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type12 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type12& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type12 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type12& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type13 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type13
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type13()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type13()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type13 that will be copied.
     */
    eProsima_user_DllExport Type13(
            const Type13& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type13 that will be copied.
     */
    eProsima_user_DllExport Type13(
            Type13&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type13 that will be copied.
     */
    eProsima_user_DllExport Type13& operator =(
            const Type13& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type13 that will be copied.
     */
    eProsima_user_DllExport Type13& operator =(
            Type13&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type13 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type13& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type13 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type13& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type14 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type14
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type14()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type14()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type14 that will be copied.
     */
    eProsima_user_DllExport Type14(
            const Type14& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type14 that will be copied.
     */
    eProsima_user_DllExport Type14(
            Type14&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type14 that will be copied.
     */
    eProsima_user_DllExport Type14& operator =(
            const Type14& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type14 that will be copied.
     */
    eProsima_user_DllExport Type14& operator =(
            Type14&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type14 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type14& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type14 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type14& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type15 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type15
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type15()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type15()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type15 that will be copied.
     */
    eProsima_user_DllExport Type15(
            const Type15& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type15 that will be copied.
     */
    eProsima_user_DllExport Type15(
            Type15&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type15 that will be copied.
     */
    eProsima_user_DllExport Type15& operator =(
            const Type15& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type15 that will be copied.
     */
    eProsima_user_DllExport Type15& operator =(
            Type15&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type15 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type15& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type15 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type15& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type16 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type16
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type16()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type16()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type16 that will be copied.
     */
    eProsima_user_DllExport Type16(
            const Type16& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type16 that will be copied.
     */
    eProsima_user_DllExport Type16(
            Type16&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type16 that will be copied.
     */
    eProsima_user_DllExport Type16& operator =(
            const Type16& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type16 that will be copied.
     */
    eProsima_user_DllExport Type16& operator =(
            Type16&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type16 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type16& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type16 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type16& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type17 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type17
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type17()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type17()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type17 that will be copied.
     */
    eProsima_user_DllExport Type17(
            const Type17& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type17 that will be copied.
     */
    eProsima_user_DllExport Type17(
            Type17&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type17 that will be copied.
     */
    eProsima_user_DllExport Type17& operator =(
            const Type17& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type17 that will be copied.
     */
    eProsima_user_DllExport Type17& operator =(
            Type17&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type17 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type17& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type17 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type17& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type18 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type18
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type18()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type18()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type18 that will be copied.
     */
    eProsima_user_DllExport Type18(
            const Type18& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type18 that will be copied.
     */
    eProsima_user_DllExport Type18(
            Type18&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type18 that will be copied.
     */
    eProsima_user_DllExport Type18& operator =(
            const Type18& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type18 that will be copied.
     */
    eProsima_user_DllExport Type18& operator =(
            Type18&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type18 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type18& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type18 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type18& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type19 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type19
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type19()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type19()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type19 that will be copied.
     */
    eProsima_user_DllExport Type19(
            const Type19& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type19 that will be copied.
     */
    eProsima_user_DllExport Type19(
            Type19&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type19 that will be copied.
     */
    eProsima_user_DllExport Type19& operator =(
            const Type19& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type19 that will be copied.
     */
    eProsima_user_DllExport Type19& operator =(
            Type19&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type19 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type19& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type19 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type19& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type20 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type20
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type20()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type20()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type20 that will be copied.
     */
    eProsima_user_DllExport Type20(
            const Type20& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type20 that will be copied.
     */
    eProsima_user_DllExport Type20(
            Type20&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type20 that will be copied.
     */
    eProsima_user_DllExport Type20& operator =(
            const Type20& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type20 that will be copied.
     */
    eProsima_user_DllExport Type20& operator =(
            Type20&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type20 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type20& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type20 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type20& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type21 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type21
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type21()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type21()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type21 that will be copied.
     */
    eProsima_user_DllExport Type21(
            const Type21& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type21 that will be copied.
     */
    eProsima_user_DllExport Type21(
            Type21&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type21 that will be copied.
     */
    eProsima_user_DllExport Type21& operator =(
            const Type21& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type21 that will be copied.
     */
    eProsima_user_DllExport Type21& operator =(
            Type21&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type21 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type21& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type21 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type21& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type22 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type22
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type22()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type22()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type22 that will be copied.
     */
    eProsima_user_DllExport Type22(
            const Type22& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type22 that will be copied.
     */
    eProsima_user_DllExport Type22(
            Type22&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type22 that will be copied.
     */
    eProsima_user_DllExport Type22& operator =(
            const Type22& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type22 that will be copied.
     */
    eProsima_user_DllExport Type22& operator =(
            Type22&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type22 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type22& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type22 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type22& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type23 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type23
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type23()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type23()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type23 that will be copied.
     */
    eProsima_user_DllExport Type23(
            const Type23& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type23 that will be copied.
     */
    eProsima_user_DllExport Type23(
            Type23&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type23 that will be copied.
     */
    eProsima_user_DllExport Type23& operator =(
            const Type23& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type23 that will be copied.
     */
    eProsima_user_DllExport Type23& operator =(
            Type23&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type23 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type23& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type23 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type23& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type24 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type24
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type24()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type24()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type24 that will be copied.
     */
    eProsima_user_DllExport Type24(
            const Type24& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type24 that will be copied.
     */
    eProsima_user_DllExport Type24(
            Type24&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type24 that will be copied.
     */
    eProsima_user_DllExport Type24& operator =(
            const Type24& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type24 that will be copied.
     */
    eProsima_user_DllExport Type24& operator =(
            Type24&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type24 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type24& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type24 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type24& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type25 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type25
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type25()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type25()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type25 that will be copied.
     */
    eProsima_user_DllExport Type25(
            const Type25& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type25 that will be copied.
     */
    eProsima_user_DllExport Type25(
            Type25&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type25 that will be copied.
     */
    eProsima_user_DllExport Type25& operator =(
            const Type25& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type25 that will be copied.
     */
    eProsima_user_DllExport Type25& operator =(
            Type25&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type25 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type25& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type25 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type25& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type26 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type26
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type26()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type26()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type26 that will be copied.
     */
    eProsima_user_DllExport Type26(
            const Type26& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type26 that will be copied.
     */
    eProsima_user_DllExport Type26(
            Type26&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type26 that will be copied.
     */
    eProsima_user_DllExport Type26& operator =(
            const Type26& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type26 that will be copied.
     */
    eProsima_user_DllExport Type26& operator =(
            Type26&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type26 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type26& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type26 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type26& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type27 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type27
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type27()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type27()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type27 that will be copied.
     */
    eProsima_user_DllExport Type27(
            const Type27& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type27 that will be copied.
     */
    eProsima_user_DllExport Type27(
            Type27&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type27 that will be copied.
     */
    eProsima_user_DllExport Type27& operator =(
            const Type27& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type27 that will be copied.
     */
    eProsima_user_DllExport Type27& operator =(
            Type27&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type27 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type27& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type27 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type27& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type28 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type28
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type28()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type28()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type28 that will be copied.
     */
    eProsima_user_DllExport Type28(
            const Type28& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type28 that will be copied.
     */
    eProsima_user_DllExport Type28(
            Type28&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type28 that will be copied.
     */
    eProsima_user_DllExport Type28& operator =(
            const Type28& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type28 that will be copied.
     */
    eProsima_user_DllExport Type28& operator =(
            Type28&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type28 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type28& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type28 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type28& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type29 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type29
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type29()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type29()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type29 that will be copied.
     */
    eProsima_user_DllExport Type29(
            const Type29& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type29 that will be copied.
     */
    eProsima_user_DllExport Type29(
            Type29&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type29 that will be copied.
     */
    eProsima_user_DllExport Type29& operator =(
            const Type29& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type29 that will be copied.
     */
    eProsima_user_DllExport Type29& operator =(
            Type29&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type29 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type29& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type29 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type29& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type30 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type30
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type30()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type30()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type30 that will be copied.
     */
    eProsima_user_DllExport Type30(
            const Type30& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type30 that will be copied.
     */
    eProsima_user_DllExport Type30(
            Type30&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type30 that will be copied.
     */
    eProsima_user_DllExport Type30& operator =(
            const Type30& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type30 that will be copied.
     */
    eProsima_user_DllExport Type30& operator =(
            Type30&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type30 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type30& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type30 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type30& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type31 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type31
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type31()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type31()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type31 that will be copied.
     */
    eProsima_user_DllExport Type31(
            const Type31& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type31 that will be copied.
     */
    eProsima_user_DllExport Type31(
            Type31&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type31 that will be copied.
     */
    eProsima_user_DllExport Type31& operator =(
            const Type31& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type31 that will be copied.
     */
    eProsima_user_DllExport Type31& operator =(
            Type31&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type31 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type31& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type31 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type31& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type32 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type32
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type32()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type32()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type32 that will be copied.
     */
    eProsima_user_DllExport Type32(
            const Type32& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type32 that will be copied.
     */
    eProsima_user_DllExport Type32(
            Type32&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type32 that will be copied.
     */
    eProsima_user_DllExport Type32& operator =(
            const Type32& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type32 that will be copied.
     */
    eProsima_user_DllExport Type32& operator =(
            Type32&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type32 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type32& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type32 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type32& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type33 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type33
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type33()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type33()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type33 that will be copied.
     */
    eProsima_user_DllExport Type33(
            const Type33& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type33 that will be copied.
     */
    eProsima_user_DllExport Type33(
            Type33&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type33 that will be copied.
     */
    eProsima_user_DllExport Type33& operator =(
            const Type33& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type33 that will be copied.
     */
    eProsima_user_DllExport Type33& operator =(
            Type33&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type33 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type33& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type33 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type33& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type34 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type34
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type34()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type34()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type34 that will be copied.
     */
    eProsima_user_DllExport Type34(
            const Type34& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type34 that will be copied.
     */
    eProsima_user_DllExport Type34(
            Type34&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type34 that will be copied.
     */
    eProsima_user_DllExport Type34& operator =(
            const Type34& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type34 that will be copied.
     */
    eProsima_user_DllExport Type34& operator =(
            Type34&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type34 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type34& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type34 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type34& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type35 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type35
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type35()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type35()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type35 that will be copied.
     */
    eProsima_user_DllExport Type35(
            const Type35& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type35 that will be copied.
     */
    eProsima_user_DllExport Type35(
            Type35&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type35 that will be copied.
     */
    eProsima_user_DllExport Type35& operator =(
            const Type35& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type35 that will be copied.
     */
    eProsima_user_DllExport Type35& operator =(
            Type35&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type35 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type35& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type35 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type35& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type36 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type36
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type36()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type36()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type36 that will be copied.
     */
    eProsima_user_DllExport Type36(
            const Type36& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type36 that will be copied.
     */
    eProsima_user_DllExport Type36(
            Type36&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type36 that will be copied.
     */
    eProsima_user_DllExport Type36& operator =(
            const Type36& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type36 that will be copied.
     */
    eProsima_user_DllExport Type36& operator =(
            Type36&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type36 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type36& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type36 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type36& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type37 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type37
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type37()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type37()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type37 that will be copied.
     */
    eProsima_user_DllExport Type37(
            const Type37& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type37 that will be copied.
     */
    eProsima_user_DllExport Type37(
            Type37&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type37 that will be copied.
     */
    eProsima_user_DllExport Type37& operator =(
            const Type37& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type37 that will be copied.
     */
    eProsima_user_DllExport Type37& operator =(
            Type37&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type37 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type37& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type37 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type37& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type38 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type38
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type38()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type38()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type38 that will be copied.
     */
    eProsima_user_DllExport Type38(
            const Type38& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type38 that will be copied.
     */
    eProsima_user_DllExport Type38(
            Type38&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type38 that will be copied.
     */
    eProsima_user_DllExport Type38& operator =(
            const Type38& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type38 that will be copied.
     */
    eProsima_user_DllExport Type38& operator =(
            Type38&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type38 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type38& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type38 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type38& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type39 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type39
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type39()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type39()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type39 that will be copied.
     */
    eProsima_user_DllExport Type39(
            const Type39& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type39 that will be copied.
     */
    eProsima_user_DllExport Type39(
            Type39&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type39 that will be copied.
     */
    eProsima_user_DllExport Type39& operator =(
            const Type39& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type39 that will be copied.
     */
    eProsima_user_DllExport Type39& operator =(
            Type39&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type39 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type39& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type39 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type39& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type40 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type40
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type40()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type40()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type40 that will be copied.
     */
    eProsima_user_DllExport Type40(
            const Type40& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type40 that will be copied.
     */
    eProsima_user_DllExport Type40(
            Type40&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type40 that will be copied.
     */
    eProsima_user_DllExport Type40& operator =(
            const Type40& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type40 that will be copied.
     */
    eProsima_user_DllExport Type40& operator =(
            Type40&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type40 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type40& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type40 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type40& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type41 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type41
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type41()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type41()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type41 that will be copied.
     */
    eProsima_user_DllExport Type41(
            const Type41& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type41 that will be copied.
     */
    eProsima_user_DllExport Type41(
            Type41&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type41 that will be copied.
     */
    eProsima_user_DllExport Type41& operator =(
            const Type41& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type41 that will be copied.
     */
    eProsima_user_DllExport Type41& operator =(
            Type41&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type41 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type41& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type41 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type41& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type42 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type42
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type42()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type42()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type42 that will be copied.
     */
    eProsima_user_DllExport Type42(
            const Type42& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type42 that will be copied.
     */
    eProsima_user_DllExport Type42(
            Type42&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type42 that will be copied.
     */
    eProsima_user_DllExport Type42& operator =(
            const Type42& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type42 that will be copied.
     */
    eProsima_user_DllExport Type42& operator =(
            Type42&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type42 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type42& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type42 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type42& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type43 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type43
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type43()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type43()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type43 that will be copied.
     */
    eProsima_user_DllExport Type43(
            const Type43& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type43 that will be copied.
     */
    eProsima_user_DllExport Type43(
            Type43&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type43 that will be copied.
     */
    eProsima_user_DllExport Type43& operator =(
            const Type43& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type43 that will be copied.
     */
    eProsima_user_DllExport Type43& operator =(
            Type43&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type43 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type43& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type43 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type43& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type44 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type44
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type44()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type44()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type44 that will be copied.
     */
    eProsima_user_DllExport Type44(
            const Type44& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type44 that will be copied.
     */
    eProsima_user_DllExport Type44(
            Type44&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type44 that will be copied.
     */
    eProsima_user_DllExport Type44& operator =(
            const Type44& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type44 that will be copied.
     */
    eProsima_user_DllExport Type44& operator =(
            Type44&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type44 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type44& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type44 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type44& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type45 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type45
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type45()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type45()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type45 that will be copied.
     */
    eProsima_user_DllExport Type45(
            const Type45& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type45 that will be copied.
     */
    eProsima_user_DllExport Type45(
            Type45&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type45 that will be copied.
     */
    eProsima_user_DllExport Type45& operator =(
            const Type45& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type45 that will be copied.
     */
    eProsima_user_DllExport Type45& operator =(
            Type45&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type45 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type45& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type45 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type45& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type46 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type46
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type46()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type46()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type46 that will be copied.
     */
    eProsima_user_DllExport Type46(
            const Type46& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type46 that will be copied.
     */
    eProsima_user_DllExport Type46(
            Type46&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type46 that will be copied.
     */
    eProsima_user_DllExport Type46& operator =(
            const Type46& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type46 that will be copied.
     */
    eProsima_user_DllExport Type46& operator =(
            Type46&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type46 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type46& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type46 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type46& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type47 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type47
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type47()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type47()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type47 that will be copied.
     */
    eProsima_user_DllExport Type47(
            const Type47& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type47 that will be copied.
     */
    eProsima_user_DllExport Type47(
            Type47&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type47 that will be copied.
     */
    eProsima_user_DllExport Type47& operator =(
            const Type47& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type47 that will be copied.
     */
    eProsima_user_DllExport Type47& operator =(
            Type47&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type47 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type47& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type47 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type47& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type48 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type48
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type48()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type48()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type48 that will be copied.
     */
    eProsima_user_DllExport Type48(
            const Type48& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type48 that will be copied.
     */
    eProsima_user_DllExport Type48(
            Type48&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type48 that will be copied.
     */
    eProsima_user_DllExport Type48& operator =(
            const Type48& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type48 that will be copied.
     */
    eProsima_user_DllExport Type48& operator =(
            Type48&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type48 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type48& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type48 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type48& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type49 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type49
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type49()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type49()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type49 that will be copied.
     */
    eProsima_user_DllExport Type49(
            const Type49& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type49 that will be copied.
     */
    eProsima_user_DllExport Type49(
            Type49&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type49 that will be copied.
     */
    eProsima_user_DllExport Type49& operator =(
            const Type49& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type49 that will be copied.
     */
    eProsima_user_DllExport Type49& operator =(
            Type49&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type49 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type49& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type49 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type49& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type50 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type50
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type50()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type50()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type50 that will be copied.
     */
    eProsima_user_DllExport Type50(
            const Type50& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type50 that will be copied.
     */
    eProsima_user_DllExport Type50(
            Type50&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type50 that will be copied.
     */
    eProsima_user_DllExport Type50& operator =(
            const Type50& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type50 that will be copied.
     */
    eProsima_user_DllExport Type50& operator =(
            Type50&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type50 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type50& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type50 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type50& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type51 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type51
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type51()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type51()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type51 that will be copied.
     */
    eProsima_user_DllExport Type51(
            const Type51& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type51 that will be copied.
     */
    eProsima_user_DllExport Type51(
            Type51&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type51 that will be copied.
     */
    eProsima_user_DllExport Type51& operator =(
            const Type51& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type51 that will be copied.
     */
    eProsima_user_DllExport Type51& operator =(
            Type51&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type51 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type51& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type51 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type51& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type52 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type52
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type52()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type52()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type52 that will be copied.
     */
    eProsima_user_DllExport Type52(
            const Type52& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type52 that will be copied.
     */
    eProsima_user_DllExport Type52(
            Type52&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type52 that will be copied.
     */
    eProsima_user_DllExport Type52& operator =(
            const Type52& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type52 that will be copied.
     */
    eProsima_user_DllExport Type52& operator =(
            Type52&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type52 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type52& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type52 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type52& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type53 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type53
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type53()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type53()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type53 that will be copied.
     */
    eProsima_user_DllExport Type53(
            const Type53& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type53 that will be copied.
     */
    eProsima_user_DllExport Type53(
            Type53&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type53 that will be copied.
     */
    eProsima_user_DllExport Type53& operator =(
            const Type53& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type53 that will be copied.
     */
    eProsima_user_DllExport Type53& operator =(
            Type53&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type53 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type53& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type53 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type53& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type54 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type54
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type54()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type54()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type54 that will be copied.
     */
    eProsima_user_DllExport Type54(
            const Type54& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type54 that will be copied.
     */
    eProsima_user_DllExport Type54(
            Type54&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type54 that will be copied.
     */
    eProsima_user_DllExport Type54& operator =(
            const Type54& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type54 that will be copied.
     */
    eProsima_user_DllExport Type54& operator =(
            Type54&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type54 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type54& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type54 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type54& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type55 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type55
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type55()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type55()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type55 that will be copied.
     */
    eProsima_user_DllExport Type55(
            const Type55& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type55 that will be copied.
     */
    eProsima_user_DllExport Type55(
            Type55&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type55 that will be copied.
     */
    eProsima_user_DllExport Type55& operator =(
            const Type55& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type55 that will be copied.
     */
    eProsima_user_DllExport Type55& operator =(
            Type55&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type55 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type55& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type55 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type55& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type56 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type56
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type56()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type56()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type56 that will be copied.
     */
    eProsima_user_DllExport Type56(
            const Type56& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type56 that will be copied.
     */
    eProsima_user_DllExport Type56(
            Type56&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type56 that will be copied.
     */
    eProsima_user_DllExport Type56& operator =(
            const Type56& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type56 that will be copied.
     */
    eProsima_user_DllExport Type56& operator =(
            Type56&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type56 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type56& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type56 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type56& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type57 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type57
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type57()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type57()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type57 that will be copied.
     */
    eProsima_user_DllExport Type57(
            const Type57& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type57 that will be copied.
     */
    eProsima_user_DllExport Type57(
            Type57&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type57 that will be copied.
     */
    eProsima_user_DllExport Type57& operator =(
            const Type57& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type57 that will be copied.
     */
    eProsima_user_DllExport Type57& operator =(
            Type57&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type57 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type57& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type57 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type57& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type58 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type58
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type58()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type58()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type58 that will be copied.
     */
    eProsima_user_DllExport Type58(
            const Type58& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type58 that will be copied.
     */
    eProsima_user_DllExport Type58(
            Type58&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type58 that will be copied.
     */
    eProsima_user_DllExport Type58& operator =(
            const Type58& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type58 that will be copied.
     */
    eProsima_user_DllExport Type58& operator =(
            Type58&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type58 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type58& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type58 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type58& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type59 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type59
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type59()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type59()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type59 that will be copied.
     */
    eProsima_user_DllExport Type59(
            const Type59& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type59 that will be copied.
     */
    eProsima_user_DllExport Type59(
            Type59&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type59 that will be copied.
     */
    eProsima_user_DllExport Type59& operator =(
            const Type59& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type59 that will be copied.
     */
    eProsima_user_DllExport Type59& operator =(
            Type59&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type59 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type59& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type59 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type59& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type60 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type60
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type60()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type60()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type60 that will be copied.
     */
    eProsima_user_DllExport Type60(
            const Type60& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type60 that will be copied.
     */
    eProsima_user_DllExport Type60(
            Type60&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type60 that will be copied.
     */
    eProsima_user_DllExport Type60& operator =(
            const Type60& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type60 that will be copied.
     */
    eProsima_user_DllExport Type60& operator =(
            Type60&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type60 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type60& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type60 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type60& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type61 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type61
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type61()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type61()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type61 that will be copied.
     */
    eProsima_user_DllExport Type61(
            const Type61& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type61 that will be copied.
     */
    eProsima_user_DllExport Type61(
            Type61&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type61 that will be copied.
     */
    eProsima_user_DllExport Type61& operator =(
            const Type61& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type61 that will be copied.
     */
    eProsima_user_DllExport Type61& operator =(
            Type61&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type61 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type61& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type61 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type61& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type62 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type62
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type62()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type62()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type62 that will be copied.
     */
    eProsima_user_DllExport Type62(
            const Type62& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type62 that will be copied.
     */
    eProsima_user_DllExport Type62(
            Type62&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type62 that will be copied.
     */
    eProsima_user_DllExport Type62& operator =(
            const Type62& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type62 that will be copied.
     */
    eProsima_user_DllExport Type62& operator =(
            Type62&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type62 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type62& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type62 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type62& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type63 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type63
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type63()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type63()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type63 that will be copied.
     */
    eProsima_user_DllExport Type63(
            const Type63& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type63 that will be copied.
     */
    eProsima_user_DllExport Type63(
            Type63&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type63 that will be copied.
     */
    eProsima_user_DllExport Type63& operator =(
            const Type63& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type63 that will be copied.
     */
    eProsima_user_DllExport Type63& operator =(
            Type63&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type63 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type63& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type63 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type63& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type64 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type64
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type64()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type64()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type64 that will be copied.
     */
    eProsima_user_DllExport Type64(
            const Type64& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type64 that will be copied.
     */
    eProsima_user_DllExport Type64(
            Type64&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type64 that will be copied.
     */
    eProsima_user_DllExport Type64& operator =(
            const Type64& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type64 that will be copied.
     */
    eProsima_user_DllExport Type64& operator =(
            Type64&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type64 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type64& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type64 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type64& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type65 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type65
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type65()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type65()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type65 that will be copied.
     */
    eProsima_user_DllExport Type65(
            const Type65& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type65 that will be copied.
     */
    eProsima_user_DllExport Type65(
            Type65&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type65 that will be copied.
     */
    eProsima_user_DllExport Type65& operator =(
            const Type65& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type65 that will be copied.
     */
    eProsima_user_DllExport Type65& operator =(
            Type65&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type65 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type65& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type65 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type65& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type66 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type66
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type66()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type66()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type66 that will be copied.
     */
    eProsima_user_DllExport Type66(
            const Type66& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type66 that will be copied.
     */
    eProsima_user_DllExport Type66(
            Type66&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type66 that will be copied.
     */
    eProsima_user_DllExport Type66& operator =(
            const Type66& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type66 that will be copied.
     */
    eProsima_user_DllExport Type66& operator =(
            Type66&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type66 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type66& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type66 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type66& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type67 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type67
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type67()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type67()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type67 that will be copied.
     */
    eProsima_user_DllExport Type67(
            const Type67& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type67 that will be copied.
     */
    eProsima_user_DllExport Type67(
            Type67&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type67 that will be copied.
     */
    eProsima_user_DllExport Type67& operator =(
            const Type67& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type67 that will be copied.
     */
    eProsima_user_DllExport Type67& operator =(
            Type67&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type67 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type67& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type67 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type67& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type68 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type68
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type68()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type68()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type68 that will be copied.
     */
    eProsima_user_DllExport Type68(
            const Type68& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type68 that will be copied.
     */
    eProsima_user_DllExport Type68(
            Type68&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type68 that will be copied.
     */
    eProsima_user_DllExport Type68& operator =(
            const Type68& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type68 that will be copied.
     */
    eProsima_user_DllExport Type68& operator =(
            Type68&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type68 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type68& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type68 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type68& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type69 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type69
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type69()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type69()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type69 that will be copied.
     */
    eProsima_user_DllExport Type69(
            const Type69& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type69 that will be copied.
     */
    eProsima_user_DllExport Type69(
            Type69&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type69 that will be copied.
     */
    eProsima_user_DllExport Type69& operator =(
            const Type69& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type69 that will be copied.
     */
    eProsima_user_DllExport Type69& operator =(
            Type69&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type69 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type69& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type69 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type69& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type70 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type70
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type70()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type70()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type70 that will be copied.
     */
    eProsima_user_DllExport Type70(
            const Type70& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type70 that will be copied.
     */
    eProsima_user_DllExport Type70(
            Type70&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type70 that will be copied.
     */
    eProsima_user_DllExport Type70& operator =(
            const Type70& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type70 that will be copied.
     */
    eProsima_user_DllExport Type70& operator =(
            Type70&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type70 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type70& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type70 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type70& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type71 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type71
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type71()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type71()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type71 that will be copied.
     */
    eProsima_user_DllExport Type71(
            const Type71& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type71 that will be copied.
     */
    eProsima_user_DllExport Type71(
            Type71&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type71 that will be copied.
     */
    eProsima_user_DllExport Type71& operator =(
            const Type71& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type71 that will be copied.
     */
    eProsima_user_DllExport Type71& operator =(
            Type71&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type71 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type71& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type71 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type71& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type72 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type72
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type72()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type72()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type72 that will be copied.
     */
    eProsima_user_DllExport Type72(
            const Type72& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type72 that will be copied.
     */
    eProsima_user_DllExport Type72(
            Type72&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type72 that will be copied.
     */
    eProsima_user_DllExport Type72& operator =(
            const Type72& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type72 that will be copied.
     */
    eProsima_user_DllExport Type72& operator =(
            Type72&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type72 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type72& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type72 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type72& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type73 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type73
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type73()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type73()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type73 that will be copied.
     */
    eProsima_user_DllExport Type73(
            const Type73& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type73 that will be copied.
     */
    eProsima_user_DllExport Type73(
            Type73&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type73 that will be copied.
     */
    eProsima_user_DllExport Type73& operator =(
            const Type73& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type73 that will be copied.
     */
    eProsima_user_DllExport Type73& operator =(
            Type73&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type73 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type73& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type73 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type73& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type74 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type74
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type74()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type74()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type74 that will be copied.
     */
    eProsima_user_DllExport Type74(
            const Type74& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type74 that will be copied.
     */
    eProsima_user_DllExport Type74(
            Type74&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type74 that will be copied.
     */
    eProsima_user_DllExport Type74& operator =(
            const Type74& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type74 that will be copied.
     */
    eProsima_user_DllExport Type74& operator =(
            Type74&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type74 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type74& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type74 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type74& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type75 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type75
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type75()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type75()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type75 that will be copied.
     */
    eProsima_user_DllExport Type75(
            const Type75& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type75 that will be copied.
     */
    eProsima_user_DllExport Type75(
            Type75&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type75 that will be copied.
     */
    eProsima_user_DllExport Type75& operator =(
            const Type75& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type75 that will be copied.
     */
    eProsima_user_DllExport Type75& operator =(
            Type75&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type75 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type75& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type75 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type75& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type76 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type76
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type76()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type76()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type76 that will be copied.
     */
    eProsima_user_DllExport Type76(
            const Type76& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type76 that will be copied.
     */
    eProsima_user_DllExport Type76(
            Type76&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type76 that will be copied.
     */
    eProsima_user_DllExport Type76& operator =(
            const Type76& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type76 that will be copied.
     */
    eProsima_user_DllExport Type76& operator =(
            Type76&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type76 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type76& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type76 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type76& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type77 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type77
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type77()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type77()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type77 that will be copied.
     */
    eProsima_user_DllExport Type77(
            const Type77& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type77 that will be copied.
     */
    eProsima_user_DllExport Type77(
            Type77&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type77 that will be copied.
     */
    eProsima_user_DllExport Type77& operator =(
            const Type77& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type77 that will be copied.
     */
    eProsima_user_DllExport Type77& operator =(
            Type77&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type77 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type77& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type77 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type77& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type78 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type78
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type78()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type78()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type78 that will be copied.
     */
    eProsima_user_DllExport Type78(
            const Type78& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type78 that will be copied.
     */
    eProsima_user_DllExport Type78(
            Type78&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type78 that will be copied.
     */
    eProsima_user_DllExport Type78& operator =(
            const Type78& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type78 that will be copied.
     */
    eProsima_user_DllExport Type78& operator =(
            Type78&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type78 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type78& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type78 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type78& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type79 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type79
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type79()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type79()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type79 that will be copied.
     */
    eProsima_user_DllExport Type79(
            const Type79& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type79 that will be copied.
     */
    eProsima_user_DllExport Type79(
            Type79&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type79 that will be copied.
     */
    eProsima_user_DllExport Type79& operator =(
            const Type79& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type79 that will be copied.
     */
    eProsima_user_DllExport Type79& operator =(
            Type79&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type79 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type79& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type79 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type79& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type80 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type80
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type80()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type80()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type80 that will be copied.
     */
    eProsima_user_DllExport Type80(
            const Type80& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type80 that will be copied.
     */
    eProsima_user_DllExport Type80(
            Type80&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type80 that will be copied.
     */
    eProsima_user_DllExport Type80& operator =(
            const Type80& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type80 that will be copied.
     */
    eProsima_user_DllExport Type80& operator =(
            Type80&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type80 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type80& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type80 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type80& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type81 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type81
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type81()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type81()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type81 that will be copied.
     */
    eProsima_user_DllExport Type81(
            const Type81& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type81 that will be copied.
     */
    eProsima_user_DllExport Type81(
            Type81&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type81 that will be copied.
     */
    eProsima_user_DllExport Type81& operator =(
            const Type81& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type81 that will be copied.
     */
    eProsima_user_DllExport Type81& operator =(
            Type81&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type81 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type81& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type81 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type81& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type82 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type82
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type82()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type82()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type82 that will be copied.
     */
    eProsima_user_DllExport Type82(
            const Type82& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type82 that will be copied.
     */
    eProsima_user_DllExport Type82(
            Type82&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type82 that will be copied.
     */
    eProsima_user_DllExport Type82& operator =(
            const Type82& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type82 that will be copied.
     */
    eProsima_user_DllExport Type82& operator =(
            Type82&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type82 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type82& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type82 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type82& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type83 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type83
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type83()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type83()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type83 that will be copied.
     */
    eProsima_user_DllExport Type83(
            const Type83& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type83 that will be copied.
     */
    eProsima_user_DllExport Type83(
            Type83&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type83 that will be copied.
     */
    eProsima_user_DllExport Type83& operator =(
            const Type83& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type83 that will be copied.
     */
    eProsima_user_DllExport Type83& operator =(
            Type83&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type83 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type83& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type83 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type83& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type84 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type84
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type84()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type84()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type84 that will be copied.
     */
    eProsima_user_DllExport Type84(
            const Type84& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type84 that will be copied.
     */
    eProsima_user_DllExport Type84(
            Type84&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type84 that will be copied.
     */
    eProsima_user_DllExport Type84& operator =(
            const Type84& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type84 that will be copied.
     */
    eProsima_user_DllExport Type84& operator =(
            Type84&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type84 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type84& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type84 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type84& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type85 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type85
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type85()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type85()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type85 that will be copied.
     */
    eProsima_user_DllExport Type85(
            const Type85& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type85 that will be copied.
     */
    eProsima_user_DllExport Type85(
            Type85&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type85 that will be copied.
     */
    eProsima_user_DllExport Type85& operator =(
            const Type85& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type85 that will be copied.
     */
    eProsima_user_DllExport Type85& operator =(
            Type85&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type85 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type85& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type85 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type85& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type86 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type86
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type86()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type86()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type86 that will be copied.
     */
    eProsima_user_DllExport Type86(
            const Type86& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type86 that will be copied.
     */
    eProsima_user_DllExport Type86(
            Type86&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type86 that will be copied.
     */
    eProsima_user_DllExport Type86& operator =(
            const Type86& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type86 that will be copied.
     */
    eProsima_user_DllExport Type86& operator =(
            Type86&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type86 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type86& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type86 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type86& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type87 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type87
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type87()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type87()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type87 that will be copied.
     */
    eProsima_user_DllExport Type87(
            const Type87& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type87 that will be copied.
     */
    eProsima_user_DllExport Type87(
            Type87&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type87 that will be copied.
     */
    eProsima_user_DllExport Type87& operator =(
            const Type87& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type87 that will be copied.
     */
    eProsima_user_DllExport Type87& operator =(
            Type87&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type87 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type87& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type87 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type87& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type88 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type88
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type88()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type88()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type88 that will be copied.
     */
    eProsima_user_DllExport Type88(
            const Type88& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type88 that will be copied.
     */
    eProsima_user_DllExport Type88(
            Type88&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type88 that will be copied.
     */
    eProsima_user_DllExport Type88& operator =(
            const Type88& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type88 that will be copied.
     */
    eProsima_user_DllExport Type88& operator =(
            Type88&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type88 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type88& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type88 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type88& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type89 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type89
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type89()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type89()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type89 that will be copied.
     */
    eProsima_user_DllExport Type89(
            const Type89& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type89 that will be copied.
     */
    eProsima_user_DllExport Type89(
            Type89&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type89 that will be copied.
     */
    eProsima_user_DllExport Type89& operator =(
            const Type89& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type89 that will be copied.
     */
    eProsima_user_DllExport Type89& operator =(
            Type89&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type89 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type89& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type89 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type89& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type90 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type90
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type90()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type90()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type90 that will be copied.
     */
    eProsima_user_DllExport Type90(
            const Type90& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type90 that will be copied.
     */
    eProsima_user_DllExport Type90(
            Type90&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type90 that will be copied.
     */
    eProsima_user_DllExport Type90& operator =(
            const Type90& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type90 that will be copied.
     */
    eProsima_user_DllExport Type90& operator =(
            Type90&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type90 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type90& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type90 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type90& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type91 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type91
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type91()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type91()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type91 that will be copied.
     */
    eProsima_user_DllExport Type91(
            const Type91& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type91 that will be copied.
     */
    eProsima_user_DllExport Type91(
            Type91&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type91 that will be copied.
     */
    eProsima_user_DllExport Type91& operator =(
            const Type91& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type91 that will be copied.
     */
    eProsima_user_DllExport Type91& operator =(
            Type91&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type91 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type91& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type91 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type91& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type92 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type92
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type92()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type92()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type92 that will be copied.
     */
    eProsima_user_DllExport Type92(
            const Type92& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type92 that will be copied.
     */
    eProsima_user_DllExport Type92(
            Type92&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type92 that will be copied.
     */
    eProsima_user_DllExport Type92& operator =(
            const Type92& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type92 that will be copied.
     */
    eProsima_user_DllExport Type92& operator =(
            Type92&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type92 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type92& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type92 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type92& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type93 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type93
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type93()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type93()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type93 that will be copied.
     */
    eProsima_user_DllExport Type93(
            const Type93& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type93 that will be copied.
     */
    eProsima_user_DllExport Type93(
            Type93&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type93 that will be copied.
     */
    eProsima_user_DllExport Type93& operator =(
            const Type93& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type93 that will be copied.
     */
    eProsima_user_DllExport Type93& operator =(
            Type93&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type93 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type93& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type93 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type93& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type94 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type94
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type94()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type94()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type94 that will be copied.
     */
    eProsima_user_DllExport Type94(
            const Type94& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type94 that will be copied.
     */
    eProsima_user_DllExport Type94(
            Type94&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type94 that will be copied.
     */
    eProsima_user_DllExport Type94& operator =(
            const Type94& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type94 that will be copied.
     */
    eProsima_user_DllExport Type94& operator =(
            Type94&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type94 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type94& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type94 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type94& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type95 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type95
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type95()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type95()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type95 that will be copied.
     */
    eProsima_user_DllExport Type95(
            const Type95& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type95 that will be copied.
     */
    eProsima_user_DllExport Type95(
            Type95&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type95 that will be copied.
     */
    eProsima_user_DllExport Type95& operator =(
            const Type95& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type95 that will be copied.
     */
    eProsima_user_DllExport Type95& operator =(
            Type95&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type95 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type95& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type95 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type95& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type96 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type96
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type96()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type96()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type96 that will be copied.
     */
    eProsima_user_DllExport Type96(
            const Type96& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type96 that will be copied.
     */
    eProsima_user_DllExport Type96(
            Type96&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type96 that will be copied.
     */
    eProsima_user_DllExport Type96& operator =(
            const Type96& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type96 that will be copied.
     */
    eProsima_user_DllExport Type96& operator =(
            Type96&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type96 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type96& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type96 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type96& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type97 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type97
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type97()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type97()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type97 that will be copied.
     */
    eProsima_user_DllExport Type97(
            const Type97& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type97 that will be copied.
     */
    eProsima_user_DllExport Type97(
            Type97&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type97 that will be copied.
     */
    eProsima_user_DllExport Type97& operator =(
            const Type97& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type97 that will be copied.
     */
    eProsima_user_DllExport Type97& operator =(
            Type97&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type97 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type97& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type97 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type97& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type98 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type98
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type98()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type98()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type98 that will be copied.
     */
    eProsima_user_DllExport Type98(
            const Type98& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type98 that will be copied.
     */
    eProsima_user_DllExport Type98(
            Type98&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type98 that will be copied.
     */
    eProsima_user_DllExport Type98& operator =(
            const Type98& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type98 that will be copied.
     */
    eProsima_user_DllExport Type98& operator =(
            Type98&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type98 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type98& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type98 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type98& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type99 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type99
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type99()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type99()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type99 that will be copied.
     */
    eProsima_user_DllExport Type99(
            const Type99& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type99 that will be copied.
     */
    eProsima_user_DllExport Type99(
            Type99&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type99 that will be copied.
     */
    eProsima_user_DllExport Type99& operator =(
            const Type99& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type99 that will be copied.
     */
    eProsima_user_DllExport Type99& operator =(
            Type99&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type99 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type99& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type99 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type99& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure Type100 defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class Type100
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type100()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type100()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type100 that will be copied.
     */
    eProsima_user_DllExport Type100(
            const Type100& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type100 that will be copied.
     */
    eProsima_user_DllExport Type100(
            Type100&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type100 that will be copied.
     */
    eProsima_user_DllExport Type100& operator =(
            const Type100& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type100 that will be copied.
     */
    eProsima_user_DllExport Type100& operator =(
            Type100&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type100 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type100& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type100 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type100& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};
/*!
 * @brief This class represents the structure TypeBig defined by the user in the IDL file.
 * @ingroup XtypesTestsTypeBig
 */
class TypeBig
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport TypeBig()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~TypeBig()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object TypeBig that will be copied.
     */
    eProsima_user_DllExport TypeBig(
            const TypeBig& x)
    {
                    m_content = x.m_content;

                    m_dep1 = x.m_dep1;

                    m_dep2 = x.m_dep2;

                    m_dep3 = x.m_dep3;

                    m_dep4 = x.m_dep4;

                    m_dep5 = x.m_dep5;

                    m_dep6 = x.m_dep6;

                    m_dep7 = x.m_dep7;

                    m_dep8 = x.m_dep8;

                    m_dep9 = x.m_dep9;

                    m_dep10 = x.m_dep10;

                    m_dep11 = x.m_dep11;

                    m_dep12 = x.m_dep12;

                    m_dep13 = x.m_dep13;

                    m_dep14 = x.m_dep14;

                    m_dep15 = x.m_dep15;

                    m_dep16 = x.m_dep16;

                    m_dep17 = x.m_dep17;

                    m_dep18 = x.m_dep18;

                    m_dep19 = x.m_dep19;

                    m_dep20 = x.m_dep20;

                    m_dep21 = x.m_dep21;

                    m_dep22 = x.m_dep22;

                    m_dep23 = x.m_dep23;

                    m_dep24 = x.m_dep24;

                    m_dep25 = x.m_dep25;

                    m_dep26 = x.m_dep26;

                    m_dep27 = x.m_dep27;

                    m_dep28 = x.m_dep28;

                    m_dep29 = x.m_dep29;

                    m_dep30 = x.m_dep30;

                    m_dep31 = x.m_dep31;

                    m_dep32 = x.m_dep32;

                    m_dep33 = x.m_dep33;

                    m_dep34 = x.m_dep34;

                    m_dep35 = x.m_dep35;

                    m_dep36 = x.m_dep36;

                    m_dep37 = x.m_dep37;

                    m_dep38 = x.m_dep38;

                    m_dep39 = x.m_dep39;

                    m_dep40 = x.m_dep40;

                    m_dep41 = x.m_dep41;

                    m_dep42 = x.m_dep42;

                    m_dep43 = x.m_dep43;

                    m_dep44 = x.m_dep44;

                    m_dep45 = x.m_dep45;

                    m_dep46 = x.m_dep46;

                    m_dep47 = x.m_dep47;

                    m_dep48 = x.m_dep48;

                    m_dep49 = x.m_dep49;

                    m_dep50 = x.m_dep50;

                    m_dep51 = x.m_dep51;

                    m_dep52 = x.m_dep52;

                    m_dep53 = x.m_dep53;

                    m_dep54 = x.m_dep54;

                    m_dep55 = x.m_dep55;

                    m_dep56 = x.m_dep56;

                    m_dep57 = x.m_dep57;

                    m_dep58 = x.m_dep58;

                    m_dep59 = x.m_dep59;

                    m_dep60 = x.m_dep60;

                    m_dep61 = x.m_dep61;

                    m_dep62 = x.m_dep62;

                    m_dep63 = x.m_dep63;

                    m_dep64 = x.m_dep64;

                    m_dep65 = x.m_dep65;

                    m_dep66 = x.m_dep66;

                    m_dep67 = x.m_dep67;

                    m_dep68 = x.m_dep68;

                    m_dep69 = x.m_dep69;

                    m_dep70 = x.m_dep70;

                    m_dep71 = x.m_dep71;

                    m_dep72 = x.m_dep72;

                    m_dep73 = x.m_dep73;

                    m_dep74 = x.m_dep74;

                    m_dep75 = x.m_dep75;

                    m_dep76 = x.m_dep76;

                    m_dep77 = x.m_dep77;

                    m_dep78 = x.m_dep78;

                    m_dep79 = x.m_dep79;

                    m_dep80 = x.m_dep80;

                    m_dep81 = x.m_dep81;

                    m_dep82 = x.m_dep82;

                    m_dep83 = x.m_dep83;

                    m_dep84 = x.m_dep84;

                    m_dep85 = x.m_dep85;

                    m_dep86 = x.m_dep86;

                    m_dep87 = x.m_dep87;

                    m_dep88 = x.m_dep88;

                    m_dep89 = x.m_dep89;

                    m_dep90 = x.m_dep90;

                    m_dep91 = x.m_dep91;

                    m_dep92 = x.m_dep92;

                    m_dep93 = x.m_dep93;

                    m_dep94 = x.m_dep94;

                    m_dep95 = x.m_dep95;

                    m_dep96 = x.m_dep96;

                    m_dep97 = x.m_dep97;

                    m_dep98 = x.m_dep98;

                    m_dep99 = x.m_dep99;

                    m_dep100 = x.m_dep100;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object TypeBig that will be copied.
     */
    eProsima_user_DllExport TypeBig(
            TypeBig&& x) noexcept
    {
        m_content = std::move(x.m_content);
        m_dep1 = std::move(x.m_dep1);
        m_dep2 = std::move(x.m_dep2);
        m_dep3 = std::move(x.m_dep3);
        m_dep4 = std::move(x.m_dep4);
        m_dep5 = std::move(x.m_dep5);
        m_dep6 = std::move(x.m_dep6);
        m_dep7 = std::move(x.m_dep7);
        m_dep8 = std::move(x.m_dep8);
        m_dep9 = std::move(x.m_dep9);
        m_dep10 = std::move(x.m_dep10);
        m_dep11 = std::move(x.m_dep11);
        m_dep12 = std::move(x.m_dep12);
        m_dep13 = std::move(x.m_dep13);
        m_dep14 = std::move(x.m_dep14);
        m_dep15 = std::move(x.m_dep15);
        m_dep16 = std::move(x.m_dep16);
        m_dep17 = std::move(x.m_dep17);
        m_dep18 = std::move(x.m_dep18);
        m_dep19 = std::move(x.m_dep19);
        m_dep20 = std::move(x.m_dep20);
        m_dep21 = std::move(x.m_dep21);
        m_dep22 = std::move(x.m_dep22);
        m_dep23 = std::move(x.m_dep23);
        m_dep24 = std::move(x.m_dep24);
        m_dep25 = std::move(x.m_dep25);
        m_dep26 = std::move(x.m_dep26);
        m_dep27 = std::move(x.m_dep27);
        m_dep28 = std::move(x.m_dep28);
        m_dep29 = std::move(x.m_dep29);
        m_dep30 = std::move(x.m_dep30);
        m_dep31 = std::move(x.m_dep31);
        m_dep32 = std::move(x.m_dep32);
        m_dep33 = std::move(x.m_dep33);
        m_dep34 = std::move(x.m_dep34);
        m_dep35 = std::move(x.m_dep35);
        m_dep36 = std::move(x.m_dep36);
        m_dep37 = std::move(x.m_dep37);
        m_dep38 = std::move(x.m_dep38);
        m_dep39 = std::move(x.m_dep39);
        m_dep40 = std::move(x.m_dep40);
        m_dep41 = std::move(x.m_dep41);
        m_dep42 = std::move(x.m_dep42);
        m_dep43 = std::move(x.m_dep43);
        m_dep44 = std::move(x.m_dep44);
        m_dep45 = std::move(x.m_dep45);
        m_dep46 = std::move(x.m_dep46);
        m_dep47 = std::move(x.m_dep47);
        m_dep48 = std::move(x.m_dep48);
        m_dep49 = std::move(x.m_dep49);
        m_dep50 = std::move(x.m_dep50);
        m_dep51 = std::move(x.m_dep51);
        m_dep52 = std::move(x.m_dep52);
        m_dep53 = std::move(x.m_dep53);
        m_dep54 = std::move(x.m_dep54);
        m_dep55 = std::move(x.m_dep55);
        m_dep56 = std::move(x.m_dep56);
        m_dep57 = std::move(x.m_dep57);
        m_dep58 = std::move(x.m_dep58);
        m_dep59 = std::move(x.m_dep59);
        m_dep60 = std::move(x.m_dep60);
        m_dep61 = std::move(x.m_dep61);
        m_dep62 = std::move(x.m_dep62);
        m_dep63 = std::move(x.m_dep63);
        m_dep64 = std::move(x.m_dep64);
        m_dep65 = std::move(x.m_dep65);
        m_dep66 = std::move(x.m_dep66);
        m_dep67 = std::move(x.m_dep67);
        m_dep68 = std::move(x.m_dep68);
        m_dep69 = std::move(x.m_dep69);
        m_dep70 = std::move(x.m_dep70);
        m_dep71 = std::move(x.m_dep71);
        m_dep72 = std::move(x.m_dep72);
        m_dep73 = std::move(x.m_dep73);
        m_dep74 = std::move(x.m_dep74);
        m_dep75 = std::move(x.m_dep75);
        m_dep76 = std::move(x.m_dep76);
        m_dep77 = std::move(x.m_dep77);
        m_dep78 = std::move(x.m_dep78);
        m_dep79 = std::move(x.m_dep79);
        m_dep80 = std::move(x.m_dep80);
        m_dep81 = std::move(x.m_dep81);
        m_dep82 = std::move(x.m_dep82);
        m_dep83 = std::move(x.m_dep83);
        m_dep84 = std::move(x.m_dep84);
        m_dep85 = std::move(x.m_dep85);
        m_dep86 = std::move(x.m_dep86);
        m_dep87 = std::move(x.m_dep87);
        m_dep88 = std::move(x.m_dep88);
        m_dep89 = std::move(x.m_dep89);
        m_dep90 = std::move(x.m_dep90);
        m_dep91 = std::move(x.m_dep91);
        m_dep92 = std::move(x.m_dep92);
        m_dep93 = std::move(x.m_dep93);
        m_dep94 = std::move(x.m_dep94);
        m_dep95 = std::move(x.m_dep95);
        m_dep96 = std::move(x.m_dep96);
        m_dep97 = std::move(x.m_dep97);
        m_dep98 = std::move(x.m_dep98);
        m_dep99 = std::move(x.m_dep99);
        m_dep100 = std::move(x.m_dep100);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object TypeBig that will be copied.
     */
    eProsima_user_DllExport TypeBig& operator =(
            const TypeBig& x)
    {

                    m_content = x.m_content;

                    m_dep1 = x.m_dep1;

                    m_dep2 = x.m_dep2;

                    m_dep3 = x.m_dep3;

                    m_dep4 = x.m_dep4;

                    m_dep5 = x.m_dep5;

                    m_dep6 = x.m_dep6;

                    m_dep7 = x.m_dep7;

                    m_dep8 = x.m_dep8;

                    m_dep9 = x.m_dep9;

                    m_dep10 = x.m_dep10;

                    m_dep11 = x.m_dep11;

                    m_dep12 = x.m_dep12;

                    m_dep13 = x.m_dep13;

                    m_dep14 = x.m_dep14;

                    m_dep15 = x.m_dep15;

                    m_dep16 = x.m_dep16;

                    m_dep17 = x.m_dep17;

                    m_dep18 = x.m_dep18;

                    m_dep19 = x.m_dep19;

                    m_dep20 = x.m_dep20;

                    m_dep21 = x.m_dep21;

                    m_dep22 = x.m_dep22;

                    m_dep23 = x.m_dep23;

                    m_dep24 = x.m_dep24;

                    m_dep25 = x.m_dep25;

                    m_dep26 = x.m_dep26;

                    m_dep27 = x.m_dep27;

                    m_dep28 = x.m_dep28;

                    m_dep29 = x.m_dep29;

                    m_dep30 = x.m_dep30;

                    m_dep31 = x.m_dep31;

                    m_dep32 = x.m_dep32;

                    m_dep33 = x.m_dep33;

                    m_dep34 = x.m_dep34;

                    m_dep35 = x.m_dep35;

                    m_dep36 = x.m_dep36;

                    m_dep37 = x.m_dep37;

                    m_dep38 = x.m_dep38;

                    m_dep39 = x.m_dep39;

                    m_dep40 = x.m_dep40;

                    m_dep41 = x.m_dep41;

                    m_dep42 = x.m_dep42;

                    m_dep43 = x.m_dep43;

                    m_dep44 = x.m_dep44;

                    m_dep45 = x.m_dep45;

                    m_dep46 = x.m_dep46;

                    m_dep47 = x.m_dep47;

                    m_dep48 = x.m_dep48;

                    m_dep49 = x.m_dep49;

                    m_dep50 = x.m_dep50;

                    m_dep51 = x.m_dep51;

                    m_dep52 = x.m_dep52;

                    m_dep53 = x.m_dep53;

                    m_dep54 = x.m_dep54;

                    m_dep55 = x.m_dep55;

                    m_dep56 = x.m_dep56;

                    m_dep57 = x.m_dep57;

                    m_dep58 = x.m_dep58;

                    m_dep59 = x.m_dep59;

                    m_dep60 = x.m_dep60;

                    m_dep61 = x.m_dep61;

                    m_dep62 = x.m_dep62;

                    m_dep63 = x.m_dep63;

                    m_dep64 = x.m_dep64;

                    m_dep65 = x.m_dep65;

                    m_dep66 = x.m_dep66;

                    m_dep67 = x.m_dep67;

                    m_dep68 = x.m_dep68;

                    m_dep69 = x.m_dep69;

                    m_dep70 = x.m_dep70;

                    m_dep71 = x.m_dep71;

                    m_dep72 = x.m_dep72;

                    m_dep73 = x.m_dep73;

                    m_dep74 = x.m_dep74;

                    m_dep75 = x.m_dep75;

                    m_dep76 = x.m_dep76;

                    m_dep77 = x.m_dep77;

                    m_dep78 = x.m_dep78;

                    m_dep79 = x.m_dep79;

                    m_dep80 = x.m_dep80;

                    m_dep81 = x.m_dep81;

                    m_dep82 = x.m_dep82;

                    m_dep83 = x.m_dep83;

                    m_dep84 = x.m_dep84;

                    m_dep85 = x.m_dep85;

                    m_dep86 = x.m_dep86;

                    m_dep87 = x.m_dep87;

                    m_dep88 = x.m_dep88;

                    m_dep89 = x.m_dep89;

                    m_dep90 = x.m_dep90;

                    m_dep91 = x.m_dep91;

                    m_dep92 = x.m_dep92;

                    m_dep93 = x.m_dep93;

                    m_dep94 = x.m_dep94;

                    m_dep95 = x.m_dep95;

                    m_dep96 = x.m_dep96;

                    m_dep97 = x.m_dep97;

                    m_dep98 = x.m_dep98;

                    m_dep99 = x.m_dep99;

                    m_dep100 = x.m_dep100;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object TypeBig that will be copied.
     */
    eProsima_user_DllExport TypeBig& operator =(
            TypeBig&& x) noexcept
    {

        m_content = std::move(x.m_content);
        m_dep1 = std::move(x.m_dep1);
        m_dep2 = std::move(x.m_dep2);
        m_dep3 = std::move(x.m_dep3);
        m_dep4 = std::move(x.m_dep4);
        m_dep5 = std::move(x.m_dep5);
        m_dep6 = std::move(x.m_dep6);
        m_dep7 = std::move(x.m_dep7);
        m_dep8 = std::move(x.m_dep8);
        m_dep9 = std::move(x.m_dep9);
        m_dep10 = std::move(x.m_dep10);
        m_dep11 = std::move(x.m_dep11);
        m_dep12 = std::move(x.m_dep12);
        m_dep13 = std::move(x.m_dep13);
        m_dep14 = std::move(x.m_dep14);
        m_dep15 = std::move(x.m_dep15);
        m_dep16 = std::move(x.m_dep16);
        m_dep17 = std::move(x.m_dep17);
        m_dep18 = std::move(x.m_dep18);
        m_dep19 = std::move(x.m_dep19);
        m_dep20 = std::move(x.m_dep20);
        m_dep21 = std::move(x.m_dep21);
        m_dep22 = std::move(x.m_dep22);
        m_dep23 = std::move(x.m_dep23);
        m_dep24 = std::move(x.m_dep24);
        m_dep25 = std::move(x.m_dep25);
        m_dep26 = std::move(x.m_dep26);
        m_dep27 = std::move(x.m_dep27);
        m_dep28 = std::move(x.m_dep28);
        m_dep29 = std::move(x.m_dep29);
        m_dep30 = std::move(x.m_dep30);
        m_dep31 = std::move(x.m_dep31);
        m_dep32 = std::move(x.m_dep32);
        m_dep33 = std::move(x.m_dep33);
        m_dep34 = std::move(x.m_dep34);
        m_dep35 = std::move(x.m_dep35);
        m_dep36 = std::move(x.m_dep36);
        m_dep37 = std::move(x.m_dep37);
        m_dep38 = std::move(x.m_dep38);
        m_dep39 = std::move(x.m_dep39);
        m_dep40 = std::move(x.m_dep40);
        m_dep41 = std::move(x.m_dep41);
        m_dep42 = std::move(x.m_dep42);
        m_dep43 = std::move(x.m_dep43);
        m_dep44 = std::move(x.m_dep44);
        m_dep45 = std::move(x.m_dep45);
        m_dep46 = std::move(x.m_dep46);
        m_dep47 = std::move(x.m_dep47);
        m_dep48 = std::move(x.m_dep48);
        m_dep49 = std::move(x.m_dep49);
        m_dep50 = std::move(x.m_dep50);
        m_dep51 = std::move(x.m_dep51);
        m_dep52 = std::move(x.m_dep52);
        m_dep53 = std::move(x.m_dep53);
        m_dep54 = std::move(x.m_dep54);
        m_dep55 = std::move(x.m_dep55);
        m_dep56 = std::move(x.m_dep56);
        m_dep57 = std::move(x.m_dep57);
        m_dep58 = std::move(x.m_dep58);
        m_dep59 = std::move(x.m_dep59);
        m_dep60 = std::move(x.m_dep60);
        m_dep61 = std::move(x.m_dep61);
        m_dep62 = std::move(x.m_dep62);
        m_dep63 = std::move(x.m_dep63);
        m_dep64 = std::move(x.m_dep64);
        m_dep65 = std::move(x.m_dep65);
        m_dep66 = std::move(x.m_dep66);
        m_dep67 = std::move(x.m_dep67);
        m_dep68 = std::move(x.m_dep68);
        m_dep69 = std::move(x.m_dep69);
        m_dep70 = std::move(x.m_dep70);
        m_dep71 = std::move(x.m_dep71);
        m_dep72 = std::move(x.m_dep72);
        m_dep73 = std::move(x.m_dep73);
        m_dep74 = std::move(x.m_dep74);
        m_dep75 = std::move(x.m_dep75);
        m_dep76 = std::move(x.m_dep76);
        m_dep77 = std::move(x.m_dep77);
        m_dep78 = std::move(x.m_dep78);
        m_dep79 = std::move(x.m_dep79);
        m_dep80 = std::move(x.m_dep80);
        m_dep81 = std::move(x.m_dep81);
        m_dep82 = std::move(x.m_dep82);
        m_dep83 = std::move(x.m_dep83);
        m_dep84 = std::move(x.m_dep84);
        m_dep85 = std::move(x.m_dep85);
        m_dep86 = std::move(x.m_dep86);
        m_dep87 = std::move(x.m_dep87);
        m_dep88 = std::move(x.m_dep88);
        m_dep89 = std::move(x.m_dep89);
        m_dep90 = std::move(x.m_dep90);
        m_dep91 = std::move(x.m_dep91);
        m_dep92 = std::move(x.m_dep92);
        m_dep93 = std::move(x.m_dep93);
        m_dep94 = std::move(x.m_dep94);
        m_dep95 = std::move(x.m_dep95);
        m_dep96 = std::move(x.m_dep96);
        m_dep97 = std::move(x.m_dep97);
        m_dep98 = std::move(x.m_dep98);
        m_dep99 = std::move(x.m_dep99);
        m_dep100 = std::move(x.m_dep100);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeBig object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const TypeBig& x) const
    {
        return (m_content == x.m_content &&
           m_dep1 == x.m_dep1 &&
           m_dep2 == x.m_dep2 &&
           m_dep3 == x.m_dep3 &&
           m_dep4 == x.m_dep4 &&
           m_dep5 == x.m_dep5 &&
           m_dep6 == x.m_dep6 &&
           m_dep7 == x.m_dep7 &&
           m_dep8 == x.m_dep8 &&
           m_dep9 == x.m_dep9 &&
           m_dep10 == x.m_dep10 &&
           m_dep11 == x.m_dep11 &&
           m_dep12 == x.m_dep12 &&
           m_dep13 == x.m_dep13 &&
           m_dep14 == x.m_dep14 &&
           m_dep15 == x.m_dep15 &&
           m_dep16 == x.m_dep16 &&
           m_dep17 == x.m_dep17 &&
           m_dep18 == x.m_dep18 &&
           m_dep19 == x.m_dep19 &&
           m_dep20 == x.m_dep20 &&
           m_dep21 == x.m_dep21 &&
           m_dep22 == x.m_dep22 &&
           m_dep23 == x.m_dep23 &&
           m_dep24 == x.m_dep24 &&
           m_dep25 == x.m_dep25 &&
           m_dep26 == x.m_dep26 &&
           m_dep27 == x.m_dep27 &&
           m_dep28 == x.m_dep28 &&
           m_dep29 == x.m_dep29 &&
           m_dep30 == x.m_dep30 &&
           m_dep31 == x.m_dep31 &&
           m_dep32 == x.m_dep32 &&
           m_dep33 == x.m_dep33 &&
           m_dep34 == x.m_dep34 &&
           m_dep35 == x.m_dep35 &&
           m_dep36 == x.m_dep36 &&
           m_dep37 == x.m_dep37 &&
           m_dep38 == x.m_dep38 &&
           m_dep39 == x.m_dep39 &&
           m_dep40 == x.m_dep40 &&
           m_dep41 == x.m_dep41 &&
           m_dep42 == x.m_dep42 &&
           m_dep43 == x.m_dep43 &&
           m_dep44 == x.m_dep44 &&
           m_dep45 == x.m_dep45 &&
           m_dep46 == x.m_dep46 &&
           m_dep47 == x.m_dep47 &&
           m_dep48 == x.m_dep48 &&
           m_dep49 == x.m_dep49 &&
           m_dep50 == x.m_dep50 &&
           m_dep51 == x.m_dep51 &&
           m_dep52 == x.m_dep52 &&
           m_dep53 == x.m_dep53 &&
           m_dep54 == x.m_dep54 &&
           m_dep55 == x.m_dep55 &&
           m_dep56 == x.m_dep56 &&
           m_dep57 == x.m_dep57 &&
           m_dep58 == x.m_dep58 &&
           m_dep59 == x.m_dep59 &&
           m_dep60 == x.m_dep60 &&
           m_dep61 == x.m_dep61 &&
           m_dep62 == x.m_dep62 &&
           m_dep63 == x.m_dep63 &&
           m_dep64 == x.m_dep64 &&
           m_dep65 == x.m_dep65 &&
           m_dep66 == x.m_dep66 &&
           m_dep67 == x.m_dep67 &&
           m_dep68 == x.m_dep68 &&
           m_dep69 == x.m_dep69 &&
           m_dep70 == x.m_dep70 &&
           m_dep71 == x.m_dep71 &&
           m_dep72 == x.m_dep72 &&
           m_dep73 == x.m_dep73 &&
           m_dep74 == x.m_dep74 &&
           m_dep75 == x.m_dep75 &&
           m_dep76 == x.m_dep76 &&
           m_dep77 == x.m_dep77 &&
           m_dep78 == x.m_dep78 &&
           m_dep79 == x.m_dep79 &&
           m_dep80 == x.m_dep80 &&
           m_dep81 == x.m_dep81 &&
           m_dep82 == x.m_dep82 &&
           m_dep83 == x.m_dep83 &&
           m_dep84 == x.m_dep84 &&
           m_dep85 == x.m_dep85 &&
           m_dep86 == x.m_dep86 &&
           m_dep87 == x.m_dep87 &&
           m_dep88 == x.m_dep88 &&
           m_dep89 == x.m_dep89 &&
           m_dep90 == x.m_dep90 &&
           m_dep91 == x.m_dep91 &&
           m_dep92 == x.m_dep92 &&
           m_dep93 == x.m_dep93 &&
           m_dep94 == x.m_dep94 &&
           m_dep95 == x.m_dep95 &&
           m_dep96 == x.m_dep96 &&
           m_dep97 == x.m_dep97 &&
           m_dep98 == x.m_dep98 &&
           m_dep99 == x.m_dep99 &&
           m_dep100 == x.m_dep100);
    }

    /*!
     * @brief Comparison operator.
     * @param x TypeBig object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const TypeBig& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }


    /*!
     * @brief This function copies the value in member dep1
     * @param _dep1 New value to be copied in member dep1
     */
    eProsima_user_DllExport void dep1(
            const Type1& _dep1)
    {
        m_dep1 = _dep1;
    }

    /*!
     * @brief This function moves the value in member dep1
     * @param _dep1 New value to be moved in member dep1
     */
    eProsima_user_DllExport void dep1(
            Type1&& _dep1)
    {
        m_dep1 = std::move(_dep1);
    }

    /*!
     * @brief This function returns a constant reference to member dep1
     * @return Constant reference to member dep1
     */
    eProsima_user_DllExport const Type1& dep1() const
    {
        return m_dep1;
    }

    /*!
     * @brief This function returns a reference to member dep1
     * @return Reference to member dep1
     */
    eProsima_user_DllExport Type1& dep1()
    {
        return m_dep1;
    }


    /*!
     * @brief This function copies the value in member dep2
     * @param _dep2 New value to be copied in member dep2
     */
    eProsima_user_DllExport void dep2(
            const Type2& _dep2)
    {
        m_dep2 = _dep2;
    }

    /*!
     * @brief This function moves the value in member dep2
     * @param _dep2 New value to be moved in member dep2
     */
    eProsima_user_DllExport void dep2(
            Type2&& _dep2)
    {
        m_dep2 = std::move(_dep2);
    }

    /*!
     * @brief This function returns a constant reference to member dep2
     * @return Constant reference to member dep2
     */
    eProsima_user_DllExport const Type2& dep2() const
    {
        return m_dep2;
    }

    /*!
     * @brief This function returns a reference to member dep2
     * @return Reference to member dep2
     */
    eProsima_user_DllExport Type2& dep2()
    {
        return m_dep2;
    }


    /*!
     * @brief This function copies the value in member dep3
     * @param _dep3 New value to be copied in member dep3
     */
    eProsima_user_DllExport void dep3(
            const Type3& _dep3)
    {
        m_dep3 = _dep3;
    }

    /*!
     * @brief This function moves the value in member dep3
     * @param _dep3 New value to be moved in member dep3
     */
    eProsima_user_DllExport void dep3(
            Type3&& _dep3)
    {
        m_dep3 = std::move(_dep3);
    }

    /*!
     * @brief This function returns a constant reference to member dep3
     * @return Constant reference to member dep3
     */
    eProsima_user_DllExport const Type3& dep3() const
    {
        return m_dep3;
    }

    /*!
     * @brief This function returns a reference to member dep3
     * @return Reference to member dep3
     */
    eProsima_user_DllExport Type3& dep3()
    {
        return m_dep3;
    }


    /*!
     * @brief This function copies the value in member dep4
     * @param _dep4 New value to be copied in member dep4
     */
    eProsima_user_DllExport void dep4(
            const Type4& _dep4)
    {
        m_dep4 = _dep4;
    }

    /*!
     * @brief This function moves the value in member dep4
     * @param _dep4 New value to be moved in member dep4
     */
    eProsima_user_DllExport void dep4(
            Type4&& _dep4)
    {
        m_dep4 = std::move(_dep4);
    }

    /*!
     * @brief This function returns a constant reference to member dep4
     * @return Constant reference to member dep4
     */
    eProsima_user_DllExport const Type4& dep4() const
    {
        return m_dep4;
    }

    /*!
     * @brief This function returns a reference to member dep4
     * @return Reference to member dep4
     */
    eProsima_user_DllExport Type4& dep4()
    {
        return m_dep4;
    }


    /*!
     * @brief This function copies the value in member dep5
     * @param _dep5 New value to be copied in member dep5
     */
    eProsima_user_DllExport void dep5(
            const Type5& _dep5)
    {
        m_dep5 = _dep5;
    }

    /*!
     * @brief This function moves the value in member dep5
     * @param _dep5 New value to be moved in member dep5
     */
    eProsima_user_DllExport void dep5(
            Type5&& _dep5)
    {
        m_dep5 = std::move(_dep5);
    }

    /*!
     * @brief This function returns a constant reference to member dep5
     * @return Constant reference to member dep5
     */
    eProsima_user_DllExport const Type5& dep5() const
    {
        return m_dep5;
    }

    /*!
     * @brief This function returns a reference to member dep5
     * @return Reference to member dep5
     */
    eProsima_user_DllExport Type5& dep5()
    {
        return m_dep5;
    }


    /*!
     * @brief This function copies the value in member dep6
     * @param _dep6 New value to be copied in member dep6
     */
    eProsima_user_DllExport void dep6(
            const Type6& _dep6)
    {
        m_dep6 = _dep6;
    }

    /*!
     * @brief This function moves the value in member dep6
     * @param _dep6 New value to be moved in member dep6
     */
    eProsima_user_DllExport void dep6(
            Type6&& _dep6)
    {
        m_dep6 = std::move(_dep6);
    }

    /*!
     * @brief This function returns a constant reference to member dep6
     * @return Constant reference to member dep6
     */
    eProsima_user_DllExport const Type6& dep6() const
    {
        return m_dep6;
    }

    /*!
     * @brief This function returns a reference to member dep6
     * @return Reference to member dep6
     */
    eProsima_user_DllExport Type6& dep6()
    {
        return m_dep6;
    }


    /*!
     * @brief This function copies the value in member dep7
     * @param _dep7 New value to be copied in member dep7
     */
    eProsima_user_DllExport void dep7(
            const Type7& _dep7)
    {
        m_dep7 = _dep7;
    }

    /*!
     * @brief This function moves the value in member dep7
     * @param _dep7 New value to be moved in member dep7
     */
    eProsima_user_DllExport void dep7(
            Type7&& _dep7)
    {
        m_dep7 = std::move(_dep7);
    }

    /*!
     * @brief This function returns a constant reference to member dep7
     * @return Constant reference to member dep7
     */
    eProsima_user_DllExport const Type7& dep7() const
    {
        return m_dep7;
    }

    /*!
     * @brief This function returns a reference to member dep7
     * @return Reference to member dep7
     */
    eProsima_user_DllExport Type7& dep7()
    {
        return m_dep7;
    }


    /*!
     * @brief This function copies the value in member dep8
     * @param _dep8 New value to be copied in member dep8
     */
    eProsima_user_DllExport void dep8(
            const Type8& _dep8)
    {
        m_dep8 = _dep8;
    }

    /*!
     * @brief This function moves the value in member dep8
     * @param _dep8 New value to be moved in member dep8
     */
    eProsima_user_DllExport void dep8(
            Type8&& _dep8)
    {
        m_dep8 = std::move(_dep8);
    }

    /*!
     * @brief This function returns a constant reference to member dep8
     * @return Constant reference to member dep8
     */
    eProsima_user_DllExport const Type8& dep8() const
    {
        return m_dep8;
    }

    /*!
     * @brief This function returns a reference to member dep8
     * @return Reference to member dep8
     */
    eProsima_user_DllExport Type8& dep8()
    {
        return m_dep8;
    }


    /*!
     * @brief This function copies the value in member dep9
     * @param _dep9 New value to be copied in member dep9
     */
    eProsima_user_DllExport void dep9(
            const Type9& _dep9)
    {
        m_dep9 = _dep9;
    }

    /*!
     * @brief This function moves the value in member dep9
     * @param _dep9 New value to be moved in member dep9
     */
    eProsima_user_DllExport void dep9(
            Type9&& _dep9)
    {
        m_dep9 = std::move(_dep9);
    }

    /*!
     * @brief This function returns a constant reference to member dep9
     * @return Constant reference to member dep9
     */
    eProsima_user_DllExport const Type9& dep9() const
    {
        return m_dep9;
    }

    /*!
     * @brief This function returns a reference to member dep9
     * @return Reference to member dep9
     */
    eProsima_user_DllExport Type9& dep9()
    {
        return m_dep9;
    }


    /*!
     * @brief This function copies the value in member dep10
     * @param _dep10 New value to be copied in member dep10
     */
    eProsima_user_DllExport void dep10(
            const Type10& _dep10)
    {
        m_dep10 = _dep10;
    }

    /*!
     * @brief This function moves the value in member dep10
     * @param _dep10 New value to be moved in member dep10
     */
    eProsima_user_DllExport void dep10(
            Type10&& _dep10)
    {
        m_dep10 = std::move(_dep10);
    }

    /*!
     * @brief This function returns a constant reference to member dep10
     * @return Constant reference to member dep10
     */
    eProsima_user_DllExport const Type10& dep10() const
    {
        return m_dep10;
    }

    /*!
     * @brief This function returns a reference to member dep10
     * @return Reference to member dep10
     */
    eProsima_user_DllExport Type10& dep10()
    {
        return m_dep10;
    }


    /*!
     * @brief This function copies the value in member dep11
     * @param _dep11 New value to be copied in member dep11
     */
    eProsima_user_DllExport void dep11(
            const Type11& _dep11)
    {
        m_dep11 = _dep11;
    }

    /*!
     * @brief This function moves the value in member dep11
     * @param _dep11 New value to be moved in member dep11
     */
    eProsima_user_DllExport void dep11(
            Type11&& _dep11)
    {
        m_dep11 = std::move(_dep11);
    }

    /*!
     * @brief This function returns a constant reference to member dep11
     * @return Constant reference to member dep11
     */
    eProsima_user_DllExport const Type11& dep11() const
    {
        return m_dep11;
    }

    /*!
     * @brief This function returns a reference to member dep11
     * @return Reference to member dep11
     */
    eProsima_user_DllExport Type11& dep11()
    {
        return m_dep11;
    }


    /*!
     * @brief This function copies the value in member dep12
     * @param _dep12 New value to be copied in member dep12
     */
    eProsima_user_DllExport void dep12(
            const Type12& _dep12)
    {
        m_dep12 = _dep12;
    }

    /*!
     * @brief This function moves the value in member dep12
     * @param _dep12 New value to be moved in member dep12
     */
    eProsima_user_DllExport void dep12(
            Type12&& _dep12)
    {
        m_dep12 = std::move(_dep12);
    }

    /*!
     * @brief This function returns a constant reference to member dep12
     * @return Constant reference to member dep12
     */
    eProsima_user_DllExport const Type12& dep12() const
    {
        return m_dep12;
    }

    /*!
     * @brief This function returns a reference to member dep12
     * @return Reference to member dep12
     */
    eProsima_user_DllExport Type12& dep12()
    {
        return m_dep12;
    }


    /*!
     * @brief This function copies the value in member dep13
     * @param _dep13 New value to be copied in member dep13
     */
    eProsima_user_DllExport void dep13(
            const Type13& _dep13)
    {
        m_dep13 = _dep13;
    }

    /*!
     * @brief This function moves the value in member dep13
     * @param _dep13 New value to be moved in member dep13
     */
    eProsima_user_DllExport void dep13(
            Type13&& _dep13)
    {
        m_dep13 = std::move(_dep13);
    }

    /*!
     * @brief This function returns a constant reference to member dep13
     * @return Constant reference to member dep13
     */
    eProsima_user_DllExport const Type13& dep13() const
    {
        return m_dep13;
    }

    /*!
     * @brief This function returns a reference to member dep13
     * @return Reference to member dep13
     */
    eProsima_user_DllExport Type13& dep13()
    {
        return m_dep13;
    }


    /*!
     * @brief This function copies the value in member dep14
     * @param _dep14 New value to be copied in member dep14
     */
    eProsima_user_DllExport void dep14(
            const Type14& _dep14)
    {
        m_dep14 = _dep14;
    }

    /*!
     * @brief This function moves the value in member dep14
     * @param _dep14 New value to be moved in member dep14
     */
    eProsima_user_DllExport void dep14(
            Type14&& _dep14)
    {
        m_dep14 = std::move(_dep14);
    }

    /*!
     * @brief This function returns a constant reference to member dep14
     * @return Constant reference to member dep14
     */
    eProsima_user_DllExport const Type14& dep14() const
    {
        return m_dep14;
    }

    /*!
     * @brief This function returns a reference to member dep14
     * @return Reference to member dep14
     */
    eProsima_user_DllExport Type14& dep14()
    {
        return m_dep14;
    }


    /*!
     * @brief This function copies the value in member dep15
     * @param _dep15 New value to be copied in member dep15
     */
    eProsima_user_DllExport void dep15(
            const Type15& _dep15)
    {
        m_dep15 = _dep15;
    }

    /*!
     * @brief This function moves the value in member dep15
     * @param _dep15 New value to be moved in member dep15
     */
    eProsima_user_DllExport void dep15(
            Type15&& _dep15)
    {
        m_dep15 = std::move(_dep15);
    }

    /*!
     * @brief This function returns a constant reference to member dep15
     * @return Constant reference to member dep15
     */
    eProsima_user_DllExport const Type15& dep15() const
    {
        return m_dep15;
    }

    /*!
     * @brief This function returns a reference to member dep15
     * @return Reference to member dep15
     */
    eProsima_user_DllExport Type15& dep15()
    {
        return m_dep15;
    }


    /*!
     * @brief This function copies the value in member dep16
     * @param _dep16 New value to be copied in member dep16
     */
    eProsima_user_DllExport void dep16(
            const Type16& _dep16)
    {
        m_dep16 = _dep16;
    }

    /*!
     * @brief This function moves the value in member dep16
     * @param _dep16 New value to be moved in member dep16
     */
    eProsima_user_DllExport void dep16(
            Type16&& _dep16)
    {
        m_dep16 = std::move(_dep16);
    }

    /*!
     * @brief This function returns a constant reference to member dep16
     * @return Constant reference to member dep16
     */
    eProsima_user_DllExport const Type16& dep16() const
    {
        return m_dep16;
    }

    /*!
     * @brief This function returns a reference to member dep16
     * @return Reference to member dep16
     */
    eProsima_user_DllExport Type16& dep16()
    {
        return m_dep16;
    }


    /*!
     * @brief This function copies the value in member dep17
     * @param _dep17 New value to be copied in member dep17
     */
    eProsima_user_DllExport void dep17(
            const Type17& _dep17)
    {
        m_dep17 = _dep17;
    }

    /*!
     * @brief This function moves the value in member dep17
     * @param _dep17 New value to be moved in member dep17
     */
    eProsima_user_DllExport void dep17(
            Type17&& _dep17)
    {
        m_dep17 = std::move(_dep17);
    }

    /*!
     * @brief This function returns a constant reference to member dep17
     * @return Constant reference to member dep17
     */
    eProsima_user_DllExport const Type17& dep17() const
    {
        return m_dep17;
    }

    /*!
     * @brief This function returns a reference to member dep17
     * @return Reference to member dep17
     */
    eProsima_user_DllExport Type17& dep17()
    {
        return m_dep17;
    }


    /*!
     * @brief This function copies the value in member dep18
     * @param _dep18 New value to be copied in member dep18
     */
    eProsima_user_DllExport void dep18(
            const Type18& _dep18)
    {
        m_dep18 = _dep18;
    }

    /*!
     * @brief This function moves the value in member dep18
     * @param _dep18 New value to be moved in member dep18
     */
    eProsima_user_DllExport void dep18(
            Type18&& _dep18)
    {
        m_dep18 = std::move(_dep18);
    }

    /*!
     * @brief This function returns a constant reference to member dep18
     * @return Constant reference to member dep18
     */
    eProsima_user_DllExport const Type18& dep18() const
    {
        return m_dep18;
    }

    /*!
     * @brief This function returns a reference to member dep18
     * @return Reference to member dep18
     */
    eProsima_user_DllExport Type18& dep18()
    {
        return m_dep18;
    }


    /*!
     * @brief This function copies the value in member dep19
     * @param _dep19 New value to be copied in member dep19
     */
    eProsima_user_DllExport void dep19(
            const Type19& _dep19)
    {
        m_dep19 = _dep19;
    }

    /*!
     * @brief This function moves the value in member dep19
     * @param _dep19 New value to be moved in member dep19
     */
    eProsima_user_DllExport void dep19(
            Type19&& _dep19)
    {
        m_dep19 = std::move(_dep19);
    }

    /*!
     * @brief This function returns a constant reference to member dep19
     * @return Constant reference to member dep19
     */
    eProsima_user_DllExport const Type19& dep19() const
    {
        return m_dep19;
    }

    /*!
     * @brief This function returns a reference to member dep19
     * @return Reference to member dep19
     */
    eProsima_user_DllExport Type19& dep19()
    {
        return m_dep19;
    }


    /*!
     * @brief This function copies the value in member dep20
     * @param _dep20 New value to be copied in member dep20
     */
    eProsima_user_DllExport void dep20(
            const Type20& _dep20)
    {
        m_dep20 = _dep20;
    }

    /*!
     * @brief This function moves the value in member dep20
     * @param _dep20 New value to be moved in member dep20
     */
    eProsima_user_DllExport void dep20(
            Type20&& _dep20)
    {
        m_dep20 = std::move(_dep20);
    }

    /*!
     * @brief This function returns a constant reference to member dep20
     * @return Constant reference to member dep20
     */
    eProsima_user_DllExport const Type20& dep20() const
    {
        return m_dep20;
    }

    /*!
     * @brief This function returns a reference to member dep20
     * @return Reference to member dep20
     */
    eProsima_user_DllExport Type20& dep20()
    {
        return m_dep20;
    }


    /*!
     * @brief This function copies the value in member dep21
     * @param _dep21 New value to be copied in member dep21
     */
    eProsima_user_DllExport void dep21(
            const Type21& _dep21)
    {
        m_dep21 = _dep21;
    }

    /*!
     * @brief This function moves the value in member dep21
     * @param _dep21 New value to be moved in member dep21
     */
    eProsima_user_DllExport void dep21(
            Type21&& _dep21)
    {
        m_dep21 = std::move(_dep21);
    }

    /*!
     * @brief This function returns a constant reference to member dep21
     * @return Constant reference to member dep21
     */
    eProsima_user_DllExport const Type21& dep21() const
    {
        return m_dep21;
    }

    /*!
     * @brief This function returns a reference to member dep21
     * @return Reference to member dep21
     */
    eProsima_user_DllExport Type21& dep21()
    {
        return m_dep21;
    }


    /*!
     * @brief This function copies the value in member dep22
     * @param _dep22 New value to be copied in member dep22
     */
    eProsima_user_DllExport void dep22(
            const Type22& _dep22)
    {
        m_dep22 = _dep22;
    }

    /*!
     * @brief This function moves the value in member dep22
     * @param _dep22 New value to be moved in member dep22
     */
    eProsima_user_DllExport void dep22(
            Type22&& _dep22)
    {
        m_dep22 = std::move(_dep22);
    }

    /*!
     * @brief This function returns a constant reference to member dep22
     * @return Constant reference to member dep22
     */
    eProsima_user_DllExport const Type22& dep22() const
    {
        return m_dep22;
    }

    /*!
     * @brief This function returns a reference to member dep22
     * @return Reference to member dep22
     */
    eProsima_user_DllExport Type22& dep22()
    {
        return m_dep22;
    }


    /*!
     * @brief This function copies the value in member dep23
     * @param _dep23 New value to be copied in member dep23
     */
    eProsima_user_DllExport void dep23(
            const Type23& _dep23)
    {
        m_dep23 = _dep23;
    }

    /*!
     * @brief This function moves the value in member dep23
     * @param _dep23 New value to be moved in member dep23
     */
    eProsima_user_DllExport void dep23(
            Type23&& _dep23)
    {
        m_dep23 = std::move(_dep23);
    }

    /*!
     * @brief This function returns a constant reference to member dep23
     * @return Constant reference to member dep23
     */
    eProsima_user_DllExport const Type23& dep23() const
    {
        return m_dep23;
    }

    /*!
     * @brief This function returns a reference to member dep23
     * @return Reference to member dep23
     */
    eProsima_user_DllExport Type23& dep23()
    {
        return m_dep23;
    }


    /*!
     * @brief This function copies the value in member dep24
     * @param _dep24 New value to be copied in member dep24
     */
    eProsima_user_DllExport void dep24(
            const Type24& _dep24)
    {
        m_dep24 = _dep24;
    }

    /*!
     * @brief This function moves the value in member dep24
     * @param _dep24 New value to be moved in member dep24
     */
    eProsima_user_DllExport void dep24(
            Type24&& _dep24)
    {
        m_dep24 = std::move(_dep24);
    }

    /*!
     * @brief This function returns a constant reference to member dep24
     * @return Constant reference to member dep24
     */
    eProsima_user_DllExport const Type24& dep24() const
    {
        return m_dep24;
    }

    /*!
     * @brief This function returns a reference to member dep24
     * @return Reference to member dep24
     */
    eProsima_user_DllExport Type24& dep24()
    {
        return m_dep24;
    }


    /*!
     * @brief This function copies the value in member dep25
     * @param _dep25 New value to be copied in member dep25
     */
    eProsima_user_DllExport void dep25(
            const Type25& _dep25)
    {
        m_dep25 = _dep25;
    }

    /*!
     * @brief This function moves the value in member dep25
     * @param _dep25 New value to be moved in member dep25
     */
    eProsima_user_DllExport void dep25(
            Type25&& _dep25)
    {
        m_dep25 = std::move(_dep25);
    }

    /*!
     * @brief This function returns a constant reference to member dep25
     * @return Constant reference to member dep25
     */
    eProsima_user_DllExport const Type25& dep25() const
    {
        return m_dep25;
    }

    /*!
     * @brief This function returns a reference to member dep25
     * @return Reference to member dep25
     */
    eProsima_user_DllExport Type25& dep25()
    {
        return m_dep25;
    }


    /*!
     * @brief This function copies the value in member dep26
     * @param _dep26 New value to be copied in member dep26
     */
    eProsima_user_DllExport void dep26(
            const Type26& _dep26)
    {
        m_dep26 = _dep26;
    }

    /*!
     * @brief This function moves the value in member dep26
     * @param _dep26 New value to be moved in member dep26
     */
    eProsima_user_DllExport void dep26(
            Type26&& _dep26)
    {
        m_dep26 = std::move(_dep26);
    }

    /*!
     * @brief This function returns a constant reference to member dep26
     * @return Constant reference to member dep26
     */
    eProsima_user_DllExport const Type26& dep26() const
    {
        return m_dep26;
    }

    /*!
     * @brief This function returns a reference to member dep26
     * @return Reference to member dep26
     */
    eProsima_user_DllExport Type26& dep26()
    {
        return m_dep26;
    }


    /*!
     * @brief This function copies the value in member dep27
     * @param _dep27 New value to be copied in member dep27
     */
    eProsima_user_DllExport void dep27(
            const Type27& _dep27)
    {
        m_dep27 = _dep27;
    }

    /*!
     * @brief This function moves the value in member dep27
     * @param _dep27 New value to be moved in member dep27
     */
    eProsima_user_DllExport void dep27(
            Type27&& _dep27)
    {
        m_dep27 = std::move(_dep27);
    }

    /*!
     * @brief This function returns a constant reference to member dep27
     * @return Constant reference to member dep27
     */
    eProsima_user_DllExport const Type27& dep27() const
    {
        return m_dep27;
    }

    /*!
     * @brief This function returns a reference to member dep27
     * @return Reference to member dep27
     */
    eProsima_user_DllExport Type27& dep27()
    {
        return m_dep27;
    }


    /*!
     * @brief This function copies the value in member dep28
     * @param _dep28 New value to be copied in member dep28
     */
    eProsima_user_DllExport void dep28(
            const Type28& _dep28)
    {
        m_dep28 = _dep28;
    }

    /*!
     * @brief This function moves the value in member dep28
     * @param _dep28 New value to be moved in member dep28
     */
    eProsima_user_DllExport void dep28(
            Type28&& _dep28)
    {
        m_dep28 = std::move(_dep28);
    }

    /*!
     * @brief This function returns a constant reference to member dep28
     * @return Constant reference to member dep28
     */
    eProsima_user_DllExport const Type28& dep28() const
    {
        return m_dep28;
    }

    /*!
     * @brief This function returns a reference to member dep28
     * @return Reference to member dep28
     */
    eProsima_user_DllExport Type28& dep28()
    {
        return m_dep28;
    }


    /*!
     * @brief This function copies the value in member dep29
     * @param _dep29 New value to be copied in member dep29
     */
    eProsima_user_DllExport void dep29(
            const Type29& _dep29)
    {
        m_dep29 = _dep29;
    }

    /*!
     * @brief This function moves the value in member dep29
     * @param _dep29 New value to be moved in member dep29
     */
    eProsima_user_DllExport void dep29(
            Type29&& _dep29)
    {
        m_dep29 = std::move(_dep29);
    }

    /*!
     * @brief This function returns a constant reference to member dep29
     * @return Constant reference to member dep29
     */
    eProsima_user_DllExport const Type29& dep29() const
    {
        return m_dep29;
    }

    /*!
     * @brief This function returns a reference to member dep29
     * @return Reference to member dep29
     */
    eProsima_user_DllExport Type29& dep29()
    {
        return m_dep29;
    }


    /*!
     * @brief This function copies the value in member dep30
     * @param _dep30 New value to be copied in member dep30
     */
    eProsima_user_DllExport void dep30(
            const Type30& _dep30)
    {
        m_dep30 = _dep30;
    }

    /*!
     * @brief This function moves the value in member dep30
     * @param _dep30 New value to be moved in member dep30
     */
    eProsima_user_DllExport void dep30(
            Type30&& _dep30)
    {
        m_dep30 = std::move(_dep30);
    }

    /*!
     * @brief This function returns a constant reference to member dep30
     * @return Constant reference to member dep30
     */
    eProsima_user_DllExport const Type30& dep30() const
    {
        return m_dep30;
    }

    /*!
     * @brief This function returns a reference to member dep30
     * @return Reference to member dep30
     */
    eProsima_user_DllExport Type30& dep30()
    {
        return m_dep30;
    }


    /*!
     * @brief This function copies the value in member dep31
     * @param _dep31 New value to be copied in member dep31
     */
    eProsima_user_DllExport void dep31(
            const Type31& _dep31)
    {
        m_dep31 = _dep31;
    }

    /*!
     * @brief This function moves the value in member dep31
     * @param _dep31 New value to be moved in member dep31
     */
    eProsima_user_DllExport void dep31(
            Type31&& _dep31)
    {
        m_dep31 = std::move(_dep31);
    }

    /*!
     * @brief This function returns a constant reference to member dep31
     * @return Constant reference to member dep31
     */
    eProsima_user_DllExport const Type31& dep31() const
    {
        return m_dep31;
    }

    /*!
     * @brief This function returns a reference to member dep31
     * @return Reference to member dep31
     */
    eProsima_user_DllExport Type31& dep31()
    {
        return m_dep31;
    }


    /*!
     * @brief This function copies the value in member dep32
     * @param _dep32 New value to be copied in member dep32
     */
    eProsima_user_DllExport void dep32(
            const Type32& _dep32)
    {
        m_dep32 = _dep32;
    }

    /*!
     * @brief This function moves the value in member dep32
     * @param _dep32 New value to be moved in member dep32
     */
    eProsima_user_DllExport void dep32(
            Type32&& _dep32)
    {
        m_dep32 = std::move(_dep32);
    }

    /*!
     * @brief This function returns a constant reference to member dep32
     * @return Constant reference to member dep32
     */
    eProsima_user_DllExport const Type32& dep32() const
    {
        return m_dep32;
    }

    /*!
     * @brief This function returns a reference to member dep32
     * @return Reference to member dep32
     */
    eProsima_user_DllExport Type32& dep32()
    {
        return m_dep32;
    }


    /*!
     * @brief This function copies the value in member dep33
     * @param _dep33 New value to be copied in member dep33
     */
    eProsima_user_DllExport void dep33(
            const Type33& _dep33)
    {
        m_dep33 = _dep33;
    }

    /*!
     * @brief This function moves the value in member dep33
     * @param _dep33 New value to be moved in member dep33
     */
    eProsima_user_DllExport void dep33(
            Type33&& _dep33)
    {
        m_dep33 = std::move(_dep33);
    }

    /*!
     * @brief This function returns a constant reference to member dep33
     * @return Constant reference to member dep33
     */
    eProsima_user_DllExport const Type33& dep33() const
    {
        return m_dep33;
    }

    /*!
     * @brief This function returns a reference to member dep33
     * @return Reference to member dep33
     */
    eProsima_user_DllExport Type33& dep33()
    {
        return m_dep33;
    }


    /*!
     * @brief This function copies the value in member dep34
     * @param _dep34 New value to be copied in member dep34
     */
    eProsima_user_DllExport void dep34(
            const Type34& _dep34)
    {
        m_dep34 = _dep34;
    }

    /*!
     * @brief This function moves the value in member dep34
     * @param _dep34 New value to be moved in member dep34
     */
    eProsima_user_DllExport void dep34(
            Type34&& _dep34)
    {
        m_dep34 = std::move(_dep34);
    }

    /*!
     * @brief This function returns a constant reference to member dep34
     * @return Constant reference to member dep34
     */
    eProsima_user_DllExport const Type34& dep34() const
    {
        return m_dep34;
    }

    /*!
     * @brief This function returns a reference to member dep34
     * @return Reference to member dep34
     */
    eProsima_user_DllExport Type34& dep34()
    {
        return m_dep34;
    }


    /*!
     * @brief This function copies the value in member dep35
     * @param _dep35 New value to be copied in member dep35
     */
    eProsima_user_DllExport void dep35(
            const Type35& _dep35)
    {
        m_dep35 = _dep35;
    }

    /*!
     * @brief This function moves the value in member dep35
     * @param _dep35 New value to be moved in member dep35
     */
    eProsima_user_DllExport void dep35(
            Type35&& _dep35)
    {
        m_dep35 = std::move(_dep35);
    }

    /*!
     * @brief This function returns a constant reference to member dep35
     * @return Constant reference to member dep35
     */
    eProsima_user_DllExport const Type35& dep35() const
    {
        return m_dep35;
    }

    /*!
     * @brief This function returns a reference to member dep35
     * @return Reference to member dep35
     */
    eProsima_user_DllExport Type35& dep35()
    {
        return m_dep35;
    }


    /*!
     * @brief This function copies the value in member dep36
     * @param _dep36 New value to be copied in member dep36
     */
    eProsima_user_DllExport void dep36(
            const Type36& _dep36)
    {
        m_dep36 = _dep36;
    }

    /*!
     * @brief This function moves the value in member dep36
     * @param _dep36 New value to be moved in member dep36
     */
    eProsima_user_DllExport void dep36(
            Type36&& _dep36)
    {
        m_dep36 = std::move(_dep36);
    }

    /*!
     * @brief This function returns a constant reference to member dep36
     * @return Constant reference to member dep36
     */
    eProsima_user_DllExport const Type36& dep36() const
    {
        return m_dep36;
    }

    /*!
     * @brief This function returns a reference to member dep36
     * @return Reference to member dep36
     */
    eProsima_user_DllExport Type36& dep36()
    {
        return m_dep36;
    }


    /*!
     * @brief This function copies the value in member dep37
     * @param _dep37 New value to be copied in member dep37
     */
    eProsima_user_DllExport void dep37(
            const Type37& _dep37)
    {
        m_dep37 = _dep37;
    }

    /*!
     * @brief This function moves the value in member dep37
     * @param _dep37 New value to be moved in member dep37
     */
    eProsima_user_DllExport void dep37(
            Type37&& _dep37)
    {
        m_dep37 = std::move(_dep37);
    }

    /*!
     * @brief This function returns a constant reference to member dep37
     * @return Constant reference to member dep37
     */
    eProsima_user_DllExport const Type37& dep37() const
    {
        return m_dep37;
    }

    /*!
     * @brief This function returns a reference to member dep37
     * @return Reference to member dep37
     */
    eProsima_user_DllExport Type37& dep37()
    {
        return m_dep37;
    }


    /*!
     * @brief This function copies the value in member dep38
     * @param _dep38 New value to be copied in member dep38
     */
    eProsima_user_DllExport void dep38(
            const Type38& _dep38)
    {
        m_dep38 = _dep38;
    }

    /*!
     * @brief This function moves the value in member dep38
     * @param _dep38 New value to be moved in member dep38
     */
    eProsima_user_DllExport void dep38(
            Type38&& _dep38)
    {
        m_dep38 = std::move(_dep38);
    }

    /*!
     * @brief This function returns a constant reference to member dep38
     * @return Constant reference to member dep38
     */
    eProsima_user_DllExport const Type38& dep38() const
    {
        return m_dep38;
    }

    /*!
     * @brief This function returns a reference to member dep38
     * @return Reference to member dep38
     */
    eProsima_user_DllExport Type38& dep38()
    {
        return m_dep38;
    }


    /*!
     * @brief This function copies the value in member dep39
     * @param _dep39 New value to be copied in member dep39
     */
    eProsima_user_DllExport void dep39(
            const Type39& _dep39)
    {
        m_dep39 = _dep39;
    }

    /*!
     * @brief This function moves the value in member dep39
     * @param _dep39 New value to be moved in member dep39
     */
    eProsima_user_DllExport void dep39(
            Type39&& _dep39)
    {
        m_dep39 = std::move(_dep39);
    }

    /*!
     * @brief This function returns a constant reference to member dep39
     * @return Constant reference to member dep39
     */
    eProsima_user_DllExport const Type39& dep39() const
    {
        return m_dep39;
    }

    /*!
     * @brief This function returns a reference to member dep39
     * @return Reference to member dep39
     */
    eProsima_user_DllExport Type39& dep39()
    {
        return m_dep39;
    }


    /*!
     * @brief This function copies the value in member dep40
     * @param _dep40 New value to be copied in member dep40
     */
    eProsima_user_DllExport void dep40(
            const Type40& _dep40)
    {
        m_dep40 = _dep40;
    }

    /*!
     * @brief This function moves the value in member dep40
     * @param _dep40 New value to be moved in member dep40
     */
    eProsima_user_DllExport void dep40(
            Type40&& _dep40)
    {
        m_dep40 = std::move(_dep40);
    }

    /*!
     * @brief This function returns a constant reference to member dep40
     * @return Constant reference to member dep40
     */
    eProsima_user_DllExport const Type40& dep40() const
    {
        return m_dep40;
    }

    /*!
     * @brief This function returns a reference to member dep40
     * @return Reference to member dep40
     */
    eProsima_user_DllExport Type40& dep40()
    {
        return m_dep40;
    }


    /*!
     * @brief This function copies the value in member dep41
     * @param _dep41 New value to be copied in member dep41
     */
    eProsima_user_DllExport void dep41(
            const Type41& _dep41)
    {
        m_dep41 = _dep41;
    }

    /*!
     * @brief This function moves the value in member dep41
     * @param _dep41 New value to be moved in member dep41
     */
    eProsima_user_DllExport void dep41(
            Type41&& _dep41)
    {
        m_dep41 = std::move(_dep41);
    }

    /*!
     * @brief This function returns a constant reference to member dep41
     * @return Constant reference to member dep41
     */
    eProsima_user_DllExport const Type41& dep41() const
    {
        return m_dep41;
    }

    /*!
     * @brief This function returns a reference to member dep41
     * @return Reference to member dep41
     */
    eProsima_user_DllExport Type41& dep41()
    {
        return m_dep41;
    }


    /*!
     * @brief This function copies the value in member dep42
     * @param _dep42 New value to be copied in member dep42
     */
    eProsima_user_DllExport void dep42(
            const Type42& _dep42)
    {
        m_dep42 = _dep42;
    }

    /*!
     * @brief This function moves the value in member dep42
     * @param _dep42 New value to be moved in member dep42
     */
    eProsima_user_DllExport void dep42(
            Type42&& _dep42)
    {
        m_dep42 = std::move(_dep42);
    }

    /*!
     * @brief This function returns a constant reference to member dep42
     * @return Constant reference to member dep42
     */
    eProsima_user_DllExport const Type42& dep42() const
    {
        return m_dep42;
    }

    /*!
     * @brief This function returns a reference to member dep42
     * @return Reference to member dep42
     */
    eProsima_user_DllExport Type42& dep42()
    {
        return m_dep42;
    }


    /*!
     * @brief This function copies the value in member dep43
     * @param _dep43 New value to be copied in member dep43
     */
    eProsima_user_DllExport void dep43(
            const Type43& _dep43)
    {
        m_dep43 = _dep43;
    }

    /*!
     * @brief This function moves the value in member dep43
     * @param _dep43 New value to be moved in member dep43
     */
    eProsima_user_DllExport void dep43(
            Type43&& _dep43)
    {
        m_dep43 = std::move(_dep43);
    }

    /*!
     * @brief This function returns a constant reference to member dep43
     * @return Constant reference to member dep43
     */
    eProsima_user_DllExport const Type43& dep43() const
    {
        return m_dep43;
    }

    /*!
     * @brief This function returns a reference to member dep43
     * @return Reference to member dep43
     */
    eProsima_user_DllExport Type43& dep43()
    {
        return m_dep43;
    }


    /*!
     * @brief This function copies the value in member dep44
     * @param _dep44 New value to be copied in member dep44
     */
    eProsima_user_DllExport void dep44(
            const Type44& _dep44)
    {
        m_dep44 = _dep44;
    }

    /*!
     * @brief This function moves the value in member dep44
     * @param _dep44 New value to be moved in member dep44
     */
    eProsima_user_DllExport void dep44(
            Type44&& _dep44)
    {
        m_dep44 = std::move(_dep44);
    }

    /*!
     * @brief This function returns a constant reference to member dep44
     * @return Constant reference to member dep44
     */
    eProsima_user_DllExport const Type44& dep44() const
    {
        return m_dep44;
    }

    /*!
     * @brief This function returns a reference to member dep44
     * @return Reference to member dep44
     */
    eProsima_user_DllExport Type44& dep44()
    {
        return m_dep44;
    }


    /*!
     * @brief This function copies the value in member dep45
     * @param _dep45 New value to be copied in member dep45
     */
    eProsima_user_DllExport void dep45(
            const Type45& _dep45)
    {
        m_dep45 = _dep45;
    }

    /*!
     * @brief This function moves the value in member dep45
     * @param _dep45 New value to be moved in member dep45
     */
    eProsima_user_DllExport void dep45(
            Type45&& _dep45)
    {
        m_dep45 = std::move(_dep45);
    }

    /*!
     * @brief This function returns a constant reference to member dep45
     * @return Constant reference to member dep45
     */
    eProsima_user_DllExport const Type45& dep45() const
    {
        return m_dep45;
    }

    /*!
     * @brief This function returns a reference to member dep45
     * @return Reference to member dep45
     */
    eProsima_user_DllExport Type45& dep45()
    {
        return m_dep45;
    }


    /*!
     * @brief This function copies the value in member dep46
     * @param _dep46 New value to be copied in member dep46
     */
    eProsima_user_DllExport void dep46(
            const Type46& _dep46)
    {
        m_dep46 = _dep46;
    }

    /*!
     * @brief This function moves the value in member dep46
     * @param _dep46 New value to be moved in member dep46
     */
    eProsima_user_DllExport void dep46(
            Type46&& _dep46)
    {
        m_dep46 = std::move(_dep46);
    }

    /*!
     * @brief This function returns a constant reference to member dep46
     * @return Constant reference to member dep46
     */
    eProsima_user_DllExport const Type46& dep46() const
    {
        return m_dep46;
    }

    /*!
     * @brief This function returns a reference to member dep46
     * @return Reference to member dep46
     */
    eProsima_user_DllExport Type46& dep46()
    {
        return m_dep46;
    }


    /*!
     * @brief This function copies the value in member dep47
     * @param _dep47 New value to be copied in member dep47
     */
    eProsima_user_DllExport void dep47(
            const Type47& _dep47)
    {
        m_dep47 = _dep47;
    }

    /*!
     * @brief This function moves the value in member dep47
     * @param _dep47 New value to be moved in member dep47
     */
    eProsima_user_DllExport void dep47(
            Type47&& _dep47)
    {
        m_dep47 = std::move(_dep47);
    }

    /*!
     * @brief This function returns a constant reference to member dep47
     * @return Constant reference to member dep47
     */
    eProsima_user_DllExport const Type47& dep47() const
    {
        return m_dep47;
    }

    /*!
     * @brief This function returns a reference to member dep47
     * @return Reference to member dep47
     */
    eProsima_user_DllExport Type47& dep47()
    {
        return m_dep47;
    }


    /*!
     * @brief This function copies the value in member dep48
     * @param _dep48 New value to be copied in member dep48
     */
    eProsima_user_DllExport void dep48(
            const Type48& _dep48)
    {
        m_dep48 = _dep48;
    }

    /*!
     * @brief This function moves the value in member dep48
     * @param _dep48 New value to be moved in member dep48
     */
    eProsima_user_DllExport void dep48(
            Type48&& _dep48)
    {
        m_dep48 = std::move(_dep48);
    }

    /*!
     * @brief This function returns a constant reference to member dep48
     * @return Constant reference to member dep48
     */
    eProsima_user_DllExport const Type48& dep48() const
    {
        return m_dep48;
    }

    /*!
     * @brief This function returns a reference to member dep48
     * @return Reference to member dep48
     */
    eProsima_user_DllExport Type48& dep48()
    {
        return m_dep48;
    }


    /*!
     * @brief This function copies the value in member dep49
     * @param _dep49 New value to be copied in member dep49
     */
    eProsima_user_DllExport void dep49(
            const Type49& _dep49)
    {
        m_dep49 = _dep49;
    }

    /*!
     * @brief This function moves the value in member dep49
     * @param _dep49 New value to be moved in member dep49
     */
    eProsima_user_DllExport void dep49(
            Type49&& _dep49)
    {
        m_dep49 = std::move(_dep49);
    }

    /*!
     * @brief This function returns a constant reference to member dep49
     * @return Constant reference to member dep49
     */
    eProsima_user_DllExport const Type49& dep49() const
    {
        return m_dep49;
    }

    /*!
     * @brief This function returns a reference to member dep49
     * @return Reference to member dep49
     */
    eProsima_user_DllExport Type49& dep49()
    {
        return m_dep49;
    }


    /*!
     * @brief This function copies the value in member dep50
     * @param _dep50 New value to be copied in member dep50
     */
    eProsima_user_DllExport void dep50(
            const Type50& _dep50)
    {
        m_dep50 = _dep50;
    }

    /*!
     * @brief This function moves the value in member dep50
     * @param _dep50 New value to be moved in member dep50
     */
    eProsima_user_DllExport void dep50(
            Type50&& _dep50)
    {
        m_dep50 = std::move(_dep50);
    }

    /*!
     * @brief This function returns a constant reference to member dep50
     * @return Constant reference to member dep50
     */
    eProsima_user_DllExport const Type50& dep50() const
    {
        return m_dep50;
    }

    /*!
     * @brief This function returns a reference to member dep50
     * @return Reference to member dep50
     */
    eProsima_user_DllExport Type50& dep50()
    {
        return m_dep50;
    }


    /*!
     * @brief This function copies the value in member dep51
     * @param _dep51 New value to be copied in member dep51
     */
    eProsima_user_DllExport void dep51(
            const Type51& _dep51)
    {
        m_dep51 = _dep51;
    }

    /*!
     * @brief This function moves the value in member dep51
     * @param _dep51 New value to be moved in member dep51
     */
    eProsima_user_DllExport void dep51(
            Type51&& _dep51)
    {
        m_dep51 = std::move(_dep51);
    }

    /*!
     * @brief This function returns a constant reference to member dep51
     * @return Constant reference to member dep51
     */
    eProsima_user_DllExport const Type51& dep51() const
    {
        return m_dep51;
    }

    /*!
     * @brief This function returns a reference to member dep51
     * @return Reference to member dep51
     */
    eProsima_user_DllExport Type51& dep51()
    {
        return m_dep51;
    }


    /*!
     * @brief This function copies the value in member dep52
     * @param _dep52 New value to be copied in member dep52
     */
    eProsima_user_DllExport void dep52(
            const Type52& _dep52)
    {
        m_dep52 = _dep52;
    }

    /*!
     * @brief This function moves the value in member dep52
     * @param _dep52 New value to be moved in member dep52
     */
    eProsima_user_DllExport void dep52(
            Type52&& _dep52)
    {
        m_dep52 = std::move(_dep52);
    }

    /*!
     * @brief This function returns a constant reference to member dep52
     * @return Constant reference to member dep52
     */
    eProsima_user_DllExport const Type52& dep52() const
    {
        return m_dep52;
    }

    /*!
     * @brief This function returns a reference to member dep52
     * @return Reference to member dep52
     */
    eProsima_user_DllExport Type52& dep52()
    {
        return m_dep52;
    }


    /*!
     * @brief This function copies the value in member dep53
     * @param _dep53 New value to be copied in member dep53
     */
    eProsima_user_DllExport void dep53(
            const Type53& _dep53)
    {
        m_dep53 = _dep53;
    }

    /*!
     * @brief This function moves the value in member dep53
     * @param _dep53 New value to be moved in member dep53
     */
    eProsima_user_DllExport void dep53(
            Type53&& _dep53)
    {
        m_dep53 = std::move(_dep53);
    }

    /*!
     * @brief This function returns a constant reference to member dep53
     * @return Constant reference to member dep53
     */
    eProsima_user_DllExport const Type53& dep53() const
    {
        return m_dep53;
    }

    /*!
     * @brief This function returns a reference to member dep53
     * @return Reference to member dep53
     */
    eProsima_user_DllExport Type53& dep53()
    {
        return m_dep53;
    }


    /*!
     * @brief This function copies the value in member dep54
     * @param _dep54 New value to be copied in member dep54
     */
    eProsima_user_DllExport void dep54(
            const Type54& _dep54)
    {
        m_dep54 = _dep54;
    }

    /*!
     * @brief This function moves the value in member dep54
     * @param _dep54 New value to be moved in member dep54
     */
    eProsima_user_DllExport void dep54(
            Type54&& _dep54)
    {
        m_dep54 = std::move(_dep54);
    }

    /*!
     * @brief This function returns a constant reference to member dep54
     * @return Constant reference to member dep54
     */
    eProsima_user_DllExport const Type54& dep54() const
    {
        return m_dep54;
    }

    /*!
     * @brief This function returns a reference to member dep54
     * @return Reference to member dep54
     */
    eProsima_user_DllExport Type54& dep54()
    {
        return m_dep54;
    }


    /*!
     * @brief This function copies the value in member dep55
     * @param _dep55 New value to be copied in member dep55
     */
    eProsima_user_DllExport void dep55(
            const Type55& _dep55)
    {
        m_dep55 = _dep55;
    }

    /*!
     * @brief This function moves the value in member dep55
     * @param _dep55 New value to be moved in member dep55
     */
    eProsima_user_DllExport void dep55(
            Type55&& _dep55)
    {
        m_dep55 = std::move(_dep55);
    }

    /*!
     * @brief This function returns a constant reference to member dep55
     * @return Constant reference to member dep55
     */
    eProsima_user_DllExport const Type55& dep55() const
    {
        return m_dep55;
    }

    /*!
     * @brief This function returns a reference to member dep55
     * @return Reference to member dep55
     */
    eProsima_user_DllExport Type55& dep55()
    {
        return m_dep55;
    }


    /*!
     * @brief This function copies the value in member dep56
     * @param _dep56 New value to be copied in member dep56
     */
    eProsima_user_DllExport void dep56(
            const Type56& _dep56)
    {
        m_dep56 = _dep56;
    }

    /*!
     * @brief This function moves the value in member dep56
     * @param _dep56 New value to be moved in member dep56
     */
    eProsima_user_DllExport void dep56(
            Type56&& _dep56)
    {
        m_dep56 = std::move(_dep56);
    }

    /*!
     * @brief This function returns a constant reference to member dep56
     * @return Constant reference to member dep56
     */
    eProsima_user_DllExport const Type56& dep56() const
    {
        return m_dep56;
    }

    /*!
     * @brief This function returns a reference to member dep56
     * @return Reference to member dep56
     */
    eProsima_user_DllExport Type56& dep56()
    {
        return m_dep56;
    }


    /*!
     * @brief This function copies the value in member dep57
     * @param _dep57 New value to be copied in member dep57
     */
    eProsima_user_DllExport void dep57(
            const Type57& _dep57)
    {
        m_dep57 = _dep57;
    }

    /*!
     * @brief This function moves the value in member dep57
     * @param _dep57 New value to be moved in member dep57
     */
    eProsima_user_DllExport void dep57(
            Type57&& _dep57)
    {
        m_dep57 = std::move(_dep57);
    }

    /*!
     * @brief This function returns a constant reference to member dep57
     * @return Constant reference to member dep57
     */
    eProsima_user_DllExport const Type57& dep57() const
    {
        return m_dep57;
    }

    /*!
     * @brief This function returns a reference to member dep57
     * @return Reference to member dep57
     */
    eProsima_user_DllExport Type57& dep57()
    {
        return m_dep57;
    }


    /*!
     * @brief This function copies the value in member dep58
     * @param _dep58 New value to be copied in member dep58
     */
    eProsima_user_DllExport void dep58(
            const Type58& _dep58)
    {
        m_dep58 = _dep58;
    }

    /*!
     * @brief This function moves the value in member dep58
     * @param _dep58 New value to be moved in member dep58
     */
    eProsima_user_DllExport void dep58(
            Type58&& _dep58)
    {
        m_dep58 = std::move(_dep58);
    }

    /*!
     * @brief This function returns a constant reference to member dep58
     * @return Constant reference to member dep58
     */
    eProsima_user_DllExport const Type58& dep58() const
    {
        return m_dep58;
    }

    /*!
     * @brief This function returns a reference to member dep58
     * @return Reference to member dep58
     */
    eProsima_user_DllExport Type58& dep58()
    {
        return m_dep58;
    }


    /*!
     * @brief This function copies the value in member dep59
     * @param _dep59 New value to be copied in member dep59
     */
    eProsima_user_DllExport void dep59(
            const Type59& _dep59)
    {
        m_dep59 = _dep59;
    }

    /*!
     * @brief This function moves the value in member dep59
     * @param _dep59 New value to be moved in member dep59
     */
    eProsima_user_DllExport void dep59(
            Type59&& _dep59)
    {
        m_dep59 = std::move(_dep59);
    }

    /*!
     * @brief This function returns a constant reference to member dep59
     * @return Constant reference to member dep59
     */
    eProsima_user_DllExport const Type59& dep59() const
    {
        return m_dep59;
    }

    /*!
     * @brief This function returns a reference to member dep59
     * @return Reference to member dep59
     */
    eProsima_user_DllExport Type59& dep59()
    {
        return m_dep59;
    }


    /*!
     * @brief This function copies the value in member dep60
     * @param _dep60 New value to be copied in member dep60
     */
    eProsima_user_DllExport void dep60(
            const Type60& _dep60)
    {
        m_dep60 = _dep60;
    }

    /*!
     * @brief This function moves the value in member dep60
     * @param _dep60 New value to be moved in member dep60
     */
    eProsima_user_DllExport void dep60(
            Type60&& _dep60)
    {
        m_dep60 = std::move(_dep60);
    }

    /*!
     * @brief This function returns a constant reference to member dep60
     * @return Constant reference to member dep60
     */
    eProsima_user_DllExport const Type60& dep60() const
    {
        return m_dep60;
    }

    /*!
     * @brief This function returns a reference to member dep60
     * @return Reference to member dep60
     */
    eProsima_user_DllExport Type60& dep60()
    {
        return m_dep60;
    }


    /*!
     * @brief This function copies the value in member dep61
     * @param _dep61 New value to be copied in member dep61
     */
    eProsima_user_DllExport void dep61(
            const Type61& _dep61)
    {
        m_dep61 = _dep61;
    }

    /*!
     * @brief This function moves the value in member dep61
     * @param _dep61 New value to be moved in member dep61
     */
    eProsima_user_DllExport void dep61(
            Type61&& _dep61)
    {
        m_dep61 = std::move(_dep61);
    }

    /*!
     * @brief This function returns a constant reference to member dep61
     * @return Constant reference to member dep61
     */
    eProsima_user_DllExport const Type61& dep61() const
    {
        return m_dep61;
    }

    /*!
     * @brief This function returns a reference to member dep61
     * @return Reference to member dep61
     */
    eProsima_user_DllExport Type61& dep61()
    {
        return m_dep61;
    }


    /*!
     * @brief This function copies the value in member dep62
     * @param _dep62 New value to be copied in member dep62
     */
    eProsima_user_DllExport void dep62(
            const Type62& _dep62)
    {
        m_dep62 = _dep62;
    }

    /*!
     * @brief This function moves the value in member dep62
     * @param _dep62 New value to be moved in member dep62
     */
    eProsima_user_DllExport void dep62(
            Type62&& _dep62)
    {
        m_dep62 = std::move(_dep62);
    }

    /*!
     * @brief This function returns a constant reference to member dep62
     * @return Constant reference to member dep62
     */
    eProsima_user_DllExport const Type62& dep62() const
    {
        return m_dep62;
    }

    /*!
     * @brief This function returns a reference to member dep62
     * @return Reference to member dep62
     */
    eProsima_user_DllExport Type62& dep62()
    {
        return m_dep62;
    }


    /*!
     * @brief This function copies the value in member dep63
     * @param _dep63 New value to be copied in member dep63
     */
    eProsima_user_DllExport void dep63(
            const Type63& _dep63)
    {
        m_dep63 = _dep63;
    }

    /*!
     * @brief This function moves the value in member dep63
     * @param _dep63 New value to be moved in member dep63
     */
    eProsima_user_DllExport void dep63(
            Type63&& _dep63)
    {
        m_dep63 = std::move(_dep63);
    }

    /*!
     * @brief This function returns a constant reference to member dep63
     * @return Constant reference to member dep63
     */
    eProsima_user_DllExport const Type63& dep63() const
    {
        return m_dep63;
    }

    /*!
     * @brief This function returns a reference to member dep63
     * @return Reference to member dep63
     */
    eProsima_user_DllExport Type63& dep63()
    {
        return m_dep63;
    }


    /*!
     * @brief This function copies the value in member dep64
     * @param _dep64 New value to be copied in member dep64
     */
    eProsima_user_DllExport void dep64(
            const Type64& _dep64)
    {
        m_dep64 = _dep64;
    }

    /*!
     * @brief This function moves the value in member dep64
     * @param _dep64 New value to be moved in member dep64
     */
    eProsima_user_DllExport void dep64(
            Type64&& _dep64)
    {
        m_dep64 = std::move(_dep64);
    }

    /*!
     * @brief This function returns a constant reference to member dep64
     * @return Constant reference to member dep64
     */
    eProsima_user_DllExport const Type64& dep64() const
    {
        return m_dep64;
    }

    /*!
     * @brief This function returns a reference to member dep64
     * @return Reference to member dep64
     */
    eProsima_user_DllExport Type64& dep64()
    {
        return m_dep64;
    }


    /*!
     * @brief This function copies the value in member dep65
     * @param _dep65 New value to be copied in member dep65
     */
    eProsima_user_DllExport void dep65(
            const Type65& _dep65)
    {
        m_dep65 = _dep65;
    }

    /*!
     * @brief This function moves the value in member dep65
     * @param _dep65 New value to be moved in member dep65
     */
    eProsima_user_DllExport void dep65(
            Type65&& _dep65)
    {
        m_dep65 = std::move(_dep65);
    }

    /*!
     * @brief This function returns a constant reference to member dep65
     * @return Constant reference to member dep65
     */
    eProsima_user_DllExport const Type65& dep65() const
    {
        return m_dep65;
    }

    /*!
     * @brief This function returns a reference to member dep65
     * @return Reference to member dep65
     */
    eProsima_user_DllExport Type65& dep65()
    {
        return m_dep65;
    }


    /*!
     * @brief This function copies the value in member dep66
     * @param _dep66 New value to be copied in member dep66
     */
    eProsima_user_DllExport void dep66(
            const Type66& _dep66)
    {
        m_dep66 = _dep66;
    }

    /*!
     * @brief This function moves the value in member dep66
     * @param _dep66 New value to be moved in member dep66
     */
    eProsima_user_DllExport void dep66(
            Type66&& _dep66)
    {
        m_dep66 = std::move(_dep66);
    }

    /*!
     * @brief This function returns a constant reference to member dep66
     * @return Constant reference to member dep66
     */
    eProsima_user_DllExport const Type66& dep66() const
    {
        return m_dep66;
    }

    /*!
     * @brief This function returns a reference to member dep66
     * @return Reference to member dep66
     */
    eProsima_user_DllExport Type66& dep66()
    {
        return m_dep66;
    }


    /*!
     * @brief This function copies the value in member dep67
     * @param _dep67 New value to be copied in member dep67
     */
    eProsima_user_DllExport void dep67(
            const Type67& _dep67)
    {
        m_dep67 = _dep67;
    }

    /*!
     * @brief This function moves the value in member dep67
     * @param _dep67 New value to be moved in member dep67
     */
    eProsima_user_DllExport void dep67(
            Type67&& _dep67)
    {
        m_dep67 = std::move(_dep67);
    }

    /*!
     * @brief This function returns a constant reference to member dep67
     * @return Constant reference to member dep67
     */
    eProsima_user_DllExport const Type67& dep67() const
    {
        return m_dep67;
    }

    /*!
     * @brief This function returns a reference to member dep67
     * @return Reference to member dep67
     */
    eProsima_user_DllExport Type67& dep67()
    {
        return m_dep67;
    }


    /*!
     * @brief This function copies the value in member dep68
     * @param _dep68 New value to be copied in member dep68
     */
    eProsima_user_DllExport void dep68(
            const Type68& _dep68)
    {
        m_dep68 = _dep68;
    }

    /*!
     * @brief This function moves the value in member dep68
     * @param _dep68 New value to be moved in member dep68
     */
    eProsima_user_DllExport void dep68(
            Type68&& _dep68)
    {
        m_dep68 = std::move(_dep68);
    }

    /*!
     * @brief This function returns a constant reference to member dep68
     * @return Constant reference to member dep68
     */
    eProsima_user_DllExport const Type68& dep68() const
    {
        return m_dep68;
    }

    /*!
     * @brief This function returns a reference to member dep68
     * @return Reference to member dep68
     */
    eProsima_user_DllExport Type68& dep68()
    {
        return m_dep68;
    }


    /*!
     * @brief This function copies the value in member dep69
     * @param _dep69 New value to be copied in member dep69
     */
    eProsima_user_DllExport void dep69(
            const Type69& _dep69)
    {
        m_dep69 = _dep69;
    }

    /*!
     * @brief This function moves the value in member dep69
     * @param _dep69 New value to be moved in member dep69
     */
    eProsima_user_DllExport void dep69(
            Type69&& _dep69)
    {
        m_dep69 = std::move(_dep69);
    }

    /*!
     * @brief This function returns a constant reference to member dep69
     * @return Constant reference to member dep69
     */
    eProsima_user_DllExport const Type69& dep69() const
    {
        return m_dep69;
    }

    /*!
     * @brief This function returns a reference to member dep69
     * @return Reference to member dep69
     */
    eProsima_user_DllExport Type69& dep69()
    {
        return m_dep69;
    }


    /*!
     * @brief This function copies the value in member dep70
     * @param _dep70 New value to be copied in member dep70
     */
    eProsima_user_DllExport void dep70(
            const Type70& _dep70)
    {
        m_dep70 = _dep70;
    }

    /*!
     * @brief This function moves the value in member dep70
     * @param _dep70 New value to be moved in member dep70
     */
    eProsima_user_DllExport void dep70(
            Type70&& _dep70)
    {
        m_dep70 = std::move(_dep70);
    }

    /*!
     * @brief This function returns a constant reference to member dep70
     * @return Constant reference to member dep70
     */
    eProsima_user_DllExport const Type70& dep70() const
    {
        return m_dep70;
    }

    /*!
     * @brief This function returns a reference to member dep70
     * @return Reference to member dep70
     */
    eProsima_user_DllExport Type70& dep70()
    {
        return m_dep70;
    }


    /*!
     * @brief This function copies the value in member dep71
     * @param _dep71 New value to be copied in member dep71
     */
    eProsima_user_DllExport void dep71(
            const Type71& _dep71)
    {
        m_dep71 = _dep71;
    }

    /*!
     * @brief This function moves the value in member dep71
     * @param _dep71 New value to be moved in member dep71
     */
    eProsima_user_DllExport void dep71(
            Type71&& _dep71)
    {
        m_dep71 = std::move(_dep71);
    }

    /*!
     * @brief This function returns a constant reference to member dep71
     * @return Constant reference to member dep71
     */
    eProsima_user_DllExport const Type71& dep71() const
    {
        return m_dep71;
    }

    /*!
     * @brief This function returns a reference to member dep71
     * @return Reference to member dep71
     */
    eProsima_user_DllExport Type71& dep71()
    {
        return m_dep71;
    }


    /*!
     * @brief This function copies the value in member dep72
     * @param _dep72 New value to be copied in member dep72
     */
    eProsima_user_DllExport void dep72(
            const Type72& _dep72)
    {
        m_dep72 = _dep72;
    }

    /*!
     * @brief This function moves the value in member dep72
     * @param _dep72 New value to be moved in member dep72
     */
    eProsima_user_DllExport void dep72(
            Type72&& _dep72)
    {
        m_dep72 = std::move(_dep72);
    }

    /*!
     * @brief This function returns a constant reference to member dep72
     * @return Constant reference to member dep72
     */
    eProsima_user_DllExport const Type72& dep72() const
    {
        return m_dep72;
    }

    /*!
     * @brief This function returns a reference to member dep72
     * @return Reference to member dep72
     */
    eProsima_user_DllExport Type72& dep72()
    {
        return m_dep72;
    }


    /*!
     * @brief This function copies the value in member dep73
     * @param _dep73 New value to be copied in member dep73
     */
    eProsima_user_DllExport void dep73(
            const Type73& _dep73)
    {
        m_dep73 = _dep73;
    }

    /*!
     * @brief This function moves the value in member dep73
     * @param _dep73 New value to be moved in member dep73
     */
    eProsima_user_DllExport void dep73(
            Type73&& _dep73)
    {
        m_dep73 = std::move(_dep73);
    }

    /*!
     * @brief This function returns a constant reference to member dep73
     * @return Constant reference to member dep73
     */
    eProsima_user_DllExport const Type73& dep73() const
    {
        return m_dep73;
    }

    /*!
     * @brief This function returns a reference to member dep73
     * @return Reference to member dep73
     */
    eProsima_user_DllExport Type73& dep73()
    {
        return m_dep73;
    }


    /*!
     * @brief This function copies the value in member dep74
     * @param _dep74 New value to be copied in member dep74
     */
    eProsima_user_DllExport void dep74(
            const Type74& _dep74)
    {
        m_dep74 = _dep74;
    }

    /*!
     * @brief This function moves the value in member dep74
     * @param _dep74 New value to be moved in member dep74
     */
    eProsima_user_DllExport void dep74(
            Type74&& _dep74)
    {
        m_dep74 = std::move(_dep74);
    }

    /*!
     * @brief This function returns a constant reference to member dep74
     * @return Constant reference to member dep74
     */
    eProsima_user_DllExport const Type74& dep74() const
    {
        return m_dep74;
    }

    /*!
     * @brief This function returns a reference to member dep74
     * @return Reference to member dep74
     */
    eProsima_user_DllExport Type74& dep74()
    {
        return m_dep74;
    }


    /*!
     * @brief This function copies the value in member dep75
     * @param _dep75 New value to be copied in member dep75
     */
    eProsima_user_DllExport void dep75(
            const Type75& _dep75)
    {
        m_dep75 = _dep75;
    }

    /*!
     * @brief This function moves the value in member dep75
     * @param _dep75 New value to be moved in member dep75
     */
    eProsima_user_DllExport void dep75(
            Type75&& _dep75)
    {
        m_dep75 = std::move(_dep75);
    }

    /*!
     * @brief This function returns a constant reference to member dep75
     * @return Constant reference to member dep75
     */
    eProsima_user_DllExport const Type75& dep75() const
    {
        return m_dep75;
    }

    /*!
     * @brief This function returns a reference to member dep75
     * @return Reference to member dep75
     */
    eProsima_user_DllExport Type75& dep75()
    {
        return m_dep75;
    }


    /*!
     * @brief This function copies the value in member dep76
     * @param _dep76 New value to be copied in member dep76
     */
    eProsima_user_DllExport void dep76(
            const Type76& _dep76)
    {
        m_dep76 = _dep76;
    }

    /*!
     * @brief This function moves the value in member dep76
     * @param _dep76 New value to be moved in member dep76
     */
    eProsima_user_DllExport void dep76(
            Type76&& _dep76)
    {
        m_dep76 = std::move(_dep76);
    }

    /*!
     * @brief This function returns a constant reference to member dep76
     * @return Constant reference to member dep76
     */
    eProsima_user_DllExport const Type76& dep76() const
    {
        return m_dep76;
    }

    /*!
     * @brief This function returns a reference to member dep76
     * @return Reference to member dep76
     */
    eProsima_user_DllExport Type76& dep76()
    {
        return m_dep76;
    }


    /*!
     * @brief This function copies the value in member dep77
     * @param _dep77 New value to be copied in member dep77
     */
    eProsima_user_DllExport void dep77(
            const Type77& _dep77)
    {
        m_dep77 = _dep77;
    }

    /*!
     * @brief This function moves the value in member dep77
     * @param _dep77 New value to be moved in member dep77
     */
    eProsima_user_DllExport void dep77(
            Type77&& _dep77)
    {
        m_dep77 = std::move(_dep77);
    }

    /*!
     * @brief This function returns a constant reference to member dep77
     * @return Constant reference to member dep77
     */
    eProsima_user_DllExport const Type77& dep77() const
    {
        return m_dep77;
    }

    /*!
     * @brief This function returns a reference to member dep77
     * @return Reference to member dep77
     */
    eProsima_user_DllExport Type77& dep77()
    {
        return m_dep77;
    }


    /*!
     * @brief This function copies the value in member dep78
     * @param _dep78 New value to be copied in member dep78
     */
    eProsima_user_DllExport void dep78(
            const Type78& _dep78)
    {
        m_dep78 = _dep78;
    }

    /*!
     * @brief This function moves the value in member dep78
     * @param _dep78 New value to be moved in member dep78
     */
    eProsima_user_DllExport void dep78(
            Type78&& _dep78)
    {
        m_dep78 = std::move(_dep78);
    }

    /*!
     * @brief This function returns a constant reference to member dep78
     * @return Constant reference to member dep78
     */
    eProsima_user_DllExport const Type78& dep78() const
    {
        return m_dep78;
    }

    /*!
     * @brief This function returns a reference to member dep78
     * @return Reference to member dep78
     */
    eProsima_user_DllExport Type78& dep78()
    {
        return m_dep78;
    }


    /*!
     * @brief This function copies the value in member dep79
     * @param _dep79 New value to be copied in member dep79
     */
    eProsima_user_DllExport void dep79(
            const Type79& _dep79)
    {
        m_dep79 = _dep79;
    }

    /*!
     * @brief This function moves the value in member dep79
     * @param _dep79 New value to be moved in member dep79
     */
    eProsima_user_DllExport void dep79(
            Type79&& _dep79)
    {
        m_dep79 = std::move(_dep79);
    }

    /*!
     * @brief This function returns a constant reference to member dep79
     * @return Constant reference to member dep79
     */
    eProsima_user_DllExport const Type79& dep79() const
    {
        return m_dep79;
    }

    /*!
     * @brief This function returns a reference to member dep79
     * @return Reference to member dep79
     */
    eProsima_user_DllExport Type79& dep79()
    {
        return m_dep79;
    }


    /*!
     * @brief This function copies the value in member dep80
     * @param _dep80 New value to be copied in member dep80
     */
    eProsima_user_DllExport void dep80(
            const Type80& _dep80)
    {
        m_dep80 = _dep80;
    }

    /*!
     * @brief This function moves the value in member dep80
     * @param _dep80 New value to be moved in member dep80
     */
    eProsima_user_DllExport void dep80(
            Type80&& _dep80)
    {
        m_dep80 = std::move(_dep80);
    }

    /*!
     * @brief This function returns a constant reference to member dep80
     * @return Constant reference to member dep80
     */
    eProsima_user_DllExport const Type80& dep80() const
    {
        return m_dep80;
    }

    /*!
     * @brief This function returns a reference to member dep80
     * @return Reference to member dep80
     */
    eProsima_user_DllExport Type80& dep80()
    {
        return m_dep80;
    }


    /*!
     * @brief This function copies the value in member dep81
     * @param _dep81 New value to be copied in member dep81
     */
    eProsima_user_DllExport void dep81(
            const Type81& _dep81)
    {
        m_dep81 = _dep81;
    }

    /*!
     * @brief This function moves the value in member dep81
     * @param _dep81 New value to be moved in member dep81
     */
    eProsima_user_DllExport void dep81(
            Type81&& _dep81)
    {
        m_dep81 = std::move(_dep81);
    }

    /*!
     * @brief This function returns a constant reference to member dep81
     * @return Constant reference to member dep81
     */
    eProsima_user_DllExport const Type81& dep81() const
    {
        return m_dep81;
    }

    /*!
     * @brief This function returns a reference to member dep81
     * @return Reference to member dep81
     */
    eProsima_user_DllExport Type81& dep81()
    {
        return m_dep81;
    }


    /*!
     * @brief This function copies the value in member dep82
     * @param _dep82 New value to be copied in member dep82
     */
    eProsima_user_DllExport void dep82(
            const Type82& _dep82)
    {
        m_dep82 = _dep82;
    }

    /*!
     * @brief This function moves the value in member dep82
     * @param _dep82 New value to be moved in member dep82
     */
    eProsima_user_DllExport void dep82(
            Type82&& _dep82)
    {
        m_dep82 = std::move(_dep82);
    }

    /*!
     * @brief This function returns a constant reference to member dep82
     * @return Constant reference to member dep82
     */
    eProsima_user_DllExport const Type82& dep82() const
    {
        return m_dep82;
    }

    /*!
     * @brief This function returns a reference to member dep82
     * @return Reference to member dep82
     */
    eProsima_user_DllExport Type82& dep82()
    {
        return m_dep82;
    }


    /*!
     * @brief This function copies the value in member dep83
     * @param _dep83 New value to be copied in member dep83
     */
    eProsima_user_DllExport void dep83(
            const Type83& _dep83)
    {
        m_dep83 = _dep83;
    }

    /*!
     * @brief This function moves the value in member dep83
     * @param _dep83 New value to be moved in member dep83
     */
    eProsima_user_DllExport void dep83(
            Type83&& _dep83)
    {
        m_dep83 = std::move(_dep83);
    }

    /*!
     * @brief This function returns a constant reference to member dep83
     * @return Constant reference to member dep83
     */
    eProsima_user_DllExport const Type83& dep83() const
    {
        return m_dep83;
    }

    /*!
     * @brief This function returns a reference to member dep83
     * @return Reference to member dep83
     */
    eProsima_user_DllExport Type83& dep83()
    {
        return m_dep83;
    }


    /*!
     * @brief This function copies the value in member dep84
     * @param _dep84 New value to be copied in member dep84
     */
    eProsima_user_DllExport void dep84(
            const Type84& _dep84)
    {
        m_dep84 = _dep84;
    }

    /*!
     * @brief This function moves the value in member dep84
     * @param _dep84 New value to be moved in member dep84
     */
    eProsima_user_DllExport void dep84(
            Type84&& _dep84)
    {
        m_dep84 = std::move(_dep84);
    }

    /*!
     * @brief This function returns a constant reference to member dep84
     * @return Constant reference to member dep84
     */
    eProsima_user_DllExport const Type84& dep84() const
    {
        return m_dep84;
    }

    /*!
     * @brief This function returns a reference to member dep84
     * @return Reference to member dep84
     */
    eProsima_user_DllExport Type84& dep84()
    {
        return m_dep84;
    }


    /*!
     * @brief This function copies the value in member dep85
     * @param _dep85 New value to be copied in member dep85
     */
    eProsima_user_DllExport void dep85(
            const Type85& _dep85)
    {
        m_dep85 = _dep85;
    }

    /*!
     * @brief This function moves the value in member dep85
     * @param _dep85 New value to be moved in member dep85
     */
    eProsima_user_DllExport void dep85(
            Type85&& _dep85)
    {
        m_dep85 = std::move(_dep85);
    }

    /*!
     * @brief This function returns a constant reference to member dep85
     * @return Constant reference to member dep85
     */
    eProsima_user_DllExport const Type85& dep85() const
    {
        return m_dep85;
    }

    /*!
     * @brief This function returns a reference to member dep85
     * @return Reference to member dep85
     */
    eProsima_user_DllExport Type85& dep85()
    {
        return m_dep85;
    }


    /*!
     * @brief This function copies the value in member dep86
     * @param _dep86 New value to be copied in member dep86
     */
    eProsima_user_DllExport void dep86(
            const Type86& _dep86)
    {
        m_dep86 = _dep86;
    }

    /*!
     * @brief This function moves the value in member dep86
     * @param _dep86 New value to be moved in member dep86
     */
    eProsima_user_DllExport void dep86(
            Type86&& _dep86)
    {
        m_dep86 = std::move(_dep86);
    }

    /*!
     * @brief This function returns a constant reference to member dep86
     * @return Constant reference to member dep86
     */
    eProsima_user_DllExport const Type86& dep86() const
    {
        return m_dep86;
    }

    /*!
     * @brief This function returns a reference to member dep86
     * @return Reference to member dep86
     */
    eProsima_user_DllExport Type86& dep86()
    {
        return m_dep86;
    }


    /*!
     * @brief This function copies the value in member dep87
     * @param _dep87 New value to be copied in member dep87
     */
    eProsima_user_DllExport void dep87(
            const Type87& _dep87)
    {
        m_dep87 = _dep87;
    }

    /*!
     * @brief This function moves the value in member dep87
     * @param _dep87 New value to be moved in member dep87
     */
    eProsima_user_DllExport void dep87(
            Type87&& _dep87)
    {
        m_dep87 = std::move(_dep87);
    }

    /*!
     * @brief This function returns a constant reference to member dep87
     * @return Constant reference to member dep87
     */
    eProsima_user_DllExport const Type87& dep87() const
    {
        return m_dep87;
    }

    /*!
     * @brief This function returns a reference to member dep87
     * @return Reference to member dep87
     */
    eProsima_user_DllExport Type87& dep87()
    {
        return m_dep87;
    }


    /*!
     * @brief This function copies the value in member dep88
     * @param _dep88 New value to be copied in member dep88
     */
    eProsima_user_DllExport void dep88(
            const Type88& _dep88)
    {
        m_dep88 = _dep88;
    }

    /*!
     * @brief This function moves the value in member dep88
     * @param _dep88 New value to be moved in member dep88
     */
    eProsima_user_DllExport void dep88(
            Type88&& _dep88)
    {
        m_dep88 = std::move(_dep88);
    }

    /*!
     * @brief This function returns a constant reference to member dep88
     * @return Constant reference to member dep88
     */
    eProsima_user_DllExport const Type88& dep88() const
    {
        return m_dep88;
    }

    /*!
     * @brief This function returns a reference to member dep88
     * @return Reference to member dep88
     */
    eProsima_user_DllExport Type88& dep88()
    {
        return m_dep88;
    }


    /*!
     * @brief This function copies the value in member dep89
     * @param _dep89 New value to be copied in member dep89
     */
    eProsima_user_DllExport void dep89(
            const Type89& _dep89)
    {
        m_dep89 = _dep89;
    }

    /*!
     * @brief This function moves the value in member dep89
     * @param _dep89 New value to be moved in member dep89
     */
    eProsima_user_DllExport void dep89(
            Type89&& _dep89)
    {
        m_dep89 = std::move(_dep89);
    }

    /*!
     * @brief This function returns a constant reference to member dep89
     * @return Constant reference to member dep89
     */
    eProsima_user_DllExport const Type89& dep89() const
    {
        return m_dep89;
    }

    /*!
     * @brief This function returns a reference to member dep89
     * @return Reference to member dep89
     */
    eProsima_user_DllExport Type89& dep89()
    {
        return m_dep89;
    }


    /*!
     * @brief This function copies the value in member dep90
     * @param _dep90 New value to be copied in member dep90
     */
    eProsima_user_DllExport void dep90(
            const Type90& _dep90)
    {
        m_dep90 = _dep90;
    }

    /*!
     * @brief This function moves the value in member dep90
     * @param _dep90 New value to be moved in member dep90
     */
    eProsima_user_DllExport void dep90(
            Type90&& _dep90)
    {
        m_dep90 = std::move(_dep90);
    }

    /*!
     * @brief This function returns a constant reference to member dep90
     * @return Constant reference to member dep90
     */
    eProsima_user_DllExport const Type90& dep90() const
    {
        return m_dep90;
    }

    /*!
     * @brief This function returns a reference to member dep90
     * @return Reference to member dep90
     */
    eProsima_user_DllExport Type90& dep90()
    {
        return m_dep90;
    }


    /*!
     * @brief This function copies the value in member dep91
     * @param _dep91 New value to be copied in member dep91
     */
    eProsima_user_DllExport void dep91(
            const Type91& _dep91)
    {
        m_dep91 = _dep91;
    }

    /*!
     * @brief This function moves the value in member dep91
     * @param _dep91 New value to be moved in member dep91
     */
    eProsima_user_DllExport void dep91(
            Type91&& _dep91)
    {
        m_dep91 = std::move(_dep91);
    }

    /*!
     * @brief This function returns a constant reference to member dep91
     * @return Constant reference to member dep91
     */
    eProsima_user_DllExport const Type91& dep91() const
    {
        return m_dep91;
    }

    /*!
     * @brief This function returns a reference to member dep91
     * @return Reference to member dep91
     */
    eProsima_user_DllExport Type91& dep91()
    {
        return m_dep91;
    }


    /*!
     * @brief This function copies the value in member dep92
     * @param _dep92 New value to be copied in member dep92
     */
    eProsima_user_DllExport void dep92(
            const Type92& _dep92)
    {
        m_dep92 = _dep92;
    }

    /*!
     * @brief This function moves the value in member dep92
     * @param _dep92 New value to be moved in member dep92
     */
    eProsima_user_DllExport void dep92(
            Type92&& _dep92)
    {
        m_dep92 = std::move(_dep92);
    }

    /*!
     * @brief This function returns a constant reference to member dep92
     * @return Constant reference to member dep92
     */
    eProsima_user_DllExport const Type92& dep92() const
    {
        return m_dep92;
    }

    /*!
     * @brief This function returns a reference to member dep92
     * @return Reference to member dep92
     */
    eProsima_user_DllExport Type92& dep92()
    {
        return m_dep92;
    }


    /*!
     * @brief This function copies the value in member dep93
     * @param _dep93 New value to be copied in member dep93
     */
    eProsima_user_DllExport void dep93(
            const Type93& _dep93)
    {
        m_dep93 = _dep93;
    }

    /*!
     * @brief This function moves the value in member dep93
     * @param _dep93 New value to be moved in member dep93
     */
    eProsima_user_DllExport void dep93(
            Type93&& _dep93)
    {
        m_dep93 = std::move(_dep93);
    }

    /*!
     * @brief This function returns a constant reference to member dep93
     * @return Constant reference to member dep93
     */
    eProsima_user_DllExport const Type93& dep93() const
    {
        return m_dep93;
    }

    /*!
     * @brief This function returns a reference to member dep93
     * @return Reference to member dep93
     */
    eProsima_user_DllExport Type93& dep93()
    {
        return m_dep93;
    }


    /*!
     * @brief This function copies the value in member dep94
     * @param _dep94 New value to be copied in member dep94
     */
    eProsima_user_DllExport void dep94(
            const Type94& _dep94)
    {
        m_dep94 = _dep94;
    }

    /*!
     * @brief This function moves the value in member dep94
     * @param _dep94 New value to be moved in member dep94
     */
    eProsima_user_DllExport void dep94(
            Type94&& _dep94)
    {
        m_dep94 = std::move(_dep94);
    }

    /*!
     * @brief This function returns a constant reference to member dep94
     * @return Constant reference to member dep94
     */
    eProsima_user_DllExport const Type94& dep94() const
    {
        return m_dep94;
    }

    /*!
     * @brief This function returns a reference to member dep94
     * @return Reference to member dep94
     */
    eProsima_user_DllExport Type94& dep94()
    {
        return m_dep94;
    }


    /*!
     * @brief This function copies the value in member dep95
     * @param _dep95 New value to be copied in member dep95
     */
    eProsima_user_DllExport void dep95(
            const Type95& _dep95)
    {
        m_dep95 = _dep95;
    }

    /*!
     * @brief This function moves the value in member dep95
     * @param _dep95 New value to be moved in member dep95
     */
    eProsima_user_DllExport void dep95(
            Type95&& _dep95)
    {
        m_dep95 = std::move(_dep95);
    }

    /*!
     * @brief This function returns a constant reference to member dep95
     * @return Constant reference to member dep95
     */
    eProsima_user_DllExport const Type95& dep95() const
    {
        return m_dep95;
    }

    /*!
     * @brief This function returns a reference to member dep95
     * @return Reference to member dep95
     */
    eProsima_user_DllExport Type95& dep95()
    {
        return m_dep95;
    }


    /*!
     * @brief This function copies the value in member dep96
     * @param _dep96 New value to be copied in member dep96
     */
    eProsima_user_DllExport void dep96(
            const Type96& _dep96)
    {
        m_dep96 = _dep96;
    }

    /*!
     * @brief This function moves the value in member dep96
     * @param _dep96 New value to be moved in member dep96
     */
    eProsima_user_DllExport void dep96(
            Type96&& _dep96)
    {
        m_dep96 = std::move(_dep96);
    }

    /*!
     * @brief This function returns a constant reference to member dep96
     * @return Constant reference to member dep96
     */
    eProsima_user_DllExport const Type96& dep96() const
    {
        return m_dep96;
    }

    /*!
     * @brief This function returns a reference to member dep96
     * @return Reference to member dep96
     */
    eProsima_user_DllExport Type96& dep96()
    {
        return m_dep96;
    }


    /*!
     * @brief This function copies the value in member dep97
     * @param _dep97 New value to be copied in member dep97
     */
    eProsima_user_DllExport void dep97(
            const Type97& _dep97)
    {
        m_dep97 = _dep97;
    }

    /*!
     * @brief This function moves the value in member dep97
     * @param _dep97 New value to be moved in member dep97
     */
    eProsima_user_DllExport void dep97(
            Type97&& _dep97)
    {
        m_dep97 = std::move(_dep97);
    }

    /*!
     * @brief This function returns a constant reference to member dep97
     * @return Constant reference to member dep97
     */
    eProsima_user_DllExport const Type97& dep97() const
    {
        return m_dep97;
    }

    /*!
     * @brief This function returns a reference to member dep97
     * @return Reference to member dep97
     */
    eProsima_user_DllExport Type97& dep97()
    {
        return m_dep97;
    }


    /*!
     * @brief This function copies the value in member dep98
     * @param _dep98 New value to be copied in member dep98
     */
    eProsima_user_DllExport void dep98(
            const Type98& _dep98)
    {
        m_dep98 = _dep98;
    }

    /*!
     * @brief This function moves the value in member dep98
     * @param _dep98 New value to be moved in member dep98
     */
    eProsima_user_DllExport void dep98(
            Type98&& _dep98)
    {
        m_dep98 = std::move(_dep98);
    }

    /*!
     * @brief This function returns a constant reference to member dep98
     * @return Constant reference to member dep98
     */
    eProsima_user_DllExport const Type98& dep98() const
    {
        return m_dep98;
    }

    /*!
     * @brief This function returns a reference to member dep98
     * @return Reference to member dep98
     */
    eProsima_user_DllExport Type98& dep98()
    {
        return m_dep98;
    }


    /*!
     * @brief This function copies the value in member dep99
     * @param _dep99 New value to be copied in member dep99
     */
    eProsima_user_DllExport void dep99(
            const Type99& _dep99)
    {
        m_dep99 = _dep99;
    }

    /*!
     * @brief This function moves the value in member dep99
     * @param _dep99 New value to be moved in member dep99
     */
    eProsima_user_DllExport void dep99(
            Type99&& _dep99)
    {
        m_dep99 = std::move(_dep99);
    }

    /*!
     * @brief This function returns a constant reference to member dep99
     * @return Constant reference to member dep99
     */
    eProsima_user_DllExport const Type99& dep99() const
    {
        return m_dep99;
    }

    /*!
     * @brief This function returns a reference to member dep99
     * @return Reference to member dep99
     */
    eProsima_user_DllExport Type99& dep99()
    {
        return m_dep99;
    }


    /*!
     * @brief This function copies the value in member dep100
     * @param _dep100 New value to be copied in member dep100
     */
    eProsima_user_DllExport void dep100(
            const Type100& _dep100)
    {
        m_dep100 = _dep100;
    }

    /*!
     * @brief This function moves the value in member dep100
     * @param _dep100 New value to be moved in member dep100
     */
    eProsima_user_DllExport void dep100(
            Type100&& _dep100)
    {
        m_dep100 = std::move(_dep100);
    }

    /*!
     * @brief This function returns a constant reference to member dep100
     * @return Constant reference to member dep100
     */
    eProsima_user_DllExport const Type100& dep100() const
    {
        return m_dep100;
    }

    /*!
     * @brief This function returns a reference to member dep100
     * @return Reference to member dep100
     */
    eProsima_user_DllExport Type100& dep100()
    {
        return m_dep100;
    }



private:

    std::string m_content;
    Type1 m_dep1;
    Type2 m_dep2;
    Type3 m_dep3;
    Type4 m_dep4;
    Type5 m_dep5;
    Type6 m_dep6;
    Type7 m_dep7;
    Type8 m_dep8;
    Type9 m_dep9;
    Type10 m_dep10;
    Type11 m_dep11;
    Type12 m_dep12;
    Type13 m_dep13;
    Type14 m_dep14;
    Type15 m_dep15;
    Type16 m_dep16;
    Type17 m_dep17;
    Type18 m_dep18;
    Type19 m_dep19;
    Type20 m_dep20;
    Type21 m_dep21;
    Type22 m_dep22;
    Type23 m_dep23;
    Type24 m_dep24;
    Type25 m_dep25;
    Type26 m_dep26;
    Type27 m_dep27;
    Type28 m_dep28;
    Type29 m_dep29;
    Type30 m_dep30;
    Type31 m_dep31;
    Type32 m_dep32;
    Type33 m_dep33;
    Type34 m_dep34;
    Type35 m_dep35;
    Type36 m_dep36;
    Type37 m_dep37;
    Type38 m_dep38;
    Type39 m_dep39;
    Type40 m_dep40;
    Type41 m_dep41;
    Type42 m_dep42;
    Type43 m_dep43;
    Type44 m_dep44;
    Type45 m_dep45;
    Type46 m_dep46;
    Type47 m_dep47;
    Type48 m_dep48;
    Type49 m_dep49;
    Type50 m_dep50;
    Type51 m_dep51;
    Type52 m_dep52;
    Type53 m_dep53;
    Type54 m_dep54;
    Type55 m_dep55;
    Type56 m_dep56;
    Type57 m_dep57;
    Type58 m_dep58;
    Type59 m_dep59;
    Type60 m_dep60;
    Type61 m_dep61;
    Type62 m_dep62;
    Type63 m_dep63;
    Type64 m_dep64;
    Type65 m_dep65;
    Type66 m_dep66;
    Type67 m_dep67;
    Type68 m_dep68;
    Type69 m_dep69;
    Type70 m_dep70;
    Type71 m_dep71;
    Type72 m_dep72;
    Type73 m_dep73;
    Type74 m_dep74;
    Type75 m_dep75;
    Type76 m_dep76;
    Type77 m_dep77;
    Type78 m_dep78;
    Type79 m_dep79;
    Type80 m_dep80;
    Type81 m_dep81;
    Type82 m_dep82;
    Type83 m_dep83;
    Type84 m_dep84;
    Type85 m_dep85;
    Type86 m_dep86;
    Type87 m_dep87;
    Type88 m_dep88;
    Type89 m_dep89;
    Type90 m_dep90;
    Type91 m_dep91;
    Type92 m_dep92;
    Type93 m_dep93;
    Type94 m_dep94;
    Type95 m_dep95;
    Type96 m_dep96;
    Type97 m_dep97;
    Type98 m_dep98;
    Type99 m_dep99;
    Type100 m_dep100;

};

#endif // _FAST_DDS_GENERATED_XTYPESTESTSTYPEBIG_HPP_


