# Serving via stunnel

[`stunnel`](https://www.stunnel.org/) is a TLS/SSL proxy for programs
that themselves serve only via HTTP, such as Fossil. (Fossil *can* speak
HTTPS, but only as a client.) `stunnel` decodes the HTTPS data from the
outside world as HTTP before passing it to Fossil, and it encodes the
HTTP replies from Fossil as HTTPS before sending them to the remote host
that made the request.

You can run `stunnel` in one of two modes: socket listener — much like
in our [`inetd` doc](./inetd.md) — and as an HTTP reverse proxy. We’ll
cover both cases here, separately.


## S<a name="sa"></a>ocket Activation

The following `stunnel.conf` configuration configures it to run Fossil
in socket listener mode, launching Fossil only when an HTTPS hit comes
in, then shutting it back down as soon as the transaction is complete:

```dosini
    [fossil]
    accept       = 443
    TIMEOUTclose = 0
    exec         = /usr/bin/fossil
    execargs     = /usr/bin/fossil http /home/fossil/ubercool.fossil --https
    cert         = /etc/letsencrypt/live/ubercool-project.org/fullchain.pem
    key          = /etc/letsencrypt/live/ubercool-project.org/privkey.pem
    ciphers      = ECDHE-RSA-AES256-GCM-SHA384:ECDHE-RSA-AES128-GCM-SHA256:ECDHE-RSA-AES256-SHA384:ECDHE-RSA-AES256-SHA:ECDHE-RSA-AES128-SHA256:ECDHE-RSA-AES128-SHA:AES256-GCM-SHA384:AES128-GCM-SHA256:AES256-SHA256:AES128-SHA256:AES128-SHA:DES-CBC3-SHA
    options      = CIPHER_SERVER_PREFERENCE
```

This configuration shows the TLS certificate generated by the [Let’s
Encrypt](https://letsencrypt.org) [Certbot](https://certbot.eff.org) in
[certonly mode](https://certbot.eff.org/lets-encrypt/debianbuster-other).
There are other ways to get TLS certificates, but this is a popular and
free option.

You will need to adjust the site names and paths in this example. Where
this file goes varies by OS type, so check the man pages on your system
to find out where it should be locally.

See the `stunnel` documentation for further details about this
configuration file.

It is important that the [`fossil http`](/help/http) command in that
configuration include the `--https` option to let Fossil know to use
“`https://`” instead of “`http://`” in generated hyperlinks.



## <a name="proxy"></a>Reverse Proxy

You can instead have Fossil running in the background in [standalone
HTTP server mode](./none.md), bound to a high random TCP port number on
localhost via the `--localhost` and `--port` flags, then configure
`stunnel` to reverse proxy public HTTPS connections down to it via HTTP.

The configuration is the same as the above except that you drop the
`exec` and `execargs` directives and add this instead:

```dosini
    connect      = 9000
```

That tells `stunnel` to connect to an already-running process listening
on the given TCP port number.

There are a few advantages to this mode:

1.  At the cost of some server memory and a tiny bit of idle CPU time,
    Fossil remains running so that hits can be served a smidge faster
    than in socket listener mode, where the Fossil binary has to be
    loaded and re-initialized on each HTTPS hit.

2.  The socket listener mode doesn’t work on all platforms that
    `stunnel` runs on, particularly [on Windows](../windows/stunnel.md).

*[Return to the top-level Fossil server article.](../)*
