/* $Id: indel.h 224743 2021-12-04 00:50:21Z twu $ */
#ifndef INDEL_INCLUDED
#define INDEL_INCLUDED

typedef struct Indelinfo_T *Indelinfo_T;

#include "bool.h"
#include "list.h"
#include "chrnum.h"
#include "genomicpos.h"
#include "compress.h"
#include "genome.h"

struct Indelinfo_T {
  int *int_memory;

  int *mismatch_positions_left;
  int *mismatch_positions_right;
};

extern void
Indel_setup (Genome_T genomebits_in, Genome_T genomebits_alt_in,
	     Univcoord_T genomelength_in, Trcoord_T transcriptomelength_in,
	     int max_end_insertions_in, int max_end_deletions_in,
	     int min_indel_end_matches_in, int indel_penalty_middle_in, bool maskedp_in);

extern void
Indelinfo_free (Indelinfo_T *old);
extern Indelinfo_T
Indelinfo_new (int querylength);

extern int
Indel_resolve_middle_insertion (int *best_nmismatches_i, int *best_nmismatches_j,
				int *best_ref_nmismatches_i, int *best_ref_nmismatches_j,
				Univcoord_T left, int indels,
				int *mismatch_positions_left, int nmismatches_left,
				int *mismatch_positions_right, int nmismatches_right,
				Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
				int pos5, int pos3, int querylength, Indelinfo_T indelinfo,
				bool plusp, int genestrand, bool want_lowest_coordinate_p);

int
Indel_resolve_middle_deletion (int *best_nmismatches_i, int *best_nmismatches_j,
			       int *best_ref_nmismatches_i, int *best_ref_nmismatches_j,
			       Univcoord_T left, int indels,
			       int *mismatch_positions_left, int nmismatches_left,
			       int *mismatch_positions_right, int nmismatches_right,
			       Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
			       int pos5, int pos3, int querylength, Indelinfo_T indelinfo,
			       bool plusp, int genestrand, bool want_lowest_coordinate_p);

extern int
Indel_resolve_middle_deletion_or_splice (int *best_introntype, int *best_nmismatches_i, int *best_nmismatches_j,
					 int *best_ref_nmismatches_i, int *best_ref_nmismatches_j,
					 Univcoord_T left, Univcoord_T chroffset, Univcoord_T chrhigh, int indels,
					 Genome_T ome, Genome_T ome_alt, Compress_T query_compress,
					 int pos5, int pos3, int querylength, Indelinfo_T indelinfo,
					 bool plusp, int genestrand, int min_intronlength,
					 bool want_lowest_coordinate_p);


extern int
Indel_solve_end_low (int *best_adj, int *total_nmismatches, Trcoord_T tr_left,
		     Trcoord_T troffset, Trcoord_T trhigh, int firstbound,
		     int querylength, Compress_T query_compress,
		     Genome_T omebits, Genome_T omebits_alt, Indelinfo_T indelinfo,
		     bool plusp, int genestrand, bool want_lowest_coordinate_p);

extern int
Indel_solve_end_high (int *best_adj, int *total_nmismatches, Trcoord_T tr_left,
		      Trcoord_T troffset, Trcoord_T trhigh, int lastbound,
		      int querylength, Compress_T query_compress,
		      Genome_T omebits, Genome_T omebits_alt, Indelinfo_T indelinfo,
		      bool plusp, int genestrand, bool want_lowest_coordinate_p);

#endif

