/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */

/* This file is automatically generated using bindtool */

#include <pybind11/complex.h>
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

#include <gnuradio/vocoder/freedv_api.h>

void bind_freedv_api(py::module& m)
{
    using freedv_api = ::gr::vocoder::freedv_api;

    py::class_<freedv_api, std::shared_ptr<freedv_api>> freedv_api_class(m, "freedv_api");

    py::enum_<gr::vocoder::freedv_api::freedv_modes>(freedv_api_class, "freedv_modes")

#ifdef FREEDV_MODE_1600
        .value("MODE_1600", gr::vocoder::freedv_api::MODE_1600)
#endif
#ifdef FREEDV_MODE_700
        .value("MODE_700", gr::vocoder::freedv_api::MODE_700)
#endif
#ifdef FREEDV_MODE_700B
        .value("MODE_700B", gr::vocoder::freedv_api::MODE_700B)
#endif
#ifdef FREEDV_MODE_2400A
        .value("MODE_2400A", gr::vocoder::freedv_api::MODE_2400A)
#endif
#ifdef FREEDV_MODE_2400B
        .value("MODE_2400B", gr::vocoder::freedv_api::MODE_2400B)
#endif
#ifdef FREEDV_MODE_800XA
        .value("MODE_800XA", gr::vocoder::freedv_api::MODE_800XA)
#endif
#ifdef FREEDV_MODE_700C
        .value("MODE_700C", gr::vocoder::freedv_api::MODE_700C)
#endif
#ifdef FREEDV_MODE_700D
        .value("MODE_700D", gr::vocoder::freedv_api::MODE_700D)
        .value("SYNC_UNSYNC", gr::vocoder::freedv_api::SYNC_UNSYNC)
        .value("SYNC_AUTO", gr::vocoder::freedv_api::SYNC_AUTO)
        .value("SYNC_MANUAL", gr::vocoder::freedv_api::SYNC_MANUAL)
#endif
#ifdef FREEDV_MODE_2020
        .value("MODE_2020", gr::vocoder::freedv_api::MODE_2020)
#endif
#ifdef FREEDV_MODE_2020B
        .value("MODE_2020B", gr::vocoder::freedv_api::MODE_2020B)
#endif
#ifdef FREEDV_MODE_700E
        .value("MODE_700E", gr::vocoder::freedv_api::MODE_700E)
#endif
#ifdef FREEDV_MODE_FSK_LDPC
        .value("MODE_FSK_LDPC", gr::vocoder::freedv_api::MODE_FSK_LDPC)
#endif
#ifdef FREEDV_MODE_DATAC1
        .value("MODE_DATAC1", gr::vocoder::freedv_api::MODE_DATAC1)
#endif
#ifdef FREEDV_MODE_DATAC3
        .value("MODE_DATAC3", gr::vocoder::freedv_api::MODE_DATAC3)
#endif
#ifdef FREEDV_MODE_DATAC0
        .value("MODE_DATAC0", gr::vocoder::freedv_api::MODE_DATAC0)
#endif
        .export_values();

    py::implicitly_convertible<int, gr::vocoder::freedv_api::freedv_modes>();
}
