//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/changeanalysis/armchangeanalysis"
	"net/http"
	"net/url"
	"regexp"
	"time"
)

// ChangesServer is a fake server for instances of the armchangeanalysis.ChangesClient type.
type ChangesServer struct {
	// NewListChangesByResourceGroupPager is the fake for method ChangesClient.NewListChangesByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListChangesByResourceGroupPager func(resourceGroupName string, startTime time.Time, endTime time.Time, options *armchangeanalysis.ChangesClientListChangesByResourceGroupOptions) (resp azfake.PagerResponder[armchangeanalysis.ChangesClientListChangesByResourceGroupResponse])

	// NewListChangesBySubscriptionPager is the fake for method ChangesClient.NewListChangesBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListChangesBySubscriptionPager func(startTime time.Time, endTime time.Time, options *armchangeanalysis.ChangesClientListChangesBySubscriptionOptions) (resp azfake.PagerResponder[armchangeanalysis.ChangesClientListChangesBySubscriptionResponse])
}

// NewChangesServerTransport creates a new instance of ChangesServerTransport with the provided implementation.
// The returned ChangesServerTransport instance is connected to an instance of armchangeanalysis.ChangesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewChangesServerTransport(srv *ChangesServer) *ChangesServerTransport {
	return &ChangesServerTransport{
		srv:                                srv,
		newListChangesByResourceGroupPager: newTracker[azfake.PagerResponder[armchangeanalysis.ChangesClientListChangesByResourceGroupResponse]](),
		newListChangesBySubscriptionPager:  newTracker[azfake.PagerResponder[armchangeanalysis.ChangesClientListChangesBySubscriptionResponse]](),
	}
}

// ChangesServerTransport connects instances of armchangeanalysis.ChangesClient to instances of ChangesServer.
// Don't use this type directly, use NewChangesServerTransport instead.
type ChangesServerTransport struct {
	srv                                *ChangesServer
	newListChangesByResourceGroupPager *tracker[azfake.PagerResponder[armchangeanalysis.ChangesClientListChangesByResourceGroupResponse]]
	newListChangesBySubscriptionPager  *tracker[azfake.PagerResponder[armchangeanalysis.ChangesClientListChangesBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for ChangesServerTransport.
func (c *ChangesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ChangesClient.NewListChangesByResourceGroupPager":
		resp, err = c.dispatchNewListChangesByResourceGroupPager(req)
	case "ChangesClient.NewListChangesBySubscriptionPager":
		resp, err = c.dispatchNewListChangesBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (c *ChangesServerTransport) dispatchNewListChangesByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListChangesByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListChangesByResourceGroupPager not implemented")}
	}
	newListChangesByResourceGroupPager := c.newListChangesByResourceGroupPager.get(req)
	if newListChangesByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ChangeAnalysis/changes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		startTimeUnescaped, err := url.QueryUnescape(qp.Get("$startTime"))
		if err != nil {
			return nil, err
		}
		startTimeParam, err := time.Parse(time.RFC3339Nano, startTimeUnescaped)
		if err != nil {
			return nil, err
		}
		endTimeUnescaped, err := url.QueryUnescape(qp.Get("$endTime"))
		if err != nil {
			return nil, err
		}
		endTimeParam, err := time.Parse(time.RFC3339Nano, endTimeUnescaped)
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armchangeanalysis.ChangesClientListChangesByResourceGroupOptions
		if skipTokenParam != nil {
			options = &armchangeanalysis.ChangesClientListChangesByResourceGroupOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListChangesByResourceGroupPager(resourceGroupNameParam, startTimeParam, endTimeParam, options)
		newListChangesByResourceGroupPager = &resp
		c.newListChangesByResourceGroupPager.add(req, newListChangesByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListChangesByResourceGroupPager, req, func(page *armchangeanalysis.ChangesClientListChangesByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListChangesByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListChangesByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListChangesByResourceGroupPager) {
		c.newListChangesByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (c *ChangesServerTransport) dispatchNewListChangesBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if c.srv.NewListChangesBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListChangesBySubscriptionPager not implemented")}
	}
	newListChangesBySubscriptionPager := c.newListChangesBySubscriptionPager.get(req)
	if newListChangesBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.ChangeAnalysis/changes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		startTimeUnescaped, err := url.QueryUnescape(qp.Get("$startTime"))
		if err != nil {
			return nil, err
		}
		startTimeParam, err := time.Parse(time.RFC3339Nano, startTimeUnescaped)
		if err != nil {
			return nil, err
		}
		endTimeUnescaped, err := url.QueryUnescape(qp.Get("$endTime"))
		if err != nil {
			return nil, err
		}
		endTimeParam, err := time.Parse(time.RFC3339Nano, endTimeUnescaped)
		if err != nil {
			return nil, err
		}
		skipTokenUnescaped, err := url.QueryUnescape(qp.Get("$skipToken"))
		if err != nil {
			return nil, err
		}
		skipTokenParam := getOptional(skipTokenUnescaped)
		var options *armchangeanalysis.ChangesClientListChangesBySubscriptionOptions
		if skipTokenParam != nil {
			options = &armchangeanalysis.ChangesClientListChangesBySubscriptionOptions{
				SkipToken: skipTokenParam,
			}
		}
		resp := c.srv.NewListChangesBySubscriptionPager(startTimeParam, endTimeParam, options)
		newListChangesBySubscriptionPager = &resp
		c.newListChangesBySubscriptionPager.add(req, newListChangesBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListChangesBySubscriptionPager, req, func(page *armchangeanalysis.ChangesClientListChangesBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListChangesBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		c.newListChangesBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListChangesBySubscriptionPager) {
		c.newListChangesBySubscriptionPager.remove(req)
	}
	return resp, nil
}
