//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcommunication

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// SuppressionListAddressesClient contains the methods for the SuppressionListAddresses group.
// Don't use this type directly, use NewSuppressionListAddressesClient() instead.
type SuppressionListAddressesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewSuppressionListAddressesClient creates a new instance of SuppressionListAddressesClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewSuppressionListAddressesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*SuppressionListAddressesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &SuppressionListAddressesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - Create or update a SuppressionListAddress.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - addressID - The id of the address in a suppression list.
//   - parameters - Parameters for the create or update operation
//   - options - SuppressionListAddressesClientCreateOrUpdateOptions contains the optional parameters for the SuppressionListAddressesClient.CreateOrUpdate
//     method.
func (client *SuppressionListAddressesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, parameters SuppressionListAddressResource, options *SuppressionListAddressesClientCreateOrUpdateOptions) (SuppressionListAddressesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "SuppressionListAddressesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, addressID, parameters, options)
	if err != nil {
		return SuppressionListAddressesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SuppressionListAddressesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return SuppressionListAddressesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *SuppressionListAddressesClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, parameters SuppressionListAddressResource, options *SuppressionListAddressesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}/suppressionListAddresses/{addressId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	if addressID == "" {
		return nil, errors.New("parameter addressID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressId}", url.PathEscape(addressID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *SuppressionListAddressesClient) createOrUpdateHandleResponse(resp *http.Response) (SuppressionListAddressesClientCreateOrUpdateResponse, error) {
	result := SuppressionListAddressesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuppressionListAddressResource); err != nil {
		return SuppressionListAddressesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Operation to delete a single address from a suppression list.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - addressID - The id of the address in a suppression list.
//   - options - SuppressionListAddressesClientDeleteOptions contains the optional parameters for the SuppressionListAddressesClient.Delete
//     method.
func (client *SuppressionListAddressesClient) Delete(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, options *SuppressionListAddressesClientDeleteOptions) (SuppressionListAddressesClientDeleteResponse, error) {
	var err error
	const operationName = "SuppressionListAddressesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, addressID, options)
	if err != nil {
		return SuppressionListAddressesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SuppressionListAddressesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return SuppressionListAddressesClientDeleteResponse{}, err
	}
	return SuppressionListAddressesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *SuppressionListAddressesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, options *SuppressionListAddressesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}/suppressionListAddresses/{addressId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	if addressID == "" {
		return nil, errors.New("parameter addressID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressId}", url.PathEscape(addressID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a SuppressionListAddress.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - addressID - The id of the address in a suppression list.
//   - options - SuppressionListAddressesClientGetOptions contains the optional parameters for the SuppressionListAddressesClient.Get
//     method.
func (client *SuppressionListAddressesClient) Get(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, options *SuppressionListAddressesClientGetOptions) (SuppressionListAddressesClientGetResponse, error) {
	var err error
	const operationName = "SuppressionListAddressesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, addressID, options)
	if err != nil {
		return SuppressionListAddressesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return SuppressionListAddressesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return SuppressionListAddressesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *SuppressionListAddressesClient) getCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, addressID string, options *SuppressionListAddressesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}/suppressionListAddresses/{addressId}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	if addressID == "" {
		return nil, errors.New("parameter addressID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{addressId}", url.PathEscape(addressID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *SuppressionListAddressesClient) getHandleResponse(resp *http.Response) (SuppressionListAddressesClientGetResponse, error) {
	result := SuppressionListAddressesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuppressionListAddressResource); err != nil {
		return SuppressionListAddressesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get all the addresses in a suppression list.
//
// Generated from API version 2023-06-01-preview
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - emailServiceName - The name of the EmailService resource.
//   - domainName - The name of the Domains resource.
//   - suppressionListName - The name of the suppression list.
//   - options - SuppressionListAddressesClientListOptions contains the optional parameters for the SuppressionListAddressesClient.NewListPager
//     method.
func (client *SuppressionListAddressesClient) NewListPager(resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *SuppressionListAddressesClientListOptions) *runtime.Pager[SuppressionListAddressesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[SuppressionListAddressesClientListResponse]{
		More: func(page SuppressionListAddressesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *SuppressionListAddressesClientListResponse) (SuppressionListAddressesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "SuppressionListAddressesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, emailServiceName, domainName, suppressionListName, options)
			}, nil)
			if err != nil {
				return SuppressionListAddressesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *SuppressionListAddressesClient) listCreateRequest(ctx context.Context, resourceGroupName string, emailServiceName string, domainName string, suppressionListName string, options *SuppressionListAddressesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Communication/emailServices/{emailServiceName}/domains/{domainName}/suppressionLists/{suppressionListName}/suppressionListAddresses"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if emailServiceName == "" {
		return nil, errors.New("parameter emailServiceName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{emailServiceName}", url.PathEscape(emailServiceName))
	if domainName == "" {
		return nil, errors.New("parameter domainName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{domainName}", url.PathEscape(domainName))
	if suppressionListName == "" {
		return nil, errors.New("parameter suppressionListName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{suppressionListName}", url.PathEscape(suppressionListName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-06-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *SuppressionListAddressesClient) listHandleResponse(resp *http.Response) (SuppressionListAddressesClientListResponse, error) {
	result := SuppressionListAddressesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.SuppressionListAddressResourceCollection); err != nil {
		return SuppressionListAddressesClientListResponse{}, err
	}
	return result, nil
}
