//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armconsumption

import "time"

// Amount - The amount plus currency .
type Amount struct {
	// READ-ONLY; Amount currency.
	Currency *string

	// READ-ONLY; Amount.
	Value *float64
}

// AmountWithExchangeRate - The amount with exchange rate.
type AmountWithExchangeRate struct {
	// READ-ONLY; Amount currency.
	Currency *string

	// READ-ONLY; The exchange rate.
	ExchangeRate *float64

	// READ-ONLY; The exchange rate month.
	ExchangeRateMonth *int32

	// READ-ONLY; Amount.
	Value *float64
}

// Balance - A balance resource.
type Balance struct {
	// The properties of the balance.
	Properties *BalanceProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// BalanceProperties - The properties of the balance.
type BalanceProperties struct {
	// The billing frequency.
	BillingFrequency *BillingFrequency

	// READ-ONLY; List of Adjustments (Promo credit, SIE credit etc.).
	AdjustmentDetails []*BalancePropertiesAdjustmentDetailsItem

	// READ-ONLY; Total adjustment amount.
	Adjustments *float64

	// READ-ONLY; Total charges for Azure Marketplace.
	AzureMarketplaceServiceCharges *float64

	// READ-ONLY; The beginning balance for the billing period.
	BeginningBalance *float64

	// READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *float64

	// READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string

	// READ-ONLY; The ending balance for the billing period (for open periods this will be updated daily).
	EndingBalance *float64

	// READ-ONLY; Total new purchase amount.
	NewPurchases *float64

	// READ-ONLY; List of new purchases.
	NewPurchasesDetails []*BalancePropertiesNewPurchasesDetailsItem

	// READ-ONLY; Price is hidden or not.
	PriceHidden *bool

	// READ-ONLY; Overage for Azure services.
	ServiceOverage *float64

	// READ-ONLY; serviceOverage + chargesBilledSeparately.
	TotalOverage *float64

	// READ-ONLY; Azure service commitment + total Overage.
	TotalUsage *float64

	// READ-ONLY; Total Commitment usage.
	Utilized *float64
}

type BalancePropertiesAdjustmentDetailsItem struct {
	// READ-ONLY; the name of new adjustment.
	Name *string

	// READ-ONLY; the value of new adjustment.
	Value *float64
}

type BalancePropertiesNewPurchasesDetailsItem struct {
	// READ-ONLY; the name of new purchase.
	Name *string

	// READ-ONLY; the value of new purchase.
	Value *float64
}

// Budget - A budget resource.
type Budget struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The properties of the budget.
	Properties *BudgetProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// BudgetComparisonExpression - The comparison expression to be used in the budgets.
type BudgetComparisonExpression struct {
	// REQUIRED; The name of the column to use in comparison.
	Name *string

	// REQUIRED; The operator to use for comparison.
	Operator *BudgetOperatorType

	// REQUIRED; Array of values to use for comparison
	Values []*string
}

// BudgetFilter - May be used to filter budgets by resource group, resource, or meter.
type BudgetFilter struct {
	// The logical "AND" expression. Must have at least 2 items.
	And []*BudgetFilterProperties

	// Has comparison expression for a dimension
	Dimensions *BudgetComparisonExpression

	// Has comparison expression for a tag
	Tags *BudgetComparisonExpression
}

// BudgetFilterProperties - The Dimensions or Tags to filter a budget by.
type BudgetFilterProperties struct {
	// Has comparison expression for a dimension
	Dimensions *BudgetComparisonExpression

	// Has comparison expression for a tag
	Tags *BudgetComparisonExpression
}

// BudgetProperties - The properties of the budget.
type BudgetProperties struct {
	// REQUIRED; The total amount of cost to track with the budget
	Amount *float64

	// REQUIRED; The category of the budget, whether the budget tracks cost or usage.
	Category *CategoryType

	// REQUIRED; The time covered by a budget. Tracking of the amount will be reset based on the time grain. BillingMonth, BillingQuarter,
	// and BillingAnnual are only supported by WD customers
	TimeGrain *TimeGrainType

	// REQUIRED; Has start and end date of the budget. The start date must be first of the month and should be less than the end
	// date. Budget start date must be on or after June 1, 2017. Future start date should not
	// be more than twelve months. Past start date should be selected within the timegrain period. There are no restrictions on
	// the end date.
	TimePeriod *BudgetTimePeriod

	// May be used to filter budgets by user-specified dimensions and/or tags.
	Filter *BudgetFilter

	// Dictionary of notifications associated with the budget. Budget can have up to five notifications.
	Notifications map[string]*Notification

	// READ-ONLY; The current amount of cost which is being tracked for a budget.
	CurrentSpend *CurrentSpend

	// READ-ONLY; The forecasted cost which is being tracked for a budget.
	ForecastSpend *ForecastSpend
}

// BudgetTimePeriod - The start and end date for a budget.
type BudgetTimePeriod struct {
	// REQUIRED; The start date for the budget.
	StartDate *time.Time

	// The end date for the budget. If not provided, we default this to 10 years from the start date.
	EndDate *time.Time
}

// BudgetsListResult - Result of listing budgets. It contains a list of available budgets in the scope provided.
type BudgetsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of budgets.
	Value []*Budget
}

// ChargeSummary - A charge summary resource.
type ChargeSummary struct {
	// REQUIRED; Specifies the kind of charge summary.
	Kind *ChargeSummaryKind

	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// GetChargeSummary implements the ChargeSummaryClassification interface for type ChargeSummary.
func (c *ChargeSummary) GetChargeSummary() *ChargeSummary { return c }

// ChargesListResult - Result of listing charge summary.
type ChargesListResult struct {
	// READ-ONLY; The list of charge summary
	Value []ChargeSummaryClassification
}

// CreditBalanceSummary - Summary of credit balances.
type CreditBalanceSummary struct {
	// READ-ONLY; Current balance.
	CurrentBalance *Amount

	// READ-ONLY; Estimated balance.
	EstimatedBalance *Amount

	// READ-ONLY; Estimated balance in billing currency.
	EstimatedBalanceInBillingCurrency *AmountWithExchangeRate
}

// CreditSummary - A credit summary resource.
type CreditSummary struct {
	// The properties of the credit summary.
	Properties *CreditSummaryProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// CreditSummaryProperties - The properties of the credit summary.
type CreditSummaryProperties struct {
	// READ-ONLY; Summary of balances associated with this credit summary.
	BalanceSummary *CreditBalanceSummary

	// READ-ONLY; The billing currency.
	BillingCurrency *string

	// READ-ONLY; The credit currency.
	CreditCurrency *string

	// READ-ONLY; The eTag for the resource.
	ETag *string

	// READ-ONLY; Expired credit.
	ExpiredCredit *Amount

	// READ-ONLY; Pending credit adjustments.
	PendingCreditAdjustments *Amount

	// READ-ONLY; Pending eligible charges.
	PendingEligibleCharges *Amount

	// READ-ONLY; Credit's reseller.
	Reseller *Reseller
}

// CurrentSpend - The current amount of cost which is being tracked for a budget.
type CurrentSpend struct {
	// READ-ONLY; The total amount of cost which is being tracked by the budget.
	Amount *float64

	// READ-ONLY; The unit of measure for the budget amount.
	Unit *string
}

// DownloadProperties - The properties of the price sheet download.
type DownloadProperties struct {
	// READ-ONLY; The link (url) to download the pricesheet.
	DownloadURL *string

	// READ-ONLY; Download link validity.
	ValidTill *string
}

// ErrorDetails - The details of the error.
type ErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// ErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason is provided
// in the error message.
// Some Error responses:
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after"
// header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After"
// header.
type ErrorResponse struct {
	// The details of the error.
	Error *ErrorDetails
}

// EventProperties - The event properties.
type EventProperties struct {
	// Identifies the type of the event.
	EventType *EventType

	// READ-ONLY; The amount of balance adjustment. The property is not available for ConsumptionCommitment lots.
	Adjustments *Amount

	// READ-ONLY; The amount of balance adjustment in billing currency.
	AdjustmentsInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The billing currency of the event.
	BillingCurrency *string

	// READ-ONLY; The display name of the billing profile for which the event happened. The property is only available for billing
	// account of type MicrosoftCustomerAgreement.
	BillingProfileDisplayName *string

	// READ-ONLY; The ID that uniquely identifies the billing profile for which the event happened. The property is only available
	// for billing account of type MicrosoftCustomerAgreement.
	BillingProfileID *string

	// READ-ONLY; Amount of canceled credit.
	CanceledCredit *Amount

	// READ-ONLY; The amount of charges for events of type SettleCharges and PendingEligibleCharges.
	Charges *Amount

	// READ-ONLY; The amount of charges for events of type SettleCharges and PendingEligibleCharges in billing currency.
	ChargesInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The balance after the event.
	ClosedBalance *Amount

	// READ-ONLY; The balance in billing currency after the event.
	ClosedBalanceInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The credit currency of the event.
	CreditCurrency *string

	// READ-ONLY; The amount of expired credit or commitment for NewCredit or SettleCharges event.
	CreditExpired *Amount

	// READ-ONLY; The amount of expired credit or commitment for NewCredit or SettleCharges event in billing currency.
	CreditExpiredInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The description of the event.
	Description *string

	// READ-ONLY; The eTag for the resource.
	ETag *string

	// READ-ONLY; The number which uniquely identifies the invoice on which the event was billed. This will be empty for unbilled
	// events.
	InvoiceNumber *string

	// READ-ONLY; The ID that uniquely identifies the lot for which the event happened.
	LotID *string

	// READ-ONLY; Identifies the source of the lot for which the event happened.
	LotSource *string

	// READ-ONLY; The amount of new credit or commitment for NewCredit or SettleCharges event.
	NewCredit *Amount

	// READ-ONLY; The amount of new credit or commitment for NewCredit or SettleCharges event in billing currency.
	NewCreditInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The reseller of the event.
	Reseller *Reseller

	// READ-ONLY; The date of the event.
	TransactionDate *time.Time
}

// EventSummary - An event summary resource.
type EventSummary struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The event properties.
	Properties *EventProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// Events - Result of listing event summary.
type Events struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of event summary.
	Value []*EventSummary
}

// ForecastSpend - The forecasted cost which is being tracked for a budget.
type ForecastSpend struct {
	// READ-ONLY; The forecasted cost for the total time period which is being tracked by the budget. This value is only provided
	// if the budget contains a forecast alert type.
	Amount *float64

	// READ-ONLY; The unit of measure for the budget amount.
	Unit *string
}

// HighCasedErrorDetails - The details of the error.
type HighCasedErrorDetails struct {
	// READ-ONLY; Error code.
	Code *string

	// READ-ONLY; Error message indicating why the operation failed.
	Message *string
}

// HighCasedErrorResponse - Error response indicates that the service is not able to process the incoming request. The reason
// is provided in the error message.
// Some Error responses:
// * 429 TooManyRequests - Request is throttled. Retry after waiting for the time specified in the "x-ms-ratelimit-microsoft.consumption-retry-after"
// header.
//
// * 503 ServiceUnavailable - Service is temporarily unavailable. Retry after waiting for the time specified in the "Retry-After"
// header.
type HighCasedErrorResponse struct {
	// The details of the error.
	Error *HighCasedErrorDetails
}

// LegacyChargeSummary - Legacy charge summary.
type LegacyChargeSummary struct {
	// REQUIRED; Specifies the kind of charge summary.
	Kind *ChargeSummaryKind

	// REQUIRED; Properties for legacy charge summary
	Properties *LegacyChargeSummaryProperties

	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// GetChargeSummary implements the ChargeSummaryClassification interface for type LegacyChargeSummary.
func (l *LegacyChargeSummary) GetChargeSummary() *ChargeSummary {
	return &ChargeSummary{
		ETag: l.ETag,
		ID:   l.ID,
		Kind: l.Kind,
		Name: l.Name,
		Type: l.Type,
	}
}

// LegacyChargeSummaryProperties - The properties of legacy charge summary.
type LegacyChargeSummaryProperties struct {
	// READ-ONLY; Azure Charges.
	AzureCharges *float64

	// READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string

	// READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *float64

	// READ-ONLY; Currency Code
	Currency *string

	// READ-ONLY; Marketplace Charges.
	MarketplaceCharges *float64

	// READ-ONLY; Usage end date.
	UsageEnd *string

	// READ-ONLY; Usage start date.
	UsageStart *string
}

// LegacyReservationRecommendation - Legacy reservation recommendation.
type LegacyReservationRecommendation struct {
	// REQUIRED; Specifies the kind of reservation recommendation.
	Kind *ReservationRecommendationKind

	// REQUIRED; Properties for legacy reservation recommendation
	Properties LegacyReservationRecommendationPropertiesClassification

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; Resource location
	Location *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource sku
	SKU *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// GetReservationRecommendation implements the ReservationRecommendationClassification interface for type LegacyReservationRecommendation.
func (l *LegacyReservationRecommendation) GetReservationRecommendation() *ReservationRecommendation {
	return &ReservationRecommendation{
		Etag:     l.Etag,
		ID:       l.ID,
		Kind:     l.Kind,
		Location: l.Location,
		Name:     l.Name,
		SKU:      l.SKU,
		Tags:     l.Tags,
		Type:     l.Type,
	}
}

// LegacyReservationRecommendationProperties - The properties of the reservation recommendation.
type LegacyReservationRecommendationProperties struct {
	// REQUIRED; Shared or single recommendation.
	Scope *string

	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *float64

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string

	// READ-ONLY; The meter id (GUID)
	MeterID *string

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *float64

	// READ-ONLY; The normalized Size.
	NormalizedSize *string

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32

	// READ-ONLY; The azure resource type.
	ResourceType *string

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *float64
}

// GetLegacyReservationRecommendationProperties implements the LegacyReservationRecommendationPropertiesClassification interface
// for type LegacyReservationRecommendationProperties.
func (l *LegacyReservationRecommendationProperties) GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties {
	return l
}

// LegacyReservationTransaction - Legacy Reservation transaction resource.
type LegacyReservationTransaction struct {
	// The properties of a legacy reservation transaction.
	Properties *LegacyReservationTransactionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource tags.
	Tags []*string

	// READ-ONLY; Resource type.
	Type *string
}

// LegacyReservationTransactionProperties - The properties of a legacy reservation transaction.
type LegacyReservationTransactionProperties struct {
	// READ-ONLY; The name of the account that makes the transaction.
	AccountName *string

	// READ-ONLY; The email of the account owner that makes the transaction.
	AccountOwnerEmail *string

	// READ-ONLY; The charge of the transaction.
	Amount *float64

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	ArmSKUName *string

	// READ-ONLY; The billing frequency, which can be either one-time or recurring.
	BillingFrequency *string

	// READ-ONLY; The billing month(yyyyMMdd), on which the event initiated.
	BillingMonth *int32

	// READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string

	// READ-ONLY; The ISO currency in which the transaction is charged, for example, USD.
	Currency *string

	// READ-ONLY; The current enrollment.
	CurrentEnrollment *string

	// READ-ONLY; The department name.
	DepartmentName *string

	// READ-ONLY; The description of the transaction.
	Description *string

	// READ-ONLY; The date of the transaction
	EventDate *time.Time

	// READ-ONLY; The type of the transaction (Purchase, Cancel, etc.)
	EventType *string

	// READ-ONLY; The monetary commitment amount at the enrollment scope.
	MonetaryCommitment *float64

	// READ-ONLY; The overage amount at the enrollment scope.
	Overage *float64

	// READ-ONLY; The purchasing enrollment.
	PurchasingEnrollment *string

	// READ-ONLY; The subscription guid that makes the transaction.
	PurchasingSubscriptionGUID *string

	// READ-ONLY; The subscription name that makes the transaction.
	PurchasingSubscriptionName *string

	// READ-ONLY; The quantity of the transaction.
	Quantity *float64

	// READ-ONLY; The region of the transaction.
	Region *string

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string

	// READ-ONLY; The name of the reservation order.
	ReservationOrderName *string

	// READ-ONLY; This is the term of the transaction.
	Term *string
}

// LegacySharedScopeReservationRecommendationProperties - The properties of the legacy reservation recommendation for shared
// scope.
type LegacySharedScopeReservationRecommendationProperties struct {
	// REQUIRED; Shared or single recommendation.
	Scope *string

	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *float64

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string

	// READ-ONLY; The meter id (GUID)
	MeterID *string

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *float64

	// READ-ONLY; The normalized Size.
	NormalizedSize *string

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32

	// READ-ONLY; The azure resource type.
	ResourceType *string

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *float64
}

// GetLegacyReservationRecommendationProperties implements the LegacyReservationRecommendationPropertiesClassification interface
// for type LegacySharedScopeReservationRecommendationProperties.
func (l *LegacySharedScopeReservationRecommendationProperties) GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties {
	return &LegacyReservationRecommendationProperties{
		CostWithNoReservedInstances:    l.CostWithNoReservedInstances,
		FirstUsageDate:                 l.FirstUsageDate,
		InstanceFlexibilityGroup:       l.InstanceFlexibilityGroup,
		InstanceFlexibilityRatio:       l.InstanceFlexibilityRatio,
		LookBackPeriod:                 l.LookBackPeriod,
		MeterID:                        l.MeterID,
		NetSavings:                     l.NetSavings,
		NormalizedSize:                 l.NormalizedSize,
		RecommendedQuantity:            l.RecommendedQuantity,
		RecommendedQuantityNormalized:  l.RecommendedQuantityNormalized,
		ResourceType:                   l.ResourceType,
		SKUProperties:                  l.SKUProperties,
		Scope:                          l.Scope,
		Term:                           l.Term,
		TotalCostWithReservedInstances: l.TotalCostWithReservedInstances,
	}
}

// LegacySingleScopeReservationRecommendationProperties - The properties of the legacy reservation recommendation for single
// scope.
type LegacySingleScopeReservationRecommendationProperties struct {
	// REQUIRED; Shared or single recommendation.
	Scope *string

	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *float64

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *string

	// READ-ONLY; The meter id (GUID)
	MeterID *string

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *float64

	// READ-ONLY; The normalized Size.
	NormalizedSize *string

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32

	// READ-ONLY; The azure resource type.
	ResourceType *string

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty

	// READ-ONLY; Subscription id associated with single scoped recommendation.
	SubscriptionID *string

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *float64
}

// GetLegacyReservationRecommendationProperties implements the LegacyReservationRecommendationPropertiesClassification interface
// for type LegacySingleScopeReservationRecommendationProperties.
func (l *LegacySingleScopeReservationRecommendationProperties) GetLegacyReservationRecommendationProperties() *LegacyReservationRecommendationProperties {
	return &LegacyReservationRecommendationProperties{
		CostWithNoReservedInstances:    l.CostWithNoReservedInstances,
		FirstUsageDate:                 l.FirstUsageDate,
		InstanceFlexibilityGroup:       l.InstanceFlexibilityGroup,
		InstanceFlexibilityRatio:       l.InstanceFlexibilityRatio,
		LookBackPeriod:                 l.LookBackPeriod,
		MeterID:                        l.MeterID,
		NetSavings:                     l.NetSavings,
		NormalizedSize:                 l.NormalizedSize,
		RecommendedQuantity:            l.RecommendedQuantity,
		RecommendedQuantityNormalized:  l.RecommendedQuantityNormalized,
		ResourceType:                   l.ResourceType,
		SKUProperties:                  l.SKUProperties,
		Scope:                          l.Scope,
		Term:                           l.Term,
		TotalCostWithReservedInstances: l.TotalCostWithReservedInstances,
	}
}

// LegacyUsageDetail - Legacy usage detail.
type LegacyUsageDetail struct {
	// REQUIRED; Specifies the kind of usage details.
	Kind *UsageDetailsKind

	// REQUIRED; Properties for legacy usage details
	Properties *LegacyUsageDetailProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// GetUsageDetail implements the UsageDetailClassification interface for type LegacyUsageDetail.
func (l *LegacyUsageDetail) GetUsageDetail() *UsageDetail {
	return &UsageDetail{
		Etag: l.Etag,
		ID:   l.ID,
		Kind: l.Kind,
		Name: l.Name,
		Tags: l.Tags,
		Type: l.Type,
	}
}

// LegacyUsageDetailProperties - The properties of the legacy usage detail.
type LegacyUsageDetailProperties struct {
	// READ-ONLY; Account Name.
	AccountName *string

	// READ-ONLY; Account Owner Id.
	AccountOwnerID *string

	// READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand. Use
	// this field to get usage line item specific details such as the actual VM Size
	// (ServiceType) or the ratio in which the reservation discount is applied.
	AdditionalInfo *string

	// READ-ONLY; Unique identifier for the applicable benefit.
	BenefitID *string

	// READ-ONLY; Name of the applicable benefit.
	BenefitName *string

	// READ-ONLY; Billing Account identifier.
	BillingAccountID *string

	// READ-ONLY; Billing Account Name.
	BillingAccountName *string

	// READ-ONLY; Billing Currency.
	BillingCurrency *string

	// READ-ONLY; The billing period end date.
	BillingPeriodEndDate *time.Time

	// READ-ONLY; The billing period start date.
	BillingPeriodStartDate *time.Time

	// READ-ONLY; Billing Profile identifier.
	BillingProfileID *string

	// READ-ONLY; Billing Profile Name.
	BillingProfileName *string

	// READ-ONLY; Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund.
	ChargeType *string

	// READ-ONLY; Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value
	// is not provided for marketplace usage.
	ConsumedService *string

	// READ-ONLY; The amount of cost before tax.
	Cost *float64

	// READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string

	// READ-ONLY; Date for the usage record.
	Date *time.Time

	// READ-ONLY; Effective Price that's charged for the usage.
	EffectivePrice *float64

	// READ-ONLY; Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees
	// which recur every month, and UsageBased for charges based on how much a service is used.
	Frequency *string

	// READ-ONLY; Invoice Section Name.
	InvoiceSection *string

	// READ-ONLY; Is Azure Credit Eligible.
	IsAzureCreditEligible *bool

	// READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetailsResponse

	// READ-ONLY; The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter
	// for which the reservation was purchased. For the actual VM Size for which the reservation is
	// purchased see productOrderName.
	MeterID *string

	// READ-ONLY; Offer Id. Ex: MS-AZR-0017P, MS-AZR-0148P.
	OfferID *string

	// READ-ONLY; Part Number of the service used. Can be used to join with the price sheet. Not available for marketplace.
	PartNumber *string

	// READ-ONLY; Retail price for the resource.
	PayGPrice *float64

	// READ-ONLY; Plan Name.
	PlanName *string

	// READ-ONLY; Identifier that indicates how the meter is priced.
	PricingModel *PricingModelType

	// READ-ONLY; Product name for the consumed service or purchase. Not available for Marketplace.
	Product *string

	// READ-ONLY; Product Order Id. For reservations this is the Reservation Order ID.
	ProductOrderID *string

	// READ-ONLY; Product Order Name. For reservations this is the SKU that was purchased.
	ProductOrderName *string

	// READ-ONLY; Publisher Name.
	PublisherName *string

	// READ-ONLY; Publisher Type.
	PublisherType *string

	// READ-ONLY; The usage quantity.
	Quantity *float64

	// READ-ONLY; ARM resource id of the reservation. Only applies to records relevant to reservations.
	ReservationID *string

	// READ-ONLY; User provided display name of the reservation. Last known name for a particular day is populated in the daily
	// data. Only applies to records relevant to reservations.
	ReservationName *string

	// READ-ONLY; Resource Group Name.
	ResourceGroup *string

	// READ-ONLY; Unique identifier of the Azure Resource Manager usage detail resource.
	ResourceID *string

	// READ-ONLY; Resource Location.
	ResourceLocation *string

	// READ-ONLY; Resource Name.
	ResourceName *string

	// READ-ONLY; Service-specific metadata.
	ServiceInfo1 *string

	// READ-ONLY; Legacy field with optional service-specific metadata.
	ServiceInfo2 *string

	// READ-ONLY; Subscription guid.
	SubscriptionID *string

	// READ-ONLY; Subscription name.
	SubscriptionName *string

	// READ-ONLY; Term (in months). 1 month for monthly recurring purchase. 12 months for a 1 year reservation. 36 months for
	// a 3 year reservation.
	Term *string

	// READ-ONLY; Unit Price is the price applicable to you. (your EA or other contract price).
	UnitPrice *float64
}

// LotProperties - The lot properties.
type LotProperties struct {
	// READ-ONLY; The billing currency of the lot.
	BillingCurrency *string

	// READ-ONLY; The balance as of the last invoice.
	ClosedBalance *Amount

	// READ-ONLY; The balance as of the last invoice in billing currency.
	ClosedBalanceInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The currency of the lot.
	CreditCurrency *string

	// READ-ONLY; The eTag for the resource.
	ETag *string

	// READ-ONLY; The expiration date of a lot.
	ExpirationDate *time.Time

	// READ-ONLY; The original amount of a lot.
	OriginalAmount *Amount

	// READ-ONLY; The original amount of a lot in billing currency.
	OriginalAmountInBillingCurrency *AmountWithExchangeRate

	// READ-ONLY; The po number of the invoice on which the lot was added. This property is not available for ConsumptionCommitment
	// lots.
	PoNumber *string

	// READ-ONLY; The date when the lot was added.
	PurchasedDate *time.Time

	// READ-ONLY; The reseller of the lot.
	Reseller *Reseller

	// READ-ONLY; The source of the lot.
	Source *LotSource

	// READ-ONLY; The date when the lot became effective.
	StartDate *time.Time

	// READ-ONLY; The status of the lot.
	Status *Status
}

// LotSummary - A lot summary resource.
type LotSummary struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The lot properties.
	Properties *LotProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// Lots - Result of listing lot summary.
type Lots struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of lot summary.
	Value []*LotSummary
}

// ManagementGroupAggregatedCostProperties - The properties of the Management Group Aggregated Cost.
type ManagementGroupAggregatedCostProperties struct {
	// Children of a management group
	Children []*ManagementGroupAggregatedCostResult

	// List of subscription Guids excluded from the calculation of aggregated cost
	ExcludedSubscriptions []*string

	// List of subscription Guids included in the calculation of aggregated cost
	IncludedSubscriptions []*string

	// READ-ONLY; Azure Charges.
	AzureCharges *float64

	// READ-ONLY; The id of the billing period resource that the aggregated cost belongs to.
	BillingPeriodID *string

	// READ-ONLY; Charges Billed Separately.
	ChargesBilledSeparately *float64

	// READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string

	// READ-ONLY; Marketplace Charges.
	MarketplaceCharges *float64

	// READ-ONLY; The end of the date time range covered by the aggregated cost.
	UsageEnd *time.Time

	// READ-ONLY; The start of the date time range covered by aggregated cost.
	UsageStart *time.Time
}

// ManagementGroupAggregatedCostResult - A management group aggregated cost resource.
type ManagementGroupAggregatedCostResult struct {
	// The properties of the Management Group Aggregated Cost.
	Properties *ManagementGroupAggregatedCostProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// Marketplace - A marketplace resource.
type Marketplace struct {
	// The properties of the marketplace usage detail.
	Properties *MarketplaceProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// MarketplaceProperties - The properties of the marketplace usage detail.
type MarketplaceProperties struct {
	// READ-ONLY; Account name.
	AccountName *string

	// READ-ONLY; Additional information.
	AdditionalInfo *string

	// READ-ONLY; Additional details of this usage item. By default this is not populated, unless it's specified in $expand.
	AdditionalProperties *string

	// READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string

	// READ-ONLY; The quantity of usage.
	ConsumedQuantity *float64

	// READ-ONLY; Consumed service name.
	ConsumedService *string

	// READ-ONLY; The cost center of this department if it is a department and a costcenter exists
	CostCenter *string

	// READ-ONLY; The ISO currency in which the meter is charged, for example, USD.
	Currency *string

	// READ-ONLY; Department name.
	DepartmentName *string

	// READ-ONLY; The uri of the resource instance that the usage is about.
	InstanceID *string

	// READ-ONLY; The name of the resource instance that the usage is about.
	InstanceName *string

	// READ-ONLY; The estimated usage is subject to change.
	IsEstimated *bool

	// READ-ONLY; Flag indicating whether this is a recurring charge or not.
	IsRecurringCharge *bool

	// READ-ONLY; The meter id (GUID).
	MeterID *string

	// READ-ONLY; The type of offer.
	OfferName *string

	// READ-ONLY; The order number.
	OrderNumber *string

	// READ-ONLY; The name of plan.
	PlanName *string

	// READ-ONLY; The amount of cost before tax.
	PretaxCost *float64

	// READ-ONLY; The name of publisher.
	PublisherName *string

	// READ-ONLY; The name of resource group.
	ResourceGroup *string

	// READ-ONLY; The marketplace resource rate.
	ResourceRate *float64

	// READ-ONLY; Subscription guid.
	SubscriptionGUID *string

	// READ-ONLY; Subscription name.
	SubscriptionName *string

	// READ-ONLY; The unit of measure.
	UnitOfMeasure *string

	// READ-ONLY; The end of the date time range covered by the usage detail.
	UsageEnd *time.Time

	// READ-ONLY; The start of the date time range covered by the usage detail.
	UsageStart *time.Time
}

// MarketplacesListResult - Result of listing marketplaces. It contains a list of available marketplaces in reverse chronological
// order by billing period.
type MarketplacesListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of marketplaces.
	Value []*Marketplace
}

// MeterDetails - The properties of the meter detail.
type MeterDetails struct {
	// READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string

	// READ-ONLY; The location in which the Azure service is available.
	MeterLocation *string

	// READ-ONLY; The name of the meter, within the given meter category
	MeterName *string

	// READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string

	// READ-ONLY; The pretax listing price.
	PretaxStandardRate *float64

	// READ-ONLY; The name of the service.
	ServiceName *string

	// READ-ONLY; The service tier.
	ServiceTier *string

	// READ-ONLY; The total included quantity associated with the offer.
	TotalIncludedQuantity *float64

	// READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	Unit *string
}

// MeterDetailsResponse - The properties of the meter detail.
type MeterDetailsResponse struct {
	// READ-ONLY; The category of the meter, for example, 'Cloud services', 'Networking', etc..
	MeterCategory *string

	// READ-ONLY; The name of the meter, within the given meter category
	MeterName *string

	// READ-ONLY; The subcategory of the meter, for example, 'A6 Cloud services', 'ExpressRoute (IXP)', etc..
	MeterSubCategory *string

	// READ-ONLY; The service family.
	ServiceFamily *string

	// READ-ONLY; The unit in which the meter consumption is charged, for example, 'Hours', 'GB', etc.
	UnitOfMeasure *string
}

// ModernChargeSummary - Modern charge summary.
type ModernChargeSummary struct {
	// REQUIRED; Specifies the kind of charge summary.
	Kind *ChargeSummaryKind

	// REQUIRED; Properties for modern charge summary
	Properties *ModernChargeSummaryProperties

	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// GetChargeSummary implements the ChargeSummaryClassification interface for type ModernChargeSummary.
func (m *ModernChargeSummary) GetChargeSummary() *ChargeSummary {
	return &ChargeSummary{
		ETag: m.ETag,
		ID:   m.ID,
		Kind: m.Kind,
		Name: m.Name,
		Type: m.Type,
	}
}

// ModernChargeSummaryProperties - The properties of modern charge summary.
type ModernChargeSummaryProperties struct {
	// READ-ONLY; Azure Charges.
	AzureCharges *Amount

	// READ-ONLY; Billing Account Id
	BillingAccountID *string

	// READ-ONLY; The id of the billing period resource that the charge belongs to.
	BillingPeriodID *string

	// READ-ONLY; Billing Profile Id
	BillingProfileID *string

	// READ-ONLY; Charges Billed separately.
	ChargesBilledSeparately *Amount

	// READ-ONLY; Customer Id
	CustomerID *string

	// READ-ONLY; Invoice Section Id
	InvoiceSectionID *string

	// READ-ONLY; Is charge Invoiced
	IsInvoiced *bool

	// READ-ONLY; Marketplace Charges.
	MarketplaceCharges *Amount

	// READ-ONLY; Usage end date.
	UsageEnd *string

	// READ-ONLY; Usage start date.
	UsageStart *string
}

// ModernReservationRecommendation - Modern reservation recommendation.
type ModernReservationRecommendation struct {
	// REQUIRED; Specifies the kind of reservation recommendation.
	Kind *ReservationRecommendationKind

	// REQUIRED; Properties for modern reservation recommendation
	Properties *ModernReservationRecommendationProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; Resource location
	Location *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource sku
	SKU *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// GetReservationRecommendation implements the ReservationRecommendationClassification interface for type ModernReservationRecommendation.
func (m *ModernReservationRecommendation) GetReservationRecommendation() *ReservationRecommendation {
	return &ReservationRecommendation{
		Etag:     m.Etag,
		ID:       m.ID,
		Kind:     m.Kind,
		Location: m.Location,
		Name:     m.Name,
		SKU:      m.SKU,
		Tags:     m.Tags,
		Type:     m.Type,
	}
}

// ModernReservationRecommendationProperties - The properties of the reservation recommendation.
type ModernReservationRecommendationProperties struct {
	// READ-ONLY; The total amount of cost without reserved instances.
	CostWithNoReservedInstances *Amount

	// READ-ONLY; The usage date for looking back.
	FirstUsageDate *time.Time

	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *float32

	// READ-ONLY; Resource Location.
	Location *string

	// READ-ONLY; The number of days of usage to look back for recommendation.
	LookBackPeriod *int32

	// READ-ONLY; The meter id (GUID)
	MeterID *string

	// READ-ONLY; Total estimated savings with reserved instances.
	NetSavings *Amount

	// READ-ONLY; The normalized Size.
	NormalizedSize *string

	// READ-ONLY; Recommended quality for reserved instances.
	RecommendedQuantity *float64

	// READ-ONLY; The recommended Quantity Normalized.
	RecommendedQuantityNormalized *float32

	// READ-ONLY; This is the ARM Sku name.
	SKUName *string

	// READ-ONLY; List of sku properties
	SKUProperties []*SKUProperty

	// READ-ONLY; Shared or single recommendation.
	Scope *string

	// READ-ONLY; RI recommendations in one or three year terms.
	Term *string

	// READ-ONLY; The total amount of cost with reserved instances.
	TotalCostWithReservedInstances *Amount
}

// ModernReservationTransaction - Modern Reservation transaction resource.
type ModernReservationTransaction struct {
	// REQUIRED; The properties of a modern reservation transaction.
	Properties *ModernReservationTransactionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource tags.
	Tags []*string

	// READ-ONLY; Resource type.
	Type *string
}

// ModernReservationTransactionProperties - The properties of a modern reservation transaction.
type ModernReservationTransactionProperties struct {
	// READ-ONLY; The charge of the transaction.
	Amount *float64

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	ArmSKUName *string

	// READ-ONLY; The billing frequency, which can be either one-time or recurring.
	BillingFrequency *string

	// READ-ONLY; Billing profile Id.
	BillingProfileID *string

	// READ-ONLY; Billing profile name.
	BillingProfileName *string

	// READ-ONLY; The ISO currency in which the transaction is charged, for example, USD.
	Currency *string

	// READ-ONLY; The description of the transaction.
	Description *string

	// READ-ONLY; The date of the transaction
	EventDate *time.Time

	// READ-ONLY; The type of the transaction (Purchase, Cancel, etc.)
	EventType *string

	// READ-ONLY; Invoice Number
	Invoice *string

	// READ-ONLY; Invoice Id as on the invoice where the specific transaction appears.
	InvoiceID *string

	// READ-ONLY; Invoice Section Id
	InvoiceSectionID *string

	// READ-ONLY; Invoice Section Name.
	InvoiceSectionName *string

	// READ-ONLY; The subscription guid that makes the transaction.
	PurchasingSubscriptionGUID *string

	// READ-ONLY; The subscription name that makes the transaction.
	PurchasingSubscriptionName *string

	// READ-ONLY; The quantity of the transaction.
	Quantity *float64

	// READ-ONLY; The region of the transaction.
	Region *string

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string

	// READ-ONLY; The name of the reservation order.
	ReservationOrderName *string

	// READ-ONLY; This is the term of the transaction.
	Term *string
}

// ModernReservationTransactionsListResult - Result of listing reservation recommendations.
type ModernReservationTransactionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of reservation recommendations.
	Value []*ModernReservationTransaction
}

// ModernUsageDetail - Modern usage detail.
type ModernUsageDetail struct {
	// REQUIRED; Specifies the kind of usage details.
	Kind *UsageDetailsKind

	// REQUIRED; Properties for modern usage details
	Properties *ModernUsageDetailProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// GetUsageDetail implements the UsageDetailClassification interface for type ModernUsageDetail.
func (m *ModernUsageDetail) GetUsageDetail() *UsageDetail {
	return &UsageDetail{
		Etag: m.Etag,
		ID:   m.ID,
		Kind: m.Kind,
		Name: m.Name,
		Tags: m.Tags,
		Type: m.Type,
	}
}

// ModernUsageDetailProperties - The properties of the usage detail.
type ModernUsageDetailProperties struct {
	// READ-ONLY; Additional details of this usage item. Use this field to get usage line item specific details such as the actual
	// VM Size (ServiceType) or the ratio in which the reservation discount is applied.
	AdditionalInfo *string

	// READ-ONLY; Unique identifier for the applicable benefit.
	BenefitID *string

	// READ-ONLY; Name of the applicable benefit.
	BenefitName *string

	// READ-ONLY; Billing Account identifier.
	BillingAccountID *string

	// READ-ONLY; Name of the Billing Account.
	BillingAccountName *string

	// READ-ONLY; The currency defining the billed cost.
	BillingCurrencyCode *string

	// READ-ONLY; Billing Period End Date as in the invoice.
	BillingPeriodEndDate *time.Time

	// READ-ONLY; Billing Period Start Date as in the invoice.
	BillingPeriodStartDate *time.Time

	// READ-ONLY; Identifier for the billing profile that groups costs across invoices in the a singular billing currency across
	// across the customers who have onboarded the Microsoft customer agreement and the
	// customers in CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc.
	BillingProfileID *string

	// READ-ONLY; Name of the billing profile that groups costs across invoices in the a singular billing currency across across
	// the customers who have onboarded the Microsoft customer agreement and the customers in
	// CSP who have made entitlement purchases like SaaS, Marketplace, RI, etc.
	BillingProfileName *string

	// READ-ONLY; Indicates a charge represents credits, usage, a Marketplace purchase, a reservation fee, or a refund.
	ChargeType *string

	// READ-ONLY; Consumed service name. Name of the azure resource provider that emits the usage or was purchased. This value
	// is not provided for marketplace usage.
	ConsumedService *string

	// READ-ONLY; Name for Cost Allocation Rule.
	CostAllocationRuleName *string

	// READ-ONLY; The cost center of this department if it is a department and a cost center is provided.
	CostCenter *string

	// READ-ONLY; ExtendedCost or blended cost before tax in billed currency.
	CostInBillingCurrency *float64

	// READ-ONLY; ExtendedCost or blended cost before tax in pricing currency to correlate with prices.
	CostInPricingCurrency *float64

	// READ-ONLY; Estimated extendedCost or blended cost before tax in USD.
	CostInUSD *float64

	// READ-ONLY; Name of the customer's AAD tenant.
	CustomerName *string

	// READ-ONLY; Identifier of the customer's AAD tenant.
	CustomerTenantID *string

	// READ-ONLY; Date for the usage record.
	Date *time.Time

	// READ-ONLY; Effective Price that's charged for the usage.
	EffectivePrice *float64

	// READ-ONLY; Exchange rate used in conversion from pricing currency to billing currency.
	ExchangeRate *string

	// READ-ONLY; Date on which exchange rate used in conversion from pricing currency to billing currency.
	ExchangeRateDate *time.Time

	// READ-ONLY; Exchange Rate from pricing currency to billing currency.
	ExchangeRatePricingToBilling *float64

	// READ-ONLY; Indicates how frequently this charge will occur. OneTime for purchases which only happen once, Monthly for fees
	// which recur every month, and UsageBased for charges based on how much a service is used.
	Frequency *string

	// READ-ONLY; Instance Name.
	InstanceName *string

	// READ-ONLY; Invoice ID as on the invoice where the specific transaction appears.
	InvoiceID *string

	// READ-ONLY; Identifier of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements
	// onboarded by partners.
	InvoiceSectionID *string

	// READ-ONLY; Name of the project that is being charged in the invoice. Not applicable for Microsoft Customer Agreements onboarded
	// by partners.
	InvoiceSectionName *string

	// READ-ONLY; Determines if the cost is eligible to be paid for using Azure credits.
	IsAzureCreditEligible *bool

	// READ-ONLY; Market Price that's charged for the usage.
	MarketPrice *float64

	// READ-ONLY; Identifies the top-level service for the usage.
	MeterCategory *string

	// READ-ONLY; The meter id (GUID). Not available for marketplace. For reserved instance this represents the primary meter
	// for which the reservation was purchased. For the actual VM Size for which the reservation is
	// purchased see productOrderName.
	MeterID *string

	// READ-ONLY; Identifies the name of the meter against which consumption is measured.
	MeterName *string

	// READ-ONLY; Identifies the location of the datacenter for certain services that are priced based on datacenter location.
	MeterRegion *string

	// READ-ONLY; Defines the type or sub-category of Azure service that can affect the rate.
	MeterSubCategory *string

	// READ-ONLY; Flag to indicate if partner earned credit has been applied or not.
	PartnerEarnedCreditApplied *string

	// READ-ONLY; Rate of discount applied if there is a partner earned credit (PEC) based on partner admin link access.
	PartnerEarnedCreditRate *float64

	// READ-ONLY; Name of the partner' AAD tenant.
	PartnerName *string

	// READ-ONLY; Identifier for the partner's AAD tenant.
	PartnerTenantID *string

	// READ-ONLY; Retail price for the resource.
	PayGPrice *float64

	// READ-ONLY; The amount of PayG cost before tax in billing currency.
	PaygCostInBillingCurrency *float64

	// READ-ONLY; The amount of PayG cost before tax in US Dollar currency.
	PaygCostInUSD *float64

	// READ-ONLY; Reference to an original invoice there is a refund (negative cost). This is populated only when there is a refund.
	PreviousInvoiceID *string

	// READ-ONLY; Pricing Billing Currency.
	PricingCurrencyCode *string

	// READ-ONLY; Identifier that indicates how the meter is priced
	PricingModel *PricingModelType

	// READ-ONLY; Name of the product that has accrued charges by consumption or purchase as listed in the invoice. Not available
	// for Marketplace.
	Product *string

	// READ-ONLY; Identifier for the product that has accrued charges by consumption or purchase . This is the concatenated key
	// of productId and SkuId in partner center.
	ProductIdentifier *string

	// READ-ONLY; The identifier for the asset or Azure plan name that the subscription belongs to. For example: Azure Plan. For
	// reservations this is the Reservation Order ID.
	ProductOrderID *string

	// READ-ONLY; Product Order Name. For reservations this is the SKU that was purchased.
	ProductOrderName *string

	// READ-ONLY; Identifier for Product Category or Line Of Business, Ex - Azure, Microsoft 365, AWS e.t.c
	Provider *string

	// READ-ONLY; Publisher Id.
	PublisherID *string

	// READ-ONLY; Name of the publisher of the service including Microsoft or Third Party publishers.
	PublisherName *string

	// READ-ONLY; Type of publisher that identifies if the publisher is first party, third party reseller or third party agency.
	PublisherType *string

	// READ-ONLY; Measure the quantity purchased or consumed.The amount of the meter used during the billing period.
	Quantity *float64

	// READ-ONLY; MPNId for the reseller associated with the subscription.
	ResellerMpnID *string

	// READ-ONLY; Reseller Name.
	ResellerName *string

	// READ-ONLY; ARM resource id of the reservation. Only applies to records relevant to reservations.
	ReservationID *string

	// READ-ONLY; User provided display name of the reservation. Last known name for a particular day is populated in the daily
	// data. Only applies to records relevant to reservations.
	ReservationName *string

	// READ-ONLY; Name of the Azure resource group used for cohesive lifecycle management of resources.
	ResourceGroup *string

	// READ-ONLY; Name of the resource location.
	ResourceLocation *string

	// READ-ONLY; Resource Location Normalized.
	ResourceLocationNormalized *string

	// READ-ONLY; List the service family for the product purchased or charged (Example: Storage ; Compute).
	ServiceFamily *string

	// READ-ONLY; Service-specific metadata.
	ServiceInfo1 *string

	// READ-ONLY; Legacy field with optional service-specific metadata.
	ServiceInfo2 *string

	// READ-ONLY; End date for the period when the service usage was rated for charges. The prices for Azure services are determined
	// based on the rating period.
	ServicePeriodEndDate *time.Time

	// READ-ONLY; Start date for the rating period when the service usage was rated for charges. The prices for Azure services
	// are determined for the rating period.
	ServicePeriodStartDate *time.Time

	// READ-ONLY; Unique Microsoft generated identifier for the Azure Subscription.
	SubscriptionGUID *string

	// READ-ONLY; Name of the Azure Subscription.
	SubscriptionName *string

	// READ-ONLY; Term (in months). Displays the term for the validity of the offer. For example. In case of reserved instances
	// it displays 12 months for yearly term of reserved instance. For one time purchases or
	// recurring purchases, the terms displays 1 month; This is not applicable for Azure consumption.
	Term *string

	// READ-ONLY; Identifies the Unit that the service is charged in. For example, GB, hours, 10,000 s.
	UnitOfMeasure *string

	// READ-ONLY; Unit Price is the price applicable to you. (your EA or other contract price).
	UnitPrice *float64
}

// Notification - The notification associated with a budget.
type Notification struct {
	// REQUIRED; Email addresses to send the budget notification to when the threshold is exceeded. Must have at least one contact
	// email or contact group specified at the Subscription or Resource Group scopes. All
	// other scopes must have at least one contact email specified.
	ContactEmails []*string

	// REQUIRED; The notification is enabled or not.
	Enabled *bool

	// REQUIRED; The comparison operator.
	Operator *OperatorType

	// REQUIRED; Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It
	// is always percent and has to be between 0 and 1000.
	Threshold *float64

	// Action groups to send the budget notification to when the threshold is exceeded. Must be provided as a fully qualified
	// Azure resource id. Only supported at Subscription or Resource Group scopes.
	ContactGroups []*string

	// Contact roles to send the budget notification to when the threshold is exceeded.
	ContactRoles []*string

	// Language in which the recipient will receive the notification
	Locale *CultureCode

	// The type of threshold
	ThresholdType *ThresholdType
}

// Operation - A Consumption REST API operation.
type Operation struct {
	// The object that represents the operation.
	Display *OperationDisplay

	// READ-ONLY; Operation Id.
	ID *string

	// READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of the operation.
	Description *string

	// READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string

	// READ-ONLY; Service provider: Microsoft.Consumption.
	Provider *string

	// READ-ONLY; Resource on which the operation is performed: UsageDetail, etc.
	Resource *string
}

// OperationListResult - Result of listing consumption operations. It contains a list of operations and a URL link to get
// the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string

	// READ-ONLY; List of consumption operations supported by the Microsoft.Consumption resource provider.
	Value []*Operation
}

// PriceSheetModel - price sheet result. It contains the pricesheet associated with billing period
type PriceSheetModel struct {
	// READ-ONLY; Pricesheet download details.
	Download *MeterDetails

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; Price sheet
	Pricesheets []*PriceSheetProperties
}

// PriceSheetProperties - The properties of the price sheet.
type PriceSheetProperties struct {
	// READ-ONLY; The id of the billing period resource that the usage belongs to.
	BillingPeriodID *string

	// READ-ONLY; Currency Code
	CurrencyCode *string

	// READ-ONLY; Included quality for an offer
	IncludedQuantity *float64

	// READ-ONLY; The details about the meter. By default this is not populated, unless it's specified in $expand.
	MeterDetails *MeterDetails

	// READ-ONLY; The meter id (GUID)
	MeterID *string

	// READ-ONLY; Offer Id
	OfferID *string

	// READ-ONLY; Part Number
	PartNumber *string

	// READ-ONLY; Unit of measure
	UnitOfMeasure *string

	// READ-ONLY; Unit Price
	UnitPrice *float64
}

// PriceSheetResult - An pricesheet resource.
type PriceSheetResult struct {
	// price sheet result. It contains the pricesheet associated with billing period
	Properties *PriceSheetModel

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// ProxyResource - The Resource model definition.
type ProxyResource struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// Reseller - The reseller properties.
type Reseller struct {
	// READ-ONLY; The reseller property description.
	ResellerDescription *string

	// READ-ONLY; The reseller property ID.
	ResellerID *string
}

// ReservationDetail - reservation detail resource.
type ReservationDetail struct {
	// The properties of the reservation detail.
	Properties *ReservationDetailProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// ReservationDetailProperties - The properties of the reservation detail.
type ReservationDetailProperties struct {
	// READ-ONLY; The instance Flexibility Group.
	InstanceFlexibilityGroup *string

	// READ-ONLY; The instance Flexibility Ratio.
	InstanceFlexibilityRatio *string

	// READ-ONLY; This identifier is the name of the resource or the fully qualified Resource ID.
	InstanceID *string

	// READ-ONLY; The reservation kind.
	Kind *string

	// READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping
	// for applying the benefit scope and also specifies the number of instances to which
	// the reservation benefit can be applied to.
	ReservationID *string

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string

	// READ-ONLY; This is the total hours reserved for the day. E.g. if reservation for 1 instance was made on 1 PM, this will
	// be 11 hours for that day and 24 hours from subsequent days.
	ReservedHours *float64

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SKUName *string

	// READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *float64

	// READ-ONLY; The date on which consumption occurred.
	UsageDate *time.Time

	// READ-ONLY; This is the total hours used by the instance.
	UsedHours *float64
}

// ReservationDetailsListResult - Result of listing reservation details.
type ReservationDetailsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of reservation details.
	Value []*ReservationDetail
}

// ReservationRecommendation - A reservation recommendation resource.
type ReservationRecommendation struct {
	// REQUIRED; Specifies the kind of reservation recommendation.
	Kind *ReservationRecommendationKind

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; Resource location
	Location *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource sku
	SKU *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// GetReservationRecommendation implements the ReservationRecommendationClassification interface for type ReservationRecommendation.
func (r *ReservationRecommendation) GetReservationRecommendation() *ReservationRecommendation {
	return r
}

// ReservationRecommendationDetailsCalculatedSavingsProperties - Details of estimated savings.
type ReservationRecommendationDetailsCalculatedSavingsProperties struct {
	// The number of reserved units used to calculate savings. Always 1 for virtual machines.
	ReservedUnitCount *float32

	// READ-ONLY; The cost without reservation.
	OnDemandCost *float32

	// READ-ONLY; The difference between total reservation cost and reservation cost.
	OverageCost *float32

	// READ-ONLY; The quantity for calculated savings.
	Quantity *float32

	// READ-ONLY; The exact cost of the estimated usage using reservation.
	ReservationCost *float32

	// READ-ONLY; The amount saved by purchasing the recommended quantity of reservation.
	Savings *float32

	// READ-ONLY; The cost of the suggested quantity.
	TotalReservationCost *float32
}

// ReservationRecommendationDetailsModel - Reservation recommendation details.
type ReservationRecommendationDetailsModel struct {
	// Resource Location.
	Location *string

	// The properties of the reservation recommendation.
	Properties *ReservationRecommendationDetailsProperties

	// Resource sku
	SKU *string

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// ReservationRecommendationDetailsProperties - The properties of the reservation recommendation.
type ReservationRecommendationDetailsProperties struct {
	// READ-ONLY; An ISO 4217 currency code identifier for the costs and savings
	Currency *string

	// READ-ONLY; Resource specific properties.
	Resource *ReservationRecommendationDetailsResourceProperties

	// READ-ONLY; Resource Group.
	ResourceGroup *string

	// READ-ONLY; Savings information for the recommendation.
	Savings *ReservationRecommendationDetailsSavingsProperties

	// READ-ONLY; Scope of the reservation, ex: Single or Shared.
	Scope *string

	// READ-ONLY; Historical usage details used to calculate the estimated savings.
	Usage *ReservationRecommendationDetailsUsageProperties
}

// ReservationRecommendationDetailsResourceProperties - Details of the resource.
type ReservationRecommendationDetailsResourceProperties struct {
	// READ-ONLY; List of subscriptions for which the reservation is applied.
	AppliedScopes []*string

	// READ-ONLY; On demand rate of the resource.
	OnDemandRate *float32

	// READ-ONLY; Azure product ex: StandardE8sv3 etc.
	Product *string

	// READ-ONLY; Azure resource region ex:EastUS, WestUS etc.
	Region *string

	// READ-ONLY; Reservation rate of the resource.
	ReservationRate *float32

	// READ-ONLY; The azure resource type.
	ResourceType *string
}

// ReservationRecommendationDetailsSavingsProperties - Details of the estimated savings.
type ReservationRecommendationDetailsSavingsProperties struct {
	// List of calculated savings.
	CalculatedSavings []*ReservationRecommendationDetailsCalculatedSavingsProperties

	// READ-ONLY; Number of days of usage to look back used for computing the recommendation.
	LookBackPeriod *int32

	// READ-ONLY; Number of recommended units of the resource.
	RecommendedQuantity *float32

	// READ-ONLY; Term period of the reservation, ex: P1Y or P3Y.
	ReservationOrderTerm *string

	// READ-ONLY; Type of savings, ex: instance.
	SavingsType *string

	// READ-ONLY; Measurement unit ex: hour etc.
	UnitOfMeasure *string
}

// ReservationRecommendationDetailsUsageProperties - Details about historical usage data that has been used for computing
// the recommendation.
type ReservationRecommendationDetailsUsageProperties struct {
	// READ-ONLY; The first usage date used for looking back for computing the recommendation.
	FirstConsumptionDate *string

	// READ-ONLY; The last usage date used for looking back for computing the recommendation.
	LastConsumptionDate *string

	// READ-ONLY; What the usage data values represent ex: virtual machine instance.
	LookBackUnitType *string

	// READ-ONLY; The breakdown of historical resource usage. The values are in the order of usage between the firstConsumptionDate
	// and the lastConsumptionDate.
	UsageData []*float32

	// READ-ONLY; The grain of the values represented in the usage data ex: hourly.
	UsageGrain *string
}

// ReservationRecommendationsListResult - Result of listing reservation recommendations.
type ReservationRecommendationsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The link (url) to the previous page of results.
	PreviousLink *string

	// READ-ONLY; The list of reservation recommendations.
	Value []ReservationRecommendationClassification
}

// ReservationSummariesListResult - Result of listing reservation summaries.
type ReservationSummariesListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of reservation summaries.
	Value []*ReservationSummary
}

// ReservationSummary - reservation summary resource.
type ReservationSummary struct {
	// The properties of the reservation summary.
	Properties *ReservationSummaryProperties

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// ReservationSummaryProperties - The properties of the reservation summary.
type ReservationSummaryProperties struct {
	// READ-ONLY; This is average utilization for the entire time range. (day or month depending on the grain)
	AvgUtilizationPercentage *float64

	// READ-ONLY; The reservation kind.
	Kind *string

	// READ-ONLY; This is the maximum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to
	// 12/10/2017 and on that for hour 4 and 5, utilization was 100%, this field will return 100%
	// for that day.
	MaxUtilizationPercentage *float64

	// READ-ONLY; This is the minimum hourly utilization in the usage time (day or month). E.g. if usage record corresponds to
	// 12/10/2017 and on that for hour 4 and 5, utilization was 10%, this field will return 10%
	// for that day
	MinUtilizationPercentage *float64

	// READ-ONLY; This is the purchased quantity for the reservationId.
	PurchasedQuantity *float64

	// READ-ONLY; This is the remaining quantity for the reservationId.
	RemainingQuantity *float64

	// READ-ONLY; The reservation ID is the identifier of a reservation within a reservation order. Each reservation is the grouping
	// for applying the benefit scope and also specifies the number of instances to which
	// the reservation benefit can be applied to.
	ReservationID *string

	// READ-ONLY; The reservation order ID is the identifier for a reservation purchase. Each reservation order ID represents
	// a single purchase transaction. A reservation order contains reservations. The reservation
	// order specifies the VM size and region for the reservations.
	ReservationOrderID *string

	// READ-ONLY; This is the total hours reserved. E.g. if reservation for 1 instance was made on 1 PM, this will be 11 hours
	// for that day and 24 hours from subsequent days
	ReservedHours *float64

	// READ-ONLY; This is the ARM Sku name. It can be used to join with the serviceType field in additional info in usage records.
	SKUName *string

	// READ-ONLY; This is the total count of instances that are reserved for the reservationId.
	TotalReservedQuantity *float64

	// READ-ONLY; Data corresponding to the utilization record. If the grain of data is monthly, it will be first day of month.
	UsageDate *time.Time

	// READ-ONLY; Total used hours by the reservation
	UsedHours *float64

	// READ-ONLY; This is the used quantity for the reservationId.
	UsedQuantity *float64

	// READ-ONLY; This is the utilized percentage for the reservation Id.
	UtilizedPercentage *float64
}

// ReservationTransaction - Reservation transaction resource.
type ReservationTransaction struct {
	// The properties of a legacy reservation transaction.
	Properties *LegacyReservationTransactionProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource tags.
	Tags []*string

	// READ-ONLY; Resource type.
	Type *string
}

// ReservationTransactionResource - The Resource model definition.
type ReservationTransactionResource struct {
	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource tags.
	Tags []*string

	// READ-ONLY; Resource type.
	Type *string
}

// ReservationTransactionsListResult - Result of listing reservation recommendations.
type ReservationTransactionsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of reservation recommendations.
	Value []*ReservationTransaction
}

// Resource - The Resource model definition.
type Resource struct {
	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// ResourceAttributes - The Resource model definition.
type ResourceAttributes struct {
	// READ-ONLY; Resource location
	Location *string

	// READ-ONLY; Resource sku
	SKU *string
}

// SKUProperty - The Sku property
type SKUProperty struct {
	// READ-ONLY; The name of sku property.
	Name *string

	// READ-ONLY; The value of sku property.
	Value *string
}

// Tag - The tag resource.
type Tag struct {
	// Tag key.
	Key *string

	// Tag values.
	Value []*string
}

// TagProperties - The properties of the tag.
type TagProperties struct {
	// A list of Tag.
	Tags []*Tag

	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The link (url) to the previous page of results.
	PreviousLink *string
}

// TagsResult - A resource listing all tags.
type TagsResult struct {
	// eTag of the resource. To handle concurrent update scenario, this field will be used to determine whether the user is updating
	// the latest version or not.
	ETag *string

	// The properties of the tag.
	Properties *TagProperties

	// READ-ONLY; Resource Id.
	ID *string

	// READ-ONLY; Resource name.
	Name *string

	// READ-ONLY; Resource type.
	Type *string
}

// UsageDetail - An usage detail resource.
type UsageDetail struct {
	// REQUIRED; Specifies the kind of usage details.
	Kind *UsageDetailsKind

	// READ-ONLY; The etag for the resource.
	Etag *string

	// READ-ONLY; The full qualified ARM ID of an event.
	ID *string

	// READ-ONLY; The ID that uniquely identifies an event.
	Name *string

	// READ-ONLY; Resource tags.
	Tags map[string]*string

	// READ-ONLY; Resource type.
	Type *string
}

// GetUsageDetail implements the UsageDetailClassification interface for type UsageDetail.
func (u *UsageDetail) GetUsageDetail() *UsageDetail { return u }

// UsageDetailsListResult - Result of listing usage details. It contains a list of available usage details in reverse chronological
// order by billing period.
type UsageDetailsListResult struct {
	// READ-ONLY; The link (url) to the next page of results.
	NextLink *string

	// READ-ONLY; The list of usage details.
	Value []UsageDetailClassification
}
