//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservicefleet

import "time"

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info any

	// READ-ONLY; The additional info type.
	Type *string
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo

	// READ-ONLY; The error code.
	Code *string

	// READ-ONLY; The error details.
	Details []*ErrorDetail

	// READ-ONLY; The error message.
	Message *string

	// READ-ONLY; The error target.
	Target *string
}

// Fleet - The Fleet resource.
type Fleet struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Managed identity.
	Identity *ManagedServiceIdentity

	// The resource-specific properties for this resource.
	Properties *FleetProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.
	// Entity tags are used for comparing two or more entities from the same requested resource.
	// HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
	// (section 14.27) header fields.
	ETag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FleetCredentialResult - One credential result item.
type FleetCredentialResult struct {
	// READ-ONLY; The name of the credential.
	Name *string

	// READ-ONLY; Base64-encoded Kubernetes configuration file.
	Value []byte
}

// FleetCredentialResults - The Credential results response.
type FleetCredentialResults struct {
	// READ-ONLY; Array of base64-encoded Kubernetes configuration files.
	Kubeconfigs []*FleetCredentialResult
}

// FleetListResult - The response of a Fleet list operation.
type FleetListResult struct {
	// REQUIRED; The Fleet items on this page
	Value []*Fleet

	// The link to the next page of items
	NextLink *string
}

// FleetMember - A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
type FleetMember struct {
	// The resource-specific properties for this resource.
	Properties *FleetMemberProperties

	// READ-ONLY; If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.
	// Entity tags are used for comparing two or more entities from the same requested resource.
	// HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
	// (section 14.27) header fields.
	ETag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FleetMemberListResult - The response of a FleetMember list operation.
type FleetMemberListResult struct {
	// REQUIRED; The FleetMember items on this page
	Value []*FleetMember

	// The link to the next page of items
	NextLink *string
}

// FleetMemberProperties - A member of the Fleet. It contains a reference to an existing Kubernetes cluster on Azure.
type FleetMemberProperties struct {
	// REQUIRED; The ARM resource id of the cluster that joins the Fleet. Must be a valid Azure resource id. e.g.:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/managedClusters/{clusterName}'.
	ClusterResourceID *string

	// The group this member belongs to for multi-cluster update management.
	Group *string

	// READ-ONLY; The status of the last operation.
	ProvisioningState *FleetMemberProvisioningState
}

// FleetMemberUpdate - The type used for update operations of the FleetMember.
type FleetMemberUpdate struct {
	// The updatable properties of the FleetMember.
	Properties *FleetMemberUpdateProperties
}

// FleetMemberUpdateProperties - The updatable properties of the FleetMember.
type FleetMemberUpdateProperties struct {
	// The group this member belongs to for multi-cluster update management.
	Group *string
}

// FleetPatch - Properties of a Fleet that can be patched.
type FleetPatch struct {
	// Managed identity.
	Identity *ManagedServiceIdentity

	// Resource tags.
	Tags map[string]*string
}

// FleetProperties - Fleet properties.
type FleetProperties struct {
	// READ-ONLY; The status of the last operation.
	ProvisioningState *FleetProvisioningState
}

// FleetUpdateStrategy - Defines a multi-stage process to perform update operations across members of a Fleet.
type FleetUpdateStrategy struct {
	// The resource-specific properties for this resource.
	Properties *FleetUpdateStrategyProperties

	// READ-ONLY; If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.
	// Entity tags are used for comparing two or more entities from the same requested resource.
	// HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
	// (section 14.27) header fields.
	ETag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FleetUpdateStrategyListResult - The response of a FleetUpdateStrategy list operation.
type FleetUpdateStrategyListResult struct {
	// REQUIRED; The FleetUpdateStrategy items on this page
	Value []*FleetUpdateStrategy

	// The link to the next page of items
	NextLink *string
}

// FleetUpdateStrategyProperties - The properties of the UpdateStrategy.
type FleetUpdateStrategyProperties struct {
	// REQUIRED; Defines the update sequence of the clusters.
	Strategy *UpdateRunStrategy

	// READ-ONLY; The provisioning state of the UpdateStrategy resource.
	ProvisioningState *FleetUpdateStrategyProvisioningState
}

// ManagedClusterUpdate - The update to be applied to the ManagedClusters.
type ManagedClusterUpdate struct {
	// REQUIRED; The upgrade to apply to the ManagedClusters.
	Upgrade *ManagedClusterUpgradeSpec

	// The node image upgrade to be applied to the target nodes in update run.
	NodeImageSelection *NodeImageSelection
}

// ManagedClusterUpgradeSpec - The upgrade to apply to a ManagedCluster.
type ManagedClusterUpgradeSpec struct {
	// REQUIRED; The upgrade type. Full requires the KubernetesVersion property to be set. NodeImageOnly requires the KubernetesVersion
	// property not to be set.
	Type *ManagedClusterUpgradeType

	// The Kubernetes version to upgrade the member clusters to.
	KubernetesVersion *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MemberUpdateStatus - The status of a member update operation.
type MemberUpdateStatus struct {
	// READ-ONLY; The Azure resource id of the target Kubernetes cluster.
	ClusterResourceID *string

	// READ-ONLY; The status message after processing the member update operation.
	Message *string

	// READ-ONLY; The name of the FleetMember.
	Name *string

	// READ-ONLY; The operation resource id of the latest attempt to perform the operation.
	OperationID *string

	// READ-ONLY; The status of the MemberUpdate operation.
	Status *UpdateStatus
}

// NodeImageSelection - The node image upgrade to be applied to the target nodes in update run.
type NodeImageSelection struct {
	// REQUIRED; The node image upgrade type.
	Type *NodeImageSelectionType
}

// NodeImageSelectionStatus - The node image upgrade specs for the update run.
type NodeImageSelectionStatus struct {
	// READ-ONLY; The image versions to upgrade the nodes to.
	SelectedNodeImageVersions []*NodeImageVersion
}

// NodeImageVersion - The node upgrade image version.
type NodeImageVersion struct {
	// READ-ONLY; The image version to upgrade the nodes to (e.g., 'AKSUbuntu-1804gen2containerd-2022.12.13').
	Version *string
}

// Operation - Details of a REST API operation, returned from the Resource Provider Operations API
type Operation struct {
	// Localized display information for this particular operation.
	Display *OperationDisplay

	// READ-ONLY; Enum. Indicates the action type. "Internal" refers to actions that are for internal only APIs.
	ActionType *ActionType

	// READ-ONLY; Whether the operation applies to data-plane. This is "true" for data-plane operations and "false" for ARM/control-plane
	// operations.
	IsDataAction *bool

	// READ-ONLY; The name of the operation, as per Resource-Based Access Control (RBAC). Examples: "Microsoft.Compute/virtualMachines/write",
	// "Microsoft.Compute/virtualMachines/capture/action"
	Name *string

	// READ-ONLY; The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit logs UX. Default
	// value is "user,system"
	Origin *Origin
}

// OperationDisplay - Localized display information for this particular operation.
type OperationDisplay struct {
	// READ-ONLY; The short, localized friendly description of the operation; suitable for tool tips and detailed views.
	Description *string

	// READ-ONLY; The concise, localized friendly name for the operation; suitable for dropdowns. E.g. "Create or Update Virtual
	// Machine", "Restart Virtual Machine".
	Operation *string

	// READ-ONLY; The localized friendly form of the resource provider name, e.g. "Microsoft Monitoring Insights" or "Microsoft
	// Compute".
	Provider *string

	// READ-ONLY; The localized friendly name of the resource type related to this operation. E.g. "Virtual Machines" or "Job
	// Schedule Collections".
	Resource *string
}

// OperationListResult - A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to
// get the next set of results.
type OperationListResult struct {
	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string

	// READ-ONLY; List of operations supported by the resource provider
	Value []*Operation
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UpdateGroup - A group to be updated.
type UpdateGroup struct {
	// REQUIRED; Name of the group. It must match a group name of an existing fleet member.
	Name *string
}

// UpdateGroupStatus - The status of a UpdateGroup.
type UpdateGroupStatus struct {
	// READ-ONLY; The list of member this UpdateGroup updates.
	Members []*MemberUpdateStatus

	// READ-ONLY; The name of the UpdateGroup.
	Name *string

	// READ-ONLY; The status of the UpdateGroup.
	Status *UpdateStatus
}

// UpdateRun - A multi-stage process to perform update operations across members of a Fleet.
type UpdateRun struct {
	// The resource-specific properties for this resource.
	Properties *UpdateRunProperties

	// READ-ONLY; If eTag is provided in the response body, it may also be provided as a header per the normal etag convention.
	// Entity tags are used for comparing two or more entities from the same requested resource.
	// HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range
	// (section 14.27) header fields.
	ETag *string

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// UpdateRunListResult - The response of a UpdateRun list operation.
type UpdateRunListResult struct {
	// REQUIRED; The UpdateRun items on this page
	Value []*UpdateRun

	// The link to the next page of items
	NextLink *string
}

// UpdateRunProperties - The properties of the UpdateRun.
type UpdateRunProperties struct {
	// REQUIRED; The update to be applied to all clusters in the UpdateRun. The managedClusterUpdate can be modified until the
	// run is started.
	ManagedClusterUpdate *ManagedClusterUpdate

	// The strategy defines the order in which the clusters will be updated. If not set, all members will be updated sequentially.
	// The UpdateRun status will show a single UpdateStage and a single UpdateGroup
	// targeting all members. The strategy of the UpdateRun can be modified until the run is started.
	Strategy *UpdateRunStrategy

	// The resource id of the FleetUpdateStrategy resource to reference.
	// When creating a new run, there are three ways to define a strategy for the run:
	// 1. Define a new strategy in place: Set the "strategy" field.
	// 2. Use an existing strategy: Set the "updateStrategyId" field. (since 2023-08-15-preview)
	// 3. Use the default strategy to update all the members one by one: Leave both "updateStrategyId" and "strategy" unset. (since
	// 2023-08-15-preview)
	// Setting both "updateStrategyId" and "strategy" is invalid.
	// UpdateRuns created by "updateStrategyId" snapshot the referenced UpdateStrategy at the time of creation and store it in
	// the "strategy" field. Subsequent changes to the referenced FleetUpdateStrategy
	// resource do not propagate. UpdateRunStrategy changes can be made directly on the "strategy" field before launching the
	// UpdateRun.
	UpdateStrategyID *string

	// READ-ONLY; The provisioning state of the UpdateRun resource.
	ProvisioningState *UpdateRunProvisioningState

	// READ-ONLY; The status of the UpdateRun.
	Status *UpdateRunStatus
}

// UpdateRunStatus - The status of a UpdateRun.
type UpdateRunStatus struct {
	// READ-ONLY; The node image upgrade specs for the update run. It is only set in update run when NodeImageSelection.type is
	// Consistent.
	NodeImageSelection *NodeImageSelectionStatus

	// READ-ONLY; The stages composing an update run. Stages are run sequentially withing an UpdateRun.
	Stages []*UpdateStageStatus

	// READ-ONLY; The status of the UpdateRun.
	Status *UpdateStatus
}

// UpdateRunStrategy - Defines the update sequence of the clusters via stages and groups.
// Stages within a run are executed sequentially one after another. Groups within a stage are executed in parallel. Member
// clusters within a group are updated sequentially one after another.
// A valid strategy contains no duplicate groups within or across stages.
type UpdateRunStrategy struct {
	// REQUIRED; The list of stages that compose this update run. Min size: 1.
	Stages []*UpdateStage
}

// UpdateStage - Defines a stage which contains the groups to update and the steps to take (e.g., wait for a time period)
// before starting the next stage.
type UpdateStage struct {
	// REQUIRED; The name of the stage. Must be unique within the UpdateRun.
	Name *string

	// The time in seconds to wait at the end of this stage before starting the next one. Defaults to 0 seconds if unspecified.
	AfterStageWaitInSeconds *int32

	// Defines the groups to be executed in parallel in this stage. Duplicate groups are not allowed. Min size: 1.
	Groups []*UpdateGroup
}

// UpdateStageStatus - The status of a UpdateStage.
type UpdateStageStatus struct {
	// READ-ONLY; The status of the wait period configured on the UpdateStage.
	AfterStageWaitStatus *WaitStatus

	// READ-ONLY; The list of groups to be updated as part of this UpdateStage.
	Groups []*UpdateGroupStatus

	// READ-ONLY; The name of the UpdateStage.
	Name *string

	// READ-ONLY; The status of the UpdateStage.
	Status *UpdateStatus
}

// UpdateStatus - The status for an operation or group of operations.
type UpdateStatus struct {
	// READ-ONLY; The time the operation or group was completed.
	CompletedTime *time.Time

	// READ-ONLY; The error details when a failure is encountered.
	Error *ErrorDetail

	// READ-ONLY; The time the operation or group was started.
	StartTime *time.Time

	// READ-ONLY; The State of the operation or group.
	State *UpdateState
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// WaitStatus - The status of the wait duration.
type WaitStatus struct {
	// READ-ONLY; The status of the wait duration.
	Status *UpdateStatus

	// READ-ONLY; The wait duration configured in seconds.
	WaitDurationInSeconds *int32
}
