//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetworkanalytics_test

import (
	"context"
	"log"

	"time"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/networkanalytics/armnetworkanalytics"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListBySubscription_MaximumSet_Gen.json
func ExampleDataProductsClient_NewListBySubscriptionPager_dataProductsListBySubscriptionMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataProductsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataProductListResult = armnetworkanalytics.DataProductListResult{
		// 	Value: []*armnetworkanalytics.DataProduct{
		// 		{
		// 			Name: to.Ptr("dataproduct01"),
		// 			Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
		// 			SystemData: &armnetworkanalytics.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
		// 				CreatedBy: to.Ptr("abc@micros.com"),
		// 				CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("abc@micros.com"),
		// 				LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
		// 			},
		// 			Identity: &armnetworkanalytics.ManagedServiceIdentity{
		// 				Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityType("IdentityType")),
		// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
		// 					"key8474": &armnetworkanalytics.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armnetworkanalytics.DataProductProperties{
		// 				AvailableMinorVersions: []*string{
		// 					to.Ptr("1.0.1"),
		// 					to.Ptr("1.0.2")},
		// 					ConsumptionEndpoints: &armnetworkanalytics.ConsumptionEndpointsProperties{
		// 						FileAccessResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
		// 						FileAccessURL: to.Ptr("https://operatorinsightsstorageResourceName.blob.core.windows.net"),
		// 						IngestionResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
		// 						IngestionURL: to.Ptr("https://aoiingestionstorageResourceName.blob.core.windows.net"),
		// 						QueryResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Kusto/clusters/clusterName"),
		// 						QueryURL: to.Ptr("https://opinsightsclusterName.regionName.kusto.windows.net"),
		// 					},
		// 					CurrentMinorVersion: to.Ptr("1.0.1"),
		// 					CustomerEncryptionKey: &armnetworkanalytics.EncryptionKeyDetails{
		// 						KeyName: to.Ptr("keyName"),
		// 						KeyVaultURI: to.Ptr("https://KeyVault.vault.azure.net"),
		// 						KeyVersion: to.Ptr("keyVersion"),
		// 					},
		// 					CustomerManagedKeyEncryptionEnabled: to.Ptr(armnetworkanalytics.ControlStateEnabled),
		// 					Documentation: to.Ptr("https://learn.microsoft.com/"),
		// 					KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
		// 					MajorVersion: to.Ptr("1.0.0"),
		// 					ManagedResourceGroupConfiguration: &armnetworkanalytics.ManagedResourceGroupConfiguration{
		// 						Name: to.Ptr("managedResourceGroupName"),
		// 						Location: to.Ptr("eastus"),
		// 					},
		// 					Networkacls: &armnetworkanalytics.DataProductNetworkACLs{
		// 						AllowedQueryIPRangeList: []*string{
		// 							to.Ptr("1.1.1.1"),
		// 							to.Ptr("1.1.1.2")},
		// 							DefaultAction: to.Ptr(armnetworkanalytics.DefaultActionAllow),
		// 							IPRules: []*armnetworkanalytics.IPRules{
		// 								{
		// 									Action: to.Ptr("Allow"),
		// 									Value: to.Ptr("1.1.1.1"),
		// 							}},
		// 							VirtualNetworkRule: []*armnetworkanalytics.VirtualNetworkRule{
		// 								{
		// 									Action: to.Ptr("Allow"),
		// 									ID: to.Ptr("/subscriptions/subscriptionId/resourcegroups/resourceGroupName/providers/Microsoft.Network/virtualNetworks/virtualNetworkName/subnets/subnetName"),
		// 									State: to.Ptr("Succeeded"),
		// 							}},
		// 						},
		// 						Owners: []*string{
		// 							to.Ptr("abc@micros.com")},
		// 							PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
		// 							Product: to.Ptr("MCC"),
		// 							ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
		// 							PublicNetworkAccess: to.Ptr(armnetworkanalytics.ControlStateEnabled),
		// 							Publisher: to.Ptr("Microsoft"),
		// 							PurviewAccount: to.Ptr("testpurview"),
		// 							PurviewCollection: to.Ptr("134567890"),
		// 							Redundancy: to.Ptr(armnetworkanalytics.ControlStateDisabled),
		// 							ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListBySubscription_MinimumSet_Gen.json
func ExampleDataProductsClient_NewListBySubscriptionPager_dataProductsListBySubscriptionMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataProductsClient().NewListBySubscriptionPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataProductListResult = armnetworkanalytics.DataProductListResult{
		// 	Value: []*armnetworkanalytics.DataProduct{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
		// 			Location: to.Ptr("eastus"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListByResourceGroup_MaximumSet_Gen.json
func ExampleDataProductsClient_NewListByResourceGroupPager_dataProductsListByResourceGroupMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataProductsClient().NewListByResourceGroupPager("aoiresourceGroupName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataProductListResult = armnetworkanalytics.DataProductListResult{
		// 	Value: []*armnetworkanalytics.DataProduct{
		// 		{
		// 			Name: to.Ptr("dataproduct01"),
		// 			Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts"),
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
		// 			SystemData: &armnetworkanalytics.SystemData{
		// 				CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
		// 				CreatedBy: to.Ptr("abc@micros.com"),
		// 				CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
		// 				LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
		// 				LastModifiedBy: to.Ptr("abc@micros.com"),
		// 				LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
		// 			},
		// 			Location: to.Ptr("eastus"),
		// 			Tags: map[string]*string{
		// 				"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
		// 			},
		// 			Identity: &armnetworkanalytics.ManagedServiceIdentity{
		// 				Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityType("IdentityType")),
		// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 				UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
		// 					"key8474": &armnetworkanalytics.UserAssignedIdentity{
		// 						ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 					},
		// 				},
		// 			},
		// 			Properties: &armnetworkanalytics.DataProductProperties{
		// 				AvailableMinorVersions: []*string{
		// 					to.Ptr("1.0.1"),
		// 					to.Ptr("1.0.2")},
		// 					ConsumptionEndpoints: &armnetworkanalytics.ConsumptionEndpointsProperties{
		// 						FileAccessResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
		// 						FileAccessURL: to.Ptr("https://operatorinsightsstorageResourceName.blob.core.windows.net"),
		// 						IngestionResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
		// 						IngestionURL: to.Ptr("https://aoiingestionstorageResourceName.blob.core.windows.net"),
		// 						QueryResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Kusto/clusters/clusterName"),
		// 						QueryURL: to.Ptr("https://opinsightsclusterName.regionName.kusto.windows.net"),
		// 					},
		// 					CurrentMinorVersion: to.Ptr("1.0.1"),
		// 					CustomerEncryptionKey: &armnetworkanalytics.EncryptionKeyDetails{
		// 						KeyName: to.Ptr("keyName"),
		// 						KeyVaultURI: to.Ptr("https://KeyVault.vault.azure.net"),
		// 						KeyVersion: to.Ptr("keyVersion"),
		// 					},
		// 					CustomerManagedKeyEncryptionEnabled: to.Ptr(armnetworkanalytics.ControlStateEnabled),
		// 					Documentation: to.Ptr("https://learn.microsoft.com/"),
		// 					KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
		// 					MajorVersion: to.Ptr("1.0.0"),
		// 					ManagedResourceGroupConfiguration: &armnetworkanalytics.ManagedResourceGroupConfiguration{
		// 						Name: to.Ptr("managedResourceGroupName"),
		// 						Location: to.Ptr("eastus"),
		// 					},
		// 					Networkacls: &armnetworkanalytics.DataProductNetworkACLs{
		// 						AllowedQueryIPRangeList: []*string{
		// 							to.Ptr("1.1.1.1"),
		// 							to.Ptr("1.1.1.2")},
		// 							DefaultAction: to.Ptr(armnetworkanalytics.DefaultActionAllow),
		// 							IPRules: []*armnetworkanalytics.IPRules{
		// 								{
		// 									Action: to.Ptr("Allow"),
		// 									Value: to.Ptr("1.1.1.1"),
		// 							}},
		// 							VirtualNetworkRule: []*armnetworkanalytics.VirtualNetworkRule{
		// 								{
		// 									Action: to.Ptr("Allow"),
		// 									ID: to.Ptr("/subscriptions/subscriptionId/resourcegroups/resourceGroupName/providers/Microsoft.Network/virtualNetworks/virtualNetworkName/subnets/subnetName"),
		// 									State: to.Ptr("Succeeded"),
		// 							}},
		// 						},
		// 						Owners: []*string{
		// 							to.Ptr("abc@micros.com")},
		// 							PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
		// 							Product: to.Ptr("MCC"),
		// 							ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
		// 							PublicNetworkAccess: to.Ptr(armnetworkanalytics.ControlStateEnabled),
		// 							Publisher: to.Ptr("Microsoft"),
		// 							PurviewAccount: to.Ptr("testpurview"),
		// 							PurviewCollection: to.Ptr("134567890"),
		// 							Redundancy: to.Ptr(armnetworkanalytics.ControlStateDisabled),
		// 							ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
		// 						},
		// 				}},
		// 			}
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListByResourceGroup_MinimumSet_Gen.json
func ExampleDataProductsClient_NewListByResourceGroupPager_dataProductsListByResourceGroupMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewDataProductsClient().NewListByResourceGroupPager("aoiresourceGroupName", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.DataProductListResult = armnetworkanalytics.DataProductListResult{
		// 	Value: []*armnetworkanalytics.DataProduct{
		// 		{
		// 			ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
		// 			Location: to.Ptr("eastus"),
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Get_MaximumSet_Gen.json
func ExampleDataProductsClient_Get_dataProductsGetMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().Get(ctx, "aoiresourceGroupName", "dataproduct01", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataProduct = armnetworkanalytics.DataProduct{
	// 	Name: to.Ptr("dataproduct01"),
	// 	Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
	// 	SystemData: &armnetworkanalytics.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		CreatedBy: to.Ptr("abc@micros.com"),
	// 		CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("abc@micros.com"),
	// 		LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
	// 	},
	// 	Identity: &armnetworkanalytics.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityType("IdentityType")),
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
	// 			"key8474": &armnetworkanalytics.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnetworkanalytics.DataProductProperties{
	// 		AvailableMinorVersions: []*string{
	// 			to.Ptr("1.0.1"),
	// 			to.Ptr("1.0.2")},
	// 			ConsumptionEndpoints: &armnetworkanalytics.ConsumptionEndpointsProperties{
	// 				FileAccessResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
	// 				FileAccessURL: to.Ptr("https://operatorinsightsstorageResourceName.blob.core.windows.net"),
	// 				IngestionResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
	// 				IngestionURL: to.Ptr("https://aoiingestionstorageResourceName.blob.core.windows.net"),
	// 				QueryResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Kusto/clusters/clusterName"),
	// 				QueryURL: to.Ptr("https://opinsightsclusterName.regionName.kusto.windows.net"),
	// 			},
	// 			CurrentMinorVersion: to.Ptr("1.0.1"),
	// 			CustomerEncryptionKey: &armnetworkanalytics.EncryptionKeyDetails{
	// 				KeyName: to.Ptr("keyName"),
	// 				KeyVaultURI: to.Ptr("https://KeyVault.vault.azure.net"),
	// 				KeyVersion: to.Ptr("keyVersion"),
	// 			},
	// 			CustomerManagedKeyEncryptionEnabled: to.Ptr(armnetworkanalytics.ControlStateEnabled),
	// 			Documentation: to.Ptr("https://learn.microsoft.com/"),
	// 			KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
	// 			MajorVersion: to.Ptr("1.0.0"),
	// 			ManagedResourceGroupConfiguration: &armnetworkanalytics.ManagedResourceGroupConfiguration{
	// 				Name: to.Ptr("managedResourceGroupName"),
	// 				Location: to.Ptr("eastus"),
	// 			},
	// 			Networkacls: &armnetworkanalytics.DataProductNetworkACLs{
	// 				AllowedQueryIPRangeList: []*string{
	// 					to.Ptr("1.1.1.1"),
	// 					to.Ptr("1.1.1.2")},
	// 					DefaultAction: to.Ptr(armnetworkanalytics.DefaultActionAllow),
	// 					IPRules: []*armnetworkanalytics.IPRules{
	// 						{
	// 							Action: to.Ptr("Allow"),
	// 							Value: to.Ptr("1.1.1.1"),
	// 					}},
	// 					VirtualNetworkRule: []*armnetworkanalytics.VirtualNetworkRule{
	// 						{
	// 							Action: to.Ptr("Allow"),
	// 							ID: to.Ptr("/subscriptions/subscriptionId/resourcegroups/resourceGroupName/providers/Microsoft.Network/virtualNetworks/virtualNetworkName/subnets/subnetName"),
	// 							State: to.Ptr("Succeeded"),
	// 					}},
	// 				},
	// 				Owners: []*string{
	// 					to.Ptr("abc@micros.com")},
	// 					PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
	// 					Product: to.Ptr("MCC"),
	// 					ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr(armnetworkanalytics.ControlStateEnabled),
	// 					Publisher: to.Ptr("Microsoft"),
	// 					PurviewAccount: to.Ptr("testpurview"),
	// 					PurviewCollection: to.Ptr("134567890"),
	// 					Redundancy: to.Ptr(armnetworkanalytics.ControlStateDisabled),
	// 					ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Get_MinimumSet_Gen.json
func ExampleDataProductsClient_Get_dataProductsGetMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().Get(ctx, "aoiresourceGroupName", "dataproduct01", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataProduct = armnetworkanalytics.DataProduct{
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
	// 	Location: to.Ptr("eastus"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Create_MaximumSet_Gen.json
func ExampleDataProductsClient_BeginCreate_dataProductsCreateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataProductsClient().BeginCreate(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.DataProduct{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
		},
		Identity: &armnetworkanalytics.ManagedServiceIdentity{
			Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
				"/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Properties: &armnetworkanalytics.DataProductProperties{
			ConsumptionEndpoints: &armnetworkanalytics.ConsumptionEndpointsProperties{},
			CurrentMinorVersion:  to.Ptr("1.0.1"),
			CustomerEncryptionKey: &armnetworkanalytics.EncryptionKeyDetails{
				KeyName:     to.Ptr("keyName"),
				KeyVaultURI: to.Ptr("https://KeyVault.vault.azure.net"),
				KeyVersion:  to.Ptr("keyVersion"),
			},
			CustomerManagedKeyEncryptionEnabled: to.Ptr(armnetworkanalytics.ControlStateEnabled),
			MajorVersion:                        to.Ptr("1.0.0"),
			ManagedResourceGroupConfiguration: &armnetworkanalytics.ManagedResourceGroupConfiguration{
				Name:     to.Ptr("managedResourceGroupName"),
				Location: to.Ptr("eastus"),
			},
			Networkacls: &armnetworkanalytics.DataProductNetworkACLs{
				AllowedQueryIPRangeList: []*string{
					to.Ptr("1.1.1.1")},
				DefaultAction: to.Ptr(armnetworkanalytics.DefaultActionAllow),
				IPRules: []*armnetworkanalytics.IPRules{
					{
						Action: to.Ptr("Allow"),
						Value:  to.Ptr("1.1.1.1"),
					}},
				VirtualNetworkRule: []*armnetworkanalytics.VirtualNetworkRule{
					{
						Action: to.Ptr("Allow"),
						ID:     to.Ptr("/subscriptions/subscriptionId/resourcegroups/resourceGroupName/providers/Microsoft.Network/virtualNetworks/virtualNetworkName/subnets/subnetName"),
						State:  to.Ptr(""),
					}},
			},
			Owners: []*string{
				to.Ptr("abc@micros.com")},
			PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
			Product:             to.Ptr("MCC"),
			ProvisioningState:   to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
			PublicNetworkAccess: to.Ptr(armnetworkanalytics.ControlStateEnabled),
			Publisher:           to.Ptr("Microsoft"),
			PurviewAccount:      to.Ptr("testpurview"),
			PurviewCollection:   to.Ptr("134567890"),
			Redundancy:          to.Ptr(armnetworkanalytics.ControlStateDisabled),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataProduct = armnetworkanalytics.DataProduct{
	// 	Name: to.Ptr("dataproduct01"),
	// 	Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
	// 	SystemData: &armnetworkanalytics.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		CreatedBy: to.Ptr("abc@micros.com"),
	// 		CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("abc@micros.com"),
	// 		LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
	// 	},
	// 	Identity: &armnetworkanalytics.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityType("IdentityType")),
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
	// 			"key8474": &armnetworkanalytics.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnetworkanalytics.DataProductProperties{
	// 		AvailableMinorVersions: []*string{
	// 			to.Ptr("1.0.1"),
	// 			to.Ptr("1.0.2")},
	// 			ConsumptionEndpoints: &armnetworkanalytics.ConsumptionEndpointsProperties{
	// 				FileAccessResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
	// 				FileAccessURL: to.Ptr("https://operatorinsightsstorageResourceName.blob.core.windows.net"),
	// 				IngestionResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
	// 				IngestionURL: to.Ptr("https://aoiingestionstorageResourceName.blob.core.windows.net"),
	// 				QueryResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Kusto/clusters/clusterName"),
	// 				QueryURL: to.Ptr("https://opinsightsclusterName.regionName.kusto.windows.net"),
	// 			},
	// 			CurrentMinorVersion: to.Ptr("1.0.1"),
	// 			CustomerEncryptionKey: &armnetworkanalytics.EncryptionKeyDetails{
	// 				KeyName: to.Ptr("keyName"),
	// 				KeyVaultURI: to.Ptr("https://KeyVault.vault.azure.net"),
	// 				KeyVersion: to.Ptr("keyVersion"),
	// 			},
	// 			CustomerManagedKeyEncryptionEnabled: to.Ptr(armnetworkanalytics.ControlStateEnabled),
	// 			Documentation: to.Ptr("https://learn.microsoft.com/"),
	// 			KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
	// 			MajorVersion: to.Ptr("1.0.0"),
	// 			ManagedResourceGroupConfiguration: &armnetworkanalytics.ManagedResourceGroupConfiguration{
	// 				Name: to.Ptr("managedResourceGroupName"),
	// 				Location: to.Ptr("eastus"),
	// 			},
	// 			Networkacls: &armnetworkanalytics.DataProductNetworkACLs{
	// 				AllowedQueryIPRangeList: []*string{
	// 					to.Ptr("1.1.1.1"),
	// 					to.Ptr("1.1.1.2")},
	// 					DefaultAction: to.Ptr(armnetworkanalytics.DefaultActionAllow),
	// 					IPRules: []*armnetworkanalytics.IPRules{
	// 						{
	// 							Action: to.Ptr("Allow"),
	// 							Value: to.Ptr("1.1.1.1"),
	// 					}},
	// 					VirtualNetworkRule: []*armnetworkanalytics.VirtualNetworkRule{
	// 						{
	// 							Action: to.Ptr("Allow"),
	// 							ID: to.Ptr("/subscriptions/subscriptionId/resourcegroups/resourceGroupName/providers/Microsoft.Network/virtualNetworks/virtualNetworkName/subnets/subnetName"),
	// 							State: to.Ptr("Succeeded"),
	// 					}},
	// 				},
	// 				Owners: []*string{
	// 					to.Ptr("abc@micros.com")},
	// 					PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
	// 					Product: to.Ptr("MCC"),
	// 					ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr(armnetworkanalytics.ControlStateEnabled),
	// 					Publisher: to.Ptr("Microsoft"),
	// 					PurviewAccount: to.Ptr("testpurview"),
	// 					PurviewCollection: to.Ptr("134567890"),
	// 					Redundancy: to.Ptr(armnetworkanalytics.ControlStateDisabled),
	// 					ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Create_MinimumSet_Gen.json
func ExampleDataProductsClient_BeginCreate_dataProductsCreateMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataProductsClient().BeginCreate(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.DataProduct{
		Location: to.Ptr("eastus"),
		Tags: map[string]*string{
			"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
		},
		Properties: &armnetworkanalytics.DataProductProperties{
			MajorVersion: to.Ptr("1.0.0"),
			Product:      to.Ptr("MCC"),
			Publisher:    to.Ptr("Microsoft"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataProduct = armnetworkanalytics.DataProduct{
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
	// 	Location: to.Ptr("eastus"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Update_MaximumSet_Gen.json
func ExampleDataProductsClient_BeginUpdate_dataProductsUpdateMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataProductsClient().BeginUpdate(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.DataProductUpdate{
		Identity: &armnetworkanalytics.ManagedServiceIdentity{
			Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityTypeUserAssigned),
			UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
				"/subscriptions/subid/resourceGroups/resourceGroupName/providers/Microsoft.ManagedIdentity/userAssignedIdentities/id1": {},
			},
		},
		Properties: &armnetworkanalytics.DataProductUpdateProperties{
			CurrentMinorVersion: to.Ptr("1.0.1"),
			Owners: []*string{
				to.Ptr("abc@micros.com"),
				to.Ptr("def@micros.com")},
			PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
			PurviewAccount:      to.Ptr("testpurview"),
			PurviewCollection:   to.Ptr("134567890"),
		},
		Tags: map[string]*string{
			"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataProduct = armnetworkanalytics.DataProduct{
	// 	Name: to.Ptr("dataproduct01"),
	// 	Type: to.Ptr("Microsoft.NetworkAnalytics/DataProducts"),
	// 	ID: to.Ptr("/subscriptions/00000000-0000-0000-0000-00000000000/resourceGroups/aoiresourceGroupName/providers/Microsoft.NetworkAnalytics/DataProducts/dataproduct01"),
	// 	SystemData: &armnetworkanalytics.SystemData{
	// 		CreatedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		CreatedBy: to.Ptr("abc@micros.com"),
	// 		CreatedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 		LastModifiedAt: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-09-04T08:26:27.150Z"); return t}()),
	// 		LastModifiedBy: to.Ptr("abc@micros.com"),
	// 		LastModifiedByType: to.Ptr(armnetworkanalytics.CreatedByTypeUser),
	// 	},
	// 	Location: to.Ptr("eastus"),
	// 	Tags: map[string]*string{
	// 		"userSpecifiedKeyName": to.Ptr("userSpecifiedKeyValue"),
	// 	},
	// 	Identity: &armnetworkanalytics.ManagedServiceIdentity{
	// 		Type: to.Ptr(armnetworkanalytics.ManagedServiceIdentityType("IdentityType")),
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		TenantID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 		UserAssignedIdentities: map[string]*armnetworkanalytics.UserAssignedIdentity{
	// 			"key8474": &armnetworkanalytics.UserAssignedIdentity{
	// 				ClientID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 			},
	// 		},
	// 	},
	// 	Properties: &armnetworkanalytics.DataProductProperties{
	// 		AvailableMinorVersions: []*string{
	// 			to.Ptr("1.0.1"),
	// 			to.Ptr("1.0.2")},
	// 			ConsumptionEndpoints: &armnetworkanalytics.ConsumptionEndpointsProperties{
	// 				FileAccessResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
	// 				FileAccessURL: to.Ptr("https://operatorinsightsstorageResourceName.blob.core.windows.net"),
	// 				IngestionResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Storage/storageAccounts/storageResourceName"),
	// 				IngestionURL: to.Ptr("https://aoiingestionstorageResourceName.blob.core.windows.net"),
	// 				QueryResourceID: to.Ptr("/subscriptions/subscriptionId/resourceGroups/resourceGroupName/providers/Microsoft.Kusto/clusters/clusterName"),
	// 				QueryURL: to.Ptr("https://opinsightsclusterName.regionName.kusto.windows.net"),
	// 			},
	// 			CurrentMinorVersion: to.Ptr("1.0.1"),
	// 			CustomerEncryptionKey: &armnetworkanalytics.EncryptionKeyDetails{
	// 				KeyName: to.Ptr("keyName"),
	// 				KeyVaultURI: to.Ptr("https://KeyVault.vault.azure.net"),
	// 				KeyVersion: to.Ptr("keyVersion"),
	// 			},
	// 			CustomerManagedKeyEncryptionEnabled: to.Ptr(armnetworkanalytics.ControlStateEnabled),
	// 			Documentation: to.Ptr("https://learn.microsoft.com/"),
	// 			KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
	// 			MajorVersion: to.Ptr("1.0.0"),
	// 			ManagedResourceGroupConfiguration: &armnetworkanalytics.ManagedResourceGroupConfiguration{
	// 				Name: to.Ptr("managedResourceGroupName"),
	// 				Location: to.Ptr("eastus"),
	// 			},
	// 			Networkacls: &armnetworkanalytics.DataProductNetworkACLs{
	// 				AllowedQueryIPRangeList: []*string{
	// 					to.Ptr("1.1.1.1"),
	// 					to.Ptr("1.1.1.2")},
	// 					DefaultAction: to.Ptr(armnetworkanalytics.DefaultActionAllow),
	// 					IPRules: []*armnetworkanalytics.IPRules{
	// 						{
	// 							Action: to.Ptr("Allow"),
	// 							Value: to.Ptr("1.1.1.1"),
	// 					}},
	// 					VirtualNetworkRule: []*armnetworkanalytics.VirtualNetworkRule{
	// 						{
	// 							Action: to.Ptr("Allow"),
	// 							ID: to.Ptr("/subscriptions/subscriptionId/resourcegroups/resourceGroupName/providers/Microsoft.Network/virtualNetworks/virtualNetworkName/subnets/subnetName"),
	// 							State: to.Ptr("Succeeded"),
	// 					}},
	// 				},
	// 				Owners: []*string{
	// 					to.Ptr("abc@micros.com"),
	// 					to.Ptr("def@micros.com")},
	// 					PrivateLinksEnabled: to.Ptr(armnetworkanalytics.ControlStateDisabled),
	// 					Product: to.Ptr("MCC"),
	// 					ProvisioningState: to.Ptr(armnetworkanalytics.ProvisioningStateSucceeded),
	// 					PublicNetworkAccess: to.Ptr(armnetworkanalytics.ControlStateEnabled),
	// 					Publisher: to.Ptr("Microsoft"),
	// 					PurviewAccount: to.Ptr("testpurview"),
	// 					PurviewCollection: to.Ptr("134567890"),
	// 					Redundancy: to.Ptr(armnetworkanalytics.ControlStateDisabled),
	// 					ResourceGUID: to.Ptr("00000000-0000-0000-0000-000000000000"),
	// 				},
	// 			}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Update_MinimumSet_Gen.json
func ExampleDataProductsClient_BeginUpdate_dataProductsUpdateMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataProductsClient().BeginUpdate(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.DataProductUpdate{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.DataProduct = armnetworkanalytics.DataProduct{
	// 	Location: to.Ptr("jwlerdaudgxff"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Delete_MaximumSet_Gen.json
func ExampleDataProductsClient_BeginDelete_dataProductsDeleteMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataProductsClient().BeginDelete(ctx, "aoiresourceGroupName", "dataproduct01", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_Delete_MinimumSet_Gen.json
func ExampleDataProductsClient_BeginDelete_dataProductsDeleteMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewDataProductsClient().BeginDelete(ctx, "aoiresourceGroupName", "dataproduct01", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	_, err = poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_AddUserRole_MaximumSet_Gen.json
func ExampleDataProductsClient_AddUserRole_dataProductsAddUserRoleMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().AddUserRole(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.RoleAssignmentCommonProperties{
		DataTypeScope: []*string{
			to.Ptr("scope")},
		PrincipalID:   to.Ptr("00000000-0000-0000-0000-00000000000"),
		PrincipalType: to.Ptr("User"),
		Role:          to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
		RoleID:        to.Ptr("00000000-0000-0000-0000-00000000000"),
		UserName:      to.Ptr("UserName"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RoleAssignmentDetail = armnetworkanalytics.RoleAssignmentDetail{
	// 	DataTypeScope: []*string{
	// 		to.Ptr("scope")},
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 		PrincipalType: to.Ptr("User"),
	// 		Role: to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
	// 		RoleAssignmentID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 		RoleID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 		UserName: to.Ptr("UserName"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_AddUserRole_MinimumSet_Gen.json
func ExampleDataProductsClient_AddUserRole_dataProductsAddUserRoleMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().AddUserRole(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.RoleAssignmentCommonProperties{
		DataTypeScope: []*string{
			to.Ptr("scope")},
		PrincipalID:   to.Ptr("00000000-0000-0000-0000-00000000000"),
		PrincipalType: to.Ptr("User"),
		Role:          to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
		RoleID:        to.Ptr("00000000-0000-0000-0000-00000000000"),
		UserName:      to.Ptr("userName"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.RoleAssignmentDetail = armnetworkanalytics.RoleAssignmentDetail{
	// 	DataTypeScope: []*string{
	// 		to.Ptr("scope")},
	// 		PrincipalID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 		PrincipalType: to.Ptr("User"),
	// 		Role: to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
	// 		RoleAssignmentID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 		RoleID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 		UserName: to.Ptr("userName"),
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_GenerateStorageAccountSasToken_MaximumSet_Gen.json
func ExampleDataProductsClient_GenerateStorageAccountSasToken_dataProductsGenerateStorageAccountSasTokenMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().GenerateStorageAccountSasToken(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.AccountSas{
		ExpiryTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:34:58.151Z"); return t }()),
		IPAddress:       to.Ptr("1.1.1.1"),
		StartTimeStamp:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:34:58.151Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountSasToken = armnetworkanalytics.AccountSasToken{
	// 	StorageAccountSasToken: to.Ptr("storageAccountSasToken"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_GenerateStorageAccountSasToken_MinimumSet_Gen.json
func ExampleDataProductsClient_GenerateStorageAccountSasToken_dataProductsGenerateStorageAccountSasTokenMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().GenerateStorageAccountSasToken(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.AccountSas{
		ExpiryTimeStamp: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:35:17.051Z"); return t }()),
		IPAddress:       to.Ptr("1.1.1.1"),
		StartTimeStamp:  to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2023-08-24T05:35:17.051Z"); return t }()),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.AccountSasToken = armnetworkanalytics.AccountSasToken{
	// 	StorageAccountSasToken: to.Ptr("storageAccountSasToken"),
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListRolesAssignments_MaximumSet_Gen.json
func ExampleDataProductsClient_ListRolesAssignments_dataProductsListRolesAssignmentsMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().ListRolesAssignments(ctx, "aoiresourceGroupName", "dataproduct01", map[string]any{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListRoleAssignments = armnetworkanalytics.ListRoleAssignments{
	// 	Count: to.Ptr[int32](1),
	// 	RoleAssignmentResponse: []*armnetworkanalytics.RoleAssignmentDetail{
	// 		{
	// 			DataTypeScope: []*string{
	// 				to.Ptr("scope")},
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 				PrincipalType: to.Ptr("User"),
	// 				Role: to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
	// 				RoleAssignmentID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 				RoleID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 				UserName: to.Ptr("UserName"),
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_ListRolesAssignments_MinimumSet_Gen.json
func ExampleDataProductsClient_ListRolesAssignments_dataProductsListRolesAssignmentsMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewDataProductsClient().ListRolesAssignments(ctx, "aoiresourceGroupName", "dataproduct01", map[string]any{}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ListRoleAssignments = armnetworkanalytics.ListRoleAssignments{
	// 	Count: to.Ptr[int32](1),
	// 	RoleAssignmentResponse: []*armnetworkanalytics.RoleAssignmentDetail{
	// 		{
	// 			DataTypeScope: []*string{
	// 				to.Ptr("scope")},
	// 				PrincipalID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 				PrincipalType: to.Ptr("User"),
	// 				Role: to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
	// 				RoleAssignmentID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 				RoleID: to.Ptr("00000000-0000-0000-0000-00000000000"),
	// 				UserName: to.Ptr("UserName"),
	// 		}},
	// 	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RemoveUserRole_MaximumSet_Gen.json
func ExampleDataProductsClient_RemoveUserRole_dataProductsRemoveUserRoleMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDataProductsClient().RemoveUserRole(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.RoleAssignmentDetail{
		DataTypeScope: []*string{
			to.Ptr("scope")},
		PrincipalID:      to.Ptr("00000000-0000-0000-0000-00000000000"),
		PrincipalType:    to.Ptr("User"),
		Role:             to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
		RoleAssignmentID: to.Ptr("00000000-0000-0000-0000-00000000000"),
		RoleID:           to.Ptr("00000000-0000-0000-0000-00000000000"),
		UserName:         to.Ptr("UserName"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RemoveUserRole_MinimumSet_Gen.json
func ExampleDataProductsClient_RemoveUserRole_dataProductsRemoveUserRoleMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDataProductsClient().RemoveUserRole(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.RoleAssignmentDetail{
		DataTypeScope: []*string{
			to.Ptr("scope")},
		PrincipalID:      to.Ptr("00000000-0000-0000-0000-00000000000"),
		PrincipalType:    to.Ptr("User"),
		Role:             to.Ptr(armnetworkanalytics.DataProductUserRoleReader),
		RoleAssignmentID: to.Ptr("00000000-0000-0000-0000-00000000000"),
		RoleID:           to.Ptr("00000000-0000-0000-0000-00000000000"),
		UserName:         to.Ptr("UserName"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RotateKey_MaximumSet_Gen.json
func ExampleDataProductsClient_RotateKey_dataProductsRotateKeyMaximumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDataProductsClient().RotateKey(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.KeyVaultInfo{
		KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/db9788dde7a0c2c0d82e4fdf5f7b4de3843937e3/specification/networkanalytics/resource-manager/Microsoft.NetworkAnalytics/stable/2023-11-15/examples/DataProducts_RotateKey_MinimumSet_Gen.json
func ExampleDataProductsClient_RotateKey_dataProductsRotateKeyMaximumSetGenGeneratedByMinimumSetRuleMinimumSetGen() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetworkanalytics.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewDataProductsClient().RotateKey(ctx, "aoiresourceGroupName", "dataproduct01", armnetworkanalytics.KeyVaultInfo{
		KeyVaultURL: to.Ptr("https://myKeyVault.vault.azure.net"),
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}
