//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/trafficmanager/armtrafficmanager"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// HeatMapServer is a fake server for instances of the armtrafficmanager.HeatMapClient type.
type HeatMapServer struct {
	// Get is the fake for method HeatMapClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, profileName string, options *armtrafficmanager.HeatMapClientGetOptions) (resp azfake.Responder[armtrafficmanager.HeatMapClientGetResponse], errResp azfake.ErrorResponder)
}

// NewHeatMapServerTransport creates a new instance of HeatMapServerTransport with the provided implementation.
// The returned HeatMapServerTransport instance is connected to an instance of armtrafficmanager.HeatMapClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewHeatMapServerTransport(srv *HeatMapServer) *HeatMapServerTransport {
	return &HeatMapServerTransport{srv: srv}
}

// HeatMapServerTransport connects instances of armtrafficmanager.HeatMapClient to instances of HeatMapServer.
// Don't use this type directly, use NewHeatMapServerTransport instead.
type HeatMapServerTransport struct {
	srv *HeatMapServer
}

// Do implements the policy.Transporter interface for HeatMapServerTransport.
func (h *HeatMapServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "HeatMapClient.Get":
		resp, err = h.dispatchGet(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (h *HeatMapServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if h.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Network/trafficmanagerprofiles/(?P<profileName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/heatMaps/(?P<heatMapType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	qp := req.URL.Query()
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	profileNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("profileName")])
	if err != nil {
		return nil, err
	}
	topLeftUnescaped, err := url.QueryUnescape(qp.Get("topLeft"))
	if err != nil {
		return nil, err
	}
	topLeftElements := splitHelper(topLeftUnescaped, ",")
	topLeftParam := make([]float64, len(topLeftElements))
	for i := 0; i < len(topLeftElements); i++ {
		parsedFloat64, parseErr := strconv.ParseFloat(topLeftElements[i], 64)
		if parseErr != nil {
			return nil, parseErr
		}
		topLeftParam[i] = float64(parsedFloat64)
	}
	botRightUnescaped, err := url.QueryUnescape(qp.Get("botRight"))
	if err != nil {
		return nil, err
	}
	botRightElements := splitHelper(botRightUnescaped, ",")
	botRightParam := make([]float64, len(botRightElements))
	for i := 0; i < len(botRightElements); i++ {
		parsedFloat64, parseErr := strconv.ParseFloat(botRightElements[i], 64)
		if parseErr != nil {
			return nil, parseErr
		}
		botRightParam[i] = float64(parsedFloat64)
	}
	var options *armtrafficmanager.HeatMapClientGetOptions
	if len(topLeftParam) > 0 || len(botRightParam) > 0 {
		options = &armtrafficmanager.HeatMapClientGetOptions{
			TopLeft:  topLeftParam,
			BotRight: botRightParam,
		}
	}
	respr, errRespr := h.srv.Get(req.Context(), resourceGroupNameParam, profileNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).HeatMapModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
