// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: google/geo/type/viewport.proto

package _type

import (
	bytes "bytes"
	fmt "fmt"
	_type "github.com/gogo/googleapis/google/type"
	proto "github.com/gogo/protobuf/proto"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

// A latitude-longitude viewport, represented as two diagonally opposite `low`
// and `high` points. A viewport is considered a closed region, i.e. it includes
// its boundary. The latitude bounds must range between -90 to 90 degrees
// inclusive, and the longitude bounds must range between -180 to 180 degrees
// inclusive. Various cases include:
//
//  - If `low` = `high`, the viewport consists of that single point.
//
//  - If `low.longitude` > `high.longitude`, the longitude range is inverted
//    (the viewport crosses the 180 degree longitude line).
//
//  - If `low.longitude` = -180 degrees and `high.longitude` = 180 degrees,
//    the viewport includes all longitudes.
//
//  - If `low.longitude` = 180 degrees and `high.longitude` = -180 degrees,
//    the longitude range is empty.
//
//  - If `low.latitude` > `high.latitude`, the latitude range is empty.
//
// Both `low` and `high` must be populated, and the represented box cannot be
// empty (as specified by the definitions above). An empty viewport will result
// in an error.
//
// For example, this viewport fully encloses New York City:
//
// {
//     "low": {
//         "latitude": 40.477398,
//         "longitude": -74.259087
//     },
//     "high": {
//         "latitude": 40.91618,
//         "longitude": -73.70018
//     }
// }
type Viewport struct {
	// Required. The low point of the viewport.
	Low *_type.LatLng `protobuf:"bytes,1,opt,name=low,proto3" json:"low,omitempty"`
	// Required. The high point of the viewport.
	High                 *_type.LatLng `protobuf:"bytes,2,opt,name=high,proto3" json:"high,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *Viewport) Reset()      { *m = Viewport{} }
func (*Viewport) ProtoMessage() {}
func (*Viewport) Descriptor() ([]byte, []int) {
	return fileDescriptor_52240f0f30767909, []int{0}
}
func (m *Viewport) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *Viewport) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_Viewport.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *Viewport) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Viewport.Merge(m, src)
}
func (m *Viewport) XXX_Size() int {
	return m.Size()
}
func (m *Viewport) XXX_DiscardUnknown() {
	xxx_messageInfo_Viewport.DiscardUnknown(m)
}

var xxx_messageInfo_Viewport proto.InternalMessageInfo

func (m *Viewport) GetLow() *_type.LatLng {
	if m != nil {
		return m.Low
	}
	return nil
}

func (m *Viewport) GetHigh() *_type.LatLng {
	if m != nil {
		return m.High
	}
	return nil
}

func (*Viewport) XXX_MessageName() string {
	return "google.geo.type.Viewport"
}
func init() {
	proto.RegisterType((*Viewport)(nil), "google.geo.type.Viewport")
}

func init() { proto.RegisterFile("google/geo/type/viewport.proto", fileDescriptor_52240f0f30767909) }

var fileDescriptor_52240f0f30767909 = []byte{
	// 212 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe2, 0x92, 0x4b, 0xcf, 0xcf, 0x4f,
	0xcf, 0x49, 0xd5, 0x4f, 0x4f, 0xcd, 0xd7, 0x2f, 0xa9, 0x2c, 0x48, 0xd5, 0x2f, 0xcb, 0x4c, 0x2d,
	0x2f, 0xc8, 0x2f, 0x2a, 0xd1, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0x17, 0xe2, 0x87, 0xc8, 0xeb, 0xa5,
	0xa7, 0xe6, 0xeb, 0x81, 0xe4, 0xa5, 0x24, 0xa0, 0x1a, 0xc0, 0x8a, 0x73, 0x12, 0x4b, 0x72, 0xf2,
	0xd2, 0x21, 0x4a, 0x95, 0xa2, 0xb8, 0x38, 0xc2, 0xa0, 0x9a, 0x85, 0x54, 0xb9, 0x98, 0x73, 0xf2,
	0xcb, 0x25, 0x18, 0x15, 0x18, 0x35, 0xb8, 0x8d, 0x84, 0xf5, 0xa0, 0x86, 0x80, 0xf4, 0xe8, 0xf9,
	0x24, 0x96, 0xf8, 0xe4, 0xa5, 0x07, 0x81, 0xe4, 0x85, 0xd4, 0xb9, 0x58, 0x32, 0x32, 0xd3, 0x33,
	0x24, 0x98, 0x70, 0xab, 0x03, 0x2b, 0x70, 0x8a, 0xbf, 0xf1, 0x50, 0x8e, 0xe1, 0xc3, 0x43, 0x39,
	0xc6, 0x1f, 0x0f, 0xe5, 0x18, 0x1b, 0x1e, 0xc9, 0x31, 0xae, 0x78, 0x24, 0xc7, 0x78, 0xe2, 0x91,
	0x1c, 0xe3, 0x85, 0x47, 0x72, 0x8c, 0x0f, 0x1e, 0xc9, 0x31, 0xbe, 0x78, 0x24, 0xc7, 0xf0, 0x01,
	0x24, 0xf6, 0x58, 0x8e, 0x91, 0x4b, 0x38, 0x39, 0x3f, 0x57, 0x0f, 0xcd, 0xe1, 0x4e, 0xbc, 0x30,
	0xc7, 0x05, 0x80, 0x5c, 0x1b, 0xc0, 0x18, 0xc5, 0x02, 0x12, 0x5e, 0xc4, 0xc4, 0xe2, 0xee, 0x1e,
	0x12, 0x90, 0xc4, 0x06, 0xf6, 0x83, 0x31, 0x20, 0x00, 0x00, 0xff, 0xff, 0x40, 0xdd, 0xeb, 0x99,
	0x10, 0x01, 0x00, 0x00,
}

func (this *Viewport) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Viewport)
	if !ok {
		that2, ok := that.(Viewport)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Low.Equal(that1.Low) {
		return false
	}
	if !this.High.Equal(that1.High) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Viewport) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&_type.Viewport{")
	if this.Low != nil {
		s = append(s, "Low: "+fmt.Sprintf("%#v", this.Low)+",\n")
	}
	if this.High != nil {
		s = append(s, "High: "+fmt.Sprintf("%#v", this.High)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringViewport(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *Viewport) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Viewport) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *Viewport) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.XXX_unrecognized != nil {
		i -= len(m.XXX_unrecognized)
		copy(dAtA[i:], m.XXX_unrecognized)
	}
	if m.High != nil {
		{
			size, err := m.High.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintViewport(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	if m.Low != nil {
		{
			size, err := m.Low.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintViewport(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func encodeVarintViewport(dAtA []byte, offset int, v uint64) int {
	offset -= sovViewport(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func NewPopulatedViewport(r randyViewport, easy bool) *Viewport {
	this := &Viewport{}
	if r.Intn(5) != 0 {
		this.Low = _type.NewPopulatedLatLng(r, easy)
	}
	if r.Intn(5) != 0 {
		this.High = _type.NewPopulatedLatLng(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedViewport(r, 3)
	}
	return this
}

type randyViewport interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneViewport(r randyViewport) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringViewport(r randyViewport) string {
	v1 := r.Intn(100)
	tmps := make([]rune, v1)
	for i := 0; i < v1; i++ {
		tmps[i] = randUTF8RuneViewport(r)
	}
	return string(tmps)
}
func randUnrecognizedViewport(r randyViewport, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldViewport(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldViewport(dAtA []byte, r randyViewport, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateViewport(dAtA, uint64(key))
		v2 := r.Int63()
		if r.Intn(2) == 0 {
			v2 *= -1
		}
		dAtA = encodeVarintPopulateViewport(dAtA, uint64(v2))
	case 1:
		dAtA = encodeVarintPopulateViewport(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateViewport(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateViewport(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateViewport(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateViewport(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Viewport) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Low != nil {
		l = m.Low.Size()
		n += 1 + l + sovViewport(uint64(l))
	}
	if m.High != nil {
		l = m.High.Size()
		n += 1 + l + sovViewport(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovViewport(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozViewport(x uint64) (n int) {
	return sovViewport(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Viewport) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Viewport{`,
		`Low:` + strings.Replace(fmt.Sprintf("%v", this.Low), "LatLng", "_type.LatLng", 1) + `,`,
		`High:` + strings.Replace(fmt.Sprintf("%v", this.High), "LatLng", "_type.LatLng", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringViewport(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Viewport) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowViewport
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Viewport: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Viewport: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Low", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowViewport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthViewport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthViewport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Low == nil {
				m.Low = &_type.LatLng{}
			}
			if err := m.Low.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field High", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowViewport
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthViewport
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthViewport
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.High == nil {
				m.High = &_type.LatLng{}
			}
			if err := m.High.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipViewport(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthViewport
			}
			if (iNdEx + skippy) < 0 {
				return ErrInvalidLengthViewport
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, dAtA[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipViewport(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowViewport
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowViewport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowViewport
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthViewport
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupViewport
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthViewport
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthViewport        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowViewport          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupViewport = fmt.Errorf("proto: unexpected end of group")
)
