/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ResourceLimits struct for ResourceLimits
type ResourceLimits struct {
	// The maximum number of CPU cores per server.
	CoresPerServer *int32 `json:"coresPerServer"`
	// The maximum number of CPU cores per contract.
	CoresPerContract *int32 `json:"coresPerContract"`
	// The number of CPU cores provisioned.
	CoresProvisioned *int32 `json:"coresProvisioned"`
	// The maximum amount of RAM (in MB) that can be provisioned for a particular server under this contract.
	RamPerServer *int32 `json:"ramPerServer"`
	// The maximum amount of RAM (in MB) that can be provisioned under this contract.
	RamPerContract *int32 `json:"ramPerContract"`
	// The amount of RAM (in MB) provisioned under this contract.
	RamProvisioned *int32 `json:"ramProvisioned"`
	// The maximum size (in MB) of an idividual hard disk volume.
	HddLimitPerVolume *int64 `json:"hddLimitPerVolume"`
	// The maximum amount of disk space (in MB) that can be provided under this contract.
	HddLimitPerContract *int64 `json:"hddLimitPerContract"`
	// The amount of hard disk space (in MB) that is currently provisioned.
	HddVolumeProvisioned *int64 `json:"hddVolumeProvisioned"`
	// The maximum size (in MB) of an individual solid state disk volume.
	SsdLimitPerVolume *int64 `json:"ssdLimitPerVolume"`
	// The maximum amount of solid state disk space (in MB) that can be provisioned under this contract.
	SsdLimitPerContract *int64 `json:"ssdLimitPerContract"`
	// The amount of solid state disk space (in MB) that is currently provisioned.
	SsdVolumeProvisioned *int64 `json:"ssdVolumeProvisioned"`
	// The amount of DAS disk space (in MB) in a Cube server that is currently provisioned.
	DasVolumeProvisioned *int64 `json:"dasVolumeProvisioned"`
	// The maximum number of static public IP addresses that can be reserved by this customer across contracts.
	ReservableIps *int32 `json:"reservableIps"`
	// The maximum number of static public IP addresses that can be reserved for this contract.
	ReservedIpsOnContract *int32 `json:"reservedIpsOnContract"`
	// The number of static public IP addresses in use.
	ReservedIpsInUse *int32 `json:"reservedIpsInUse"`
	// The maximum number of Kubernetes clusters that can be created under this contract.
	K8sClusterLimitTotal *int32 `json:"k8sClusterLimitTotal"`
	// The amount of Kubernetes clusters that is currently provisioned.
	K8sClustersProvisioned *int32 `json:"k8sClustersProvisioned"`
	// The NLB total limit.
	NlbLimitTotal *int32 `json:"nlbLimitTotal"`
	// The NLBs provisioned.
	NlbProvisioned *int32 `json:"nlbProvisioned"`
	// The NAT Gateway total limit.
	NatGatewayLimitTotal *int32 `json:"natGatewayLimitTotal"`
	// The NAT Gateways provisioned.
	NatGatewayProvisioned *int32 `json:"natGatewayProvisioned"`
	// The maximum number of security groups per VDC.
	SecurityGroupsPerVdc *int32 `json:"securityGroupsPerVdc"`
	// The maximum number of security groups that can be attached to a NIC or a VM individually. For example, a user can have maximum 10 security groups per NIC and 10 per VM.
	SecurityGroupsPerResource *int32 `json:"securityGroupsPerResource"`
	// The maximum number of rules per security group.
	RulesPerSecurityGroup *int32 `json:"rulesPerSecurityGroup"`
}

// NewResourceLimits instantiates a new ResourceLimits object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewResourceLimits(coresPerServer int32, coresPerContract int32, coresProvisioned int32, ramPerServer int32, ramPerContract int32, ramProvisioned int32, hddLimitPerVolume int64, hddLimitPerContract int64, hddVolumeProvisioned int64, ssdLimitPerVolume int64, ssdLimitPerContract int64, ssdVolumeProvisioned int64, dasVolumeProvisioned int64, reservableIps int32, reservedIpsOnContract int32, reservedIpsInUse int32, k8sClusterLimitTotal int32, k8sClustersProvisioned int32, nlbLimitTotal int32, nlbProvisioned int32, natGatewayLimitTotal int32, natGatewayProvisioned int32, securityGroupsPerVdc int32, securityGroupsPerResource int32, rulesPerSecurityGroup int32) *ResourceLimits {
	this := ResourceLimits{}

	this.CoresPerServer = &coresPerServer
	this.CoresPerContract = &coresPerContract
	this.CoresProvisioned = &coresProvisioned
	this.RamPerServer = &ramPerServer
	this.RamPerContract = &ramPerContract
	this.RamProvisioned = &ramProvisioned
	this.HddLimitPerVolume = &hddLimitPerVolume
	this.HddLimitPerContract = &hddLimitPerContract
	this.HddVolumeProvisioned = &hddVolumeProvisioned
	this.SsdLimitPerVolume = &ssdLimitPerVolume
	this.SsdLimitPerContract = &ssdLimitPerContract
	this.SsdVolumeProvisioned = &ssdVolumeProvisioned
	this.DasVolumeProvisioned = &dasVolumeProvisioned
	this.ReservableIps = &reservableIps
	this.ReservedIpsOnContract = &reservedIpsOnContract
	this.ReservedIpsInUse = &reservedIpsInUse
	this.K8sClusterLimitTotal = &k8sClusterLimitTotal
	this.K8sClustersProvisioned = &k8sClustersProvisioned
	this.NlbLimitTotal = &nlbLimitTotal
	this.NlbProvisioned = &nlbProvisioned
	this.NatGatewayLimitTotal = &natGatewayLimitTotal
	this.NatGatewayProvisioned = &natGatewayProvisioned
	this.SecurityGroupsPerVdc = &securityGroupsPerVdc
	this.SecurityGroupsPerResource = &securityGroupsPerResource
	this.RulesPerSecurityGroup = &rulesPerSecurityGroup

	return &this
}

// NewResourceLimitsWithDefaults instantiates a new ResourceLimits object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewResourceLimitsWithDefaults() *ResourceLimits {
	this := ResourceLimits{}
	return &this
}

// GetCoresPerServer returns the CoresPerServer field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetCoresPerServer() *int32 {
	if o == nil {
		return nil
	}

	return o.CoresPerServer

}

// GetCoresPerServerOk returns a tuple with the CoresPerServer field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetCoresPerServerOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.CoresPerServer, true
}

// SetCoresPerServer sets field value
func (o *ResourceLimits) SetCoresPerServer(v int32) {

	o.CoresPerServer = &v

}

// HasCoresPerServer returns a boolean if a field has been set.
func (o *ResourceLimits) HasCoresPerServer() bool {
	if o != nil && o.CoresPerServer != nil {
		return true
	}

	return false
}

// GetCoresPerContract returns the CoresPerContract field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetCoresPerContract() *int32 {
	if o == nil {
		return nil
	}

	return o.CoresPerContract

}

// GetCoresPerContractOk returns a tuple with the CoresPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetCoresPerContractOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.CoresPerContract, true
}

// SetCoresPerContract sets field value
func (o *ResourceLimits) SetCoresPerContract(v int32) {

	o.CoresPerContract = &v

}

// HasCoresPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasCoresPerContract() bool {
	if o != nil && o.CoresPerContract != nil {
		return true
	}

	return false
}

// GetCoresProvisioned returns the CoresProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetCoresProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.CoresProvisioned

}

// GetCoresProvisionedOk returns a tuple with the CoresProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetCoresProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.CoresProvisioned, true
}

// SetCoresProvisioned sets field value
func (o *ResourceLimits) SetCoresProvisioned(v int32) {

	o.CoresProvisioned = &v

}

// HasCoresProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasCoresProvisioned() bool {
	if o != nil && o.CoresProvisioned != nil {
		return true
	}

	return false
}

// GetRamPerServer returns the RamPerServer field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetRamPerServer() *int32 {
	if o == nil {
		return nil
	}

	return o.RamPerServer

}

// GetRamPerServerOk returns a tuple with the RamPerServer field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRamPerServerOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.RamPerServer, true
}

// SetRamPerServer sets field value
func (o *ResourceLimits) SetRamPerServer(v int32) {

	o.RamPerServer = &v

}

// HasRamPerServer returns a boolean if a field has been set.
func (o *ResourceLimits) HasRamPerServer() bool {
	if o != nil && o.RamPerServer != nil {
		return true
	}

	return false
}

// GetRamPerContract returns the RamPerContract field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetRamPerContract() *int32 {
	if o == nil {
		return nil
	}

	return o.RamPerContract

}

// GetRamPerContractOk returns a tuple with the RamPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRamPerContractOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.RamPerContract, true
}

// SetRamPerContract sets field value
func (o *ResourceLimits) SetRamPerContract(v int32) {

	o.RamPerContract = &v

}

// HasRamPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasRamPerContract() bool {
	if o != nil && o.RamPerContract != nil {
		return true
	}

	return false
}

// GetRamProvisioned returns the RamProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetRamProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.RamProvisioned

}

// GetRamProvisionedOk returns a tuple with the RamProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRamProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.RamProvisioned, true
}

// SetRamProvisioned sets field value
func (o *ResourceLimits) SetRamProvisioned(v int32) {

	o.RamProvisioned = &v

}

// HasRamProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasRamProvisioned() bool {
	if o != nil && o.RamProvisioned != nil {
		return true
	}

	return false
}

// GetHddLimitPerVolume returns the HddLimitPerVolume field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetHddLimitPerVolume() *int64 {
	if o == nil {
		return nil
	}

	return o.HddLimitPerVolume

}

// GetHddLimitPerVolumeOk returns a tuple with the HddLimitPerVolume field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetHddLimitPerVolumeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.HddLimitPerVolume, true
}

// SetHddLimitPerVolume sets field value
func (o *ResourceLimits) SetHddLimitPerVolume(v int64) {

	o.HddLimitPerVolume = &v

}

// HasHddLimitPerVolume returns a boolean if a field has been set.
func (o *ResourceLimits) HasHddLimitPerVolume() bool {
	if o != nil && o.HddLimitPerVolume != nil {
		return true
	}

	return false
}

// GetHddLimitPerContract returns the HddLimitPerContract field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetHddLimitPerContract() *int64 {
	if o == nil {
		return nil
	}

	return o.HddLimitPerContract

}

// GetHddLimitPerContractOk returns a tuple with the HddLimitPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetHddLimitPerContractOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.HddLimitPerContract, true
}

// SetHddLimitPerContract sets field value
func (o *ResourceLimits) SetHddLimitPerContract(v int64) {

	o.HddLimitPerContract = &v

}

// HasHddLimitPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasHddLimitPerContract() bool {
	if o != nil && o.HddLimitPerContract != nil {
		return true
	}

	return false
}

// GetHddVolumeProvisioned returns the HddVolumeProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetHddVolumeProvisioned() *int64 {
	if o == nil {
		return nil
	}

	return o.HddVolumeProvisioned

}

// GetHddVolumeProvisionedOk returns a tuple with the HddVolumeProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetHddVolumeProvisionedOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.HddVolumeProvisioned, true
}

// SetHddVolumeProvisioned sets field value
func (o *ResourceLimits) SetHddVolumeProvisioned(v int64) {

	o.HddVolumeProvisioned = &v

}

// HasHddVolumeProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasHddVolumeProvisioned() bool {
	if o != nil && o.HddVolumeProvisioned != nil {
		return true
	}

	return false
}

// GetSsdLimitPerVolume returns the SsdLimitPerVolume field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetSsdLimitPerVolume() *int64 {
	if o == nil {
		return nil
	}

	return o.SsdLimitPerVolume

}

// GetSsdLimitPerVolumeOk returns a tuple with the SsdLimitPerVolume field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSsdLimitPerVolumeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.SsdLimitPerVolume, true
}

// SetSsdLimitPerVolume sets field value
func (o *ResourceLimits) SetSsdLimitPerVolume(v int64) {

	o.SsdLimitPerVolume = &v

}

// HasSsdLimitPerVolume returns a boolean if a field has been set.
func (o *ResourceLimits) HasSsdLimitPerVolume() bool {
	if o != nil && o.SsdLimitPerVolume != nil {
		return true
	}

	return false
}

// GetSsdLimitPerContract returns the SsdLimitPerContract field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetSsdLimitPerContract() *int64 {
	if o == nil {
		return nil
	}

	return o.SsdLimitPerContract

}

// GetSsdLimitPerContractOk returns a tuple with the SsdLimitPerContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSsdLimitPerContractOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.SsdLimitPerContract, true
}

// SetSsdLimitPerContract sets field value
func (o *ResourceLimits) SetSsdLimitPerContract(v int64) {

	o.SsdLimitPerContract = &v

}

// HasSsdLimitPerContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasSsdLimitPerContract() bool {
	if o != nil && o.SsdLimitPerContract != nil {
		return true
	}

	return false
}

// GetSsdVolumeProvisioned returns the SsdVolumeProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetSsdVolumeProvisioned() *int64 {
	if o == nil {
		return nil
	}

	return o.SsdVolumeProvisioned

}

// GetSsdVolumeProvisionedOk returns a tuple with the SsdVolumeProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSsdVolumeProvisionedOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.SsdVolumeProvisioned, true
}

// SetSsdVolumeProvisioned sets field value
func (o *ResourceLimits) SetSsdVolumeProvisioned(v int64) {

	o.SsdVolumeProvisioned = &v

}

// HasSsdVolumeProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasSsdVolumeProvisioned() bool {
	if o != nil && o.SsdVolumeProvisioned != nil {
		return true
	}

	return false
}

// GetDasVolumeProvisioned returns the DasVolumeProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetDasVolumeProvisioned() *int64 {
	if o == nil {
		return nil
	}

	return o.DasVolumeProvisioned

}

// GetDasVolumeProvisionedOk returns a tuple with the DasVolumeProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetDasVolumeProvisionedOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}

	return o.DasVolumeProvisioned, true
}

// SetDasVolumeProvisioned sets field value
func (o *ResourceLimits) SetDasVolumeProvisioned(v int64) {

	o.DasVolumeProvisioned = &v

}

// HasDasVolumeProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasDasVolumeProvisioned() bool {
	if o != nil && o.DasVolumeProvisioned != nil {
		return true
	}

	return false
}

// GetReservableIps returns the ReservableIps field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetReservableIps() *int32 {
	if o == nil {
		return nil
	}

	return o.ReservableIps

}

// GetReservableIpsOk returns a tuple with the ReservableIps field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetReservableIpsOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.ReservableIps, true
}

// SetReservableIps sets field value
func (o *ResourceLimits) SetReservableIps(v int32) {

	o.ReservableIps = &v

}

// HasReservableIps returns a boolean if a field has been set.
func (o *ResourceLimits) HasReservableIps() bool {
	if o != nil && o.ReservableIps != nil {
		return true
	}

	return false
}

// GetReservedIpsOnContract returns the ReservedIpsOnContract field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetReservedIpsOnContract() *int32 {
	if o == nil {
		return nil
	}

	return o.ReservedIpsOnContract

}

// GetReservedIpsOnContractOk returns a tuple with the ReservedIpsOnContract field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetReservedIpsOnContractOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.ReservedIpsOnContract, true
}

// SetReservedIpsOnContract sets field value
func (o *ResourceLimits) SetReservedIpsOnContract(v int32) {

	o.ReservedIpsOnContract = &v

}

// HasReservedIpsOnContract returns a boolean if a field has been set.
func (o *ResourceLimits) HasReservedIpsOnContract() bool {
	if o != nil && o.ReservedIpsOnContract != nil {
		return true
	}

	return false
}

// GetReservedIpsInUse returns the ReservedIpsInUse field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetReservedIpsInUse() *int32 {
	if o == nil {
		return nil
	}

	return o.ReservedIpsInUse

}

// GetReservedIpsInUseOk returns a tuple with the ReservedIpsInUse field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetReservedIpsInUseOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.ReservedIpsInUse, true
}

// SetReservedIpsInUse sets field value
func (o *ResourceLimits) SetReservedIpsInUse(v int32) {

	o.ReservedIpsInUse = &v

}

// HasReservedIpsInUse returns a boolean if a field has been set.
func (o *ResourceLimits) HasReservedIpsInUse() bool {
	if o != nil && o.ReservedIpsInUse != nil {
		return true
	}

	return false
}

// GetK8sClusterLimitTotal returns the K8sClusterLimitTotal field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetK8sClusterLimitTotal() *int32 {
	if o == nil {
		return nil
	}

	return o.K8sClusterLimitTotal

}

// GetK8sClusterLimitTotalOk returns a tuple with the K8sClusterLimitTotal field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetK8sClusterLimitTotalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.K8sClusterLimitTotal, true
}

// SetK8sClusterLimitTotal sets field value
func (o *ResourceLimits) SetK8sClusterLimitTotal(v int32) {

	o.K8sClusterLimitTotal = &v

}

// HasK8sClusterLimitTotal returns a boolean if a field has been set.
func (o *ResourceLimits) HasK8sClusterLimitTotal() bool {
	if o != nil && o.K8sClusterLimitTotal != nil {
		return true
	}

	return false
}

// GetK8sClustersProvisioned returns the K8sClustersProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetK8sClustersProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.K8sClustersProvisioned

}

// GetK8sClustersProvisionedOk returns a tuple with the K8sClustersProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetK8sClustersProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.K8sClustersProvisioned, true
}

// SetK8sClustersProvisioned sets field value
func (o *ResourceLimits) SetK8sClustersProvisioned(v int32) {

	o.K8sClustersProvisioned = &v

}

// HasK8sClustersProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasK8sClustersProvisioned() bool {
	if o != nil && o.K8sClustersProvisioned != nil {
		return true
	}

	return false
}

// GetNlbLimitTotal returns the NlbLimitTotal field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetNlbLimitTotal() *int32 {
	if o == nil {
		return nil
	}

	return o.NlbLimitTotal

}

// GetNlbLimitTotalOk returns a tuple with the NlbLimitTotal field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetNlbLimitTotalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.NlbLimitTotal, true
}

// SetNlbLimitTotal sets field value
func (o *ResourceLimits) SetNlbLimitTotal(v int32) {

	o.NlbLimitTotal = &v

}

// HasNlbLimitTotal returns a boolean if a field has been set.
func (o *ResourceLimits) HasNlbLimitTotal() bool {
	if o != nil && o.NlbLimitTotal != nil {
		return true
	}

	return false
}

// GetNlbProvisioned returns the NlbProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetNlbProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.NlbProvisioned

}

// GetNlbProvisionedOk returns a tuple with the NlbProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetNlbProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.NlbProvisioned, true
}

// SetNlbProvisioned sets field value
func (o *ResourceLimits) SetNlbProvisioned(v int32) {

	o.NlbProvisioned = &v

}

// HasNlbProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasNlbProvisioned() bool {
	if o != nil && o.NlbProvisioned != nil {
		return true
	}

	return false
}

// GetNatGatewayLimitTotal returns the NatGatewayLimitTotal field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetNatGatewayLimitTotal() *int32 {
	if o == nil {
		return nil
	}

	return o.NatGatewayLimitTotal

}

// GetNatGatewayLimitTotalOk returns a tuple with the NatGatewayLimitTotal field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetNatGatewayLimitTotalOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.NatGatewayLimitTotal, true
}

// SetNatGatewayLimitTotal sets field value
func (o *ResourceLimits) SetNatGatewayLimitTotal(v int32) {

	o.NatGatewayLimitTotal = &v

}

// HasNatGatewayLimitTotal returns a boolean if a field has been set.
func (o *ResourceLimits) HasNatGatewayLimitTotal() bool {
	if o != nil && o.NatGatewayLimitTotal != nil {
		return true
	}

	return false
}

// GetNatGatewayProvisioned returns the NatGatewayProvisioned field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetNatGatewayProvisioned() *int32 {
	if o == nil {
		return nil
	}

	return o.NatGatewayProvisioned

}

// GetNatGatewayProvisionedOk returns a tuple with the NatGatewayProvisioned field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetNatGatewayProvisionedOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.NatGatewayProvisioned, true
}

// SetNatGatewayProvisioned sets field value
func (o *ResourceLimits) SetNatGatewayProvisioned(v int32) {

	o.NatGatewayProvisioned = &v

}

// HasNatGatewayProvisioned returns a boolean if a field has been set.
func (o *ResourceLimits) HasNatGatewayProvisioned() bool {
	if o != nil && o.NatGatewayProvisioned != nil {
		return true
	}

	return false
}

// GetSecurityGroupsPerVdc returns the SecurityGroupsPerVdc field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetSecurityGroupsPerVdc() *int32 {
	if o == nil {
		return nil
	}

	return o.SecurityGroupsPerVdc

}

// GetSecurityGroupsPerVdcOk returns a tuple with the SecurityGroupsPerVdc field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSecurityGroupsPerVdcOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.SecurityGroupsPerVdc, true
}

// SetSecurityGroupsPerVdc sets field value
func (o *ResourceLimits) SetSecurityGroupsPerVdc(v int32) {

	o.SecurityGroupsPerVdc = &v

}

// HasSecurityGroupsPerVdc returns a boolean if a field has been set.
func (o *ResourceLimits) HasSecurityGroupsPerVdc() bool {
	if o != nil && o.SecurityGroupsPerVdc != nil {
		return true
	}

	return false
}

// GetSecurityGroupsPerResource returns the SecurityGroupsPerResource field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetSecurityGroupsPerResource() *int32 {
	if o == nil {
		return nil
	}

	return o.SecurityGroupsPerResource

}

// GetSecurityGroupsPerResourceOk returns a tuple with the SecurityGroupsPerResource field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetSecurityGroupsPerResourceOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.SecurityGroupsPerResource, true
}

// SetSecurityGroupsPerResource sets field value
func (o *ResourceLimits) SetSecurityGroupsPerResource(v int32) {

	o.SecurityGroupsPerResource = &v

}

// HasSecurityGroupsPerResource returns a boolean if a field has been set.
func (o *ResourceLimits) HasSecurityGroupsPerResource() bool {
	if o != nil && o.SecurityGroupsPerResource != nil {
		return true
	}

	return false
}

// GetRulesPerSecurityGroup returns the RulesPerSecurityGroup field value
// If the value is explicit nil, nil is returned
func (o *ResourceLimits) GetRulesPerSecurityGroup() *int32 {
	if o == nil {
		return nil
	}

	return o.RulesPerSecurityGroup

}

// GetRulesPerSecurityGroupOk returns a tuple with the RulesPerSecurityGroup field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ResourceLimits) GetRulesPerSecurityGroupOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}

	return o.RulesPerSecurityGroup, true
}

// SetRulesPerSecurityGroup sets field value
func (o *ResourceLimits) SetRulesPerSecurityGroup(v int32) {

	o.RulesPerSecurityGroup = &v

}

// HasRulesPerSecurityGroup returns a boolean if a field has been set.
func (o *ResourceLimits) HasRulesPerSecurityGroup() bool {
	if o != nil && o.RulesPerSecurityGroup != nil {
		return true
	}

	return false
}

func (o ResourceLimits) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.CoresPerServer != nil {
		toSerialize["coresPerServer"] = o.CoresPerServer
	}

	if o.CoresPerContract != nil {
		toSerialize["coresPerContract"] = o.CoresPerContract
	}

	if o.CoresProvisioned != nil {
		toSerialize["coresProvisioned"] = o.CoresProvisioned
	}

	if o.RamPerServer != nil {
		toSerialize["ramPerServer"] = o.RamPerServer
	}

	if o.RamPerContract != nil {
		toSerialize["ramPerContract"] = o.RamPerContract
	}

	if o.RamProvisioned != nil {
		toSerialize["ramProvisioned"] = o.RamProvisioned
	}

	if o.HddLimitPerVolume != nil {
		toSerialize["hddLimitPerVolume"] = o.HddLimitPerVolume
	}

	if o.HddLimitPerContract != nil {
		toSerialize["hddLimitPerContract"] = o.HddLimitPerContract
	}

	if o.HddVolumeProvisioned != nil {
		toSerialize["hddVolumeProvisioned"] = o.HddVolumeProvisioned
	}

	if o.SsdLimitPerVolume != nil {
		toSerialize["ssdLimitPerVolume"] = o.SsdLimitPerVolume
	}

	if o.SsdLimitPerContract != nil {
		toSerialize["ssdLimitPerContract"] = o.SsdLimitPerContract
	}

	if o.SsdVolumeProvisioned != nil {
		toSerialize["ssdVolumeProvisioned"] = o.SsdVolumeProvisioned
	}

	if o.DasVolumeProvisioned != nil {
		toSerialize["dasVolumeProvisioned"] = o.DasVolumeProvisioned
	}

	if o.ReservableIps != nil {
		toSerialize["reservableIps"] = o.ReservableIps
	}

	if o.ReservedIpsOnContract != nil {
		toSerialize["reservedIpsOnContract"] = o.ReservedIpsOnContract
	}

	if o.ReservedIpsInUse != nil {
		toSerialize["reservedIpsInUse"] = o.ReservedIpsInUse
	}

	if o.K8sClusterLimitTotal != nil {
		toSerialize["k8sClusterLimitTotal"] = o.K8sClusterLimitTotal
	}

	if o.K8sClustersProvisioned != nil {
		toSerialize["k8sClustersProvisioned"] = o.K8sClustersProvisioned
	}

	if o.NlbLimitTotal != nil {
		toSerialize["nlbLimitTotal"] = o.NlbLimitTotal
	}

	if o.NlbProvisioned != nil {
		toSerialize["nlbProvisioned"] = o.NlbProvisioned
	}

	if o.NatGatewayLimitTotal != nil {
		toSerialize["natGatewayLimitTotal"] = o.NatGatewayLimitTotal
	}

	if o.NatGatewayProvisioned != nil {
		toSerialize["natGatewayProvisioned"] = o.NatGatewayProvisioned
	}

	if o.SecurityGroupsPerVdc != nil {
		toSerialize["securityGroupsPerVdc"] = o.SecurityGroupsPerVdc
	}

	if o.SecurityGroupsPerResource != nil {
		toSerialize["securityGroupsPerResource"] = o.SecurityGroupsPerResource
	}

	if o.RulesPerSecurityGroup != nil {
		toSerialize["rulesPerSecurityGroup"] = o.RulesPerSecurityGroup
	}

	return json.Marshal(toSerialize)
}

type NullableResourceLimits struct {
	value *ResourceLimits
	isSet bool
}

func (v NullableResourceLimits) Get() *ResourceLimits {
	return v.value
}

func (v *NullableResourceLimits) Set(val *ResourceLimits) {
	v.value = val
	v.isSet = true
}

func (v NullableResourceLimits) IsSet() bool {
	return v.isSet
}

func (v *NullableResourceLimits) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableResourceLimits(val *ResourceLimits) *NullableResourceLimits {
	return &NullableResourceLimits{value: val, isSet: true}
}

func (v NullableResourceLimits) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableResourceLimits) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
