/*
Copyright 2017 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// This file was generated using openssl by the gencerts.sh script
// and holds raw certificates for the webhook tests.

package webhook

var caKey = []byte(`-----BEGIN RSA PRIVATE KEY-----
MIIEogIBAAKCAQEAp5bQmSrpWJmTKFosJSBuqw3v7ocvB9kr+WPL8qdntbtCUnrl
Da2Sm0vR9jgM+6ZPsmBVMadfJNcnflKzkDjKGb3LIwfyk1VHX250rV9TvhhWZtcm
RzSc/uf4Bdf2UPZjL2kO+1qrUT56s3adHVdoJL2fSmHgL98HVGHuYi/+7tZbv9pH
P+smMEFkhuDuGBk/AWy6QSJ8aLRTi6K1VhHoxamMeP757Ubfz7gmtlH2+EGge0En
UMGmaMBBoC2RJkDFcmeZrhrATQG/RDiXGRR5j4O2Hw7E9fGBNvBMoNqC4eVYtNqm
mnKADwWcqqZxSTAdk7k5WV2L9ko5SbZgK4mV8QIDAQABAoIBAFRbwSLoi88ydvW/
9iq2GZ73BAhgedcMhWsixf2eMME0wpy8CeKJtZuAXe7/peFihQl4HkpBQs5LkzCu
Nn7pZynv9HnsvTlWmve5pPfEXWX54DwiHr2HCWPyplFitTVp4OFzk7wIluXtelwt
38ZuQhkEblNF01Clho3+Qb2hBUV5Rp4onekA70oQYtWLwq4IVY0MK+G7FkzRc2Dv
n7b1IxJan5UrLSvtIzbQ5ZI9xL50gA6R3sZd+3guXhXdx+YYSSpf0PMwBAn8qmhf
kjW1Wkytai13kVaZM5go01Kq4UxnNIauvdZuKLR5nANlHAHbcLVe9XwYKr0nJhxz
ZvVnaEECgYEA2rHe1VgZA8YJflbuSgj8B3AG1KIqdhTLkodBZsTFPEYqMHHwShhR
QYGWozadt7brIBOb++hgpXAu85mhQTD3FwCrHV/m901KC+k4THtxqC5OaaxseoZp
1y26wCeez9/JKzah6Bgv538DKE0GD7W0GSPzAH7upb3Pc1WdE3KPtakCgYEAxC05
CWz4jX9WFkUQ/TWau7CEuIr+kvVKnainq8cz5zUmVdwfTHhO98HHne/IDxQSK1xW
1fdsg20AmVYNT7P6E14qUAih+E4JEhNh/MV65kkNk1KAR4wvHIrI/PIOrszPMou4
5jNiyLeZeKY4y552K2bgQDOjk5p7yax57w8UewkCgYBdI1malL16jPHoG4+6eh8T
79MI5dOdnHeifPYOlYjGhb9cCHpko/yfIFiORClhX4a9j3xkCXB3pNJqLqitgfQJ
mOBHT1unQQRjFD1E3WHnVWlRufwtJmeXG8OoKHeLYmxjeg30MbDdL4uhs0P8ls8P
0e6g7G4oqjDalsCh0q1/mQKBgCv17lgcYT5kEIiBBaOYRYpVrggkrZOFACmAR8KI
qyrekC6hWyops5h1hiPwPaaTWtb4pETiYyC4Zm/2BpmbvShl65lvtcwMwJ+aVFTu
c/Hy4OXokPJ3iX8d4pg8Leoh3zR2dwKu9S4BZpTQut12LwjeztXUPI2xCphQ3Coj
+PTxAoGAJ8OYCl1ECPy0d5NA7vPOeQ4DaEC7ugjw9MqoY8DczROjF05711XKDwWl
g6Kcffaz9f49gFUGq6tIG4N6yutR0xecE21w9z7ubA6k50x9umj5XkDyM5W9Tt5Z
yRU/vk7jrZmt0WFDhb6Ao1RlFjLlKhBkQZ6dd6C6fxatUg3BGYI=
-----END RSA PRIVATE KEY-----`)

var caCert = []byte(`-----BEGIN CERTIFICATE-----
MIIDGTCCAgGgAwIBAgIUealQGELTHLUVcpsNNwz8XexiWvswDQYJKoZIhvcNAQEL
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTCC
ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKeW0Jkq6ViZkyhaLCUgbqsN
7+6HLwfZK/ljy/KnZ7W7QlJ65Q2tkptL0fY4DPumT7JgVTGnXyTXJ35Ss5A4yhm9
yyMH8pNVR19udK1fU74YVmbXJkc0nP7n+AXX9lD2Yy9pDvtaq1E+erN2nR1XaCS9
n0ph4C/fB1Rh7mIv/u7WW7/aRz/rJjBBZIbg7hgZPwFsukEifGi0U4uitVYR6MWp
jHj++e1G38+4JrZR9vhBoHtBJ1DBpmjAQaAtkSZAxXJnma4awE0Bv0Q4lxkUeY+D
th8OxPXxgTbwTKDaguHlWLTapppygA8FnKqmcUkwHZO5OVldi/ZKOUm2YCuJlfEC
AwEAAaNTMFEwHQYDVR0OBBYEFJGX6zVDm0Ur4gJJR+PKlgGdwhPfMB8GA1UdIwQY
MBaAFJGX6zVDm0Ur4gJJR+PKlgGdwhPfMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZI
hvcNAQELBQADggEBAJaRryxp0iYWGfLiZ0uIdOiYRVZUtmpqUSqT9/y29ffDAnCS
5labJS8FjaiQdlyaH+E9gzo0+nkO9NyfemJRLTEsU4Mz9AAvxs/NuWucqiyF0Y6d
JSYt7+2liGK5WvJMbHfW3jloWlv3oX+qL4iGFkJN+L9G+vf0GnKZCxgNIOqM4otv
cviCA9ouPwnSfnCeTsBoaUJqhLMizvUx7avvUyZTuV+t9+aN/qH4V//hTBqz9CNq
koodzngbUuyaGFI8QISUAhU+pbt6npb69LlhJHC0icDXCc4uTsd+SDsBOorZDuUL
HsNKnE0CSPZ65ENVNfJjB1fVEYbbpjr8kizOCDE=
-----END CERTIFICATE-----`)

var badCACert = []byte(`-----BEGIN CERTIFICATE-----
MIIDGTCCAgGgAwIBAgIUDr7CjUg6evYtl4uqdgyu94ACVOAwDQYJKoZIhvcNAQEL
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTCC
ASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAMzgv+bNXgI07CBjqHRie/2R
3Etpu7eVC9/LuBoe+KpUuns3r2Ix0bKg1VIjDLdidcFmAqx/qSi0SWdEtAfPWqWo
LI6GVYmBUZzcJHAxMsJJLIpVCIZsQt+k4Dz0ECGwB/Q501Es9hEiTHZSXnPN8XSO
0f9m2rINT3yWCa+UyMlxolIJAkYlajU/BU8xIOcSKACaE2iNKv3rs+6qIO7dpP+j
tUWI/Vtjdt5PSY7+WUl5yh4WqTMkMKfAonSyvCxzyMb1HIe3TAN0dTulN/PdAe9x
7qLJx08wju2v5eBhwwQn0ZO9FPPNE/440nwanUmJtQBh46htgImPmz3j2VQvRLcC
AwEAAaNTMFEwHQYDVR0OBBYEFKp7SXYko8r9qgYDbOaDOEt2aNUhMB8GA1UdIwQY
MBaAFKp7SXYko8r9qgYDbOaDOEt2aNUhMA8GA1UdEwEB/wQFMAMBAf8wDQYJKoZI
hvcNAQELBQADggEBAADzhaAVNIIWykvV4+RZ6FtSS3oJwerFUY2/PECLTcEyjtuu
eTu9uiZMu4R/hmvcGXxa40uS96SOwseIo8FJFSVEiTLqPJB+ZhiFE/wAaChRlc78
4/Q9Hj46IS67aZoOT+nCIv3PcOrxFMZqtLyBLIrtFxkv2WfoaqxTm7GbBdvwIvQO
DvOHHudXGeC+RL8sz8YIv1ghd8LxLdWZmyZhvCWHB0YHnoVryN6oqhKY0zv9YUGJ
r97Qb+RQu9ijmNHWkwuTy5Zxj/GMIqC/vYu7x5DH/m0oCnSGqASLh1gAsjC0Aa+D
YqXbFLxSCtUNhKuW5ejbvHAYp/QgtjAtu81HOkQ=
-----END CERTIFICATE-----`)

var caCertInter = []byte(`-----BEGIN CERTIFICATE-----
MIIDMzCCAhugAwIBAgIUTJoqwFusJcupNCs/u39LBFrkZEIwDQYJKoZIhvcNAQEL
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowKDEmMCQGA1UEAwwdd2ViaG9va190ZXN0c19pbnRl
cm1lZGlhdGVfY2EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDT9DIt
uNXhesrh8XtPXK4pR7xGReEsIlgLpMYf11PtFln9eV0HXvUO2CG/YvMxwgyd6Yoq
EfzD4rjmXvl5bQPMygmxf5GN1PM7ef7gVYuHfDgsQ4a82u1JFhKvuOrXn3QRfRg4
M4uYND7J4+Bg6J8oaA0yXIiMCpBi+XwEufo0RvgxM6mT+CeJ82hmlTKVhQJZZ9ZT
al1C4dTR2XeH5TLiIAvm+egBmSZhtCVn14rGk/PcHOWV7hdCxaFhSm7dSC+dR4zK
SxNleJ4Y+tZgoMfvgP/xHZEjbBzxnxyasES/Nc4nTgylcr6aqEX/fbcF0QzHpL9Z
ibkt1cBExU9zHuFJAgMBAAGjYDBeMB0GA1UdDgQWBBTfgUwjHsTOey7WqL4f3oFD
bmY77TAfBgNVHSMEGDAWgBSRl+s1Q5tFK+ICSUfjypYBncIT3zAPBgNVHRMBAf8E
BTADAQH/MAsGA1UdDwQEAwIBBjANBgkqhkiG9w0BAQsFAAOCAQEARYbIpIidgAVb
5ra9zd7F902+xC13/nmlrKL/dRMrRdZxk1kVVww3FbXSp7k7oHsih42KUCVDBevw
0ZZiolZlLneU57dEKKiTMkuPdVbNbIBPXIQpHLrXpVIR5BRRdRZ5OJZY24hYCvce
50XV8ITIU0R/U4sQ6NFHv8NJ5BB+2u1M3HF2LSKZFLnfP5FBcTCg84Jd6gEmTU2j
wZELnHy1AVdQnKMP9VrdAr9Wn6omWxAfO/PSb9YeKhGH5vtX+Bpb9bSPQIpXeBdB
LLCkme0M+1UsF7xua0KVi4DSuJc+RBl4aOH0ZvKmrIWzLzZhRS0vaO/fPArVCvvI
VrUba0E3WQ==
-----END CERTIFICATE-----`)

var caCertInterSHA1 = []byte(`-----BEGIN CERTIFICATE-----
MIIDMzCCAhugAwIBAgIUTJoqwFusJcupNCs/u39LBFrkZEMwDQYJKoZIhvcNAQEF
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowKDEmMCQGA1UEAwwdd2ViaG9va190ZXN0c19pbnRl
cm1lZGlhdGVfY2EwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDT9DIt
uNXhesrh8XtPXK4pR7xGReEsIlgLpMYf11PtFln9eV0HXvUO2CG/YvMxwgyd6Yoq
EfzD4rjmXvl5bQPMygmxf5GN1PM7ef7gVYuHfDgsQ4a82u1JFhKvuOrXn3QRfRg4
M4uYND7J4+Bg6J8oaA0yXIiMCpBi+XwEufo0RvgxM6mT+CeJ82hmlTKVhQJZZ9ZT
al1C4dTR2XeH5TLiIAvm+egBmSZhtCVn14rGk/PcHOWV7hdCxaFhSm7dSC+dR4zK
SxNleJ4Y+tZgoMfvgP/xHZEjbBzxnxyasES/Nc4nTgylcr6aqEX/fbcF0QzHpL9Z
ibkt1cBExU9zHuFJAgMBAAGjYDBeMB0GA1UdDgQWBBTfgUwjHsTOey7WqL4f3oFD
bmY77TAfBgNVHSMEGDAWgBSRl+s1Q5tFK+ICSUfjypYBncIT3zAPBgNVHRMBAf8E
BTADAQH/MAsGA1UdDwQEAwIBBjANBgkqhkiG9w0BAQUFAAOCAQEAAhMQTwrpAeIQ
nShHfTERiwg/tx3dL971d3pFS5wi4kEIbbYCUGpzkmK/FTw4hfUnLpwcjjAbOWkk
45glOmrLJXM4RvH5PQF3GZmZvxv8Dl4zuhH1QvWbJHUiC+gyrBWI0moyLSmNiutZ
d3TZGEehZGwivMdHHuhgiyFM4i33EQTW1vdMdOvdu8yNpAeXM2h1PcJwbEML9PO3
LONzVKhz/RsyEwv7PkX1gdmi6eyAE61BWJGwzxE4K0xIYmcr6iOjsJhEf/5Qc93P
IGSHsG/HjWwZ47gbobtv7L+8uKP/0ky+k1cE4nIB1gKYey+SYwvkQTsj24oG9xcL
XhgnIl+qDw==
-----END CERTIFICATE-----`)

var serverKey = []byte(`-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEA52b4byIJpUDyTKo5FiCa5Ekiy7CCd8UoleSomQjh5zZGsIbg
z9RqjaTMLF0jqbzh9ix2DQSnY+w32LqPM2sOK1+/atmeCa8m5bvZrRoDxP2T3pQH
Tye0C9WI7jqosmMquRFakaY1ODxDRPWF9CRghFF62NcHfnztW2rMiEYtuDRkZGsp
JL/B5OAzEgLr4iP8TKMlqSuhaQhi52dEZo0pJ1Ie4up8xxXKeoqfO3WSVDeRpj/n
0tYSALhOCdGn0RMav5wfZmxdfZpKUhBrcxFfeiDB5c7xdlnziHrY5lqSQPCHxAQb
S1jMaV4adhxDzF56t5RU6/5eWPZ4IvlTRtYmNwIDAQABAoIBAAb0r28XxNZ011O6
ojCqFj3afPNGgQV8pbWrw+2luLSsiv9vbn6Q0gsj8wc6XYISrXAq8fl+NFHqndsj
8H4JL8nZ/PUHSZrc6vxo4ygy6f4X6UP9iyKz/NOGPbF7jeqe1H/vp5tNNbhVB2ih
QL+QAF653El8XTtOIgxnb3KBOYqZ6e0rWvC5XlZrfT4EGqpokW4zQ6ROQUbnWyCk
LC4CtQpcLLd7fdGfA2cB2xDdGJ3Er8gAnU/X+tAtcghWanoNARKGU6opyGpwhipe
+31CivIUhtASWdbS73ay5QaDQSlgNM1/2hk5Beal7D9bGfKtwT/VGDSpKc4EKP8j
ktQSE0ECgYEA/jHMLQyvJ2VuqBdMI5hbaw5jzUAQwaJof5iQNuvFrbtWDeotAf+6
HomwoqzZ9+juiil4PHLQJzkArHwMWXbc+3FAznN1foS+YlOmIgJrjKa+EP+sz/X2
GxuyH3RD9+TH4EGd4TbeDr0eZOnIbKVybj4ueE+um7jtdLzYW2Y8iCcCgYEA6Qu6
x5WOQaPaEOQwEP5AqVBZnZl1ogeEVanlPYl6amPFFnlc41+M61p3ebwRqikaC9Dv
hePiOcTTJyt4h7qzgd5rJTjy5bNYDx9F61NGagF0xJLQiMnXM/TsoFABVWetLepG
DTzgvCf7wmB9QTgdLct7KyG4suDBJlEAvr70q3ECgYEAxx4pC0z5U4oAMYn2aZeq
XOUrxpcdySC4bOMMbQkpk1rBIStEUGGK4OsIw5VVNP5xBSdQ+UESzva3EWYmoloa
5pgjpNUKv62qGQnfhJqStt3S2yv8qfbI7xk14a/IokHDVGbyDn5VWgRI79G1322G
gtcQvcvlQjSNRbm8XXRrjFcCgYA66x1Awl3h2IQUSyyfzzgX1lmhz59+5HmfksGD
SlOpvCmi4fILBihBhHC6VUL+C0ArhppX9mJGiq17tLDXV+t0RQA/u+MlEa+MuzJZ
KYee21ljLV8NhkIjP6Pnb/K2XezZs+YcCK0kxNMQtIZWS9KMtmogYHkquEn83vPa
Rbrj8QKBgHifm6Z9F4qTz2b2RsYPoMHOdsX0DrZ8xQOH8jioTAy/Xi2hrL5Klp7h
zaLifWtOdtckFxIk+6D/zLLn1icC7cc8n4TMwQ1ikY+9IPnkTXVx4b/r/NSbAVxZ
J821mkhGdqKJGAzk6uh/Sn4rNGubH+I1x2Xa9hWbARCLsj8tp6TX
-----END RSA PRIVATE KEY-----`)

var serverCert = []byte(`-----BEGIN CERTIFICATE-----
MIIDHzCCAgegAwIBAgIUTJoqwFusJcupNCs/u39LBFrkZEQwDQYJKoZIhvcNAQEL
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowHzEdMBsGA1UEAwwUd2ViaG9va190ZXN0c19zZXJ2
ZXIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDnZvhvIgmlQPJMqjkW
IJrkSSLLsIJ3xSiV5KiZCOHnNkawhuDP1GqNpMwsXSOpvOH2LHYNBKdj7DfYuo8z
aw4rX79q2Z4Jryblu9mtGgPE/ZPelAdPJ7QL1YjuOqiyYyq5EVqRpjU4PENE9YX0
JGCEUXrY1wd+fO1basyIRi24NGRkaykkv8Hk4DMSAuviI/xMoyWpK6FpCGLnZ0Rm
jSknUh7i6nzHFcp6ip87dZJUN5GmP+fS1hIAuE4J0afRExq/nB9mbF19mkpSEGtz
EV96IMHlzvF2WfOIetjmWpJA8IfEBBtLWMxpXhp2HEPMXnq3lFTr/l5Y9ngi+VNG
1iY3AgMBAAGjVTBTMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG
CCsGAQUFBwMCBggrBgEFBQcDATAaBgNVHREEEzARhwR/AAABgglsb2NhbGhvc3Qw
DQYJKoZIhvcNAQELBQADggEBAAeUHlNJiGfvhi8ts96javP8tO5gPkN7uErIMpzA
N1rf5Kdy7/LsxM6Uvwn0ns+p1vxANAjR/c0nfu0eIO1t5fKVDD0s9+ohKA/6phrm
xChTyl21mDZlFKjq0sjSwzBcUHPJjzUW9+AMDvS7pOjR5h4nD21LlMIkBzinl5KT
uo2Pm/OZqepPdM5XH9DaW0T0tjXKvRFe4FklJSKGD7f+T1whtmyziyA84YjYVa/6
gF+gpIOmPruJI9UoFqEncNpLfh5vKu2Vxv+maztFRhb+9gOg+nVBq1pxmMZV0PuM
L+tz0avIZEO2+KhgVGF3AF8HSZQHYcaskGFSGc8FxDKcDjM=
-----END CERTIFICATE-----`)

var serverCertNoSAN = []byte(`-----BEGIN CERTIFICATE-----
MIIC+DCCAeCgAwIBAgIUTJoqwFusJcupNCs/u39LBFrkZEUwDQYJKoZIhvcNAQEL
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowFDESMBAGA1UEAwwJbG9jYWxob3N0MIIBIjANBgkq
hkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA52b4byIJpUDyTKo5FiCa5Ekiy7CCd8Uo
leSomQjh5zZGsIbgz9RqjaTMLF0jqbzh9ix2DQSnY+w32LqPM2sOK1+/atmeCa8m
5bvZrRoDxP2T3pQHTye0C9WI7jqosmMquRFakaY1ODxDRPWF9CRghFF62NcHfnzt
W2rMiEYtuDRkZGspJL/B5OAzEgLr4iP8TKMlqSuhaQhi52dEZo0pJ1Ie4up8xxXK
eoqfO3WSVDeRpj/n0tYSALhOCdGn0RMav5wfZmxdfZpKUhBrcxFfeiDB5c7xdlnz
iHrY5lqSQPCHxAQbS1jMaV4adhxDzF56t5RU6/5eWPZ4IvlTRtYmNwIDAQABozkw
NzAJBgNVHRMEAjAAMAsGA1UdDwQEAwIF4DAdBgNVHSUEFjAUBggrBgEFBQcDAgYI
KwYBBQUHAwEwDQYJKoZIhvcNAQELBQADggEBAGfCa0eCws/7+NYLJwVsdd7C/QHT
qbPw6w8oGnlXELMPwC701VFOcadhhengYCY1Kwa/KVu1ucFODDgp1ncvRoMVVWvD
/q6V07zu+aV/aW64zU27f+TzxTVXyCgfCSFUELJYBsBFWLw0K57ZDZdN2KJD+zD5
BAU0ghmy1DB+WSFMTqQ2iQaNX8oZh5jTZV3JtRNncqEqqIh4Nv7YYYZ02rgE7P2o
btVFYLBXHW7VYqnWpWM1pBfZpfGzMpGdR+1feST/88gUZh7ze15Ib4BlyU13v+0l
/BjuUsSWiITKWb2fqTiAkrqVbkOrC7Orz8yvgjuih4lEinQV1+KJUtcMmng=
-----END CERTIFICATE-----`)

var clientKey = []byte(`-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEAx9B61aokP+gqr+fYHf3a0J8ilKR2GeQndpg9Mn7MH+nXd5DG
sYqxQ8lISJlY6pGjwHPyk7/ivRDiX19j7xD2YQ0vq6KQ85D3fsqIL/0tJtv0SBa4
T/73b2ZYiG/SOOY+fhCK5RuFtkxi2/zjE1tquoRD0QlT0F5uO6c+7mQAH1eYEeiC
AAZAyf46AaQrKyW1dlFZi38LyVQFXtZD0uBiQb81A79lY7KSh8u70bkKaO4KGBED
zUoGRS4Avaj5SzJeXdXKz7JOGQLaMrlkAlgJWhD06wc020MM9KilvAjseIraeV+2
UGUJQxw8l3yU0WfpY1QzX8t6hBpVyq7Ri0WsGQIDAQABAoIBAApuIotWt0+ysc++
3XQrVSnAtNBniVaupzS0m7UwEz2zOjEemJCZ+cjdD+3iO1b7RT39j3MQ+CgAYqCx
3QiUrRfB1XQzJzffoFu4/MTshVfa8XR14ych2w6wm/x7QdEAi9CO0oFFH4S1lg9/
subGxdp4nwWhZAOjekOY5lsRU0RPeZwkPNN0SNODRO6eC2Pm4sU11+OkcF2BKEbU
Fc4ePtF6V3QBl6iAaFBXZEV+Fu/zGsH+YIlIbeCP5cAwHuAVmR1bfsKWxCmHJFjI
PzrL/bX0vrH6koajgfpZd4BZ8QVQFySLNLPb9vFywrKTJGHwEX6gNT1Dfz4SlGvr
sNEMg4ECgYEA6Szv3eMHDQyVfVa8CgKqeqesgOYcIxIsL0eXVaFCjZpOdiMJaA/8
Gg39ecGzFMRhDxq1pUbYuIXbHL4i3JBiH4328uEI+EPLg34Ov6iPMruvK6ovWEbk
mNlb4yefVoI+qX3fEI2N3XQSM1sFrEqgMMfvoS2XgGaRu+NUITZyy3ECgYEA21+O
rnaP+xt3OJkGD80XR18sXAO5kFfbABKURCkU98VceKjO296+3Zevh/baTOTUBI+R
ggVcMGn1GlHZPumfcKdEFRBL44rio2oDxBOANqHKRxEBbi/K1r7siZJItOxpV3kx
rm/NTt+/t5HI7WJz86waReg2yGJka57CRp0DBykCgYEAy4Uvb+oiU19yc03rHomp
JxmG1ZMDaBEKg9Hm4xS3tETEyxRVt4CMOGmRnl5U4oFtffOALFwj+RrMXtAOOZnE
K2qL6v5EB/2UepbiZKLJKizq/h+y50gpasf9Dc2do7JW4zU8J4SGGI6g/DYsQ293
VlyMaZATtjzQYsBOxBZ0J+ECgYARKWWZIm9bHqfyBo6h19KVY82tmSEAOM9KLyno
NyqLw6XbTqF4M/HMlhxGT7p+P3ySqsSgXlj69J8XIwYS1OYDQyKhXzgAohHe5OFM
ipYCMCAJ9TueaiC9MgyBKq+Db+dBz5piYh62p+xwqPgGEiiuDG21wFfgz0m53Z6n
NYtSGQKBgBUF/6/HQOCnoHjg9VE5oIpp0c0zWOnHp+9vqrGJGfkMQnz5OF+bEK7j
oZ6aymuKC93HB05wB3mxOwNwBGDC6LsaMkzyKuD3YNBXgROAnsTl7FG4j/O15L58
6BGb7UYXGw0RqrasgoLtzL5/3eac/SFgfaLcNtbdk3orGuKPGU3A
-----END RSA PRIVATE KEY-----`)

var clientCert = []byte(`-----BEGIN CERTIFICATE-----
MIIDFDCCAfygAwIBAgIUTJoqwFusJcupNCs/u39LBFrkZEYwDQYJKoZIhvcNAQEL
BQAwGzEZMBcGA1UEAwwQd2ViaG9va190ZXN0c19jYTAgFw0yMjAzMjUxNTMzMjla
GA8yMjk2MDEwODE1MzMyOVowHzEdMBsGA1UEAwwUd2ViaG9va190ZXN0c19jbGll
bnQwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDH0HrVqiQ/6Cqv59gd
/drQnyKUpHYZ5Cd2mD0yfswf6dd3kMaxirFDyUhImVjqkaPAc/KTv+K9EOJfX2Pv
EPZhDS+ropDzkPd+yogv/S0m2/RIFrhP/vdvZliIb9I45j5+EIrlG4W2TGLb/OMT
W2q6hEPRCVPQXm47pz7uZAAfV5gR6IIABkDJ/joBpCsrJbV2UVmLfwvJVAVe1kPS
4GJBvzUDv2VjspKHy7vRuQpo7goYEQPNSgZFLgC9qPlLMl5d1crPsk4ZAtoyuWQC
WAlaEPTrBzTbQwz0qKW8COx4itp5X7ZQZQlDHDyXfJTRZ+ljVDNfy3qEGlXKrtGL
RawZAgMBAAGjSjBIMAkGA1UdEwQCMAAwCwYDVR0PBAQDAgXgMB0GA1UdJQQWMBQG
CCsGAQUFBwMCBggrBgEFBQcDATAPBgNVHREECDAGhwR/AAABMA0GCSqGSIb3DQEB
CwUAA4IBAQA67Zgf2H84cDOlEbBFznivpp9jRQzwv21e4O0o0HtUJ/rgwbfry1D7
LkYjtqMKQcxMREfp4d5rmkC0f7W3Skf3eoaCXTyW7Zh8ghHuqMllReSrOTAjS60m
1kzOAE07/Br1O8JtpPKFX7CTSBvLZYNNTRa/dPyQT8ZAMWSyHLc3kW9peIkQ5SZZ
kZ4EJ0/ztNuTLBbjcaxtFDYJpKuv14NJNy/ddjWvKSyBOtqae3HdEvmnfE9Ar9wt
J20OuNSKUAOZEbk9n8UrTV/C/oQ4yDpw0iHSNWhti+KvARQSTj115NkEg+7HrM4d
vhrAcrxy49UrY03GqZwmaf79vF+c2oKk
-----END CERTIFICATE-----`)

var sha1ServerCertInter = []byte(`-----BEGIN CERTIFICATE-----
MIIDITCCAgmgAwIBAgIUaVjtC++/JGFoZRtkpo/j5q1nQ/4wDQYJKoZIhvcNAQEF
BQAwKDEmMCQGA1UEAwwdd2ViaG9va190ZXN0c19pbnRlcm1lZGlhdGVfY2EwIBcN
MjIwMzI1MTUzMzI5WhgPMjI5NjAxMDgxNTMzMjlaMBQxEjAQBgNVBAMMCWxvY2Fs
aG9zdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOdm+G8iCaVA8kyq
ORYgmuRJIsuwgnfFKJXkqJkI4ec2RrCG4M/Uao2kzCxdI6m84fYsdg0Ep2PsN9i6
jzNrDitfv2rZngmvJuW72a0aA8T9k96UB08ntAvViO46qLJjKrkRWpGmNTg8Q0T1
hfQkYIRRetjXB3587VtqzIhGLbg0ZGRrKSS/weTgMxIC6+Ij/EyjJakroWkIYudn
RGaNKSdSHuLqfMcVynqKnzt1klQ3kaY/59LWEgC4TgnRp9ETGr+cH2ZsXX2aSlIQ
a3MRX3ogweXO8XZZ84h62OZakkDwh8QEG0tYzGleGnYcQ8xeereUVOv+Xlj2eCL5
U0bWJjcCAwEAAaNVMFMwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYw
FAYIKwYBBQUHAwIGCCsGAQUFBwMBMBoGA1UdEQQTMBGHBH8AAAGCCWxvY2FsaG9z
dDANBgkqhkiG9w0BAQUFAAOCAQEATpiJFBwcRFIfZ9ffvS1WDzHqNElEnvocv/ul
3KVtoX4gmKRoOy344s3oJ5APPHYWUFuZVc3uofjW265r2uOW1Cb4P9yAtNc4htBS
+hYsdS3MQlzZCS9rItaT25R6Ieq5TbHGRCof387jzvo1NNhcAQ5akQlQKI87km77
VzoEBdAw68Q0ZE+X34Q9eAA44oCcLAgCpGvs6hQuUSInribSR3vtsjuaLjdJ5F1f
GCu2QGM4cVLaezmoa1J54ETZggT2xFw2IyWJ2g/kXFpo+HnoyaDrPthud3Pe5xEt
JMzX0s3jPSjfeAv34Pr37s0Or18r1bS1hrgxE0SV2vk31fsImg==
-----END CERTIFICATE-----`)

var serverCertInterSHA1 = []byte(`-----BEGIN CERTIFICATE-----
MIIDITCCAgmgAwIBAgIUfSzzygvth1xlpa9DtyGpHuY2V+swDQYJKoZIhvcNAQEL
BQAwKDEmMCQGA1UEAwwdd2ViaG9va190ZXN0c19pbnRlcm1lZGlhdGVfY2EwIBcN
MjIwMzI1MTUzMzI5WhgPMjI5NjAxMDgxNTMzMjlaMBQxEjAQBgNVBAMMCWxvY2Fs
aG9zdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOdm+G8iCaVA8kyq
ORYgmuRJIsuwgnfFKJXkqJkI4ec2RrCG4M/Uao2kzCxdI6m84fYsdg0Ep2PsN9i6
jzNrDitfv2rZngmvJuW72a0aA8T9k96UB08ntAvViO46qLJjKrkRWpGmNTg8Q0T1
hfQkYIRRetjXB3587VtqzIhGLbg0ZGRrKSS/weTgMxIC6+Ij/EyjJakroWkIYudn
RGaNKSdSHuLqfMcVynqKnzt1klQ3kaY/59LWEgC4TgnRp9ETGr+cH2ZsXX2aSlIQ
a3MRX3ogweXO8XZZ84h62OZakkDwh8QEG0tYzGleGnYcQ8xeereUVOv+Xlj2eCL5
U0bWJjcCAwEAAaNVMFMwCQYDVR0TBAIwADALBgNVHQ8EBAMCBeAwHQYDVR0lBBYw
FAYIKwYBBQUHAwIGCCsGAQUFBwMBMBoGA1UdEQQTMBGHBH8AAAGCCWxvY2FsaG9z
dDANBgkqhkiG9w0BAQsFAAOCAQEAwe/JUeIiJ5ugiO4tM0ZtvgHuFC3hK+ZWndRE
z4JfVXTW9soxpa/cOU9QdJhZzouIu9yqZasY4zSEerC1e6grBYP95vMbN6xUAown
wNzrQzyJ6yP526txiIdOkKf+yVNdz0OWNHMPtwTWIr8kKGK23ABF94aUa0VlkErp
Qrd8NQ3guIPI+/upuxirJCFdhE+U3U0pLHpGaGvhkOytfnLYiINwR9norVCDGbQG
ITH0tOz8gVWWWwxa9s5CmbqTnasgUMDh1jHa5xOo+riX8H5lwQUaItKU1JM+QMIR
6Z+M0Isdw647A6tmX7DqNcmHlBKxPN1GDcVXalwYJUoXwTb9Hw==
-----END CERTIFICATE-----`)
