/*
 * Decompiled with CFR 0.152.
 */
package com.dsi.ant.plugins.antplus.pcc.defines;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DeviceType {
    BIKE_POWER(11, "Bike Power Sensors"),
    CONTROLLABLE_DEVICE(16, "Controls"),
    FITNESS_EQUIPMENT(17, "Fitness Equipment Devices"),
    BLOOD_PRESSURE(18, "Blood Pressure Monitors"),
    GEOCACHE(19, "Geocache Transmitters"),
    ENVIRONMENT(25, "Environment Sensors"),
    WEIGHT_SCALE(119, "Weight Sensors"),
    HEARTRATE(120, "Heart Rate Sensors"),
    BIKE_SPDCAD(121, "Bike Speed and Cadence Sensors"),
    BIKE_CADENCE(122, "Bike Cadence Sensors"),
    BIKE_SPD(123, "Bike Speed Sensors"),
    STRIDE_SDM(124, "Stride-Based Speed and Distance Sensors"),
    UNKNOWN(-1, "Unknown");

    private final int intValue;
    private final String name;

    private DeviceType(int intValue, String name) {
        this.intValue = intValue;
        this.name = name;
    }

    public int getIntValue() {
        return this.intValue;
    }

    public static DeviceType getValueFromInt(int intValue) {
        intValue &= 0xFFFFFF7F;
        for (DeviceType dt : DeviceType.values()) {
            if (dt.intValue != intValue) continue;
            return dt;
        }
        return UNKNOWN;
    }

    public String toString() {
        return this.name;
    }
}

