/***************************************************************************
                          vec2d.cpp  -  description
                             -------------------
    begin                : Tue Jan 8 2002
    copyright            : (C) 1999-2002 by Brian Ashe & Jacques Fortier
    email                : gtkpool@seul.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <gtk/gtk.h>
#include <math.h>
#include "vec2d.h"
#include "point2d.h"

Vec2D::Vec2D (double dx, double dy) {
	setVec(dx, dy);
}

Vec2D::Vec2D (const Point2D &p1, const Point2D &p2) {
	setVec(p2.x - p1.x, p2.y - p1.y);
}

Vec2D::Vec2D (const Vec2D &v){
	dx = v.dx; dy = v.dy;
}

double Vec2D::mag () {
	return sqrt(dx * dx + dy * dy);
}
	
Vec2D Vec2D::addVec (const Vec2D vec) {
	return setVec(dx + vec.dx, dy + vec.dy);
}

Vec2D Vec2D::subVec (const Vec2D vec) {
	return setVec(dx - vec.dx, dy - vec.dy);
}

Vec2D Vec2D::unitVec () {
	double m = mag();
	return setVec(dx / m, dy / m);
}

Vec2D Vec2D::mulVec (double scale) {
	return setVec(dx * scale, dy * scale);
}

double Vec2D::dotProd (Vec2D vec2) {
	return dx * vec2.dx + dy * vec2.dy;
}

Vec2D Vec2D::setVec (double dx, double dy) {
	this->dx = dx;
	this->dy = dy;
	return *this;
}

Vec2D Vec2D::setVec (const Vec2D &vec) {
	return setVec(vec.dx, vec.dy);
}


Vec2D Vec2D::copy () {
	return Vec2D(dx, dy);
}

Vec2D::~Vec2D(){
}
