/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.testng.internal.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tarjan<T> {
    int m_index = 0;
    private Stack<T> m_s;
    Map<T, Integer> m_indices = new HashMap<T, Integer>();
    Map<T, Integer> m_lowlinks = new HashMap<T, Integer>();
    private List<T> m_cycle;

    public Tarjan(Graph<T> graph, T start) {
        this.m_s = new Stack();
        this.run(graph, start);
    }

    private void run(Graph<T> graph, T v) {
        this.m_indices.put(v, this.m_index);
        this.m_lowlinks.put(v, this.m_index);
        ++this.m_index;
        this.m_s.push(v);
        for (T vprime : graph.getPredecessors(v)) {
            if (!this.m_indices.containsKey(vprime)) {
                this.run(graph, vprime);
                int min = Math.min(this.m_lowlinks.get(v), this.m_lowlinks.get(vprime));
                this.m_lowlinks.put(v, min);
                continue;
            }
            if (!this.m_s.contains(vprime)) continue;
            this.m_lowlinks.put(v, Math.min(this.m_lowlinks.get(v), this.m_indices.get(vprime)));
        }
        if (this.m_lowlinks.get(v) == this.m_indices.get(v)) {
            T n;
            this.m_cycle = new ArrayList<T>();
            do {
                n = this.m_s.pop();
                this.m_cycle.add(n);
            } while (!n.equals(v));
        }
    }

    public static void main(String[] args) {
        Graph<String> g = new Graph<String>();
        g.addNode("a");
        g.addNode("b");
        g.addNode("c");
        g.addNode("d");
        String[] edges = new String[]{"a", "b", "b", "a", "c", "d", "d", "a", "a", "c"};
        for (int i = 0; i < edges.length; i += 2) {
            g.addPredecessor(edges[i], edges[i + 1]);
        }
        new Tarjan<String>(g, "a");
    }

    public List<T> getCycle() {
        return this.m_cycle;
    }
}

