/***************************************************************************
             unitmanager  -
                             -------------------
    begin                : 2004-05-05
    copyright            : (C) 2004 by Klaas Freitag
    email                : freitag@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _UNITMANAGER_H
#define _UNITMANAGER_H

#include <QDate>
#include "einheit.h"

/**
 *
 */

// FIXME: How to identify the unit for piece?
#define PIECE_UNIT_ID 6

class UnitManager
{
  public:
    UnitManager();

    virtual ~UnitManager();
    static UnitManager* self();

    Einheit getUnit( int id );
    Einheit getPauschUnit();
    QStringList allUnits();
    Einheit getUnit(const QString& singularUnit);
    int getUnitIDSingular( const QString& einheit );
    QString getECE20(const QString& einheitStr);

    // Workaround: since the unit table does not have an auto update id column,
    // this function calculates the next free unit id to save a new one.
    int nextFreeId();

    /* parked tax related functions for the moment */
    bool readTaxes( const QDate& );
    double tax( const QDate& date );
    double reducedTax( const QDate& date );

  private:
    Einheit::List mUnits;

    void load();

    double mFullTax;
    double mReducedTax;
    QDate  mTaxDate;


};

#endif

/* END */

