/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/*!
    \file   _lcmaps_voms_attributes.h
    \brief  This file contains the headers for the functions to retrieve
            VOMS attributes (fqans) from gsi credentials/contexts (at the gssapi level)
    \author Martijn Steenbakkers for EGEE

    This file contains the headers for the functions to retrieve VOMS
    attributes (fqans) from gsi credentials/contexts (at the gssapi level)
    The following functions are defined:
    -# lcmaps_gss_cred_to_voms_fqans()
*/

#ifndef _LCMAPS_VOMS_ATTRIBUTES_H
#define _LCMAPS_VOMS_ATTRIBUTES_H

/******************************************************************************
                             Include header files
******************************************************************************/
#include <gssapi.h>

#include "lcmaps_types.h"

/******************************************************************************
 *                 Module definition
 *****************************************************************************/

/******************************************************************************
Function:    lcmaps_gss_cred_to_voms_fqans
Description:
    Extract from a gsi credential (of type gss_cred_id_t) a list of VOMS
    fully qualified attribute names (FQANs)
Parameters:
    gss_credential: gsi credential (of type gss_cred_id_t)
    pnfqan:         the number of fqans found. If the proxy is empty (VERR_NOEXT),
                    this will be set to zero. Not an immediate error !
Returns:
    A list of fqans or NULL
******************************************************************************/
char ** lcmaps_gss_cred_to_voms_fqans(
        gss_cred_id_t gss_credential,
        lcmaps_vomsdata_t ** lcmaps_vomsdata,
        int * pnfqan
);

/******************************************************************************
Function:    lcmaps_x509_to_voms_fqans
Description:
    Extract from X509 certificate chain (of types X509, STACK_OF(X509)) a list of VOMS
    fully qualified attribute names (FQANs)
Parameters:
    px509_cred:     pointer to a x509 credential
    px509_chain:    pointer to a x509 chain
    pnfqan:         the number of fqans found. If the proxy is empty (VERR_NOEXT),
                    this will be set to zero. Not an immediate error !
Returns:
    A list of fqans or NULL
******************************************************************************/
char ** lcmaps_x509_to_voms_fqans(
        X509 * px509_cred,
        STACK_OF(X509) * px509_chain,
        lcmaps_vomsdata_t ** lcmaps_vomsdata,
        int * pnfqan
);


#endif /* _LCMAPS_VOMS_ATTRIBUTES_H */

/******************************************************************************
CVS Information:
    $Source: /srv/home/dennisvd/svn/mw-security/lcmaps/src/grid_credential_handling/gsi_handling/_lcmaps_voms_attributes.h,v $
    $Date: 2014-03-13 11:56:06 +0100 (Thu, 13 Mar 2014) $
    $Revision: 17647 $
    $Author: msalle $
******************************************************************************/
