/*
 *  config.h
 *  mod_musicindex
 *
 *  $Id: config.h 1001 2012-07-30 18:45:20Z varenet $
 *
 *  Created by Thibaut VARENE on Thu Mar 20 2003.
 *  Copyright (c) 2003-2005 Regis BOUDIN
 *  Copyright (c) 2003-2004 Thibaut VARENE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License version 2.1,
 *  as published by the Free Software Foundation.
 *
 */

#ifndef CONFIG_H
#define CONFIG_H

#include "mod_musicindex.h"

#define CONF_COOKIE_LIFE 300	/**< Default lifetime for the cookie in seconds */
#define CONF_RSS_ITEMS	 20	/**< Default number of items to be displayed in a RSS feed */
#define CONF_DIRPERLINE	3	/**< Number of directories to show per line by default */

/*
 * Flags used in mu_config struct, field "sets".
 * 16 bits max.
 */
#define CF_TITLE	(1 << 0)	/**< title was set */
#define CF_DIR		(1 << 1)	/**< directory was set - currently impossible */
#define CF_CSS		(1 << 2)	/**< CSS was set */
#define CF_ICES		(1 << 3)	/**< Icecast server was set */
#define CF_CACHE	(1 << 4)	/**< Cache backend was set */
#define CF_DPL		(1 << 5)	/**< Dirs per line was set */
#define CF_CKLF		(1 << 6)	/**< Cookie life was set */
#define CF_RSS		(1 << 7)	/**< RSS was set */
#define CF_ORDER	(1 << 8)	/**< sort order was set */
#define CF_FIELDS	(1 << 9)	/**< display fields were set */

#define CF_MERGED	(1 << 15)	/**< flag for merged config */

void *create_musicindex_config(apr_pool_t *p, char *dummy);

void *merge_musicindex_configs(apr_pool_t *p, void *basev, void *addv);

extern const command_rec musicindex_cmds[];

#endif	/* CONFIG_H */
