/* SPDX-FileCopyrightText: 2014-2025 - Sébastien Wilmet <swilmet@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>

G_BEGIN_DECLS

G_MODULE_EXPORT
void		gtk_source_iter_get_leading_spaces_end_boundary		(const GtkTextIter *iter,
									 GtkTextIter       *leading_end);

G_MODULE_EXPORT
void		gtk_source_iter_get_trailing_spaces_start_boundary	(const GtkTextIter *iter,
									 GtkTextIter       *trailing_start);

G_MODULE_EXPORT
gchar *		gtk_source_iter_get_line_indentation			(const GtkTextIter *iter);

G_MODULE_EXPORT
gboolean	gtk_source_iter_starts_string				(const GtkTextIter *iter,
									 const gchar       *str,
									 GtkTextIter       *match_end);

G_MODULE_EXPORT
gboolean	gtk_source_iter_ends_string				(const GtkTextIter *iter,
									 const gchar       *str,
									 GtkTextIter       *match_start);

G_END_DECLS
