/**
 * \file pappsomspp/processing/cbor/psm/evalscan/psmfeaturesscan.h
 * \date 15/07/2025
 * \author Olivier Langella
 * \brief compute features on scan's PSM
 */

/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of PAPPSOms-tools.
 *
 *     PAPPSOms-tools is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms-tools is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms-tools.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/
#pragma once

#include "../cborscanmapbase.h"
#include "../../../../psm/xtandem/xtandemspectrumprocess.h"
#include "../../../../psm/features/psmfeatures.h"


namespace pappso
{
namespace cbor
{
namespace psm
{

/**
 * @todo write docs
 */
class PsmFeaturesScan : public CborScanMapBase
{
  public:
  /**
   * Default constructor
   */
  PsmFeaturesScan(const PsmFileScanProcess &psm_file_scan_process,
                  pappso::XtandemSpectrumProcess &tandem_spectrum_process,
                  std::list<pappso::Enums::PeptideIon> &ion_list,
                  pappso::PsmFeatures &psm_features,
                  pappso::PrecisionPtr fragment_tolerance);

  /**
   * Destructor
   */
  virtual ~PsmFeaturesScan();

  protected:
  void process() override;
  double checkInf(double input) const;

  private:
  pappso::XtandemSpectrumProcess &m_tandemSpectrumProcess;
  std::list<pappso::Enums::PeptideIon> &m_ionList;
  pappso::PsmFeatures m_psmFeatures;
  pappso::PrecisionPtr m_fragmentTolerance;
};

} // namespace psm
} // namespace cbor
} // namespace pappso
