// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use gdk_pixbuf_sys::*;
use std::env;
use std::error::Error;
use std::ffi::OsString;
use std::mem::{align_of, size_of};
use std::path::Path;
use std::process::Command;
use std::str;
use tempfile::Builder;

static PACKAGES: &[&str] = &["gdk-pixbuf-2.0"];

#[derive(Clone, Debug)]
struct Compiler {
    pub args: Vec<String>,
}

impl Compiler {
    pub fn new() -> Result<Self, Box<dyn Error>> {
        let mut args = get_var("CC", "cc")?;
        args.push("-Wno-deprecated-declarations".to_owned());
        // For _Generic
        args.push("-std=c11".to_owned());
        // For %z support in printf when using MinGW.
        args.push("-D__USE_MINGW_ANSI_STDIO".to_owned());
        args.extend(get_var("CFLAGS", "")?);
        args.extend(get_var("CPPFLAGS", "")?);
        args.extend(pkg_config_cflags(PACKAGES)?);
        Ok(Self { args })
    }

    pub fn compile(&self, src: &Path, out: &Path) -> Result<(), Box<dyn Error>> {
        let mut cmd = self.to_command();
        cmd.arg(src);
        cmd.arg("-o");
        cmd.arg(out);
        let status = cmd.spawn()?.wait()?;
        if !status.success() {
            return Err(format!("compilation command {:?} failed, {}", &cmd, status).into());
        }
        Ok(())
    }

    fn to_command(&self) -> Command {
        let mut cmd = Command::new(&self.args[0]);
        cmd.args(&self.args[1..]);
        cmd
    }
}

fn get_var(name: &str, default: &str) -> Result<Vec<String>, Box<dyn Error>> {
    match env::var(name) {
        Ok(value) => Ok(shell_words::split(&value)?),
        Err(env::VarError::NotPresent) => Ok(shell_words::split(default)?),
        Err(err) => Err(format!("{} {}", name, err).into()),
    }
}

fn pkg_config_cflags(packages: &[&str]) -> Result<Vec<String>, Box<dyn Error>> {
    if packages.is_empty() {
        return Ok(Vec::new());
    }
    let pkg_config = env::var_os("PKG_CONFIG").unwrap_or_else(|| OsString::from("pkg-config"));
    let mut cmd = Command::new(pkg_config);
    cmd.arg("--cflags");
    cmd.args(packages);
    let out = cmd.output()?;
    if !out.status.success() {
        return Err(format!("command {:?} returned {}", &cmd, out.status).into());
    }
    let stdout = str::from_utf8(&out.stdout)?;
    Ok(shell_words::split(stdout.trim())?)
}

#[derive(Copy, Clone, Debug, Eq, PartialEq)]
struct Layout {
    size: usize,
    alignment: usize,
}

#[derive(Copy, Clone, Debug, Default, Eq, PartialEq)]
struct Results {
    /// Number of successfully completed tests.
    passed: usize,
    /// Total number of failed tests (including those that failed to compile).
    failed: usize,
}

impl Results {
    fn record_passed(&mut self) {
        self.passed += 1;
    }
    fn record_failed(&mut self) {
        self.failed += 1;
    }
    fn summary(&self) -> String {
        format!("{} passed; {} failed", self.passed, self.failed)
    }
    fn expect_total_success(&self) {
        if self.failed == 0 {
            println!("OK: {}", self.summary());
        } else {
            panic!("FAILED: {}", self.summary());
        };
    }
}

#[test]
#[cfg(target_os = "linux")]
fn cross_validate_constants_with_c() {
    let mut c_constants: Vec<(String, String)> = Vec::new();

    for l in get_c_output("constant").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let value = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse value");
        c_constants.push((name, value));
    }

    let mut results = Results::default();

    for ((rust_name, rust_value), (c_name, c_value)) in
        RUST_CONSTANTS.iter().zip(c_constants.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_value != c_value {
            results.record_failed();
            eprintln!(
                "Constant value mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_value, &c_value
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

#[test]
#[cfg(target_os = "linux")]
fn cross_validate_layout_with_c() {
    let mut c_layouts = Vec::new();

    for l in get_c_output("layout").unwrap().lines() {
        let mut words = l.trim().split(';');
        let name = words.next().expect("Failed to parse name").to_owned();
        let size = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse size");
        let alignment = words
            .next()
            .and_then(|s| s.parse().ok())
            .expect("Failed to parse alignment");
        c_layouts.push((name, Layout { size, alignment }));
    }

    let mut results = Results::default();

    for ((rust_name, rust_layout), (c_name, c_layout)) in RUST_LAYOUTS.iter().zip(c_layouts.iter())
    {
        if rust_name != c_name {
            results.record_failed();
            eprintln!("Name mismatch:\nRust: {:?}\nC:    {:?}", rust_name, c_name,);
            continue;
        }

        if rust_layout != c_layout {
            results.record_failed();
            eprintln!(
                "Layout mismatch for {}\nRust: {:?}\nC:    {:?}",
                rust_name, rust_layout, &c_layout
            );
            continue;
        }

        results.record_passed();
    }

    results.expect_total_success();
}

fn get_c_output(name: &str) -> Result<String, Box<dyn Error>> {
    let tmpdir = Builder::new().prefix("abi").tempdir()?;
    let exe = tmpdir.path().join(name);
    let c_file = Path::new("tests").join(name).with_extension("c");

    let cc = Compiler::new().expect("configured compiler");
    cc.compile(&c_file, &exe)?;

    let mut abi_cmd = Command::new(exe);
    let output = abi_cmd.output()?;
    if !output.status.success() {
        return Err(format!("command {:?} failed, {:?}", &abi_cmd, &output).into());
    }

    Ok(String::from_utf8(output.stdout)?)
}

const RUST_LAYOUTS: &[(&str, Layout)] = &[
    (
        "GdkColorspace",
        Layout {
            size: size_of::<GdkColorspace>(),
            alignment: align_of::<GdkColorspace>(),
        },
    ),
    (
        "GdkInterpType",
        Layout {
            size: size_of::<GdkInterpType>(),
            alignment: align_of::<GdkInterpType>(),
        },
    ),
    (
        "GdkPixbufAlphaMode",
        Layout {
            size: size_of::<GdkPixbufAlphaMode>(),
            alignment: align_of::<GdkPixbufAlphaMode>(),
        },
    ),
    (
        "GdkPixbufAnimation",
        Layout {
            size: size_of::<GdkPixbufAnimation>(),
            alignment: align_of::<GdkPixbufAnimation>(),
        },
    ),
    (
        "GdkPixbufAnimationClass",
        Layout {
            size: size_of::<GdkPixbufAnimationClass>(),
            alignment: align_of::<GdkPixbufAnimationClass>(),
        },
    ),
    (
        "GdkPixbufAnimationIter",
        Layout {
            size: size_of::<GdkPixbufAnimationIter>(),
            alignment: align_of::<GdkPixbufAnimationIter>(),
        },
    ),
    (
        "GdkPixbufAnimationIterClass",
        Layout {
            size: size_of::<GdkPixbufAnimationIterClass>(),
            alignment: align_of::<GdkPixbufAnimationIterClass>(),
        },
    ),
    (
        "GdkPixbufError",
        Layout {
            size: size_of::<GdkPixbufError>(),
            alignment: align_of::<GdkPixbufError>(),
        },
    ),
    (
        "GdkPixbufFormat",
        Layout {
            size: size_of::<GdkPixbufFormat>(),
            alignment: align_of::<GdkPixbufFormat>(),
        },
    ),
    (
        "GdkPixbufFormatFlags",
        Layout {
            size: size_of::<GdkPixbufFormatFlags>(),
            alignment: align_of::<GdkPixbufFormatFlags>(),
        },
    ),
    (
        "GdkPixbufLoader",
        Layout {
            size: size_of::<GdkPixbufLoader>(),
            alignment: align_of::<GdkPixbufLoader>(),
        },
    ),
    (
        "GdkPixbufLoaderClass",
        Layout {
            size: size_of::<GdkPixbufLoaderClass>(),
            alignment: align_of::<GdkPixbufLoaderClass>(),
        },
    ),
    (
        "GdkPixbufModule",
        Layout {
            size: size_of::<GdkPixbufModule>(),
            alignment: align_of::<GdkPixbufModule>(),
        },
    ),
    (
        "GdkPixbufModulePattern",
        Layout {
            size: size_of::<GdkPixbufModulePattern>(),
            alignment: align_of::<GdkPixbufModulePattern>(),
        },
    ),
    (
        "GdkPixbufRotation",
        Layout {
            size: size_of::<GdkPixbufRotation>(),
            alignment: align_of::<GdkPixbufRotation>(),
        },
    ),
];

const RUST_CONSTANTS: &[(&str, &str)] = &[
    ("(gint) GDK_COLORSPACE_RGB", "0"),
    ("(gint) GDK_INTERP_BILINEAR", "2"),
    ("(gint) GDK_INTERP_HYPER", "3"),
    ("(gint) GDK_INTERP_NEAREST", "0"),
    ("(gint) GDK_INTERP_TILES", "1"),
    ("(gint) GDK_PIXBUF_ALPHA_BILEVEL", "0"),
    ("(gint) GDK_PIXBUF_ALPHA_FULL", "1"),
    ("(gint) GDK_PIXBUF_ERROR_BAD_OPTION", "2"),
    ("(gint) GDK_PIXBUF_ERROR_CORRUPT_IMAGE", "0"),
    ("(gint) GDK_PIXBUF_ERROR_FAILED", "5"),
    ("(gint) GDK_PIXBUF_ERROR_INCOMPLETE_ANIMATION", "6"),
    ("(gint) GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY", "1"),
    ("(gint) GDK_PIXBUF_ERROR_UNKNOWN_TYPE", "3"),
    ("(gint) GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION", "4"),
    ("(guint) GDK_PIXBUF_FORMAT_SCALABLE", "2"),
    ("(guint) GDK_PIXBUF_FORMAT_THREADSAFE", "4"),
    ("(guint) GDK_PIXBUF_FORMAT_WRITABLE", "1"),
    ("(gint) GDK_PIXBUF_ROTATE_CLOCKWISE", "270"),
    ("(gint) GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE", "90"),
    ("(gint) GDK_PIXBUF_ROTATE_NONE", "0"),
    ("(gint) GDK_PIXBUF_ROTATE_UPSIDEDOWN", "180"),
];
