.TH XvStopVideo __libmansuffix__ __vendorversion__ "libXv Functions"
.SH NAME
XvStopVideo \- stop active video
.\"
.SH SYNOPSIS
.B #include <X11/extensions/Xvlib.h>
.sp
.nf
.BI "int XvStopVideo(Display *" dpy ", XvPortID " port ", Drawable " draw ");"
.fi
.SH ARGUMENTS
.\"
.IP \fIdpy\fR 8
Specifies the connection to the X server.
.IP \fIport\fR 8
Specifies the port for which video is to be stopped.
.IP \fIdraw\fR 8
Specifies the drawable associated with the named port.
.SH DESCRIPTION
.\"
.BR XvStopVideo (__libmansuffix__)
stops active video for the specified port and drawable.  If the port
is not processing video, or if it is processing video in a different
drawable, the request is ignored.  When video is stopped a
.BR XvVideoNotify (__libmansuffix__)
event with detail XvStopped is generated for the associated drawable.
.\"
.SH RETURN VALUES
.IP [Success] 8
Returned if
.BR XvStopVideo (__libmansuffix__)
completed successfully.
.IP [XvBadExtension] 8
Returned if the Xv extension is unavailable.
.IP [XvBadAlloc] 8
Returned if
.BR XvStopVideo (__libmansuffix__)
failed to allocate memory to process the request.
.SH DIAGNOSTICS
.IP [XvBadPort] 8
Generated if the requested port does not exist.
.IP [BadDrawable] 8
Generated if the requested drawable does not exist.
.\"
.SH SEE ALSO
.BR XvGetVideo (__libmansuffix__),
.BR XvPutVideo (__libmansuffix__),
.BR XvVideoNotify (__libmansuffix__)
