# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.pass_input_type_algorithm import PassInputTypeAlgorithm


class AggregateDataSetFilter(PassInputTypeAlgorithm):
    r"""
    AggregateDataSetFilter - Aggregates data sets to a reduced number
    of processes.
    
    Superclass: PassInputTypeAlgorithm
    
    This class allows polydata and unstructured grids to be aggregated
    over a smaller set of processes. The derived
    DIYAggregateDataSetFilter will operate on image data, rectilinear
    grids and structured grids.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAggregateDataSetFilter, obj, update, **traits)
    
    merge_points = tvtk_base.true_bool_trait(desc=\
        r"""
        Get/Set if the filter should merge coincidental points Note 1:
        The filter will only merge points if the ghost cell array doesn't
        exist Note 2: This option is only taken into account with
        UnstructuredGrid objects Defaults to On
        """
    )

    def _merge_points_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMergePoints,
                        self.merge_points_)

    number_of_target_processes = traits.Int(1, enter_set=True, auto_set=False, desc=\
        r"""
        Number of target processes. Valid values are between 1 and the
        total number of processes. The default is 1. If a value is passed
        in that is less than 1 than number_of_target_processes is
        changed/kept at 1. If a value is passed in that is greater than
        the total number of processes then number_of_target_processes is
        changed/kept at the total number of processes. This is useful for
        scripting use cases where later on the script is run with more
        processes than the current amount.
        """
    )

    def _number_of_target_processes_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNumberOfTargetProcesses,
                        self.number_of_target_processes)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    _updateable_traits_ = \
    (('merge_points', 'GetMergePoints'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('number_of_target_processes',
    'GetNumberOfTargetProcesses'), ('progress', 'GetProgress'),
    ('progress_text', 'GetProgressText'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display', 'merge_points',
    'release_data_flag', 'number_of_target_processes', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AggregateDataSetFilter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AggregateDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['merge_points'], [], ['number_of_target_processes']),
            title='Edit AggregateDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AggregateDataSetFilter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

