/*
 * SPDX-License-Identifier: GPL-2.0-only
 */

/**
 * @file
 * @ingroup tests
 * This file provides some doxygen documentation for the tests module.
 */

/**
 * @ingroup tests
 * @defgroup system-tests System Tests
 *
 * @brief The "tests" module contains the System Tests, i.e., tests that
 * dependss on multiple modules. Due to their dependencies, the System Tests
 * are in this module.
 *
 * Unit tests, on the contrary, are located in each module.
 */

/**
 * @ingroup system-tests
 * @ingroup traffic-control-test
 * @defgroup system-tests-tc TrafficControl System Tests
 *
 * @brief TrafficControl System Tests
 */

/**
 * @ingroup system-tests
 * @ingroup internet-test
 * @defgroup system-tests-tcp TCP System Tests
 *
 * @brief TCP System Tests
 */

/**
 * @ingroup system-tests
 * @ingroup wifi-test
 * @defgroup system-tests-wifi WiFi System Tests
 *
 * @brief WiFi System Tests
 */

/**
 * @ingroup system-tests
 * @defgroup system-tests-perf Performance System Tests
 *
 * @brief Performance System Tests
 *
 * Note: these tests are (for real) scripts to be run.
 * The output is the time (in nanoseconds) that the test
 * required to perform the requested write operations.
 */

/**
 * @ingroup system-tests
 * @ingroup core-tests
 * @defgroup system-tests-traced TracedCallback System Tests
 *
 * @brief TracedCallback System Tests
 */

/**
 * @ingroup system-tests
 * @ingroup csma
 * @defgroup system-tests-csma CSMA System Tests
 *
 * @brief CSMA System Tests
 */
