/* NVTV GUI (NX part) -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: gui_nx.c,v 1.3 2003/10/10 16:16:57 dthierbach Exp $
 *
 * Contents:
 *
 * The GTK graphical user interface. Nvidia internal NX encoder part.
 */

#include "local.h" /* before everything else */

#include <gtk/gtk.h>

#include "gui.h"
#include "gui_nx.h"

GtkAdjustment *update_nx;

#define FIELD(b,m) addr:&(b.m), size:sizeof(b.m)
#define FIELD_NX(m) FIELD(gui_regs.enc.nx,m)

/* -------- GUI Masks -------- */

static GuiRegMask nx_mask1_reg [] = {
  {label:"scaler_h",   bits:10, tick:1, FIELD_NX(img.scaler_h)},
  {label:"scaler_v",   bits:10, tick:1, FIELD_NX(img.scaler_v)},
  {label:"overscan",   bits:11, tick:1, FIELD_NX(img.overscan)},
  {label:"vip1",       bits:28, tick:1, FIELD_NX(img.vip1)},
  {label:"vip2",       bits:28, tick:1, FIELD_NX(img.vip2)},
  {label:"muxa",       bits:2,  tick:1, FIELD_NX(muxa)},
  {label:"muxb",       bits:2,  tick:1, FIELD_NX(muxb)},
  {label:"muxc",       bits:2,  tick:1, FIELD_NX(muxc)},
  {label:"filter",     bits:2,  tick:1, FIELD_NX(filter)},
  {label:NULL}
};				    

static GuiRegMask nx_mask2_reg [] = {
  {label:"reg04",      bits:8,  tick:1, FIELD_NX(ind.nxreg04)},
  {label:"reg08",      bits:8,  tick:1, FIELD_NX(ind.nxreg08)},
  {label:"reg09",      bits:7,  tick:1, FIELD_NX(ind.nxreg09)},
  {label:"reg0a",      bits:8,  tick:1, FIELD_NX(ind.nxreg0a)},
  {label:"reg0b",      bits:8,  tick:1, FIELD_NX(ind.nxreg0b)},
  {label:"reg0c",      bits:8,  tick:1, FIELD_NX(ind.nxreg0c)},
  {label:"reg0e",      bits:10, tick:4, FIELD_NX(ind.nxreg0e)},
  {label:"reg10",      bits:10, tick:4, FIELD_NX(ind.nxreg10)},
  {label:"reg17",      bits:10, tick:4, FIELD_NX(ind.nxreg17)},
  {label:"reg1e",      bits:10, tick:4, FIELD_NX(ind.nxreg1e)},
  {label:"reg20",      bits:8,  tick:1, FIELD_NX(ind.nxreg20)},
  {label:"reg22",      bits:8,  tick:1, FIELD_NX(ind.nxreg22)},
  {label:"reg29",      bits:5,  tick:1, FIELD_NX(ind.nxreg29)},
  {label:"reg2c",      bits:6,  tick:1, FIELD_NX(ind.nxreg2c)},
  {label:"reg31",      bits:11, tick:8, FIELD_NX(ind.nxreg31)}, 
  {label:"reg35",      bits:8,  tick:1, FIELD_NX(ind.nxreg35)},
  {label:"reg3c",      bits:10, tick:4, FIELD_NX(ind.nxreg3c)},
  {label:"sys12",      bits:2,  tick:1, FIELD_NX(ind.nxsys12)},
  {label:NULL}
};				    

static GuiRegMask nx_mask1_twin [] = {
  {label:"fsub:",           bits:32, tick:1, FIELD_NX(ind.fsub)},
  {label:NULL}
};				    

static GuiFlagMask nx_mask1_flag [] = {
  {label:"daca",    mask:NX_FLAG1_DACA,   FIELD_NX(flags1)}, 
  {label:"dacb",    mask:NX_FLAG1_DACB,   FIELD_NX(flags1)}, 
  {label:"dacc",    mask:NX_FLAG1_DACC,   FIELD_NX(flags1)}, 
  {label:NULL }
};

static GuiFlagMask nx_mask2_flag [] = {
  {label:"sys-0",   mask:NX_FLAG_SYS_0,  FIELD_NX(ind.flags)},
  {label:"sys-3",   mask:NX_FLAG_SYS_3,  FIELD_NX(ind.flags)},
  {label:"sys-6",   mask:NX_FLAG_SYS_6,  FIELD_NX(ind.flags)},
  {label:"conn-3",  mask:NX_FLAG_CONN_3, FIELD_NX(ind.flags)},
  {label:"conn-5",  mask:NX_FLAG_CONN_5, FIELD_NX(ind.flags)},
  {label:NULL }
};

static GuiRegMask nx_mask1_filt [] = {
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x1[0][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x1[0][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x1[0][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x1[0][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x1[0][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x1[0][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x1[0][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x1[1][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x1[1][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x1[1][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x1[1][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x1[1][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x1[1][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x1[1][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x1[2][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x1[2][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x1[2][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x1[2][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x1[2][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x1[2][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x1[2][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x1[3][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x1[3][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x1[3][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x1[3][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x1[3][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x1[3][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x1[3][6])},
  {label:NULL}
};				    

static GuiRegMask nx_mask2_filt [] = {
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x2[0][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x2[0][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x2[0][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x2[0][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x2[0][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x2[0][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x2[0][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x2[1][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x2[1][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x2[1][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x2[1][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x2[1][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x2[1][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x2[1][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x2[2][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x2[2][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x2[2][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x2[2][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x2[2][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x2[2][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x2[2][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_x2[3][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_x2[3][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_x2[3][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_x2[3][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_x2[3][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_x2[3][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_x2[3][6])},
  {label:NULL}
};				    

static GuiRegMask nx_mask3_filt [] = {
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_y[0][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_y[0][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_y[0][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_y[0][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_y[0][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_y[0][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_y[0][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_y[1][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_y[1][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_y[1][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_y[1][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_y[1][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_y[1][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_y[1][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_y[2][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_y[2][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_y[2][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_y[2][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_y[2][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_y[2][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_y[2][6])},
  {label:"1", bits:-10, tick:1, FIELD_NX(filt_y[3][0])},
  {label:"2", bits:-10, tick:1, FIELD_NX(filt_y[3][1])},
  {label:"3", bits:-10, tick:1, FIELD_NX(filt_y[3][2])},
  {label:"4", bits:-10, tick:1, FIELD_NX(filt_y[3][3])},
  {label:"5", bits:-10, tick:1, FIELD_NX(filt_y[3][4])},
  {label:"6", bits:-10, tick:1, FIELD_NX(filt_y[3][5])},
  {label:"7", bits:-10, tick:1, FIELD_NX(filt_y[3][6])},
  {label:NULL}
};				    

/* -------- -------- */

void reset_nx_cb (GtkObject *obj, gpointer data)
{
  if ((gui_tv_chip & TV_ENCODER) != TV_NVIDIA) return;
  if (gui_act_mode) {
    gui_regs.enc.bt = gui_act_mode->regs.enc.bt;
    gui_tv_set ();
    gtk_signal_emit_by_name (GTK_OBJECT (update_nx), "changed");
    gtk_signal_emit_by_name (GTK_OBJECT (changed_all), "changed");
  }
}

void update_nx_cb (GtkObject *obj, gpointer data)
{
  if ((gui_tv_chip & TV_ENCODER) != TV_NVIDIA) return;
  gtk_signal_emit_by_name (GTK_OBJECT (update_nx), "changed");
}

void gui_map_nx_cb (GtkWidget *widget, gpointer data)
{
  RAISE (MSG_DEBUG, "gui_map_nx_cb");
}

void gui_unmap_nx_cb (GtkWidget *widget, gpointer data)
{
  RAISE (MSG_DEBUG, "gui_unmap_nx_cb");
}

/* -------- GUI Pages -------- */

GtkWidget *gui_nx_reg1_page (void)
{
  GtkAccelGroup *gui_nx_reg_accel_group;

  gui_nx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NVidia internal encoder registers 1", 
    gui_nx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_nx), GTK_SIGNAL_FUNC (reset_nx_cb),
    0, 0, 5, nx_mask1_reg, 0, 6, nx_mask1_twin, 0, 7, 3, nx_mask1_flag);
}

GtkWidget *gui_nx_reg2_page (void)
{
  GtkAccelGroup *gui_nx_reg_accel_group;

  gui_nx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NVidia internal encoder registers 2", 
    gui_nx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_nx), GTK_SIGNAL_FUNC (reset_nx_cb),
    0, 0, 11, nx_mask2_reg, 0, 11, NULL, 6, 0, 11, nx_mask2_flag);
}

GtkWidget *gui_nx_filt1_page (void)
{
  GtkAccelGroup *gui_nx_reg_accel_group;

  gui_nx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NVidia internal encoder filter x1", 
    gui_nx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_nx), GTK_SIGNAL_FUNC (reset_nx_cb),
    0, 0, 7, nx_mask1_filt, 0, 11, NULL, 0, 0, 0, NULL);
}

GtkWidget *gui_nx_filt2_page (void)
{
  GtkAccelGroup *gui_nx_reg_accel_group;

  gui_nx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NVidia internal encoder filter x2", 
    gui_nx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_nx), GTK_SIGNAL_FUNC (reset_nx_cb),
    0, 0, 7, nx_mask2_filt, 0, 11, NULL, 0, 0, 0, NULL);
}

GtkWidget *gui_nx_filt3_page (void)
{
  GtkAccelGroup *gui_nx_reg_accel_group;

  gui_nx_reg_accel_group = gtk_accel_group_new ();
  return gui_regs_page ("NVidia internal encoder filter y", 
    gui_nx_reg_accel_group, PRINT_CHIP_REGS,
    GTK_OBJECT (update_nx), GTK_SIGNAL_FUNC (reset_nx_cb),
    0, 0, 7, nx_mask3_filt, 0, 11, NULL, 0, 0, 0, NULL);
}

void gui_nx_init (void)
{
  update_nx = (GtkAdjustment *) gtk_adjustment_new (0, 0, 0, 0, 0, 0);
  gtk_signal_connect (GTK_OBJECT (update_chip), "changed", 
    GTK_SIGNAL_FUNC (update_nx_cb), NULL);
}
