// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GccEnt_HeaderFile
#define _GccEnt_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineAlloc.hxx>
#include <Standard_Macro.hxx>

class GccEnt_QualifiedLin;
class gp_Lin2d;
class GccEnt_QualifiedCirc;
class gp_Circ2d;
class GccEnt_QualifiedLin;
class GccEnt_QualifiedCirc;
class GccEnt_Array1OfPosition;


//! This package provides an implementation of the qualified
//! entities useful to create 2d entities with geometric
//! constraints. The qualifier explains which subfamily of
//! solutions we want to obtain. It uses the following law: the
//! matter/the interior side is at the left of the line, if we go
//! from the beginning to the end.
//! The qualifiers are:
//! Enclosing   : the solution(s) must enclose the argument.
//! Enclosed    : the solution(s) must be enclosed in the
//! argument.
//! Outside     : both the solution(s) and the argument must be
//! outside to each other.
//! Unqualified : the position is undefined, so give all the
//! solutions.
//! The use of a qualifier is always required if such
//! subfamilies exist. For example, it is not used for a point.
//! Note:    the interior of a curve is defined as the left-hand
//! side of the curve in relation to its orientation.
class GccEnt 
{
public:

  DEFINE_STANDARD_ALLOC

  
  //! Constructs a qualified line,
  //! so that the relative position to the circle or line of the
  //! solution computed by a construction algorithm using the
  //! qualified circle or line is not qualified, i.e. all solutions apply.
  Standard_EXPORT static   GccEnt_QualifiedLin Unqualified (const gp_Lin2d& Obj) ;
  
  //! Constructs a qualified circle
  //! so that the relative position to the circle or line of the
  //! solution computed by a construction algorithm using the
  //! qualified circle or line is not qualified, i.e. all solutions apply.
  Standard_EXPORT static   GccEnt_QualifiedCirc Unqualified (const gp_Circ2d& Obj) ;
  

  //! Constructs such a qualified circle that the solution
  //! computed by a construction algorithm using the qualified
  //! circle encloses the circle.
  Standard_EXPORT static   GccEnt_QualifiedCirc Enclosing (const gp_Circ2d& Obj) ;
  
  //! Constructs a qualified line,
  //! so that the solution computed by a construction
  //! algorithm using the qualified circle or line is enclosed by
  //! the circle or line.
  Standard_EXPORT static   GccEnt_QualifiedLin Enclosed (const gp_Lin2d& Obj) ;
  
  //! Constructs a qualified circle
  //! so that the solution computed by a construction
  //! algorithm using the qualified circle or line is enclosed by
  //! the circle or line.
  Standard_EXPORT static   GccEnt_QualifiedCirc Enclosed (const gp_Circ2d& Obj) ;
  
  //! Constructs a qualified line,
  //! so that the solution computed by a construction
  //! algorithm using the qualified circle or line and the circle
  //! or line are external to one another.
  Standard_EXPORT static   GccEnt_QualifiedLin Outside (const gp_Lin2d& Obj) ;
  
  //! Constructs a qualified circle
  //! so that the solution computed by a construction
  //! algorithm using the qualified circle or line and the circle
  //! or line are external to one another.
  Standard_EXPORT static   GccEnt_QualifiedCirc Outside (const gp_Circ2d& Obj) ;




protected:





private:




friend class GccEnt_QualifiedLin;
friend class GccEnt_QualifiedCirc;
friend class GccEnt_Array1OfPosition;

};







#endif // _GccEnt_HeaderFile
