/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015 Aaron Madlon-Kay
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.stat;

import javax.swing.UIManager;

import org.omegat.util.gui.StaticUIUtils;

/**
 *
 * @author Aaron Madlon-Kay
 */
@SuppressWarnings("serial")
public class TitledTablePanel extends javax.swing.JPanel {

    /**
     * Creates new form TitledTablePanel
     */
    public TitledTablePanel() {
        initComponents();
        
        // Set the title JTextArea's caret not to update on changes to the text.
        // When a TitledTablePanel is used in a JScrollPane (like in the 
        // PerFileMatchStatisticsPanel) the caret updating will cause unwanted
        // scrolling whenever a new TitledTablePanel is displayed.
        StaticUIUtils.setCaretUpdateEnabled(title, false);
        title.setFont(UIManager.getFont("Label.font"));
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        title = new javax.swing.JTextArea();
        scrollPane = new javax.swing.JScrollPane();
        table = new javax.swing.JTable();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 10, 0));
        setLayout(new java.awt.BorderLayout());

        title.setEditable(false);
        title.setLineWrap(true);
        title.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 5, 0));
        title.setOpaque(false);
        add(title, java.awt.BorderLayout.NORTH);

        scrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        scrollPane.setViewportView(table);

        add(scrollPane, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    javax.swing.JScrollPane scrollPane;
    javax.swing.JTable table;
    javax.swing.JTextArea title;
    // End of variables declaration//GEN-END:variables
}
