Minutes from 129-th OpenVDB TSC meeting, April 12th, 2022, (EDT)

Attendees: *Jeff* L., *Nick* A, *Dan* B., *Rich* J., *Andre* P.

Additional Attendees: Sebastian Gaida, Serjio Rojas, Greg Hurst
(United Therapeutics), Kyle Wardlow (United Therapeutics).

Regrets: *Ken* M.

Agenda:

1) Confirm quorum
2) Secretary
3) Forum
4) Typelists (PR #1336)
5) Binary re-structure (PR #1319)
6) Wolfram/Mathematica Integration (PR #1351)
7) Next meeting


--------------------

1) Confirm quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Forum

a) #1350

Questioning the choice of std::deque on Windows. No benchmarking data shared, in
many cases using a deque was a conscious choice as the data is not moved when
extended so works better when multi-threading. Jeff to reply. Nick removed bug
label, default should be to close issues such as this where there's no issue
that needs to be addressed.

b) Two dimensional grid Qs

This has been on the roadmap for years. A single slice of a 3D grid can work in
many cases, although care must be taken with level sets. Main issue with this
approach is a significantly larger memory footprint.

4) Typelists (PR #1336)

Nick has extended slightly to improve unique implementation. Now uniqueness is
enforced on append instead of at the end of the template expansion which is
more efficient. Uses std::conditional which sometimes instantiates false branch
and sometimes doesn't. Const Expr If with C++17 should handle this better.

Where to add custom grid support? Makes most sense to put it in
openvdb::initialize(), however this may mean that methods that use the dynamic
dispatch will not be able to support this custom grid.

Most important is to align the categories - with this change, they will exist in
three places as they are also in CMake for explicit instantiation and in
Houdini plugins. One inconsistency is scalar vs numeric grid types for
example.

5) Binary re-structure (PR #1319)

Might have to leave OPENVDB_BUILD_BINARIES for now. Not trivial to remove it as
not clear how custom allocators or building binaries against an external
libopenvdb will work. Dan to comment on PR for further discussion.

6) Wolfram/Mathematica Integration (PR #1351)

Greg to do a half hour presentation next time on some of the integration
questions.

Work still to do be done on improving the docs. Need to be some minor changes to
the whitespace CI rules to exclude certain subdirs, particularly around autogen
code.

This PR adds a lot of code. Question about whether or not it might be feasible
to exclude the 400k+ lines of autogen code and to do this on the fly?

Main issue to investigate is the CI and licensing. Wolfram Engine is available
for this kind of purpose, but need to follow up with TAC / John Mertic to find
out more. Three options to pursue:

* Full CI integration to build and evaluate unit tests using Wolfram/Mathematica
  licenses.
* Houdini-style build-only integration that ensures compilation is successful
  but does no evaluation.
* Minimal build only components that do not include Wolfram headers/libs.

After discussions with ASWF, should be clearer which one is preferred.

Question about openvdb_wolfram instead of openvdb_mathematica? Although
Mathematica is the main product, there is also Wolfram Engine. Greg's call on
which makes most sense.

7) Next meeting

Next meeting is on April 19th, 2022. 1pm-2pm EDT (GMT-4).
