#!/bin/sh
#
# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later

myself="$(readlink -f -- "$0")"
test_dir="$(dirname -- "$myself")"
. "$test_dir/tap-functions.sh"

[ -z "$PRIPS" ] && PRIPS='./prips'

if ! $PRIPS --features | grep -Fqe ' exclude='; then
	skip_all_ 'This prips implementation does not support exclusion'
fi
if ! $PRIPS --features | grep -Fqe ' exclude=1.'; then
	bailout_ 'Unsupported version of the "exclude" feature'
fi

plan_ 20

v=`$PRIPS -d33 1.2.3.24/29`
res="$?"
exp='1.2.3.24!1.2.3.25!1.2.3.26!1.2.3.27!1.2.3.28!1.2.3.29!1.2.3.30!1.2.3.31!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -e ...28 1.2.3.24/29`
res="$?"
exp='1.2.3.24!1.2.3.25!1.2.3.26!1.2.3.27!1.2.3.29!1.2.3.30!1.2.3.31!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -e ...28 -i 2 1.2.3.24/29`
res="$?"
exp='1.2.3.24!1.2.3.26!1.2.3.30!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -e ...28 -i 4 1.2.3.24/29`
res="$?"
exp='1.2.3.24!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i 256 1.2.0.0/22`
res="$?"
exp='1.2.0.0!1.2.1.0!1.2.2.0!1.2.3.0!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i 256 -e ..1 1.2.0.0/22`
res="$?"
exp='1.2.0.0!1.2.2.0!1.2.3.0!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -i 256 -e .0.. 1.0.0.0/8 | grep -Ece '\.[1-9][0-9]*$'`
res="$?"
exp='0'
if [ "$res" != 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i32 -e '..1.32,96' 4.0.0.0 4.0.2.193`
res="$?"
exp='4.0.0.0!4.0.0.64!4.0.0.128!4.0.0.160!4.0.0.192!4.0.0.224!4.0.2.0!4.0.2.64!4.0.2.128!4.0.2.160!4.0.2.192!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i32 -e '3..1.32,96' 4.0.0.0 4.0.2.193`
res="$?"
exp='4.0.0.0!4.0.0.64!4.0.0.128!4.0.0.160!4.0.0.192!4.0.0.224!4.0.2.0!4.0.2.64!4.0.2.128!4.0.2.160!4.0.2.192!'
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi

v=`$PRIPS -d33 -i32 -e '4..1.32,96' 4.0.0.0 4.0.2.193`
res="$?"
exp=''
if [ "$res" = 0 ]; then ok_; else not_ok_ "exit code $res"; fi
if [ "$v" = "$exp" ]; then ok_; else not_ok_ "expected $exp got $v"; fi
