# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementNamespacesOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_get(self, resource_group):
        response = self.client.namespaces.get(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_create_or_update(self, resource_group):
        response = self.client.namespaces.begin_create_or_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            namespace_info={
                "location": "str",
                "id": "str",
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inboundIpRules": [{"action": "str", "ipMask": "str"}],
                "isZoneRedundant": bool,
                "minimumTlsVersionAllowed": "str",
                "name": "str",
                "privateEndpointConnections": [
                    {
                        "groupIds": ["str"],
                        "id": "str",
                        "name": "str",
                        "privateEndpoint": {"id": "str"},
                        "privateLinkServiceConnectionState": {
                            "actionsRequired": "str",
                            "description": "str",
                            "status": "str",
                        },
                        "provisioningState": "str",
                        "type": "str",
                    }
                ],
                "provisioningState": "str",
                "publicNetworkAccess": "str",
                "sku": {"capacity": 0, "name": "str"},
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "topicSpacesConfiguration": {
                    "customDomains": [
                        {
                            "fullyQualifiedDomainName": "str",
                            "certificateUrl": "str",
                            "expectedTxtRecordName": "str",
                            "expectedTxtRecordValue": "str",
                            "identity": {"type": "str", "userAssignedIdentity": "str"},
                            "validationState": "str",
                        }
                    ],
                    "hostname": "str",
                    "maximumClientSessionsPerAuthenticationName": 0,
                    "maximumSessionExpiryInHours": 0,
                    "routeTopicResourceId": "str",
                    "routingEnrichments": {
                        "dynamic": [{"key": "str", "value": "str"}],
                        "static": ["static_routing_enrichment"],
                    },
                    "routingIdentityInfo": {"type": "str", "userAssignedIdentity": "str"},
                    "state": "str",
                },
                "topicsConfiguration": {
                    "customDomains": [
                        {
                            "fullyQualifiedDomainName": "str",
                            "certificateUrl": "str",
                            "expectedTxtRecordName": "str",
                            "expectedTxtRecordValue": "str",
                            "identity": {"type": "str", "userAssignedIdentity": "str"},
                            "validationState": "str",
                        }
                    ],
                    "hostname": "str",
                },
                "type": "str",
            },
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_delete(self, resource_group):
        response = self.client.namespaces.begin_delete(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_update(self, resource_group):
        response = self.client.namespaces.begin_update(
            resource_group_name=resource_group.name,
            namespace_name="str",
            namespace_update_parameters={
                "identity": {
                    "principalId": "str",
                    "tenantId": "str",
                    "type": "str",
                    "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                },
                "inboundIpRules": [{"action": "str", "ipMask": "str"}],
                "publicNetworkAccess": "str",
                "sku": {"capacity": 0, "name": "str"},
                "tags": {"str": "str"},
                "topicSpacesConfiguration": {
                    "customDomains": [
                        {
                            "fullyQualifiedDomainName": "str",
                            "certificateUrl": "str",
                            "expectedTxtRecordName": "str",
                            "expectedTxtRecordValue": "str",
                            "identity": {"type": "str", "userAssignedIdentity": "str"},
                            "validationState": "str",
                        }
                    ],
                    "maximumClientSessionsPerAuthenticationName": 0,
                    "maximumSessionExpiryInHours": 0,
                    "routeTopicResourceId": "str",
                    "routingEnrichments": {
                        "dynamic": [{"key": "str", "value": "str"}],
                        "static": ["static_routing_enrichment"],
                    },
                    "routingIdentityInfo": {"type": "str", "userAssignedIdentity": "str"},
                    "state": "str",
                },
                "topicsConfiguration": {
                    "customDomains": [
                        {
                            "fullyQualifiedDomainName": "str",
                            "certificateUrl": "str",
                            "expectedTxtRecordName": "str",
                            "expectedTxtRecordValue": "str",
                            "identity": {"type": "str", "userAssignedIdentity": "str"},
                            "validationState": "str",
                        }
                    ]
                },
            },
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_list_by_subscription(self, resource_group):
        response = self.client.namespaces.list_by_subscription(
            api_version="2025-02-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_list_by_resource_group(self, resource_group):
        response = self.client.namespaces.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-02-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_list_shared_access_keys(self, resource_group):
        response = self.client.namespaces.list_shared_access_keys(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_regenerate_key(self, resource_group):
        response = self.client.namespaces.begin_regenerate_key(
            resource_group_name=resource_group.name,
            namespace_name="str",
            regenerate_key_request={"keyName": "str"},
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_namespaces_begin_validate_custom_domain_ownership(self, resource_group):
        response = self.client.namespaces.begin_validate_custom_domain_ownership(
            resource_group_name=resource_group.name,
            namespace_name="str",
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
