# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from collections.abc import MutableMapping
from io import IOBase
from typing import Any, Callable, Dict, IO, Optional, TypeVar, Union, overload

from azure.core import AsyncPipelineClient
from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat

from ... import models as _models
from ..._utils.serialization import Deserializer, Serializer
from ...operations._governance_assignments_operations import (
    build_create_or_update_request,
    build_delete_request,
    build_get_request,
    build_list_request,
)
from .._configuration import SecurityCenterConfiguration

T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class GovernanceAssignmentsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.security.aio.SecurityCenter`'s
        :attr:`governance_assignments` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client: AsyncPipelineClient = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config: SecurityCenterConfiguration = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize: Serializer = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize: Deserializer = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, scope: str, assessment_name: str, **kwargs: Any) -> AsyncItemPaged["_models.GovernanceAssignment"]:
        """Get governance assignments on all of your resources inside a scope.

        :param scope: The scope of the Governance assignments. Valid scopes are: subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param assessment_name: The Assessment Key - A unique key for the assessment type. Required.
        :type assessment_name: str
        :return: An iterator like instance of either GovernanceAssignment or the result of
         cls(response)
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.security.models.GovernanceAssignment]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-01-01-preview"))
        cls: ClsType[_models.GovernanceAssignmentsList] = kwargs.pop("cls", None)

        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_list_request(
                    scope=scope,
                    assessment_name=assessment_name,
                    api_version=api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                _request = HttpRequest("GET", next_link)
                _request.url = self._client.format_url(_request.url)
                _request.method = "GET"
            return _request

        async def extract_data(pipeline_response):
            deserialized = self._deserialize("GovernanceAssignmentsList", pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.next_link or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get(
        self, scope: str, assessment_name: str, assignment_key: str, **kwargs: Any
    ) -> _models.GovernanceAssignment:
        """Get a specific governanceAssignment for the requested scope by AssignmentKey.

        :param scope: The scope of the Governance assignments. Valid scopes are: subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param assessment_name: The Assessment Key - A unique key for the assessment type. Required.
        :type assessment_name: str
        :param assignment_key: The governance assignment key - the assessment key of the required
         governance assignment. Required.
        :type assignment_key: str
        :return: GovernanceAssignment or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.GovernanceAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-01-01-preview"))
        cls: ClsType[_models.GovernanceAssignment] = kwargs.pop("cls", None)

        _request = build_get_request(
            scope=scope,
            assessment_name=assessment_name,
            assignment_key=assignment_key,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("GovernanceAssignment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def create_or_update(
        self,
        scope: str,
        assessment_name: str,
        assignment_key: str,
        governance_assignment: _models.GovernanceAssignment,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GovernanceAssignment:
        """Creates or updates a governance assignment on the given subscription.

        :param scope: The scope of the Governance assignments. Valid scopes are: subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param assessment_name: The Assessment Key - A unique key for the assessment type. Required.
        :type assessment_name: str
        :param assignment_key: The governance assignment key - the assessment key of the required
         governance assignment. Required.
        :type assignment_key: str
        :param governance_assignment: Governance assignment over a subscription scope. Required.
        :type governance_assignment: ~azure.mgmt.security.models.GovernanceAssignment
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GovernanceAssignment or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.GovernanceAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @overload
    async def create_or_update(
        self,
        scope: str,
        assessment_name: str,
        assignment_key: str,
        governance_assignment: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> _models.GovernanceAssignment:
        """Creates or updates a governance assignment on the given subscription.

        :param scope: The scope of the Governance assignments. Valid scopes are: subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param assessment_name: The Assessment Key - A unique key for the assessment type. Required.
        :type assessment_name: str
        :param assignment_key: The governance assignment key - the assessment key of the required
         governance assignment. Required.
        :type assignment_key: str
        :param governance_assignment: Governance assignment over a subscription scope. Required.
        :type governance_assignment: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: GovernanceAssignment or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.GovernanceAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def create_or_update(
        self,
        scope: str,
        assessment_name: str,
        assignment_key: str,
        governance_assignment: Union[_models.GovernanceAssignment, IO[bytes]],
        **kwargs: Any
    ) -> _models.GovernanceAssignment:
        """Creates or updates a governance assignment on the given subscription.

        :param scope: The scope of the Governance assignments. Valid scopes are: subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param assessment_name: The Assessment Key - A unique key for the assessment type. Required.
        :type assessment_name: str
        :param assignment_key: The governance assignment key - the assessment key of the required
         governance assignment. Required.
        :type assignment_key: str
        :param governance_assignment: Governance assignment over a subscription scope. Is either a
         GovernanceAssignment type or a IO[bytes] type. Required.
        :type governance_assignment: ~azure.mgmt.security.models.GovernanceAssignment or IO[bytes]
        :return: GovernanceAssignment or the result of cls(response)
        :rtype: ~azure.mgmt.security.models.GovernanceAssignment
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-01-01-preview"))
        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.GovernanceAssignment] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(governance_assignment, (IOBase, bytes)):
            _content = governance_assignment
        else:
            _json = self._serialize.body(governance_assignment, "GovernanceAssignment")

        _request = build_create_or_update_request(
            scope=scope,
            assessment_name=assessment_name,
            assignment_key=assignment_key,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        deserialized = self._deserialize("GovernanceAssignment", pipeline_response.http_response)

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def delete(self, scope: str, assessment_name: str, assignment_key: str, **kwargs: Any) -> None:
        """Delete a GovernanceAssignment over a given scope.

        :param scope: The scope of the Governance assignments. Valid scopes are: subscription (format:
         'subscriptions/{subscriptionId}'), or security connector (format:
         'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/securityConnectors/{securityConnectorName})'.
         Required.
        :type scope: str
        :param assessment_name: The Assessment Key - A unique key for the assessment type. Required.
        :type assessment_name: str
        :param assignment_key: The governance assignment key - the assessment key of the required
         governance assignment. Required.
        :type assignment_key: str
        :return: None or the result of cls(response)
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map: MutableMapping = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

        api_version: str = kwargs.pop("api_version", _params.pop("api-version", "2022-01-01-preview"))
        cls: ClsType[None] = kwargs.pop("cls", None)

        _request = build_delete_request(
            scope=scope,
            assessment_name=assessment_name,
            assignment_key=assignment_key,
            api_version=api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response, error_format=ARMErrorFormat)

        if cls:
            return cls(pipeline_response, None, {})  # type: ignore
