% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocFileCache-class.R
\name{BiocFileCache-class}
\alias{BiocFileCache-class}
\alias{BiocFileCache}
\alias{bfccache,BiocFileCacheBase-method}
\alias{bfccache}
\alias{bfccache,missing-method}
\alias{length,BiocFileCacheBase-method}
\alias{bfcrid}
\alias{bfcrid,missing-method}
\alias{bfcrid,BiocFileCacheReadOnly-method}
\alias{bfcrid,BiocFileCache-method}
\alias{[,BiocFileCache,character,missing-method}
\alias{[,BiocFileCacheReadOnly,character,missing-method}
\alias{[,BiocFileCache,missing,missing-method}
\alias{[,BiocFileCacheReadOnly,missing,missing-method}
\alias{[[,BiocFileCacheBase,character,missing-method}
\alias{[[<-,BiocFileCache,character,missing,character-method}
\alias{bfcnew,missing-method}
\alias{bfcnew,BiocFileCache-method}
\alias{bfcnew}
\alias{bfcadd,missing-method}
\alias{bfcadd,BiocFileCache-method}
\alias{bfcadd}
\alias{bfcinfo,missing-method}
\alias{bfcinfo,BiocFileCacheBase-method}
\alias{bfcinfo}
\alias{bfcrid,tbl_bfc-method}
\alias{bfcpath,missing-method}
\alias{bfcpath,BiocFileCacheBase-method}
\alias{bfcpath}
\alias{bfcrpath,missing-method}
\alias{bfcrpath,BiocFileCacheBase-method}
\alias{bfcrpath}
\alias{bfcupdate,missing-method}
\alias{bfcupdate,BiocFileCache-method}
\alias{bfcupdate}
\alias{bfcmeta<-}
\alias{bfcmeta<-,BiocFileCacheBase-method}
\alias{bfcmetaremove,missing-method}
\alias{bfcmetaremove,BiocFileCacheBase-method}
\alias{bfcmetaremove}
\alias{bfcmetalist,missing-method}
\alias{bfcmetalist,BiocFileCacheBase-method}
\alias{bfcmetalist}
\alias{bfcmeta,missing-method}
\alias{bfcmeta,BiocFileCacheBase-method}
\alias{bfcmeta}
\alias{bfcquerycols,missing-method}
\alias{bfcquerycols,BiocFileCacheBase-method}
\alias{bfcquerycols}
\alias{bfcquery,missing-method}
\alias{bfcquery,BiocFileCacheBase-method}
\alias{bfcquery}
\alias{bfccount,missing-method}
\alias{bfccount,BiocFileCacheBase-method}
\alias{bfccount}
\alias{bfccount,tbl_bfc-method}
\alias{bfcneedsupdate,missing-method}
\alias{bfcneedsupdate,BiocFileCacheBase-method}
\alias{bfcneedsupdate}
\alias{bfcdownload,missing-method}
\alias{bfcdownload,BiocFileCache-method}
\alias{bfcdownload}
\alias{bfcremove,missing-method}
\alias{bfcremove,BiocFileCache-method}
\alias{bfcremove}
\alias{bfcsync,missing-method}
\alias{bfcsync,BiocFileCache-method}
\alias{bfcsync}
\alias{exportbfc,missing-method}
\alias{exportbfc,BiocFileCacheBase-method}
\alias{exportbfc}
\alias{importbfc,character-method}
\alias{importbfc}
\alias{cleanbfc,missing-method}
\alias{cleanbfc,BiocFileCache-method}
\alias{cleanbfc}
\alias{removebfc,missing-method}
\alias{removebfc,BiocFileCache-method}
\alias{removebfc}
\alias{show,BiocFileCacheBase-method}
\title{BiocFileCache class}
\usage{
BiocFileCache(cache = getBFCOption("CACHE"), ask = interactive())

\S4method{bfccache}{BiocFileCacheBase}(x)

\S4method{bfccache}{missing}(x)

\S4method{length}{BiocFileCacheBase}(x)

bfcrid(x)

\S4method{bfcrid}{missing}(x)

\S4method{bfcrid}{BiocFileCacheReadOnly}(x)

\S4method{bfcrid}{BiocFileCache}(x)

\S4method{[}{BiocFileCache,character,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{BiocFileCacheReadOnly,character,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{BiocFileCache,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[}{BiocFileCacheReadOnly,missing,missing}(x, i, j, ..., drop = TRUE)

\S4method{[[}{BiocFileCacheBase,character,missing}(x, i, j)

\S4method{[[}{BiocFileCache,character,missing,character}(x, i, j, ...) <- value

\S4method{bfcnew}{missing}(
  x,
  rname,
  rtype = c("relative", "local"),
  ext = NA_character_,
  fname = c("unique", "exact")
)

\S4method{bfcnew}{BiocFileCache}(
  x,
  rname,
  rtype = c("relative", "local"),
  ext = NA_character_,
  fname = c("unique", "exact")
)

\S4method{bfcadd}{missing}(
  x,
  rname,
  fpath = rname,
  rtype = c("auto", "relative", "local", "web"),
  action = c("copy", "move", "asis"),
  proxy = "",
  download = TRUE,
  config = list(),
  ext = NA_character_,
  fname = c("unique", "exact"),
  ...
)

\S4method{bfcadd}{BiocFileCache}(
  x,
  rname,
  fpath = rname,
  rtype = c("auto", "relative", "local", "web"),
  action = c("copy", "move", "asis"),
  proxy = "",
  download = TRUE,
  config = list(),
  ext = NA_character_,
  fname = c("unique", "exact"),
  ...
)

\S4method{bfcinfo}{missing}(x, rids)

\S4method{bfcinfo}{BiocFileCacheBase}(x, rids)

\S4method{bfcrid}{tbl_bfc}(x)

\S4method{bfcpath}{missing}(x, rids)

\S4method{bfcpath}{BiocFileCacheBase}(x, rids)

\S4method{bfcrpath}{missing}(x, rnames, ..., rids, exact = TRUE)

\S4method{bfcrpath}{BiocFileCacheBase}(x, rnames, ..., rids, exact = TRUE)

\S4method{bfcupdate}{missing}(x, rids, value, ...)

\S4method{bfcupdate}{BiocFileCache}(
  x,
  rids,
  rname = NULL,
  rpath = NULL,
  fpath = NULL,
  proxy = "",
  config = list(),
  ask = TRUE,
  ...
)

bfcmeta(x, name, ...) <- value

\S4method{bfcmeta}{BiocFileCacheBase}(x, name, ...) <- value

\S4method{bfcmetaremove}{missing}(x, name, ...)

\S4method{bfcmetaremove}{BiocFileCacheBase}(x, name, ...)

\S4method{bfcmetalist}{missing}(x)

\S4method{bfcmetalist}{BiocFileCacheBase}(x)

\S4method{bfcmeta}{missing}(x, name, ...)

\S4method{bfcmeta}{BiocFileCacheBase}(x, name, ...)

\S4method{bfcquerycols}{missing}(x)

\S4method{bfcquerycols}{BiocFileCacheBase}(x)

\S4method{bfcquery}{missing}(x, query, field = c("rname", "rpath", "fpath"), ..., exact = FALSE)

\S4method{bfcquery}{BiocFileCacheBase}(x, query, field = c("rname", "rpath", "fpath"), ..., exact = FALSE)

\S4method{bfccount}{missing}(x)

\S4method{bfccount}{BiocFileCacheBase}(x)

\S4method{bfccount}{tbl_bfc}(x)

\S4method{bfcneedsupdate}{missing}(x, rids)

\S4method{bfcneedsupdate}{BiocFileCacheBase}(x, rids)

\S4method{bfcdownload}{missing}(x, rid, proxy = "", config = list(), ask = TRUE, FUN, ...)

\S4method{bfcdownload}{BiocFileCache}(x, rid, proxy = "", config = list(), ask = TRUE, FUN, ...)

\S4method{bfcremove}{missing}(x, rids)

\S4method{bfcremove}{BiocFileCache}(x, rids)

\S4method{bfcsync}{missing}(x, verbose = TRUE, ask = TRUE)

\S4method{bfcsync}{BiocFileCache}(x, verbose = TRUE, ask = TRUE)

\S4method{exportbfc}{missing}(
  x,
  rids,
  outputFile = "BiocFileCacheExport.tar",
  outputMethod = c("tar", "zip"),
  verbose = TRUE,
  ...
)

\S4method{exportbfc}{BiocFileCacheBase}(
  x,
  rids,
  outputFile = "BiocFileCacheExport.tar",
  outputMethod = c("tar", "zip"),
  verbose = TRUE,
  ...
)

\S4method{importbfc}{character}(filename, archiveMethod = c("untar", "unzip"), exdir = ".", ...)

\S4method{cleanbfc}{missing}(x, days = 120, ask = TRUE)

\S4method{cleanbfc}{BiocFileCache}(x, days = 120, ask = TRUE)

\S4method{removebfc}{missing}(x, ask = TRUE)

\S4method{removebfc}{BiocFileCache}(x, ask = TRUE)

\S4method{show}{BiocFileCacheBase}(object)
}
\arguments{
\item{cache}{character(1) On-disk location (directory path) of
cache. For default location see
\code{\link[tools]{R_user_dir}}.}

\item{ask}{logical(1) Ask before creating, updating, overwriting,
or removing cache or local file locations.}

\item{x}{A \code{BiocFileCache} instance or, if missing, the result
of \code{BiocFileCache()}.}

\item{i}{character() 'rid' identifiers.}

\item{j}{Ignored.}

\item{...}{For 'bfcadd', 'bfcupdate' and 'bfcdownload': Additional
arguments passed to internal download functions for use with
\code{httr::GET}. For 'bfcrpaths': Additional arguments passed
to 'bfcadd', or \code{exact} passed to 'bfcquery'. For
'bfcquery': Additional arguments passed to \code{grepl}. For
'exportbfc': Additional arguments to the selected outputMethod
function. See \code{utils::tar} or \code{utils::zip} for more
information. For 'importbfc': Additional arguments to the
selected archiveMethod function. See \code{utils::untar} or
\code{utils::unzip} for more information.}

\item{drop}{Ignored.}

\item{value}{character(1) Replacement file path.}

\item{rname}{character(1) Name of object in file cache. For
'bfcupdate' a character vector of replacement rnames.}

\item{rtype}{character(1) 'local', 'relative', or 'web' indicating
if the resource is a local file, a relative path in the cache,
or a web resource. For \code{bfcnew}: local or relative are
only options. For \code{bfcadd}, the default 'auto' creates
relative or web paths, based on the path prefix.}

\item{ext}{character(1) A file extension to add to the local
copy of the file (e.g., \sQuote{sqlite}, \sQuote{txt},
\sQuote{tar.gz}).}

\item{fname}{character(1). Options are \sQuote{unique} or
\sQuote{exact}. \sQuote{unique} provides each bfc resource with a unique
identifier when storing the file, allowing resources with the same name
to be stored in the cache. \sQuote{exact} uses the exact file name of the
resource; only one of foo/my.txt and bar/my.txt could be stored. Default
is \sQuote{unique}.}

\item{fpath}{For bfcadd(), character(1) path to current file
location or remote web resource. If none is given, the rname is
assumed to also be the path location. For bfcupdate()
character() vector of replacement web resources.}

\item{action}{character(1) How to handle the file: create a
\code{copy} of \code{fpath} in the cache directory; \code{move}
the file to the cache directory; or \code{asis} leave the file
in current location but save the path in the cache. If 'rtype
== "relative"', action can not be "asis".}

\item{proxy}{character(1) (Optional) proxy server.}

\item{download}{logical(1) If \code{rtype=web}, should remote
resource be downloaded locally immediately.}

\item{config}{list() passed as config argument in \code{httr::GET}}

\item{rids}{character() Vector of rids.}

\item{rnames}{character() to match against rnames.  Each element of
\code{rnames} must match exactly one record. Use \code{exact =
FALSE} to use regular expression matching.}

\item{exact}{logical(1) when FALSE, treat \code{query} as a regular
expression. When TRUE, use exact matching. For \code{bfcquery},
the default is \code{FALSE} (regular expression matching; for
\code{bfcrpath}, the default is \code{TRUE} (exact matching).}

\item{rpath}{character() vector of replacement rpaths.}

\item{name}{character(1) name of metadata table.}

\item{query}{character() Regular expression pattern(s) to match in
resource. It will match the pattern against \code{fields},
using \code{&} logic across query element. By default, case
sensitive. When \code{exact = TRUE}, \code{query} uses exact
matching.}

\item{field}{character() column names in resource to query, using
\code{||} logic across multiple field elements. By default,
matches pattern agains rname, rpath, and fpath. If exact
matching, may only be a single value.}

\item{rid}{character(1) Unique resource id.}

\item{FUN}{A specialized implemented function designed by the user. This
function can be used to perform and save the results of a post download
processing step rather than direct output. The function should ONLY take in
two file names: the first the raw downloaded file and the second the output
file for saved results. The output of the function should be TRUE/FALSE if
step was successful. See vignette section on Specialty Advance Use Case for
more details.}

\item{verbose}{logical(1) If descriptive message and list of issues
should be included as output.}

\item{outputFile}{character(1) The <filepath>/basename for the
output archive. Please include appropriate extension based on
outMethod and any additional parameters selected for
\code{utils::tar} or \code{utils::zip}}

\item{outputMethod}{Either 'tar' or 'zip' for how the directory
should be archived. Default is 'tar'.}

\item{filename}{character(1) The name of the archive.}

\item{archiveMethod}{Either 'untar' or 'unzip' for how the directory should
be extracted. Default is 'untar'.}

\item{exdir}{Directory to extract files too. See \code{utils::untar} or
\code{utils::unzip} for more details.}

\item{days}{integer(1) Number of days between accessDate and
currentDate; if exceeded entry will be deleted.}

\item{object}{A \code{BiocFileCache} instance.}
}
\value{
For 'BiocFileCache': a \code{BiocFileCache} instance.

For 'bfccache': character(1) location of the directory
    containing the cache.

For 'length': integer(1) Number of objects in the file
    cache.

For '[': A subset of the BiocFileCache object.

For '[[': named character(1) rpath for the given resource
    in the cache.

For '[[<-': Updated BiocFileCache, invisibly.

For 'bfcnew': named character(1), the path to save your
    object / file.  The name of the return value is the unique rid
    for the resource.

For 'bfcadd': named character(1), the path to save your
    object / file.  The name of the character is the unique rid for
    the resource.

For 'bfcinfo': A \code{bfc_tbl} of current resources in the
    database.

For 'bfcpath': the file path location to load

For 'bfcrpath': The local file path location to load.

For 'bfcupdate': an updated \code{BiocFileCache} object,
    invisibly.

For 'bfcmeta': updated BiocFileCache, invisibly

For 'bfcmetaremove': updated BiocFileCache, invisibly

For 'bfcmetalist': returns a character() of all metadata tables
    currently in the database. If no metadata tables are available returns
    character(0)

For 'bfcmeta': returns a data.frame representation of database
    table

For 'bfcquerycols': character() all columns in all database tables
     available for query.

For 'bfcquery': A \code{bfc_tbl} of current resources in
    the database whose \code{field} contained query. If multiple
    values are given, the resource must contain all of the
    patterns. A tbl with zero rows is returned when no resources
    match the query.

For 'bfccount': integer(1) Number of objects in the cache
    or query.

For 'bfcneedsupdate': named logical vector if resource
    needs to be updated. The name is the resource
    'rid'. \code{TRUE}: fpath \code{etag} or \code{modified} time of
    web resource more recent than in BiocFileCache; \code{FALSE}: fpath
    \code{etag} or \code{modified} time of web resource not more recent
    than in BiocFileCache; \code{NA}: web resource etag and modified time
    could not be determined. If the etag is available the function will use
    that information definitively and only compare last modified time if
    etag is not available. If there is an \code{expires} time that will be
    used to initially determine if the resource should be updated.

For 'bfcdownload': character(1) path to downloaded resource
    in cache.

For 'bfcremove': updated BiocFileCache object, invisibly

For 'bfcsync': logical(1) indicating whether the cache is
    in sync (\code{TRUE}) or not. 'verbose' is TRUE by default, so
    descriptive messages will also be included.

character(1) The outputFile path.

A BiocFileCache object

For 'cleanbfc': updated BiocFileCache, invisibly.

For 'removebfc': TRUE if successfully removed.
}
\description{
This class represents the location of files stored on disk. Use the
return value to add and retrieve files that persist across
sessions.
}
\details{
The package defines 'BiocFileCache', 'BiocFileCacheBase' and
'BiocFileCacheReadOnly' classes.

Slots unique to 'BiocFileCache' and  related classes:
\itemize{
  \item{'cache': }{character(1) on-disk location (directory path) of the
      cache}
  \item{'rid': }{character() of unique rids in the cache. }
}

The cache creates an RSQLite database to keep track of local and remote
resources. Each item located in the database will have the following
information:
\itemize{
  \item{'rid': }{resource id. Autogenerated. This is a unique identifier
    automatically generated when a resource is added to the cache}
  \item{'rname': }{resource name. This is given by the user when a
    resource is added to the cache. It does not have to be unique
    and can be updated at anytime. We recommend descriptive key
    words and identifers.}
  \item{'create_time': }{The date and time a resource is added to the cache.}
  \item{'access_time': }{The date and time a resource is utilized
    within the cache. The access time is updated when the resource
    is updated or accessed}
  \item{'rpath': }{resource path. This is the path to the local
    (on-disk) file}
  \item{'rtype': }{resource type. Either "relative", "local", or
    "web", indicating if the resource has a remote origin}
  \item{'fpath': }{If rtype is "web", this is the link to the
    remote resource. It will be utilized to download or update the
    remote data}
  \item{'last_modified_time': }{For a remote resource, the
    last_modified (if available) information for the local copy of
    the data. This information is checked against the remote
    resource to determine if the local copy is stale and needs to
    be updated}
}

All functions have a quick implementation where if the BiocFileCache object
is not passed as an argument, the function uses default 'BiocFileCache()' for
implementation. e.g 'bfcinfo()' can be used instead of
'bfcinfo(BiocFileCache())'. The only function this is not available for is
'bfcmeta()<-'; The BiocFileCache object must be defined as a varaible and
 passed as an argument. See vignette("BiocFileCache") for more details.
}
\section{Methods (by generic)}{
\itemize{
\item \code{bfccache(BiocFileCacheBase)}: Get the location of the on-disk cache.

\item \code{length(BiocFileCacheBase)}: Get the number of objects in the file
cache.

\item \code{bfcrid(BiocFileCacheReadOnly)}: Get the rids of the object.

\item \code{x[i}: Subset a BiocFileCache object.

\item \code{x[[i}: Get a file path for select resources from
the cache.

\item \code{`[[`(x = BiocFileCache, i = character, j = missing) <- value}: Set the file path of selected resources
from the cache.

\item \code{bfcnew(BiocFileCache)}: Add a resource to the database

\item \code{bfcadd(BiocFileCache)}: Add an existing resource to the database

\item \code{bfcinfo(BiocFileCacheBase)}: list resources in database

\item \code{bfcrid(tbl_bfc)}: Get the rids of the object

\item \code{bfcpath(BiocFileCacheBase)}: display rpaths of resource.

\item \code{bfcrpath(BiocFileCacheBase)}: display rpath of resource. If 'rnames' is
in the cache the path is returned, if it is not it will try to
add it to the cache with 'bfcadd'

\item \code{bfcupdate(BiocFileCache)}: Update a resource in the cache

\item \code{bfcmeta(BiocFileCacheBase) <- value}: add meta data table in database

\item \code{bfcmetaremove(BiocFileCacheBase)}: remove meta data table in database

\item \code{bfcmetalist(BiocFileCacheBase)}: retrieve listing of metadata tables

\item \code{bfcmeta(BiocFileCacheBase)}: retrieve metadata table

\item \code{bfcquerycols(BiocFileCacheBase)}: Get all the possible columns to query

\item \code{bfcquery(BiocFileCacheBase)}: query resource

\item \code{bfccount(BiocFileCacheBase)}: Get the number of objects in the file
cache or query.

\item \code{bfcneedsupdate(BiocFileCacheBase)}: check if a resource needs to be updated

\item \code{bfcdownload(BiocFileCache)}: Redownload resource to location in cache

\item \code{bfcremove(BiocFileCache)}: Remove a resource to the database.  If
the local file is located in \code{bfccache(x)}, the file will
also be deleted. This will not delete information in any metadata
table.

\item \code{bfcsync(BiocFileCache)}: sync cache and resource.

\item \code{exportbfc(BiocFileCacheBase)}: Create exportable file containing
BiocFileCache.

\item \code{importbfc(character)}: Import file created with exportbfc containing
BiocFileCache.

\item \code{cleanbfc(BiocFileCache)}: Remove old/unused files in
BiocFileCache. If file to be removed is not in the bfccache
location it will not be deleted. Setting \code{days=-Inf}
will remove all cached files.

\item \code{removebfc(BiocFileCache)}: Completely remove the BiocFileCache

\item \code{show(BiocFileCacheBase)}: Display a \code{BiocFileCache} instance.

}}
\examples{
# bfc <- BiocFileCache()            # global cache
# bfc
bfc0 <- BiocFileCache(tempfile())         # temporary catch for examples
bfccache(bfc0)
length(bfc0)
path <- bfcnew(bfc0, "NewResource")
path
fl1 <- tempfile(); file.create(fl1)
bfcadd(bfc0, "Test1", fl1)                 # copy
fl2 <- tempfile(); file.create(fl2)
bfcadd(bfc0, "Test2", fl2, action="move")         # move
fl3 <- tempfile(); file.create(fl3)
add3 <- bfcadd(bfc0, "Test3", fl3, rtype="local", action="asis")  # reference
rid3 <- names(add3)

bfc0
file.exists(fl1)                                # TRUE
file.exists(fl2)                                # FALSE
file.exists(fl3)                                # TRUE

# add a remote resource
url <- "http://httpbin.org/get"
bfcadd(bfc0, "TestWeb", fpath=url)
bfcinfo(bfc0)
bfcpath(bfc0, rid3)
bfcrpath(bfc0, rids = rid3)
bfcupdate(bfc0, rid3, rpath=fl3, rname="NewRname")
bfc0[[rid3]] = fl1
bfcupdate(bfc0, "BFC5", fpath="http://google.com")
meta = data.frame(list(rid = paste("BFC",seq_len(bfccount(bfc0)), sep=""),
                       num=seq(bfccount(bfc0),1,-1),
                       data=c(paste("Letter",
                       letters[seq_len(bfccount(bfc0))]))),
                  stringsAsFactors=FALSE)
bfcmeta(bfc0, name="resourcedata") <- meta
\dontrun{bfcmetaremove(bfc0, "resourcedata")}
bfcmetalist(bfc0)
tbl = bfcmeta(bfc0, "resourcedata")
tbl
bfcquerycols(bfc0)
bfcquery(bfc0, "Test")
bfcquery(bfc0, "^Test1$", field="rname")
bfccount(bfc0)
bfccount(bfcquery(bfc0, "test"))
bfcneedsupdate(bfc0, "BFC5")
bfcdownload(bfc0, "BFC5")
bfcremove(bfc0, rid3)
bfcinfo(bfc0)
bfcsync(bfc0)

if (!interactive()){
   # in interactive mode, in the sync above
   # this was probably already removed
   # noninteractive mode does not remove resources
   # so can remove manually here
   bfcremove(bfc0, "BFC1")
}
bfcsync(bfc0, FALSE)
\dontrun{exportbfc(bfc)}
\dontrun{importbfc("ExportBiocFileCache.tar")}
\dontrun{cleanbfc(bfc, ask=FALSE)}
\dontrun{removebfc(bfc, ask=FALSE)}
}
