% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baggedModel.R
\name{baggedModel}
\alias{baggedModel}
\alias{print.baggedModel}
\alias{baggedETS}
\title{Forecasting using a bagged model}
\usage{
baggedModel(y, bootstrapped_series = bld.mbb.bootstrap(y, 100), fn = ets, ...)

baggedETS(y, bootstrapped_series = bld.mbb.bootstrap(y, 100), ...)
}
\arguments{
\item{y}{A numeric vector or univariate time series of class \code{ts}.}

\item{bootstrapped_series}{bootstrapped versions of y.}

\item{fn}{the forecast function to use. Default is \code{\link[=ets]{ets()}}.}

\item{...}{Other arguments passed to the forecast function.}
}
\value{
Returns an object of class \code{baggedModel}.

The function \code{print} is used to obtain and print a summary of the
results.

\item{models}{A list containing the fitted ensemble models.}
\item{method}{The function for producing a forecastable model.}
\item{y}{The original time series.}
\item{bootstrapped_series}{The bootstrapped series.}
\item{modelargs}{The arguments passed through to \code{fn}.}
\item{fitted}{Fitted values (one-step forecasts). The
mean of the fitted values is calculated over the ensemble.}
\item{residuals}{Original values minus fitted values.}
}
\description{
The bagged model forecasting method.
}
\details{
This function implements the bagged model forecasting method described in
Bergmeir et al. By default, the \code{\link[=ets]{ets()}} function is applied to all
bootstrapped series. Base models other than \code{\link[=ets]{ets()}} can be given by the
parameter \code{fn}. Using the default parameters, the function
\code{\link[=bld.mbb.bootstrap]{bld.mbb.bootstrap()}} is used to calculate the bootstrapped series
with the Box-Cox and Loess-based decomposition (BLD) bootstrap. The function
\code{\link[=forecast.baggedModel]{forecast.baggedModel()}} can then be used to calculate forecasts.

\code{baggedETS} is a wrapper for \code{baggedModel}, setting \code{fn} to "ets".
This function is included for backwards compatibility only, and may be
deprecated in the future.
}
\examples{
fit <- baggedModel(WWWusage)
fcast <- forecast(fit)
plot(fcast)

}
\references{
Bergmeir, C., R. J. Hyndman, and J. M. Benitez (2016). Bagging
Exponential Smoothing Methods using STL Decomposition and Box-Cox
Transformation. International Journal of Forecasting 32, 303-312.
}
\author{
Christoph Bergmeir, Fotios Petropoulos
}
\keyword{ts}
