% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{reduce}
\alias{reduce}
\title{Reduce a list to a single value by iteratively applying a binary function}
\usage{
reduce(.x, .f, ..., .init)
}
\arguments{
\item{.x}{A list or atomic vector.}

\item{.f}{A 2-argument function. The function will be
passed the accumulated value as the first argument and the "next" value
as the second argument.}

\item{...}{Additional arguments passed on to \code{.f}.}

\item{.init}{If supplied, will be used as the first value to start
the accumulation, rather than using \code{x[[1]]}. This is useful if
you want to ensure that \code{reduce} returns a correct value when \code{.x}
is empty. If missing, and \code{x} is empty, will throw an error.}
}
\description{
Inspired by \code{reduce()} from the \code{purrr} package
}
\author{
Jonathon Love \href{mailto:jon@thon.cc}{jon@thon.cc}
}
\keyword{internal}
