% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyDat.R
\name{print.phyDat}
\alias{print.phyDat}
\alias{cbind.phyDat}
\alias{c.phyDat}
\alias{removeUndeterminedSites}
\alias{subset.phyDat}
\alias{[.phyDat}
\alias{unique.phyDat}
\alias{removeAmbiguousSites}
\alias{allSitePattern}
\title{Generic functions for class phyDat}
\usage{
\method{print}{phyDat}(x, ...)

\method{subset}{phyDat}(x, subset, select, site.pattern = TRUE, ...)

\method{[}{phyDat}(x, i, j, ..., drop = FALSE)

\method{unique}{phyDat}(x, incomparables = FALSE, identical = TRUE, ...)

removeUndeterminedSites(x, ...)

removeAmbiguousSites(x)

allSitePattern(n, levels = NULL, names = NULL, type = "DNA", code = 1)
}
\arguments{
\item{x}{An object containing sequences.}

\item{...}{further arguments passed to or from other methods.}

\item{subset}{a subset of taxa.}

\item{select}{a subset of characters.}

\item{site.pattern}{select site pattern or sites (see details).}

\item{i, j}{indices of the rows and/or columns to select or to drop. They
may be numeric, logical, or character (in the same way than for standard R
objects).}

\item{drop}{for compatibility with the generic (unused).}

\item{incomparables}{for compatibility with unique.}

\item{identical}{if TRUE (default) sequences have to be identical, if FALSE
sequences are considered duplicates if distance between sequences is zero
(happens frequently with ambiguous sites).}

\item{n}{Number of sequences.}

\item{levels}{Level attributes.}

\item{names}{Names of sequences.}

\item{type}{Type of sequences ("DNA", "AA" or "USER").}

\item{code}{The ncbi genetic code number for translation.
By default the standard genetic code is used.}
}
\value{
The functions return an object of class \code{phyDat}.
}
\description{
These functions help to manipulate alignments of class phyDat.
}
\details{
\code{allSitePattern} generates all possible site patterns and can be useful
in simulation studies. For further details see the vignette
AdvancedFeatures.

The generic function \code{c} can be used to to combine sequences and
\code{unique} to get all unique sequences or unique haplotypes.

\code{phyDat} stores identical columns of an alignment only once and keeps an
index of the original positions. This saves memory and especially
computations as these are usually need to be done only once for each site
pattern.
In the example below the matrix x in the example has 8 columns, but column 1
and 2 and also 3 and 5 are identical. The \code{phyDat} object y has only 6
site pattern. If argument \code{site.pattern=FALSE} the indexing behaves like
on the original matrix x. \code{site.pattern=TRUE} can be useful inside
functions.
}
\examples{

data(Laurasiatherian)
class(Laurasiatherian)
Laurasiatherian
# base frequencies
baseFreq(Laurasiatherian)
# subsetting phyDat objects
# the first 5 sequences
subset(Laurasiatherian, subset=1:5)
# the first 5 characters
subset(Laurasiatherian, select=1:5, site.pattern = FALSE)
# subsetting with []
Laurasiatherian[1:5, 1:20]
# short for
subset(Laurasiatherian, subset=1:5, select=1:20, site.pattern = FALSE)
# the first 5 site patterns (often more than 5 characters)
subset(Laurasiatherian, select=1:5, site.pattern = TRUE)

x <- matrix(c("a", "a", "c", "g", "c", "t", "a", "g",
              "a", "a", "c", "g", "c", "t", "a", "g",
              "a", "a", "c", "c", "c", "t", "t", "g"), nrow=3, byrow = TRUE,
            dimnames = list(c("t1", "t2", "t3"), 1:8))
(y <- phyDat(x))

subset(y, 1:2)
subset(y, 1:2, compress=TRUE)

subset(y, select=1:3, site.pattern = FALSE) |> as.character()
subset(y, select=1:3, site.pattern = TRUE) |> as.character()
y[,1:3] # same as subset(y, select=1:3, site.pattern = FALSE)

# Compute all possible site patterns
# for nucleotides there $4 ^ (number of tips)$ patterns
allSitePattern(5)

}
\seealso{
\code{\link[ape]{DNAbin}}, \code{\link[ape]{as.DNAbin}},
\code{\link{baseFreq}}, \code{\link{glance.phyDat}}, \code{\link{dna2codon}},
\code{\link[ape]{read.dna}}, \code{\link[ape]{read.nexus.data}}
and the chapter 1 in the \code{vignette("AdvancedFeatures",
package="phangorn")} and the example of \code{\link{pmlMix}} for the use of
\code{\link{allSitePattern}}.
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
